# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from pluggy_sdk.models.credit_card_metadata import CreditCardMetadata
from pluggy_sdk.models.merchant import Merchant
from pluggy_sdk.models.payment_data import PaymentData
from typing import Optional, Set
from typing_extensions import Self

class Transaction(BaseModel):
    """
    Transaction product
    """ # noqa: E501
    id: StrictStr = Field(description="Primary identifier of the transaction")
    description: StrictStr = Field(description="Clean description of the transaction")
    currency_code: StrictStr = Field(description="Currency ISO code", alias="currencyCode")
    amount: Union[StrictFloat, StrictInt] = Field(description="Transaction amount")
    amount_in_account_currency: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Transaction amount in Account's Currency. Only present if the transaction is in a different currency than the account's currency", alias="amountInAccountCurrency")
    var_date: datetime = Field(description="Date when the transaction was made", alias="date")
    type: Optional[StrictStr] = Field(default=None, description="Type of the transaction. DEBIT (outflow) or CREDIT (inflow)")
    balance: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Balance after the transaction")
    provider_code: Optional[StrictStr] = Field(default=None, description="Institution provided code", alias="providerCode")
    status: Optional[StrictStr] = Field(default=None, description="Status of the movement. POSTED / PENDING")
    category: Optional[StrictStr] = Field(default=None, description="Category of the transaction (e.g. Restaurants, Education). See the Transaction Categorization section in our guides.")
    category_id: Optional[StrictStr] = Field(default=None, description="Id of the transaction category. Can be used to identify the category in the Categories endpoint", alias="categoryId")
    payment_data: Optional[PaymentData] = Field(default=None, alias="paymentData")
    credit_card_metadata: Optional[CreditCardMetadata] = Field(default=None, alias="creditCardMetadata")
    merchant: Optional[Merchant] = None
    operation_type: Optional[StrictStr] = Field(default=None, description="Type of operation classified by the institution.", alias="operationType")
    provider_id: Optional[StrictStr] = Field(default=None, description="Provider's identifier for the transaction. Only returned for Open Finance connectors.", alias="providerId")
    __properties: ClassVar[List[str]] = ["id", "description", "currencyCode", "amount", "amountInAccountCurrency", "date", "type", "balance", "providerCode", "status", "category", "categoryId", "paymentData", "creditCardMetadata", "merchant", "operationType", "providerId"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DEBIT', 'CREDIT']):
            raise ValueError("must be one of enum values ('DEBIT', 'CREDIT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Transaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of payment_data
        if self.payment_data:
            _dict['paymentData'] = self.payment_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credit_card_metadata
        if self.credit_card_metadata:
            _dict['creditCardMetadata'] = self.credit_card_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of merchant
        if self.merchant:
            _dict['merchant'] = self.merchant.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Transaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "description": obj.get("description"),
            "currencyCode": obj.get("currencyCode"),
            "amount": obj.get("amount"),
            "amountInAccountCurrency": obj.get("amountInAccountCurrency"),
            "date": obj.get("date"),
            "type": obj.get("type"),
            "balance": obj.get("balance"),
            "providerCode": obj.get("providerCode"),
            "status": obj.get("status"),
            "category": obj.get("category"),
            "categoryId": obj.get("categoryId"),
            "paymentData": PaymentData.from_dict(obj["paymentData"]) if obj.get("paymentData") is not None else None,
            "creditCardMetadata": CreditCardMetadata.from_dict(obj["creditCardMetadata"]) if obj.get("creditCardMetadata") is not None else None,
            "merchant": Merchant.from_dict(obj["merchant"]) if obj.get("merchant") is not None else None,
            "operationType": obj.get("operationType"),
            "providerId": obj.get("providerId")
        })
        return _obj


