# Protean

**Protean** is an opinionated and pragmatic framework for building event-driven applications using the CQRS pattern.

[![Python](https://img.shields.io/pypi/pyversions/protean?label=Python)](https://github.com/proteanhq/protean/)
[![Release](https://img.shields.io/pypi/v/protean?label=Release&style=flat-square)](https://pypi.org/project/protean/)
[![Build Status](https://github.com/proteanhq/protean/actions/workflows/ci.yml/badge.svg)](https://github.com/proteanhq/protean/actions/workflows/ci.yml)
[![Coverage](https://codecov.io/gh/proteanhq/protean/graph/badge.svg?token=0sFuFdLBOx)](https://codecov.io/gh/proteanhq/protean)

## Installation

Protean is available on PyPI:

```console
$ python -m pip install protean
Collecting protean
  Downloading protean-0.13.0-py3-none-any.whl.metadata (5.9 kB)
...
Installing collected packages: ...
Successfully installed ...
```

Protean officially supports Python 3.11+.

## Quick Start

```python
from protean import Domain
from protean.fields import String, Text

domain = Domain(name="Publishing")

@domain.aggregate
class Post:
    title = String(required=True, max_length=1000)
    slug = String(required=True, max_length=1024)
    content = Text(required=True)

domain.init()
with domain.domain_context():
    post = Post(
        title="Hello World",
        slug="hello-world",
        content="Lorem Ipsum ..."
    )

    domain.repository_for(Post).add(post)
```

## Documentation

Online docs are available at [https://docs.proteanhq.com](https://docs.proteanhq.com).

## Contributing

> **Note**: Protean framework is not associated or related to [Protean eGov Technologies](https://www.proteantech.in/) or [Code for Gov Tech](https://codeforgovtech.in/) initiatives.

1. Check for open issues or open a fresh issue to start a discussion
    around a feature idea or a bug.
2. Fork [the repository](https://github.com/proteanhq/protean) on
    GitHub, branch off `main` and start making your changes.
3. Write a test which shows that the bug was fixed or that the feature
    works as expected.
4. Send a pull request and bug the maintainer until it gets merged and
    published.

For more information, please check out the
[community](https://docs.proteanhq.com/community/) section.

## License

BSD 3-Clause License

Copyright (c) 2018-2024, Subhash Bhushan C.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

* Neither the name of the copyright holder nor the names of its contributors
may be used to endorse or promote products derived from this software
without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
