# mypy-boto3-devicefarm

Mypy-friendly auto-generated type annotations for `boto3 devicefarm 1.10.38` service.
More information can be found [here](https://github.com/vemel/mypy_boto3).

- [mypy-boto3-devicefarm](#mypy-boto3-devicefarm)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
    - [Code auto-complete](#code-auto-complete)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `devicefarm` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-devicefarm]

# build service index. You should execute this command everytime
# you install or remove service packages
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking.

```python
import boto3

from mypy_boto3 import devicefarm
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_devicefarm as devicefarm

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("devicefarm")
client: devicefarm.DeviceFarmClient = boto3.client("devicefarm")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: devicefarm.DeviceFarmClient = session.client("devicefarm")


# Paginators need type annotation on creation
get_offering_status_paginator: devicefarm.GetOfferingStatusPaginator = client.get_paginator("get_offering_status")
list_artifacts_paginator: devicefarm.ListArtifactsPaginator = client.get_paginator("list_artifacts")
list_device_instances_paginator: devicefarm.ListDeviceInstancesPaginator = client.get_paginator("list_device_instances")
list_device_pools_paginator: devicefarm.ListDevicePoolsPaginator = client.get_paginator("list_device_pools")
list_devices_paginator: devicefarm.ListDevicesPaginator = client.get_paginator("list_devices")
list_instance_profiles_paginator: devicefarm.ListInstanceProfilesPaginator = client.get_paginator("list_instance_profiles")
list_jobs_paginator: devicefarm.ListJobsPaginator = client.get_paginator("list_jobs")
list_network_profiles_paginator: devicefarm.ListNetworkProfilesPaginator = client.get_paginator("list_network_profiles")
list_offering_promotions_paginator: devicefarm.ListOfferingPromotionsPaginator = client.get_paginator("list_offering_promotions")
list_offering_transactions_paginator: devicefarm.ListOfferingTransactionsPaginator = client.get_paginator("list_offering_transactions")
list_offerings_paginator: devicefarm.ListOfferingsPaginator = client.get_paginator("list_offerings")
list_projects_paginator: devicefarm.ListProjectsPaginator = client.get_paginator("list_projects")
list_remote_access_sessions_paginator: devicefarm.ListRemoteAccessSessionsPaginator = client.get_paginator("list_remote_access_sessions")
list_runs_paginator: devicefarm.ListRunsPaginator = client.get_paginator("list_runs")
list_samples_paginator: devicefarm.ListSamplesPaginator = client.get_paginator("list_samples")
list_suites_paginator: devicefarm.ListSuitesPaginator = client.get_paginator("list_suites")
list_tests_paginator: devicefarm.ListTestsPaginator = client.get_paginator("list_tests")
list_unique_problems_paginator: devicefarm.ListUniqueProblemsPaginator = client.get_paginator("list_unique_problems")
list_uploads_paginator: devicefarm.ListUploadsPaginator = client.get_paginator("list_uploads")
list_vpce_configurations_paginator: devicefarm.ListVPCEConfigurationsPaginator = client.get_paginator("list_vpce_configurations")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- Latest version of `boto3` is used.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from latest documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Code is processed by [black](https://github.com/psf/black) for readability.