# Contributing guide

Thank you for investing your time in contributing to our project! Read our [Code of Conduct](./CODE_OF_CONDUCT.md) to keep our community approachable and respectable. In this guide you will get an overview of the contribution workflow for our project.

## Reporting bugs, asking questions, requesting features

__Issues__ are a really valuable way of contributing to this project! If you encounter a bug, you have a question, or you want to request a feature, you are very welcome to report it on our [issues page](https://github.com/sodascience/metasyn/issues). Detailed bug reports and well-defined feature requests are highly appreciated.

If you want to open an issue, make sure to follow these steps:

1. Before you create an issue, please search keywords of your problem using the search bar on our [issues page](https://github.com/sodascience/metasyn/issues) to figure out if the issue already exists. If it does, feel free to add to the discussion there to let us know that you are also experiencing this issue!
2. Do your best to enable us to solve your issue or question. For questions, this can mean adding enough detail and sketching the context. For technical bug reports, this usually implies adding a _reproducible example_ of your problem.

## Code contributions

Nice to see that you are interested in contributing to our code! Here is a general workflow for contributing to our project.

1. Add an [issue](https://github.com/sodascience/metasyn/issues) describing the feature you want to add, or comment on an existing issue that you want to try solving it. The goal of this is to prevent you from spending time working on things that will not be accepted into our project. In general, we like to have some discussion on our issues before we start programming.
2. Fork the project and create a new branch on your fork (e.g., `add-cool-feature`)
3. Code the code 💻
4. Add a pull request (PR) when your code is ready for review. 
5. One of the core contributors will then review your code, suggest improvements, or discuss implementation details.
6. Once all questions have been addressed, all tests run, and everything looks good we will ✨ merge your PR ✨
