# Generated by ariadne-codegen
# Source: /app/operations

from typing import Any, Dict, List, Optional, Union

from .async_base_client import AsyncBaseClient
from .base_model import UNSET, UnsetType
from .get_tickets_flat import GetTicketsFlat
from .get_tickets_full import GetTicketsFull
from .input_types import (
    tickets_bool_exp,
    tickets_order_by,
    work_sites_bool_exp,
    work_sites_order_by,
)
from .user_from_token import UserFromToken
from .work_site_detail import WorkSiteDetail
from .work_site_ownership import WorkSiteOwnership
from .work_site_search import WorkSiteSearch
from .work_site_ticket_activity import WorkSiteTicketActivity


def gql(q: str) -> str:
    return q


class Client(AsyncBaseClient):
    async def user_from_token(self, **kwargs: Any) -> UserFromToken:
        query = gql(
            """
            query UserFromToken {
              user_from_token {
                id
                full_name
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="UserFromToken", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return UserFromToken.model_validate(data)

    async def get_tickets_full(
        self,
        where: tickets_bool_exp,
        order_by: Union[Optional[List[tickets_order_by]], UnsetType] = UNSET,
        offset: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> GetTicketsFull:
        query = gql(
            """
            query GetTickets_Full($where: tickets_bool_exp!, $orderBy: [tickets_order_by!], $offset: Int, $limit: Int) {
              tickets(where: $where, order_by: $orderBy, offset: $offset, limit: $limit) {
                id
                ref
                created_at
                updated_at
                deleted_at
                notes
                current_agent_is_assigned
                manually_scheduled_at
                review_status
                ticket_status
                ticket_type_id
                author {
                  id
                  full_name
                }
                order {
                  id
                  ref
                  is_closed_on_completion
                  service_date_start
                  service_date_end
                  customer {
                    id
                    title
                    abbreviation
                  }
                }
                expense_logs {
                  id
                  author {
                    id
                    full_name
                  }
                  notesj
                  expense_type
                  cents_recorded
                }
                ticket_custom_form_entries {
                  id
                  definition {
                    id
                    title
                  }
                  updated_at
                  payload
                }
                items {
                  order_item {
                    service {
                      id
                      title
                    }
                    product {
                      id
                      title
                    }
                    qty
                    quantity_unit {
                      id
                      label_abbrev
                    }
                  }
                  work_logs {
                    id
                  }
                  pos_logs {
                    id
                    qty
                    sold_at
                    created_at
                    notesj
                    xref_media_uploads {
                      upload {
                        id
                        url
                        orig_filename
                        content_type
                        content_size
                      }
                    }
                    author {
                      id
                      full_name
                    }
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "where": where,
            "orderBy": order_by,
            "offset": offset,
            "limit": limit,
        }
        response = await self.execute(
            query=query, operation_name="GetTickets_Full", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetTicketsFull.model_validate(data)

    async def get_tickets_flat(
        self,
        where: tickets_bool_exp,
        order_by: Union[Optional[List[tickets_order_by]], UnsetType] = UNSET,
        offset: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> GetTicketsFlat:
        query = gql(
            """
            query GetTickets_Flat($where: tickets_bool_exp!, $orderBy: [tickets_order_by!], $offset: Int, $limit: Int) {
              tickets(where: $where, order_by: $orderBy, offset: $offset, limit: $limit) {
                id
                ref
                created_at
                updated_at
                deleted_at
                author_id
                order_id
                notes
                current_agent_is_assigned
                manually_scheduled_at
                review_status
                ticket_status
                ticket_type_id
                requires_signature
                required_checklists_completed
                reviewer_id
                signature_id
                notesj
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "where": where,
            "orderBy": order_by,
            "offset": offset,
            "limit": limit,
        }
        response = await self.execute(
            query=query, operation_name="GetTickets_Flat", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetTicketsFlat.model_validate(data)

    async def work_site_search(
        self,
        where: work_sites_bool_exp,
        query: Union[Optional[str], UnsetType] = UNSET,
        order_by: Union[Optional[List[work_sites_order_by]], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        offset: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> WorkSiteSearch:
        _query = gql(
            """
            query WorkSiteSearch($query: String, $where: work_sites_bool_exp!, $orderBy: [work_sites_order_by!], $limit: Int, $offset: Int) {
              work_sites: search_work_sites(
                args: {_query: $query}
                where: $where
                order_by: $orderBy
                limit: $limit
                offset: $offset
              ) {
                ...WorkSitesView
              }
              work_sites_aggregate: search_work_sites_aggregate(
                args: {_query: $query}
                where: $where
              ) {
                aggregate {
                  count
                }
              }
            }

            fragment CustomerLink on customers {
              id
              abbreviation
              title
            }

            fragment UserLink on users {
              id
              fname
              lname
            }

            fragment WorkSitesView on work_sites {
              author {
                id
                full_name
                ...UserLink
              }
              title
              created_at
              deleted_at
              updated_at
              id
              confirmed_at
              county
              state
              lat
              lng
              api
              current_customer {
                accounting_id
                customer {
                  id
                  title
                  abbreviation
                  ...CustomerLink
                }
              }
              order_items_aggregate {
                aggregate {
                  count
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "query": query,
            "where": where,
            "orderBy": order_by,
            "limit": limit,
            "offset": offset,
        }
        response = await self.execute(
            query=_query, operation_name="WorkSiteSearch", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return WorkSiteSearch.model_validate(data)

    async def work_site_detail(
        self, work_site_id: Any, **kwargs: Any
    ) -> WorkSiteDetail:
        query = gql(
            """
            query WorkSiteDetail($workSiteId: uuid!) {
              work_site: work_sites_by_pk(id: $workSiteId) {
                author {
                  full_name
                  ...UserLink
                }
                created_at
                id
                title
                deleted_at
                county
                state
                lat
                lng
                api
                confirmed_at
                current_customer {
                  accounting_id
                  customer_id
                  customer {
                    title
                    ...CustomerLink
                  }
                }
              }
            }

            fragment CustomerLink on customers {
              id
              abbreviation
              title
            }

            fragment UserLink on users {
              id
              fname
              lname
            }
            """
        )
        variables: Dict[str, object] = {"workSiteId": work_site_id}
        response = await self.execute(
            query=query, operation_name="WorkSiteDetail", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return WorkSiteDetail.model_validate(data)

    async def work_site_ownership(
        self, work_site_id: Any, **kwargs: Any
    ) -> WorkSiteOwnership:
        query = gql(
            """
            query WorkSiteOwnership($workSiteId: uuid!) {
              work_site_owners: customers_xref_work_sites(
                where: {work_site_id: {_eq: $workSiteId}}
              ) {
                id
                started_at
                ended_at
                accounting_id
                customer {
                  id
                  title
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"workSiteId": work_site_id}
        response = await self.execute(
            query=query,
            operation_name="WorkSiteOwnership",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return WorkSiteOwnership.model_validate(data)

    async def work_site_ticket_activity(
        self, work_site_id: Any, **kwargs: Any
    ) -> WorkSiteTicketActivity:
        query = gql(
            """
            query WorkSiteTicketActivity($workSiteId: uuid!) {
              work_site_tickets: ticket_activity(
                where: {ticket: {items: {order_item: {work_site_id: {_eq: $workSiteId}}}}, ended_at: {_is_null: false}, _or: [{work_log_id: {_is_null: false}}, {travel_log_id: {_is_null: false}}]}
              ) {
                work_log_id
                travel_log_id
                started_at
                ended_at
                ticket_id
              }
            }
            """
        )
        variables: Dict[str, object] = {"workSiteId": work_site_id}
        response = await self.execute(
            query=query,
            operation_name="WorkSiteTicketActivity",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return WorkSiteTicketActivity.model_validate(data)
