import os
import sys
import time
import numpy
import pandas
import pathlib
import datetime
import functools
import matplotlib.pyplot as plt

# add source directory to path
sys.path.insert(0, '../src/FinToolsAP/')

import LaTeXBuilder
import LocalDatabase
import PortfolioSorts
import UtilityFunctions

# set printing options
import shutil
pandas.set_option('display.max_rows', None)
pandas.set_option('display.max_columns', None)
pandas.set_option('display.width', shutil.get_terminal_size()[0])
pandas.set_option('display.float_format', lambda x: '%.3f' % x)

# directory for loacl wrds database
LOCAL_DB = pathlib.Path('/home/andrewperry/Documents')

def main():
    
    data_path = pathlib.Path('/home/andrewperry/Nextcloud/Research/Bank Elasticity')

    DB = LocalDatabase.LocalDatabase(save_directory = data_path, 
                                     database_name = 'BankElasticityDB',
                                     tables_to_update = ['BANK_LINK']) 

    


if __name__ == '__main__':
    main()