import sys
import pathlib
import shutil
import pandas as pd
import matplotlib.pyplot as plt
import datetime
import time
from pandas.tseries.offsets import *

sys.path.insert(0, '../src/FinToolsAP/')

import QueryWRDS
import FamaFrench

# set printing options
pd.set_option('display.max_rows', None)
pd.set_option('display.max_columns', None)
pd.set_option('display.width', shutil.get_terminal_size()[0])
pd.set_option('display.float_format', lambda x: '%.5f' % x)

# directory for loacl wrds database 
LOCAL_WRDS_DB = pathlib.Path('/home/andrewperry/Documents/wrds_database/WRDS.db')

def main():
    FF = FamaFrench.FamaFrench('andrewperry', LOCAL_WRDS_DB)
    DB = QueryWRDS.QueryWRDS('andrewperry', LOCAL_WRDS_DB)
    start_date = datetime.date(1900, 6, 30)
    end_date = datetime.date(2100, 6, 30)
    s = time.time()
    ccm_df = DB.query_CCM(start_date, end_date)
    print(f'Data Loaded: {time.time() - s}')
    FFME_sort = pd.read_csv('FFSorts/univariate/ME.CSV')
    FFME_sort.date = pd.to_datetime(FFME_sort.date, format = '%Y%m')
    FFME_sort.date += MonthEnd(0)
    FFME_sort = FFME_sort.set_index('date').sort_index()
    BM_rows_keep = list(range(23, 1184))
    FFBM_sort = pd.read_csv('FFSorts/univariate/BM.CSV', skiprows = lambda x: x not in BM_rows_keep)
    FFBM_sort.date = pd.to_datetime(FFBM_sort.date, format = '%Y%m')
    FFBM_sort.date += MonthEnd(0)
    FFBM_sort = FFBM_sort.set_index('date').sort_index()
    OP_rows_keep = list(range(24, 741))
    FFOP_sort = pd.read_csv('FFSorts/univariate/OP.CSV', skiprows = lambda x: x not in OP_rows_keep)
    FFOP_sort.date = pd.to_datetime(FFOP_sort.date, format = '%Y%m')
    FFOP_sort.date += MonthEnd(0)
    FFOP_sort = FFOP_sort.set_index('date').sort_index()
    INV_rows_keep = list(range(17, 734))
    FFINV_sort = pd.read_csv('FFSorts/univariate/INV.CSV', skiprows = lambda x: x not in INV_rows_keep)
    FFINV_sort.date = pd.to_datetime(FFINV_sort.date, format = '%Y%m')
    FFINV_sort.date += MonthEnd(0)
    FFINV_sort = FFINV_sort.set_index('date').sort_index()
    EP_rows_keep = list(range(17, 878))
    FFEP_sort = pd.read_csv('FFSorts/univariate/EP.CSV', skiprows = lambda x: x not in EP_rows_keep)
    FFEP_sort.date = pd.to_datetime(FFEP_sort.date, format = '%Y%m')
    FFEP_sort.date += MonthEnd(0)
    FFEP_sort = FFEP_sort.set_index('date').sort_index()
    CFP_rows_keep = list(range(18, 879))
    FFCFP_sort = pd.read_csv('FFSorts/univariate/CFP.CSV', skiprows = lambda x: x not in CFP_rows_keep)
    FFCFP_sort.date = pd.to_datetime(FFCFP_sort.date, format = '%Y%m')
    FFCFP_sort.date += MonthEnd(0)
    FFCFP_sort = FFCFP_sort.set_index('date').sort_index()
    DP_rows_keep = list(range(19, 1168))
    FFDP_sort = pd.read_csv('FFSorts/univariate/DP.CSV', skiprows = lambda x: x not in DP_rows_keep)
    FFDP_sort.date = pd.to_datetime(FFDP_sort.date, format = '%Y%m')
    FFDP_sort.date += MonthEnd(0)
    FFDP_sort = FFDP_sort.set_index('date').sort_index()
    AC_rows_keep = list(range(17, 734))
    FFAC_sort = pd.read_csv('FFSorts/univariate/AC.CSV', skiprows = lambda x: x not in AC_rows_keep)
    FFAC_sort.date = pd.to_datetime(FFAC_sort.date, format = '%Y%m')
    FFAC_sort.date += MonthEnd(0)
    FFAC_sort = FFAC_sort.set_index('date').sort_index()
    s = time.time()
    ME_sort03070 = FF.sort_portfolios(ccm_df, char_bkpts = {'me': [0.3, 0.7]}, sorting_funcs = {'me': FF.sort_03070}, rebalance_freq = 'A', drop_na = False)
    BM_sort03070 = FF.sort_portfolios(ccm_df, char_bkpts = {'ffbm': [0.3, 0.7]}, sorting_funcs = {'ffbm': FF.sort_03070}, rebalance_freq = 'A', drop_na = False)
    OP_sort3070 = FF.sort_portfolios(ccm_df, char_bkpts = {'op': [0.3, 0.7]}, sorting_funcs = {'op': FF.sort_3070}, rebalance_freq = 'A', drop_na = False)
    INV_sort3070 = FF.sort_portfolios(ccm_df, char_bkpts = {'inv': [0.3, 0.7]}, sorting_funcs = {'inv': FF.sort_3070}, rebalance_freq = 'A', drop_na = False)
    EP_sort03070 = FF.sort_portfolios(ccm_df, char_bkpts = {'ffep': [0.3, 0.7]}, sorting_funcs = {'ffep': FF.sort_03070}, rebalance_freq = 'A', drop_na = False)
    CFP_sort03070 = FF.sort_portfolios(ccm_df, char_bkpts = {'ffcfp': [0.3, 0.7]}, sorting_funcs = {'ffcfp': FF.sort_03070}, rebalance_freq = 'A', drop_na = False)
    DP_sort03070 = FF.sort_portfolios(ccm_df, char_bkpts = {'dp': [0.3, 0.7]}, sorting_funcs = {'dp': FF.sort_03070}, rebalance_freq = 'A', drop_na = False)
    AC_sortQuint = FF.sort_portfolios(ccm_df, char_bkpts = {'ac': [0.2, 0.4, 0.6, 0.8]}, sorting_funcs = {'ac': FF.sort_quintile}, rebalance_freq = 'A', drop_na = False)
    print(f'Sorts: {time.time() - s}')
    ME_sort03070 = ME_sort03070.set_index('date').sort_index()
    BM_sort03070 = BM_sort03070.set_index('date').sort_index()
    OP_sort3070 = OP_sort3070.set_index('date').sort_index()
    INV_sort3070 = INV_sort3070.set_index('date').sort_index()
    EP_sort03070 = EP_sort03070.set_index('date').sort_index()
    CFP_sort03070 = CFP_sort03070.set_index('date').sort_index()
    DP_sort03070 = DP_sort03070.set_index('date').sort_index()
    AC_sortQuint = AC_sortQuint.set_index('date').sort_index()
    FFME_sort = FFME_sort.loc[FFME_sort.index >= ME_sort03070.index.min()]
    FFME_sort = FFME_sort.loc[FFME_sort.index <= ME_sort03070.index.max()]
    FFBM_sort = FFBM_sort.loc[FFBM_sort.index >= BM_sort03070.index.min()]
    FFBM_sort = FFBM_sort.loc[FFBM_sort.index <= BM_sort03070.index.max()]
    FFOP_sort = FFOP_sort.loc[FFOP_sort.index >= OP_sort3070.index.min()]
    FFOP_sort = FFOP_sort.loc[FFOP_sort.index <= OP_sort3070.index.max()]
    FFINV_sort = FFINV_sort.loc[FFINV_sort.index >= INV_sort3070.index.min()]
    FFINV_sort = FFINV_sort.loc[FFINV_sort.index <= INV_sort3070.index.max()]
    FFEP_sort = FFEP_sort.loc[FFEP_sort.index >= EP_sort03070.index.min()]
    FFEP_sort = FFEP_sort.loc[FFEP_sort.index <= EP_sort03070.index.max()]
    FFCFP_sort = FFCFP_sort.loc[FFCFP_sort.index >= CFP_sort03070.index.min()]
    FFCFP_sort = FFCFP_sort.loc[FFCFP_sort.index <= CFP_sort03070.index.max()]
    FFDP_sort = FFDP_sort.loc[FFDP_sort.index >= DP_sort03070.index.min()]
    FFDP_sort = FFDP_sort.loc[FFDP_sort.index <= DP_sort03070.index.max()]
    FFAC_sort = FFAC_sort.loc[FFAC_sort.index >= AC_sortQuint.index.min()]
    FFAC_sort = FFAC_sort.loc[FFAC_sort.index <= AC_sortQuint.index.max()]
    fig, ax = plt.subplots(3, 1, figsize = (32, 18))
    fig.suptitle('Univariate ME Sorts')
    for i in [2, 3, 4]:
        ax[i - 2].plot(ME_sort03070[f'me{i}'], label = 'mine')
        ax[i - 2].set_ylabel('Returns')
    ax[0].plot(FFME_sort['Lo 30'] / 100, label = 'ff')
    ax[1].plot(FFME_sort['Med 40'] / 100, label = 'ff')
    ax[2].plot(FFME_sort['Hi 30'] / 100, label = 'ff')
    ax[0].legend()
    ax[1].legend()
    ax[2].legend()
    ax[0].set_title(f'Lo 30%')
    ax[1].set_title(f'Med 40%')
    ax[2].set_title(f'Hi 30%')
    fig, ax = plt.subplots(4, 1, figsize = (32, 18))
    fig.suptitle('Univariate BM Sorts')
    for i in [2, 3, 4, 5]:
        ax[i - 2].plot(BM_sort03070[f'ffbm{i - 1}'], label = 'mine')
        ax[i - 2].set_ylabel('Returns')
    ax[0].plot(FFBM_sort['<= 0'] / 100, label = 'ff')
    ax[1].plot(FFBM_sort['Lo 30'] / 100, label = 'ff')
    ax[2].plot(FFBM_sort['Med 40'] / 100, label = 'ff')
    ax[3].plot(FFBM_sort['Hi 30'] / 100, label = 'ff')
    ax[0].legend()
    ax[1].legend()
    ax[2].legend()
    ax[3].legend()
    ax[0].set_title(f'<= 0')
    ax[1].set_title(f'Lo 30%')
    ax[2].set_title(f'Med 40%')
    ax[3].set_title(f'Hi 30%')
    fig, ax = plt.subplots(3, 1, figsize = (32, 18))
    fig.suptitle('Univariate OP Sorts')
    for i in [2, 3, 4]:
        ax[i - 2].plot(OP_sort3070[f'op{i - 1}'], label = 'mine')
        ax[i - 2].set_ylabel('Returns')
    ax[0].plot(FFOP_sort['Lo 30'] / 100, label = 'ff')
    ax[1].plot(FFOP_sort['Med 40'] / 100, label = 'ff')
    ax[2].plot(FFOP_sort['Hi 30'] / 100, label = 'ff')
    ax[0].legend()
    ax[1].legend()
    ax[2].legend()
    ax[0].set_title(f'Lo 30%')
    ax[1].set_title(f'Med 40%')
    ax[2].set_title(f'Hi 30%')
    fig, ax = plt.subplots(3, 1, figsize = (32, 18))
    fig.suptitle('Univariate INV Sorts')
    for i in [2, 3, 4]:
        ax[i - 2].plot(INV_sort3070[f'inv{i - 1}'], label = 'mine')
        ax[i - 2].set_ylabel('Returns')
    ax[0].plot(FFINV_sort['Lo 30'] / 100, label = 'ff')
    ax[1].plot(FFINV_sort['Med 40'] / 100, label = 'ff')
    ax[2].plot(FFINV_sort['Hi 30'] / 100, label = 'ff')
    ax[0].legend()
    ax[1].legend()
    ax[2].legend()
    ax[0].set_title(f'Lo 30%')
    ax[1].set_title(f'Med 40%')
    ax[2].set_title(f'Hi 30%')
    fig, ax = plt.subplots(4, 1, figsize = (32, 18))
    fig.suptitle('Univariate EP Sorts')
    for i in [2, 3, 4, 5]:
        ax[i - 2].plot(EP_sort03070[f'ffep{i - 1}'], label = 'mine')
        ax[i - 2].set_ylabel('Returns')
    ax[0].plot(FFEP_sort['<= 0'] / 100, label = 'ff')
    ax[1].plot(FFEP_sort['Lo 30'] / 100, label = 'ff')
    ax[2].plot(FFEP_sort['Med 40'] / 100, label = 'ff')
    ax[3].plot(FFEP_sort['Hi 30'] / 100, label = 'ff')
    ax[0].legend()
    ax[1].legend()
    ax[2].legend()
    ax[3].legend()
    ax[0].set_title(f'<= 0')
    ax[1].set_title(f'Lo 30%')
    ax[2].set_title(f'Med 40%')
    ax[3].set_title(f'Hi 30%')
    fig, ax = plt.subplots(4, 1, figsize = (32, 18))
    fig.suptitle('Univariate CFP Sorts')
    for i in [2, 3, 4, 5]:
        ax[i - 2].plot(CFP_sort03070[f'ffcfp{i - 1}'], label = 'mine')
        ax[i - 2].set_ylabel('Returns')
    ax[0].plot(FFCFP_sort['<= 0'] / 100, label = 'ff')
    ax[1].plot(FFCFP_sort['Lo 30'] / 100, label = 'ff')
    ax[2].plot(FFCFP_sort['Med 40'] / 100, label = 'ff')
    ax[3].plot(FFCFP_sort['Hi 30'] / 100, label = 'ff')
    ax[0].legend()
    ax[1].legend()
    ax[2].legend()
    ax[3].legend()
    ax[0].set_title(f'<= 0')
    ax[1].set_title(f'Lo 30%')
    ax[2].set_title(f'Med 40%')
    ax[3].set_title(f'Hi 30%')
    fig, ax = plt.subplots(4, 1, figsize = (32, 18))
    fig.suptitle('Univariate DP Sorts')
    for i in [2, 3, 4, 5]:
        ax[i - 2].plot(DP_sort03070[f'dp{i - 1}'], label = 'mine')
        ax[i - 2].set_ylabel('Returns')
    ax[0].plot(FFDP_sort['<= 0'] / 100, label = 'ff')
    ax[1].plot(FFDP_sort['Lo 30'] / 100, label = 'ff')
    ax[2].plot(FFDP_sort['Med 40'] / 100, label = 'ff')
    ax[3].plot(FFDP_sort['Hi 30'] / 100, label = 'ff')
    ax[0].legend()
    ax[1].legend()
    ax[2].legend()
    ax[3].legend()
    ax[0].set_title(f'<= 0')
    ax[1].set_title(f'Lo 30%')
    ax[2].set_title(f'Med 40%')
    ax[3].set_title(f'Hi 30%')
    fig, ax = plt.subplots(5, 1, figsize = (32, 18))
    fig.suptitle('Univariate AC Sorts')
    for i in [2, 3, 4, 5, 6]:
        ax[i - 2].plot(AC_sortQuint[f'ac{i - 1}'], label = 'mine')
        ax[i - 2].set_ylabel('Returns')
    ax[0].plot(FFAC_sort['Lo 20'] / 100, label = 'ff')
    ax[1].plot(FFAC_sort['Qnt 2'] / 100, label = 'ff')
    ax[2].plot(FFAC_sort['Qnt 3'] / 100, label = 'ff')
    ax[3].plot(FFAC_sort['Qnt 4'] / 100, label = 'ff')
    ax[4].plot(FFAC_sort['Hi 20'] / 100, label = 'ff')
    ax[0].legend()
    ax[1].legend()
    ax[2].legend()
    ax[3].legend()
    ax[4].legend()
    ax[0].set_title(f'Lo 20%')
    ax[1].set_title(f'Qnt 2')
    ax[2].set_title(f'Qnt 3')
    ax[3].set_title(f'Qnt 4')
    ax[4].set_title(f'Hi 20%')
    plt.show()

if __name__ == "__main__":
    main()