# Generated by Django 5.2.5 on 2025-08-07 12:42

import django.db.models.deletion
import django.utils.timezone
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        ('sites', '0002_alter_domain_unique'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='SyncConfiguration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(db_index=True, max_length=255, unique=True)),
                ('value', models.TextField()),
                ('description', models.TextField(blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Sync Configuration',
                'verbose_name_plural': 'Sync Configurations',
                'db_table': 'sb_sync_configuration',
            },
        ),
        migrations.CreateModel(
            name='HistoricalDataFilter',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('model_name', models.CharField(db_index=True, max_length=255)),
                ('filter_name', models.CharField(db_index=True, max_length=255)),
                ('filter_condition', models.TextField(help_text='JSON filter condition')),
                ('is_active', models.BooleanField(db_index=True, default=True)),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('updated_at', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField(db_index=True)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('group', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='auth.group')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('site', models.ForeignKey(blank=True, db_constraint=False, help_text='Django Site representing the site', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='sites.site')),
            ],
            options={
                'verbose_name': 'historical Data Filter',
                'verbose_name_plural': 'historical Data Filters',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': ('history_date', 'history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalModelPermission',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('model_name', models.CharField(db_index=True, max_length=255)),
                ('can_push', models.BooleanField(db_index=True, default=False)),
                ('can_pull', models.BooleanField(db_index=True, default=False)),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('updated_at', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField(db_index=True)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('group', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='auth.group')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('site', models.ForeignKey(blank=True, db_constraint=False, help_text='Django Site representing the site', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='sites.site')),
            ],
            options={
                'verbose_name': 'historical Model Permission',
                'verbose_name_plural': 'historical Model Permissions',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': ('history_date', 'history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalUserSite',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('is_active', models.BooleanField(db_index=True, default=True)),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('updated_at', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField(db_index=True)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('group', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='auth.group')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('site', models.ForeignKey(blank=True, db_constraint=False, help_text='Django Site representing the site', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='sites.site')),
                ('user', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical User Site',
                'verbose_name_plural': 'historical User Sites',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': ('history_date', 'history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalUserSyncMetadata',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('model_name', models.CharField(db_index=True, max_length=255)),
                ('last_sync', models.DateTimeField(blank=True, db_index=True, editable=False)),
                ('total_synced', models.IntegerField(default=0)),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('updated_at', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField(db_index=True)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('site', models.ForeignKey(blank=True, db_constraint=False, help_text='Django Site representing the site', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='sites.site')),
                ('user', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical User Sync Metadata',
                'verbose_name_plural': 'historical User Sync Metadata',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': ('history_date', 'history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='PerformanceMetrics',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('operation_type', models.CharField(db_index=True, max_length=20)),
                ('model_name', models.CharField(db_index=True, max_length=100)),
                ('batch_size', models.IntegerField()),
                ('processing_time', models.FloatField()),
                ('memory_usage', models.FloatField(blank=True, null=True)),
                ('query_count', models.IntegerField()),
                ('timestamp', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
            ],
            options={
                'db_table': 'sb_sync_performance_metrics',
                'ordering': ['-timestamp'],
                'indexes': [models.Index(fields=['operation_type', 'timestamp'], name='sb_sync_per_operati_ef542a_idx'), models.Index(fields=['model_name', 'timestamp'], name='sb_sync_per_model_n_7213dd_idx')],
            },
        ),
        migrations.CreateModel(
            name='HistoricalPerformanceMetrics',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('operation_type', models.CharField(db_index=True, max_length=20)),
                ('model_name', models.CharField(db_index=True, max_length=100)),
                ('batch_size', models.IntegerField()),
                ('processing_time', models.FloatField()),
                ('memory_usage', models.FloatField(blank=True, null=True)),
                ('query_count', models.IntegerField()),
                ('timestamp', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField(db_index=True)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_relation', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.DO_NOTHING, related_name='performance_metrics_history', to='sb_sync.performancemetrics')),
            ],
            options={
                'verbose_name': 'Performance Metrics History',
                'verbose_name_plural': 'historical performance metricss',
                'db_table': 'sb_sync_performance_metrics_history',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': ('history_date', 'history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='SyncLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('operation', models.CharField(choices=[('PUSH', 'Push'), ('PULL', 'Pull')], db_index=True, max_length=10)),
                ('status', models.CharField(choices=[('SUCCESS', 'Success'), ('ERROR', 'Error'), ('WARNING', 'Warning')], db_index=True, max_length=10)),
                ('model_name', models.CharField(blank=True, db_index=True, max_length=100)),
                ('object_count', models.IntegerField(default=0)),
                ('error_message', models.TextField(blank=True)),
                ('request_data', models.JSONField(blank=True, null=True)),
                ('timestamp', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('processing_time', models.FloatField(default=0.0)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'sb_sync_log',
                'ordering': ['-timestamp'],
            },
        ),
        migrations.CreateModel(
            name='HistoricalSyncLog',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('operation', models.CharField(choices=[('PUSH', 'Push'), ('PULL', 'Pull')], db_index=True, max_length=10)),
                ('status', models.CharField(choices=[('SUCCESS', 'Success'), ('ERROR', 'Error'), ('WARNING', 'Warning')], db_index=True, max_length=10)),
                ('model_name', models.CharField(blank=True, db_index=True, max_length=100)),
                ('object_count', models.IntegerField(default=0)),
                ('error_message', models.TextField(blank=True)),
                ('request_data', models.JSONField(blank=True, null=True)),
                ('timestamp', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('processing_time', models.FloatField(default=0.0)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField(db_index=True)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_relation', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.DO_NOTHING, related_name='sync_log_history', to='sb_sync.synclog')),
            ],
            options={
                'verbose_name': 'Sync Log History',
                'verbose_name_plural': 'historical sync logs',
                'db_table': 'sb_sync_log_history',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': ('history_date', 'history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='SyncMetadata',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model_name', models.CharField(db_index=True, max_length=100, unique=True)),
                ('last_sync', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('total_synced', models.BigIntegerField(default=0)),
            ],
            options={
                'db_table': 'sb_sync_metadata',
                'indexes': [models.Index(fields=['model_name', 'last_sync'], name='sb_sync_met_model_n_55aa4a_idx')],
            },
        ),
        migrations.CreateModel(
            name='HistoricalSyncMetadata',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('model_name', models.CharField(db_index=True, max_length=100)),
                ('last_sync', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('total_synced', models.BigIntegerField(default=0)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField(db_index=True)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_relation', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.DO_NOTHING, related_name='sync_metadata_history', to='sb_sync.syncmetadata')),
            ],
            options={
                'verbose_name': 'Sync Metadata History',
                'verbose_name_plural': 'historical sync metadatas',
                'db_table': 'sb_sync_metadata_history',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': ('history_date', 'history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='UserSite',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_active', models.BooleanField(db_index=True, default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth.group')),
                ('site', models.ForeignKey(help_text='Django Site representing the site', on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'User Site',
                'verbose_name_plural': 'User Sites',
                'db_table': 'sb_sync_user_site',
            },
        ),
        migrations.CreateModel(
            name='UserSyncMetadata',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model_name', models.CharField(db_index=True, max_length=255)),
                ('last_sync', models.DateTimeField(auto_now=True, db_index=True)),
                ('total_synced', models.IntegerField(default=0)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('site', models.ForeignKey(help_text='Django Site representing the site', on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'User Sync Metadata',
                'verbose_name_plural': 'User Sync Metadata',
                'db_table': 'sb_sync_user_sync_metadata',
            },
        ),
        migrations.CreateModel(
            name='DataFilter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model_name', models.CharField(db_index=True, max_length=255)),
                ('filter_name', models.CharField(db_index=True, max_length=255)),
                ('filter_condition', models.TextField(help_text='JSON filter condition')),
                ('is_active', models.BooleanField(db_index=True, default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth.group')),
                ('site', models.ForeignKey(help_text='Django Site representing the site', on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Data Filter',
                'verbose_name_plural': 'Data Filters',
                'db_table': 'sb_sync_data_filter',
                'indexes': [models.Index(fields=['site', 'group', 'model_name'], name='sb_sync_dat_site_id_e704ac_idx')],
            },
        ),
        migrations.CreateModel(
            name='ModelPermission',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model_name', models.CharField(db_index=True, max_length=255)),
                ('can_push', models.BooleanField(db_index=True, default=False)),
                ('can_pull', models.BooleanField(db_index=True, default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth.group')),
                ('site', models.ForeignKey(help_text='Django Site representing the site', on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Model Permission',
                'verbose_name_plural': 'Model Permissions',
                'db_table': 'sb_sync_model_permission',
                'indexes': [models.Index(fields=['site', 'group'], name='sb_sync_mod_site_id_a471c1_idx'), models.Index(fields=['model_name', 'site'], name='sb_sync_mod_model_n_e3c7fd_idx')],
                'unique_together': {('site', 'group', 'model_name')},
            },
        ),
        migrations.AddIndex(
            model_name='synclog',
            index=models.Index(fields=['timestamp', 'operation'], name='sb_sync_log_timesta_11c11b_idx'),
        ),
        migrations.AddIndex(
            model_name='synclog',
            index=models.Index(fields=['user', 'operation'], name='sb_sync_log_user_id_26fea0_idx'),
        ),
        migrations.AddIndex(
            model_name='synclog',
            index=models.Index(fields=['status', 'timestamp'], name='sb_sync_log_status_2999e8_idx'),
        ),
        migrations.AddIndex(
            model_name='synclog',
            index=models.Index(fields=['model_name', 'timestamp'], name='sb_sync_log_model_n_efb3d2_idx'),
        ),
        migrations.AddIndex(
            model_name='synclog',
            index=models.Index(fields=['user', 'status', 'timestamp'], name='sb_sync_log_user_id_e4ca58_idx'),
        ),
        migrations.AddIndex(
            model_name='synclog',
            index=models.Index(fields=['operation', 'status', 'timestamp'], name='sb_sync_log_operati_c09add_idx'),
        ),
        migrations.AddIndex(
            model_name='usersite',
            index=models.Index(fields=['user', 'site'], name='sb_sync_use_user_id_86f418_idx'),
        ),
        migrations.AddIndex(
            model_name='usersite',
            index=models.Index(fields=['site', 'group'], name='sb_sync_use_site_id_d19a94_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='usersite',
            unique_together={('user', 'site')},
        ),
        migrations.AddIndex(
            model_name='usersyncmetadata',
            index=models.Index(fields=['user', 'site', 'model_name'], name='sb_sync_use_user_id_076a18_idx'),
        ),
        migrations.AddIndex(
            model_name='usersyncmetadata',
            index=models.Index(fields=['site', 'model_name', 'last_sync'], name='sb_sync_use_site_id_8027d6_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='usersyncmetadata',
            unique_together={('user', 'site', 'model_name')},
        ),
    ]
