from setuptools import setup, find_packages
import os

# Read the README file
def read_readme():
    with open('README.md', 'r', encoding='utf-8') as f:
        return f.read()

setup(
    name='sb-sync',
    version='2.0.1',
    description='Django package for data synchronization with PUSH/PULL APIs',
    long_description=read_readme(),
    long_description_content_type='text/markdown',
    author='TheSocialBytes',
    author_email='info@thesocialbytes.com',
    url='https://github.com/TheSocialBytes/sync',
    packages=find_packages(),
    include_package_data=True,
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: 3.11',
        'Programming Language :: Python :: 3.12',
        'Framework :: Django',
        'Framework :: Django :: 3.2',
        'Framework :: Django :: 4.0',
        'Framework :: Django :: 4.1',
        'Framework :: Django :: 4.2',
        'Framework :: Django :: 5.0',
        'Framework :: Django :: 5.1',
        'Framework :: Django :: 5.2',
        'Topic :: Database',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: System :: Distributed Computing',
        'Topic :: System :: Networking',
    ],
    python_requires='>=3.8',
    install_requires=[
        'Django>=3.2,<5.3',
        'djangorestframework>=3.14.0',
        'PyJWT>=2.6.0',
        'python-json-logger>=2.0.4',
        'django-cors-headers>=3.13.0',
        'celery>=5.2.0',
        'redis>=4.0.0',
        'bleach>=5.0.0',
        'django-filter>=22.0',
        'django-cacheops>=7.0.0',
        'django-extensions>=3.2.0',
        'django-debug-toolbar>=4.0.0',
        'django-silk>=5.0.0',
        'django-prometheus>=2.3.0',
        'prometheus-client>=0.16.0',
        'django-simple-history>=3.4.0',
        'psutil>=5.9.0',
        'requests>=2.28.0',
        'urllib3>=1.26.0',
        'certifi>=2022.12.7',
        'charset-normalizer>=3.0.0',
        'idna>=3.4',
        'python-dateutil>=2.8.2',
        'pytz>=2022.7',
        'six>=1.16.0',
        'typing-extensions>=4.4.0',
        'packaging>=21.3',
        'pyparsing>=3.0.9',
        'click>=8.1.0',
        'kombu>=5.2.0',
        'billiard>=3.6.4.0',
        'amqp>=5.1.0',
        'vine>=5.0.0',
        'importlib-metadata>=5.0.0',
        'zipp>=3.8.0',
        'markupsafe>=2.1.0',
        'webencodings>=0.5.1',
        'html5lib>=1.1',
        'lxml>=4.9.0',
        'cssselect>=1.1.0',
        'beautifulsoup4>=4.11.0',
        'soupsieve>=2.3.0',
    ],
    extras_require={
        'dev': [
            'pytest>=7.0.0',
            'pytest-django>=4.5.0',
            'pytest-cov>=4.0.0',
            'pytest-mock>=3.10.0',
            'pytest-xdist>=3.0.0',
            'pytest-benchmark>=4.0.0',
            'pytest-html>=3.1.0',
            'pytest-json-report>=1.5.0',
            'coverage>=6.5.0',
            'black>=22.0.0',
            'isort>=5.10.0',
            'flake8>=5.0.0',
            'mypy>=1.0.0',
            'bandit>=1.7.0',
            'safety>=2.3.0',
            'pre-commit>=2.20.0',
            'tox>=4.0.0',
            'twine>=4.0.0',
            'build>=0.10.0',
            'wheel>=0.38.0',
            'setuptools>=65.0.0',
            'pip>=22.0.0',
            'virtualenv>=20.16.0',
            'pip-tools>=6.8.0',
            'pipdeptree>=2.7.0',
            'pip-audit>=2.4.0',
        ],
        'test': [
            'pytest>=7.0.0',
            'pytest-django>=4.5.0',
            'pytest-cov>=4.0.0',
            'pytest-mock>=3.10.0',
            'pytest-xdist>=3.0.0',
            'pytest-benchmark>=4.0.0',
            'pytest-html>=3.1.0',
            'pytest-json-report>=1.5.0',
            'coverage>=6.5.0',
            'factory-boy>=3.2.0',
            'faker>=18.0.0',
            'freezegun>=1.2.0',
            'responses>=0.22.0',
            'httpretty>=1.0.0',
            'requests-mock>=1.10.0',
            'betamax>=0.8.0',
            'vcrpy>=5.1.0',
            'pytest-vcr>=1.0.0',
        ],
        'docs': [
            'sphinx>=5.0.0',
            'sphinx-rtd-theme>=1.0.0',
            'sphinx-autodoc-typehints>=1.12.0',
            'sphinx-copybutton>=0.5.0',
            'sphinx-tabs>=3.0.0',
            'sphinx-panels>=0.6.0',
            'sphinx-book-theme>=0.3.0',
            'myst-parser>=0.18.0',
            'pydata-sphinx-theme>=0.8.0',
            'furo>=2022.9.0',
            'sphinx-design>=0.3.0',
            'sphinx-autobuild>=2021.3.0',
        ],
        'security': [
            'bandit>=1.7.0',
            'safety>=2.3.0',
            'pip-audit>=2.4.0',
        ],
        'performance': [
            'django-silk>=5.0.0',
            'django-debug-toolbar>=4.0.0',
            'django-extensions>=3.2.0',
            'django-cacheops>=7.0.0',
            'django-prometheus>=2.3.0',
            'prometheus-client>=0.16.0',
            'psutil>=5.9.0',
            'memory-profiler>=0.60.0',
            'line-profiler>=3.5.0',
            'py-spy>=0.3.0',
            'pyinstrument>=4.0.0',
            'scalene>=1.5.0',
            'fil>=0.0.3',
            'pytest-benchmark>=4.0.0',
            'pytest-profiling>=1.7.0',
        ],
        'monitoring': [
            'django-prometheus>=2.3.0',
            'prometheus-client>=0.16.0',
            'django-silk>=5.0.0',
            'django-debug-toolbar>=4.0.0',
            'django-extensions>=3.2.0',
            'django-cacheops>=7.0.0',
            'psutil>=5.9.0',
            'memory-profiler>=0.60.0',
            'line-profiler>=3.5.0',
            'py-spy>=0.3.0',
            'pyinstrument>=4.0.0',
            'scalene>=1.5.0',
            'fil>=0.0.3',
        ],
    },
    project_urls={
        'Bug Reports': 'https://github.com/TheSocialBytes/sync/issues',
        'Source': 'https://github.com/TheSocialBytes/sync',
        'Documentation': 'https://github.com/TheSocialBytes/sync/blob/main/README.md',
        'Changelog': 'https://github.com/TheSocialBytes/sync/blob/main/README.md',
    },
)