"""Module for communicating with Viasat IoT Nano modems."""

from pyatcommand import AtClient, AtTimeout

from .common import (
    BeamStateIdp,
    BeamType,
    BeamTypeIdp,
    BeamTypeOgx,
    ControlStateIdp,
    DataFormat,
    EventNotification,
    GeoBeam,
    GnssMode,
    GnssModeQuectel,
    GnssModeSkywave,
    LastErrorCode,
    MessagePriorityIdp,
    MessageState,
    MessageStateIdp,
    MessageStateOgx,
    MessageTypeOgx,
    ModemManufacturer,
    ModemModel,
    NetInfo,
    NetworkProtocol,
    NetworkState,
    NetworkStateOgx,
    OperatingMode,
    PowerMode,
    SatelliteId,
    ServiceClassOgx,
    SignalLevelIdp,
    SignalQuality,
    WakeupInterval,
    WakeupIntervalIdp,
    WakeupIntervalOgx,
)
from .loader import clone_and_load_modem_classes, mutate_modem
from .location import GnssFixQuality, GnssFixType, GnssLocation, GnssSatelliteInfo
from .message import IotNanoMessage, MoMessage, MtMessage
from .modem import SatelliteModem

__all__ = [
    'AtClient',
    'AtTimeout',
    'LastErrorCode',
    'SatelliteModem',
    'ModemManufacturer',
    'ModemModel',
    'BeamType',
    'BeamTypeIdp',
    'BeamStateIdp',
    'BeamTypeOgx',
    'IotNanoMessage',
    'MessageState',
    'MessageStateIdp',
    'MessageStateOgx',
    'MoMessage',
    'MtMessage',
    'NetworkProtocol',
    'ServiceClassOgx',
    'NetworkState',
    'SignalQuality',
    'NetInfo',
    'DataFormat',
    'EventNotification',
    'WakeupInterval',
    'WakeupIntervalIdp',
    'WakeupIntervalOgx',
    'PowerMode',
    'GnssMode',
    'GnssLocation',
    'GnssFixType',
    'GnssFixQuality',
    'GnssSatelliteInfo',
    'OperatingMode',
    'ControlStateIdp',
    'NetworkStateOgx',
    'MessagePriorityIdp',
    'MessageTypeOgx',
    'GnssModeSkywave',
    'GnssModeQuectel',
    'SignalLevelIdp',
    'GeoBeam',
    'SatelliteId',
    'clone_and_load_modem_classes',
    'mutate_modem',
]
