//===----------------------------------------------------------------------===//
//                         DuckDB
//
// core_functions/scalar/blob_functions.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_functions.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/function/function_set.hpp"

namespace duckdb {

struct DecodeFun {
	static constexpr const char *Name = "decode";
	static constexpr const char *Parameters = "blob,varchar";
	static constexpr const char *Description = "Converts `blob` to `VARCHAR`. Invalid UTF-8 is handled based on the error behavior argument. Can be 'strict' (default, fail), 'replace' to replace invalid characters with '?', or 'ignore' to skip invalid characters.";
	static constexpr const char *Example = "decode('\\xC3\\xBC'::BLOB)\002decode('\\xA0'::BLOB, 'replace')\002decode('\\xA0'::BLOB, 'ignore')";
	static constexpr const char *Categories = "blob";

	static ScalarFunctionSet GetFunctions();
};

struct EncodeFun {
	static constexpr const char *Name = "encode";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Converts the `string` to `BLOB`. Converts UTF-8 characters into literal encoding.";
	static constexpr const char *Example = "encode('my_string_with_ü')";
	static constexpr const char *Categories = "blob";

	static ScalarFunction GetFunction();
};

struct FromBase64Fun {
	static constexpr const char *Name = "from_base64";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Converts a base64 encoded `string` to a character string (`BLOB`).";
	static constexpr const char *Example = "from_base64('QQ==')";
	static constexpr const char *Categories = "string,blob";

	static ScalarFunction GetFunction();
};

struct ToBase64Fun {
	static constexpr const char *Name = "to_base64";
	static constexpr const char *Parameters = "blob";
	static constexpr const char *Description = "Converts a `blob` to a base64 encoded string.";
	static constexpr const char *Example = "to_base64('A'::BLOB)";
	static constexpr const char *Categories = "string,blob";

	static ScalarFunction GetFunction();
};

struct Base64Fun {
	using ALIAS = ToBase64Fun;

	static constexpr const char *Name = "base64";
};

} // namespace duckdb
