//-------------------------------------------------------------------------
//                         DuckDB
//
//
// duckdb/common/enums/metrics_type.hpp
// 
// This file is automatically generated by scripts/generate_metric_enums.py
// Do not edit this file manually, your changes will be overwritten
//-------------------------------------------------------------------------

#pragma once

#include "duckdb/common/types/value.hpp"
#include "duckdb/common/unordered_set.hpp"
#include "duckdb/common/unordered_map.hpp"
#include "duckdb/common/constants.hpp"
#include "duckdb/common/enum_util.hpp"
#include "duckdb/common/enums/optimizer_type.hpp"

namespace duckdb {

enum class MetricsType : uint8_t {
    ATTACH_LOAD_STORAGE_LATENCY,
    ATTACH_REPLAY_WAL_LATENCY,
    BLOCKED_THREAD_TIME,
    CHECKPOINT_LATENCY,
    CPU_TIME,
    CUMULATIVE_CARDINALITY,
    CUMULATIVE_ROWS_SCANNED,
    EXTRA_INFO,
    LATENCY,
    OPERATOR_CARDINALITY,
    OPERATOR_NAME,
    OPERATOR_ROWS_SCANNED,
    OPERATOR_TIMING,
    OPERATOR_TYPE,
    QUERY_NAME,
    RESULT_SET_SIZE,
    ROWS_RETURNED,
    SYSTEM_PEAK_BUFFER_MEMORY,
    SYSTEM_PEAK_TEMP_DIR_SIZE,
    TOTAL_BYTES_READ,
    TOTAL_BYTES_WRITTEN,
    TOTAL_MEMORY_ALLOCATED,
    WAITING_TO_ATTACH_LATENCY,
    COMMIT_LOCAL_STORAGE_LATENCY,
    WRITE_TO_WAL_LATENCY,
    WAL_REPLAY_ENTRY_COUNT,
    ALL_OPTIMIZERS,
    CUMULATIVE_OPTIMIZER_TIMING,
    PHYSICAL_PLANNER,
    PHYSICAL_PLANNER_COLUMN_BINDING,
    PHYSICAL_PLANNER_CREATE_PLAN,
    PHYSICAL_PLANNER_RESOLVE_TYPES,
    PLANNER,
    PLANNER_BINDING,
    OPTIMIZER_EXPRESSION_REWRITER,
    OPTIMIZER_FILTER_PULLUP,
    OPTIMIZER_FILTER_PUSHDOWN,
    OPTIMIZER_EMPTY_RESULT_PULLUP,
    OPTIMIZER_CTE_FILTER_PUSHER,
    OPTIMIZER_REGEX_RANGE,
    OPTIMIZER_IN_CLAUSE,
    OPTIMIZER_JOIN_ORDER,
    OPTIMIZER_DELIMINATOR,
    OPTIMIZER_UNNEST_REWRITER,
    OPTIMIZER_UNUSED_COLUMNS,
    OPTIMIZER_STATISTICS_PROPAGATION,
    OPTIMIZER_COMMON_SUBEXPRESSIONS,
    OPTIMIZER_COMMON_AGGREGATE,
    OPTIMIZER_COLUMN_LIFETIME,
    OPTIMIZER_BUILD_SIDE_PROBE_SIDE,
    OPTIMIZER_LIMIT_PUSHDOWN,
    OPTIMIZER_TOP_N,
    OPTIMIZER_TOP_N_WINDOW_ELIMINATION,
    OPTIMIZER_COMPRESSED_MATERIALIZATION,
    OPTIMIZER_DUPLICATE_GROUPS,
    OPTIMIZER_REORDER_FILTER,
    OPTIMIZER_SAMPLING_PUSHDOWN,
    OPTIMIZER_JOIN_FILTER_PUSHDOWN,
    OPTIMIZER_EXTENSION,
    OPTIMIZER_MATERIALIZED_CTE,
    OPTIMIZER_SUM_REWRITER,
    OPTIMIZER_LATE_MATERIALIZATION,
    OPTIMIZER_CTE_INLINING,
    OPTIMIZER_COMMON_SUBPLAN,
    OPTIMIZER_JOIN_ELIMINATION,
};

struct MetricsTypeHashFunction {
	uint64_t operator()(const MetricsType &index) const {
		return std::hash<uint8_t>()(static_cast<uint8_t>(index));
	}
};

typedef unordered_set<MetricsType, MetricsTypeHashFunction> profiler_settings_t;
typedef unordered_map<MetricsType, Value, MetricsTypeHashFunction> profiler_metrics_t;

class MetricsUtils {
public:
    static profiler_settings_t GetOptimizerMetrics();
    static profiler_settings_t GetPhaseTimingMetrics();

    static MetricsType GetOptimizerMetricByType(OptimizerType type);
    static OptimizerType GetOptimizerTypeByMetric(MetricsType type);

    static bool IsOptimizerMetric(MetricsType type);
    static bool IsPhaseTimingMetric(MetricsType type);
    static bool IsQueryGlobalMetric(MetricsType type);
};

} // namespace duckdb
