//===----------------------------------------------------------------------===//
//                         DuckDB
//
// function/scalar/geometry_functions.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_functions.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/function/function_set.hpp"

namespace duckdb {

struct StGeomfromwkbFun {
	static constexpr const char *Name = "st_geomfromwkb";
	static constexpr const char *Parameters = "wkb";
	static constexpr const char *Description = "Creates a geometry from Well-Known Binary (WKB) representation";
	static constexpr const char *Example = "ST_GeomFromWKB(X'01010000000000000000000000000000000000000000000000')";
	static constexpr const char *Categories = "geometry";

	static ScalarFunction GetFunction();
};

struct StAswkbFun {
	static constexpr const char *Name = "st_aswkb";
	static constexpr const char *Parameters = "geom";
	static constexpr const char *Description = "Returns the Well-Known Binary (WKB) representation of the geometry";
	static constexpr const char *Example = "st_aswkb(ST_GeomFromWKB(X'01010000000000000000000000000000000000000000000000000'))";
	static constexpr const char *Categories = "geometry";

	static ScalarFunction GetFunction();
};

struct StAsbinaryFun {
	using ALIAS = StAswkbFun;

	static constexpr const char *Name = "st_asbinary";
};

struct StAstextFun {
	static constexpr const char *Name = "st_astext";
	static constexpr const char *Parameters = "geom";
	static constexpr const char *Description = "Returns the Well-Known Text (WKT) representation of the geometry";
	static constexpr const char *Example = "ST_AsText(ST_GeomFromWKB(X'01010000000000000000000000000000000000000000000000'))";
	static constexpr const char *Categories = "geometry";

	static ScalarFunction GetFunction();
};

struct StAswktFun {
	using ALIAS = StAstextFun;

	static constexpr const char *Name = "st_aswkt";
};

struct StIntersectsExtentFun {
	static constexpr const char *Name = "st_intersects_extent";
	static constexpr const char *Parameters = "geom1,geom2";
	static constexpr const char *Description = "Returns true if the geometries bounding boxes intersect";
	static constexpr const char *Example = "'POINT(5 5)'::GEOMETRY && 'LINESTRING(0 0, 10 20)'::GEOMETRY;";
	static constexpr const char *Categories = "geometry";

	static ScalarFunction GetFunction();
};

struct StIntersectsExtentFunAlias {
	using ALIAS = StIntersectsExtentFun;

	static constexpr const char *Name = "&&";
};

} // namespace duckdb
