//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_serialization.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#include "duckdb/common/serializer/serializer.hpp"
#include "duckdb/common/serializer/deserializer.hpp"
#include "duckdb/common/extension_type_info.hpp"
#include "duckdb/common/extra_type_info.hpp"

namespace duckdb {

void ExtraTypeInfo::Serialize(Serializer &serializer) const {
	serializer.WriteProperty<ExtraTypeInfoType>(100, "type", type);
	serializer.WritePropertyWithDefault<string>(101, "alias", alias);
	/* [Deleted] (vector<Value>) "modifiers" */
	serializer.WritePropertyWithDefault<unique_ptr<ExtensionTypeInfo>>(103, "extension_info", extension_info);
}

shared_ptr<ExtraTypeInfo> ExtraTypeInfo::Deserialize(Deserializer &deserializer) {
	auto type = deserializer.ReadProperty<ExtraTypeInfoType>(100, "type");
	auto alias = deserializer.ReadPropertyWithDefault<string>(101, "alias");
	deserializer.ReadDeletedProperty<vector<Value>>(102, "modifiers");
	auto extension_info = deserializer.ReadPropertyWithDefault<unique_ptr<ExtensionTypeInfo>>(103, "extension_info");
	shared_ptr<ExtraTypeInfo> result;
	switch (type) {
	case ExtraTypeInfoType::AGGREGATE_STATE_TYPE_INFO:
		result = AggregateStateTypeInfo::Deserialize(deserializer);
		break;
	case ExtraTypeInfoType::ANY_TYPE_INFO:
		result = AnyTypeInfo::Deserialize(deserializer);
		break;
	case ExtraTypeInfoType::ARRAY_TYPE_INFO:
		result = ArrayTypeInfo::Deserialize(deserializer);
		break;
	case ExtraTypeInfoType::DECIMAL_TYPE_INFO:
		result = DecimalTypeInfo::Deserialize(deserializer);
		break;
	case ExtraTypeInfoType::ENUM_TYPE_INFO:
		result = EnumTypeInfo::Deserialize(deserializer);
		break;
	case ExtraTypeInfoType::GENERIC_TYPE_INFO:
		result = make_shared_ptr<ExtraTypeInfo>(type);
		break;
	case ExtraTypeInfoType::GEO_TYPE_INFO:
		result = GeoTypeInfo::Deserialize(deserializer);
		break;
	case ExtraTypeInfoType::INTEGER_LITERAL_TYPE_INFO:
		result = IntegerLiteralTypeInfo::Deserialize(deserializer);
		break;
	case ExtraTypeInfoType::INVALID_TYPE_INFO:
		return nullptr;
	case ExtraTypeInfoType::LIST_TYPE_INFO:
		result = ListTypeInfo::Deserialize(deserializer);
		break;
	case ExtraTypeInfoType::STRING_TYPE_INFO:
		result = StringTypeInfo::Deserialize(deserializer);
		break;
	case ExtraTypeInfoType::STRUCT_TYPE_INFO:
		result = StructTypeInfo::Deserialize(deserializer);
		break;
	case ExtraTypeInfoType::TEMPLATE_TYPE_INFO:
		result = TemplateTypeInfo::Deserialize(deserializer);
		break;
	case ExtraTypeInfoType::USER_TYPE_INFO:
		result = UserTypeInfo::Deserialize(deserializer);
		break;
	default:
		throw SerializationException("Unsupported type for deserialization of ExtraTypeInfo!");
	}
	result->alias = std::move(alias);
	result->extension_info = std::move(extension_info);
	return result;
}

void AggregateStateTypeInfo::Serialize(Serializer &serializer) const {
	ExtraTypeInfo::Serialize(serializer);
	serializer.WritePropertyWithDefault<string>(200, "function_name", state_type.function_name);
	serializer.WriteProperty<LogicalType>(201, "return_type", state_type.return_type);
	serializer.WritePropertyWithDefault<vector<LogicalType>>(202, "bound_argument_types", state_type.bound_argument_types);
}

shared_ptr<ExtraTypeInfo> AggregateStateTypeInfo::Deserialize(Deserializer &deserializer) {
	auto result = duckdb::shared_ptr<AggregateStateTypeInfo>(new AggregateStateTypeInfo());
	deserializer.ReadPropertyWithDefault<string>(200, "function_name", result->state_type.function_name);
	deserializer.ReadProperty<LogicalType>(201, "return_type", result->state_type.return_type);
	deserializer.ReadPropertyWithDefault<vector<LogicalType>>(202, "bound_argument_types", result->state_type.bound_argument_types);
	return std::move(result);
}

void AnyTypeInfo::Serialize(Serializer &serializer) const {
	ExtraTypeInfo::Serialize(serializer);
	serializer.WriteProperty<LogicalType>(200, "target_type", target_type);
	serializer.WritePropertyWithDefault<idx_t>(201, "cast_score", cast_score);
}

shared_ptr<ExtraTypeInfo> AnyTypeInfo::Deserialize(Deserializer &deserializer) {
	auto result = duckdb::shared_ptr<AnyTypeInfo>(new AnyTypeInfo());
	deserializer.ReadProperty<LogicalType>(200, "target_type", result->target_type);
	deserializer.ReadPropertyWithDefault<idx_t>(201, "cast_score", result->cast_score);
	return std::move(result);
}

void ArrayTypeInfo::Serialize(Serializer &serializer) const {
	ExtraTypeInfo::Serialize(serializer);
	serializer.WriteProperty<LogicalType>(200, "child_type", child_type);
	serializer.WritePropertyWithDefault<uint32_t>(201, "size", size);
}

shared_ptr<ExtraTypeInfo> ArrayTypeInfo::Deserialize(Deserializer &deserializer) {
	auto child_type = deserializer.ReadProperty<LogicalType>(200, "child_type");
	auto size = deserializer.ReadPropertyWithDefault<uint32_t>(201, "size");
	auto result = duckdb::shared_ptr<ArrayTypeInfo>(new ArrayTypeInfo(std::move(child_type), size));
	return std::move(result);
}

void DecimalTypeInfo::Serialize(Serializer &serializer) const {
	ExtraTypeInfo::Serialize(serializer);
	serializer.WritePropertyWithDefault<uint8_t>(200, "width", width);
	serializer.WritePropertyWithDefault<uint8_t>(201, "scale", scale);
}

shared_ptr<ExtraTypeInfo> DecimalTypeInfo::Deserialize(Deserializer &deserializer) {
	auto result = duckdb::shared_ptr<DecimalTypeInfo>(new DecimalTypeInfo());
	deserializer.ReadPropertyWithDefault<uint8_t>(200, "width", result->width);
	deserializer.ReadPropertyWithDefault<uint8_t>(201, "scale", result->scale);
	return std::move(result);
}

void ExtensionTypeInfo::Serialize(Serializer &serializer) const {
	serializer.WritePropertyWithDefault<vector<LogicalTypeModifier>>(100, "modifiers", modifiers);
	serializer.WritePropertyWithDefault<unordered_map<string, Value>>(101, "properties", properties, unordered_map<string, Value>());
}

unique_ptr<ExtensionTypeInfo> ExtensionTypeInfo::Deserialize(Deserializer &deserializer) {
	auto result = duckdb::unique_ptr<ExtensionTypeInfo>(new ExtensionTypeInfo());
	deserializer.ReadPropertyWithDefault<vector<LogicalTypeModifier>>(100, "modifiers", result->modifiers);
	deserializer.ReadPropertyWithExplicitDefault<unordered_map<string, Value>>(101, "properties", result->properties, unordered_map<string, Value>());
	return result;
}

void GeoTypeInfo::Serialize(Serializer &serializer) const {
	ExtraTypeInfo::Serialize(serializer);
}

shared_ptr<ExtraTypeInfo> GeoTypeInfo::Deserialize(Deserializer &deserializer) {
	auto result = duckdb::shared_ptr<GeoTypeInfo>(new GeoTypeInfo());
	return std::move(result);
}

void IntegerLiteralTypeInfo::Serialize(Serializer &serializer) const {
	ExtraTypeInfo::Serialize(serializer);
	serializer.WriteProperty<Value>(200, "constant_value", constant_value);
}

shared_ptr<ExtraTypeInfo> IntegerLiteralTypeInfo::Deserialize(Deserializer &deserializer) {
	auto result = duckdb::shared_ptr<IntegerLiteralTypeInfo>(new IntegerLiteralTypeInfo());
	deserializer.ReadProperty<Value>(200, "constant_value", result->constant_value);
	return std::move(result);
}

void ListTypeInfo::Serialize(Serializer &serializer) const {
	ExtraTypeInfo::Serialize(serializer);
	serializer.WriteProperty<LogicalType>(200, "child_type", child_type);
}

shared_ptr<ExtraTypeInfo> ListTypeInfo::Deserialize(Deserializer &deserializer) {
	auto result = duckdb::shared_ptr<ListTypeInfo>(new ListTypeInfo());
	deserializer.ReadProperty<LogicalType>(200, "child_type", result->child_type);
	return std::move(result);
}

void LogicalTypeModifier::Serialize(Serializer &serializer) const {
	serializer.WriteProperty<Value>(100, "value", value);
	serializer.WritePropertyWithDefault<string>(101, "label", label);
}

LogicalTypeModifier LogicalTypeModifier::Deserialize(Deserializer &deserializer) {
	auto value = deserializer.ReadProperty<Value>(100, "value");
	LogicalTypeModifier result(value);
	deserializer.ReadPropertyWithDefault<string>(101, "label", result.label);
	return result;
}

void StringTypeInfo::Serialize(Serializer &serializer) const {
	ExtraTypeInfo::Serialize(serializer);
	serializer.WritePropertyWithDefault<string>(200, "collation", collation);
}

shared_ptr<ExtraTypeInfo> StringTypeInfo::Deserialize(Deserializer &deserializer) {
	auto result = duckdb::shared_ptr<StringTypeInfo>(new StringTypeInfo());
	deserializer.ReadPropertyWithDefault<string>(200, "collation", result->collation);
	return std::move(result);
}

void StructTypeInfo::Serialize(Serializer &serializer) const {
	ExtraTypeInfo::Serialize(serializer);
	serializer.WritePropertyWithDefault<child_list_t<LogicalType>>(200, "child_types", child_types);
}

shared_ptr<ExtraTypeInfo> StructTypeInfo::Deserialize(Deserializer &deserializer) {
	auto result = duckdb::shared_ptr<StructTypeInfo>(new StructTypeInfo());
	deserializer.ReadPropertyWithDefault<child_list_t<LogicalType>>(200, "child_types", result->child_types);
	return std::move(result);
}

void TemplateTypeInfo::Serialize(Serializer &serializer) const {
	ExtraTypeInfo::Serialize(serializer);
	serializer.WritePropertyWithDefault<string>(200, "name", name);
}

shared_ptr<ExtraTypeInfo> TemplateTypeInfo::Deserialize(Deserializer &deserializer) {
	auto result = duckdb::shared_ptr<TemplateTypeInfo>(new TemplateTypeInfo());
	deserializer.ReadPropertyWithDefault<string>(200, "name", result->name);
	return std::move(result);
}

void UserTypeInfo::Serialize(Serializer &serializer) const {
	ExtraTypeInfo::Serialize(serializer);
	serializer.WritePropertyWithDefault<string>(200, "user_type_name", user_type_name);
	serializer.WritePropertyWithDefault<string>(201, "catalog", catalog, string());
	serializer.WritePropertyWithDefault<string>(202, "schema", schema, string());
	serializer.WritePropertyWithDefault<vector<Value>>(203, "user_type_modifiers", user_type_modifiers);
}

shared_ptr<ExtraTypeInfo> UserTypeInfo::Deserialize(Deserializer &deserializer) {
	auto result = duckdb::shared_ptr<UserTypeInfo>(new UserTypeInfo());
	deserializer.ReadPropertyWithDefault<string>(200, "user_type_name", result->user_type_name);
	deserializer.ReadPropertyWithExplicitDefault<string>(201, "catalog", result->catalog, string());
	deserializer.ReadPropertyWithExplicitDefault<string>(202, "schema", result->schema, string());
	deserializer.ReadPropertyWithDefault<vector<Value>>(203, "user_type_modifiers", result->user_type_modifiers);
	return std::move(result);
}

} // namespace duckdb
