from typing import Dict, List

# Last retrieved 16 December 2022
DEFAULT_NAMESPACES: Dict[str, List[str]] = {
    "Media": [],
    "Special": [],
    "Talk": [],
    "User": [],
    "User talk": [],
    "Project": ["WP", "Wikipedia"],
    "Project talk": ["Wikipedia talk", "WT"],
    "File": ["Image"],
    "File talk": ["Image talk"],
    "MediaWiki": [],
    "MediaWiki talk": [],
    "Template": [],
    "Template talk": [],
    "Help": [],
    "Help talk": [],
    "Category": [],
    "Category talk": [],
    "Portal": [],
    "Portal talk": [],
    "Draft": [],
    "Draft talk": [],
    "TimedText": [],
    "TimedText talk": [],
    "Module": [],
    "Module talk": [],
    "Gadget": [],
    "Gadget talk": [],
    "Gadget definition": [],
    "Gadget definition talk": [],
}

NAMESPACE_ALIASES: Dict[str, dict] = {
    "ab": {
        "Амедиа": {"canonical": "Media", "aliases": ["Медиа"]},
        "Цастәи": {"canonical": "Special", "aliases": ["Служебная"]},
        "Ахцәажәара": {"canonical": "Talk", "aliases": ["Обсуждение"]},
        "Алахәыла": {"canonical": "User", "aliases": ["Иалахә", "Участник"]},
        "Алахәыла ахцәажәара": {
            "canonical": "User talk",
            "aliases": ["Обсуждение участника"],
        },
        "Авикипедиа": {"canonical": "Project"},
        "Авикипедиа ахцәажәара": {
            "canonical": "Project talk",
            "aliases": ["Обсуждение Авикипедиа"],
        },
        "Афаил": {"canonical": "File", "aliases": ["Изображение", "Файл"]},
        "Афаил ахцәажәара": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения", "Обсуждение файла"],
        },
        "Амедиавики": {"canonical": "MediaWiki"},
        "Амедиавики ахцәажәара": {
            "canonical": "MediaWiki talk",
            "aliases": ["Обсуждение MediaWiki"],
        },
        "Ашаблон": {"canonical": "Template", "aliases": ["Шаблон"]},
        "Ашаблон ахцәажәара": {
            "canonical": "Template talk",
            "aliases": ["Обсуждение шаблона"],
        },
        "Ацхыраара": {"canonical": "Help", "aliases": ["Справка"]},
        "Ацхыраара ахцәажәара": {
            "canonical": "Help talk",
            "aliases": ["Обсуждение справки"],
        },
        "Акатегориа": {"canonical": "Category", "aliases": ["Категория"]},
        "Акатегориа ахцәажәара": {
            "canonical": "Category talk",
            "aliases": ["Обсуждение категории"],
        },
        "Амодуль": {"canonical": "Module", "aliases": ["Амодул"]},
        "Амодуль ахцәажәара": {
            "canonical": "Module talk",
            "aliases": ["Амодул ахцәажәара"],
        },
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "ace": {
        "Alat": {"canonical": "Media"},
        "Kusuih": {"canonical": "Special", "aliases": ["Istimewa"]},
        "Marit": {"canonical": "Talk", "aliases": ["Bicara", "Pembicaraan"]},
        "Ureuëng Ngui": {"canonical": "User", "aliases": ["Pengguna", "Ureuëng Nguy"]},
        "Marit Ureuëng Ngui": {
            "canonical": "User talk",
            "aliases": [
                "Bicara Pengguna",
                "Marit Ureuëng Nguy",
                "Pembicaraan Pengguna",
            ],
        },
        "Wikipedia": {"canonical": "Project"},
        "Marit Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Pembicaraan Wikipedia"],
        },
        "Beureukaih": {"canonical": "File", "aliases": ["Berkas", "Gambar"]},
        "Marit Beureukaih": {
            "canonical": "File talk",
            "aliases": [
                "Gambar Pembicaraan",
                "Pembicaraan Berkas",
                "Pembicaraan Gambar",
            ],
        },
        "MediaWiki": {"aliases": ["AlatWiki"]},
        "Marit MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": [
                "Marit AlatWiki",
                "MediaWiki Pembicaraan",
                "Pembicaraan MediaWiki",
            ],
        },
        "Seunaleuëk": {"canonical": "Template", "aliases": ["Pola", "Templat"]},
        "Marit Seunaleuëk": {
            "canonical": "Template talk",
            "aliases": ["Marit Pola", "Pembicaraan Templat", "Templat Pembicaraan"],
        },
        "Beunantu": {"canonical": "Help", "aliases": ["Bantuan"]},
        "Marit Beunantu": {
            "canonical": "Help talk",
            "aliases": ["Bantuan Pembicaraan", "Pembicaraan Bantuan"],
        },
        "Kawan": {"canonical": "Category", "aliases": ["Kategori"]},
        "Marit Kawan": {
            "canonical": "Category talk",
            "aliases": ["Kategori Pembicaraan", "Pembicaraan Kategori"],
        },
        "Modul": {"canonical": "Module"},
        "Pembicaraan Modul": {"canonical": "Module talk"},
    },
    "ady": {
        "Медиа": {"canonical": "Media"},
        "Википедие": {"canonical": "Project"},
        "Википедием и тегущыӀэн": {"canonical": "Project talk"},
    },
    "af": {
        "Spesiaal": {"canonical": "Special"},
        "Bespreking": {"canonical": "Talk"},
        "Gebruiker": {"canonical": "User"},
        "Gebruikerbespreking": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipediabespreking": {"canonical": "Project talk"},
        "Lêer": {"canonical": "File", "aliases": ["Beeld"]},
        "Lêerbespreking": {"canonical": "File talk", "aliases": ["Beeldbespreking"]},
        "MediaWikibespreking": {"canonical": "MediaWiki talk"},
        "Sjabloon": {"canonical": "Template"},
        "Sjabloonbespreking": {"canonical": "Template talk"},
        "Hulp": {"canonical": "Help"},
        "Hulpbespreking": {"canonical": "Help talk"},
        "Kategorie": {"canonical": "Category"},
        "Kategoriebespreking": {"canonical": "Category talk"},
        "Portaal": {},
        "Portaalbespreking": {},
    },
    "ak": {
        "Soronko": {"canonical": "Special"},
        "Nkɔmmɔ": {"canonical": "Talk"},
        "Odwumanyɛni": {"canonical": "User"},
        "Odwumanyɛni nkɔmmɔbea": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia nkɔmmɔ": {"canonical": "Project talk"},
        "File nkɔmmɔ": {"canonical": "File talk"},
        "MediaWiki nkɔmmɔ": {"canonical": "MediaWiki talk"},
        "Nhwɛsode": {"canonical": "Template"},
        "Nhwɛsode nkɔmmɔbea": {"canonical": "Template talk"},
        "Boa": {"canonical": "Help"},
        "Mmoa nkɔmmɔbea": {"canonical": "Help talk"},
        "Nkyekyem": {"canonical": "Category"},
        "Nkyekyem nkɔmmɔbea": {"canonical": "Category talk"},
    },
    "als": {
        "Medium": {"canonical": "Media"},
        "Spezial": {"canonical": "Special"},
        "Diskussion": {"canonical": "Talk"},
        "Benutzer": {"canonical": "User", "aliases": ["Benutzerin"]},
        "Benutzer Diskussion": {
            "canonical": "User talk",
            "aliases": ["Benutzerin Diskussion"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia Diskussion": {"canonical": "Project talk"},
        "Datei": {"canonical": "File", "aliases": ["Bild"]},
        "Datei Diskussion": {"canonical": "File talk", "aliases": ["Bild Diskussion"]},
        "MediaWiki Diskussion": {"canonical": "MediaWiki talk"},
        "Vorlage": {"canonical": "Template"},
        "Vorlage Diskussion": {"canonical": "Template talk"},
        "Hilfe": {"canonical": "Help"},
        "Hilfe Diskussion": {"canonical": "Help talk"},
        "Kategorie": {"canonical": "Category"},
        "Kategorie Diskussion": {"canonical": "Category talk"},
        "Portal Diskussion": {},
        "Buech": {},
        "Buech Diskussion": {},
        "Wort": {},
        "Wort Diskussion": {},
        "Text": {},
        "Text Diskussion": {},
        "Spruch": {},
        "Spruch Diskussion": {},
        "Nochricht": {},
        "Nochricht Diskussion": {},
        "Modul": {"canonical": "Module"},
        "Modul Diskussion": {"canonical": "Module talk"},
        "Gadget Diskussion": {"canonical": "Gadget talk"},
        "Gadget-Definition": {"canonical": "Gadget definition"},
        "Gadget-Definition Diskussion": {"canonical": "Gadget definition talk"},
    },
    "alt": {
        "Медиа": {"canonical": "Media"},
        "Аҥылу": {"canonical": "Special"},
        "Шӱӱжӱ": {"canonical": "Talk"},
        "Туружаачы": {"canonical": "User"},
        "Туружаачыны шӱӱжери": {"canonical": "User talk"},
        "Википедия": {"canonical": "Project", "aliases": ["ВП"]},
        "Википедияти шӱӱжери": {"canonical": "Project talk"},
        "Файл": {"canonical": "File", "aliases": ["Изображение"]},
        "Файлды шӱӱжери": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения"],
        },
        "MediaWiki-ни шӱӱжери": {"canonical": "MediaWiki talk"},
        "Ӱлекер": {"canonical": "Template"},
        "Ӱлекерди шӱӱжери": {"canonical": "Template talk"},
        "Болуш": {"canonical": "Help"},
        "Болушты шӱӱжери": {"canonical": "Help talk"},
        "Категория": {"canonical": "Category"},
        "Категорияны шӱӱжери": {"canonical": "Category talk"},
        "Модуль": {"canonical": "Module"},
        "Модульды шӱӱжери": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Гаджетти шӱӱжери": {"canonical": "Gadget talk"},
        "Гаджетти аайлары": {"canonical": "Gadget definition"},
        "Гаджеттиҥ аайларын шӱӱжери": {"canonical": "Gadget definition talk"},
    },
    "am": {
        "ፋይል": {"canonical": "Media"},
        "ልዩ": {"canonical": "Special"},
        "ውይይት": {"canonical": "Talk"},
        "አባል": {"canonical": "User"},
        "አባል ውይይት": {"canonical": "User talk"},
        "ውክፔዲያ": {"canonical": "Project"},
        "ውክፔዲያ ውይይት": {"canonical": "Project talk"},
        "ስዕል": {"canonical": "File"},
        "ስዕል ውይይት": {"canonical": "File talk"},
        "መልዕክት": {"canonical": "MediaWiki"},
        "መልዕክት ውይይት": {"canonical": "MediaWiki talk"},
        "መለጠፊያ": {"canonical": "Template", "aliases": ["መልጠፊያ"]},
        "መለጠፊያ ውይይት": {"canonical": "Template talk", "aliases": ["መልጠፊያ ውይይት"]},
        "እርዳታ": {"canonical": "Help"},
        "እርዳታ ውይይት": {"canonical": "Help talk"},
        "መደብ": {"canonical": "Category"},
        "መደብ ውይይት": {"canonical": "Category talk"},
        "በር": {},
        "በር ውይይት": {},
    },
    "ami": {
        "Mitiya": {"canonical": "Media", "aliases": ["媒体", "媒體"]},
        "Kasi’iked": {"canonical": "Special", "aliases": ["Kasi'iked", "特殊"]},
        "Kasasowal": {"canonical": "Talk", "aliases": ["对话", "對話", "討論", "讨论"]},
        "Midemakay": {"canonical": "User", "aliases": ["用戶", "用户"]},
        "Kasasowal no midemakay": {
            "canonical": "User talk",
            "aliases": ["用戶對話", "用戶討論", "用户对话", "用户讨论"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia a kasasowal": {"canonical": "Project talk"},
        "Faylo": {"canonical": "File", "aliases": ["图像", "圖像", "圖片", "文件", "档案", "檔案"]},
        "Masasowal to faylo": {
            "canonical": "File talk",
            "aliases": [
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "圖片討論",
                "文件对话",
                "文件對話",
                "文件討論",
                "文件讨论",
                "档案对话",
                "档案讨论",
                "檔案對話",
                "檔案討論",
            ],
        },
        "Masasowal to MediaWiki": {"canonical": "MediaWiki talk"},
        "Masalipa": {"canonical": "Template", "aliases": ["样板", "模板", "樣板"]},
        "Masalipaay a kasasowal": {
            "canonical": "Template talk",
            "aliases": ["样板对话", "样板讨论", "模板对话", "模板對話", "模板討論", "模板讨论", "樣板對話", "樣板討論"],
        },
        "Nipadama’": {"canonical": "Help", "aliases": ["Nipadama'", "帮助", "幫助"]},
        "Mipadama’ a masasowal": {
            "canonical": "Help talk",
            "aliases": ["Nipadama' a masasowal", "帮助对话", "帮助讨论", "幫助對話", "幫助討論"],
        },
        "Kasasiwasiw": {"canonical": "Category", "aliases": ["分类", "分類"]},
        "Masasowal to kasasiwasiw": {
            "canonical": "Category talk",
            "aliases": ["分类对话", "分类讨论", "分類對話", "分類討論"],
        },
        "模組": {"canonical": "Module", "aliases": ["模块", "模塊", "模组"]},
        "模組討論": {
            "canonical": "Module talk",
            "aliases": ["模块对话", "模块讨论", "模塊對話", "模塊討論", "模組對話", "模组对话", "模组讨论"],
        },
    },
    "an": {
        "Especial": {"canonical": "Special", "aliases": ["Espezial"]},
        "Descusión": {"canonical": "Talk"},
        "Usuario": {"canonical": "User", "aliases": ["Usuaria"]},
        "Descusión usuario": {
            "canonical": "User talk",
            "aliases": ["Descusión usuaria"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Descusión Wikipedia": {"canonical": "Project talk"},
        "Imachen": {"canonical": "File", "aliases": ["Imagen"]},
        "Descusión imachen": {
            "canonical": "File talk",
            "aliases": ["Imagen discusión"],
        },
        "Descusión MediaWiki": {"canonical": "MediaWiki talk"},
        "Plantilla": {"canonical": "Template"},
        "Descusión plantilla": {"canonical": "Template talk"},
        "Aduya": {"canonical": "Help"},
        "Descusión aduya": {"canonical": "Help talk"},
        "Categoría": {"canonical": "Category"},
        "Descusión categoría": {"canonical": "Category talk"},
        "Descusión Portal": {},
        "Módulo": {"canonical": "Module"},
        "Descusión módulo": {"canonical": "Module talk"},
        "Accesorio": {"canonical": "Gadget"},
        "Descusión accesorio": {"canonical": "Gadget talk"},
        "Accesorio definición": {"canonical": "Gadget definition"},
        "Descusión definición accesorio": {"canonical": "Gadget definition talk"},
    },
    "ang": {
        "Syndrig": {"canonical": "Special"},
        "Mōtung": {"canonical": "Talk", "aliases": ["Gesprec", "Motung"]},
        "Brūcend": {"canonical": "User", "aliases": ["Brucend"]},
        "Brūcendmōtung": {"canonical": "User talk", "aliases": ["Brucendmotung"]},
        "Wikipǣdia": {
            "canonical": "Project",
            "aliases": [
                "Wicipaedia",
                "Wicipædia",
                "Wicipǣdia",
                "Wikipaedia",
                "Wikipædia",
                "Ƿicipaedia",
                "Ƿicipædia",
                "Ƿicipǣdia",
                "Ƿikipaedia",
                "Ƿikipædia",
                "Ƿikipǣdia",
            ],
        },
        "Wikipǣdiamōtung": {
            "canonical": "Project talk",
            "aliases": [
                "Wicipaediamotung",
                "Wicipædiamotung",
                "Wicipǣdiamōtung",
                "Wikipaediamotung",
                "Wikipædiamotung",
                "Ƿicipaediamotung",
                "Ƿicipædiamotung",
                "Ƿicipǣdiamōtung",
                "Ƿikipaediamotung",
                "Ƿikipædiamotung",
                "Ƿikipǣdiamōtung",
            ],
        },
        "Ymele": {"canonical": "File", "aliases": ["Biliþ"]},
        "Ymelmōtung": {
            "canonical": "File talk",
            "aliases": ["Biliþmotung", "Biliþmōtung"],
        },
        "MediaWikimōtung": {"canonical": "MediaWiki talk"},
        "Bysen": {"canonical": "Template"},
        "Bysenmōtung": {
            "canonical": "Template talk",
            "aliases": ["Bysengesprec", "Bysenmotung"],
        },
        "Helpmōtung": {
            "canonical": "Help talk",
            "aliases": ["Helpgesprec", "Helpmotung"],
        },
        "Flocc": {"canonical": "Category"},
        "Floccmōtung": {
            "canonical": "Category talk",
            "aliases": ["Floccgesprec", "Floccmotung"],
        },
    },
    "ar": {
        "ميديا": {"canonical": "Media", "aliases": ["وسائط"]},
        "خاص": {"canonical": "Special"},
        "نقاش": {"canonical": "Talk"},
        "مستخدم": {"canonical": "User", "aliases": ["مستخدمة"]},
        "نقاش المستخدم": {"canonical": "User talk", "aliases": ["نقاش المستخدمة"]},
        "ويكيبيديا": {"canonical": "Project", "aliases": ["وب"]},
        "نقاش ويكيبيديا": {"canonical": "Project talk", "aliases": ["نو"]},
        "ملف": {"canonical": "File", "aliases": ["صورة"]},
        "نقاش الملف": {"canonical": "File talk", "aliases": ["نقاش الصورة"]},
        "ميدياويكي": {"canonical": "MediaWiki"},
        "نقاش ميدياويكي": {"canonical": "MediaWiki talk"},
        "قالب": {"canonical": "Template"},
        "نقاش القالب": {"canonical": "Template talk"},
        "مساعدة": {"canonical": "Help"},
        "نقاش المساعدة": {"canonical": "Help talk"},
        "تصنيف": {"canonical": "Category"},
        "نقاش التصنيف": {"canonical": "Category talk"},
        "بوابة": {},
        "نقاش البوابة": {},
        "وحدة": {"canonical": "Module"},
        "نقاش الوحدة": {"canonical": "Module talk"},
        "إضافة": {"canonical": "Gadget"},
        "نقاش الإضافة": {"canonical": "Gadget talk"},
        "تعريف الإضافة": {"canonical": "Gadget definition"},
        "نقاش تعريف الإضافة": {"canonical": "Gadget definition talk"},
        "موضوع": {"canonical": "Topic"},
    },
    "arc": {
        "ܡܝܕܝܐ": {"canonical": "Media"},
        "ܕܝܠܢܝܐ": {"canonical": "Special"},
        "ܡܡܠܠܐ": {"canonical": "Talk"},
        "ܡܦܠܚܢܐ": {"canonical": "User", "aliases": ["ܡܬܚܫܚܢܐ"]},
        "ܡܡܠܠܐ ܕܡܦܠܚܢܐ": {"canonical": "User talk", "aliases": ["ܡܡܠܠܐ ܕܡܬܚܫܚܢܐ"]},
        "ܘܝܩܝܦܕܝܐ": {"canonical": "Project"},
        "ܡܡܠܠܐ ܕܘܝܩܝܦܕܝܐ": {"canonical": "Project talk"},
        "ܠܦܦܐ": {"canonical": "File"},
        "ܡܡܠܠܐ ܕܠܦܦܐ": {"canonical": "File talk"},
        "ܡܝܕܝܐܘܝܩܝ": {"canonical": "MediaWiki"},
        "ܡܡܠܠܐ ܕܡܝܕܝܐܘܝܩܝ": {"canonical": "MediaWiki talk"},
        "ܩܠܒܐ": {"canonical": "Template"},
        "ܡܡܠܠܐ ܕܩܠܒܐ": {"canonical": "Template talk"},
        "ܥܘܕܪܢܐ": {"canonical": "Help"},
        "ܡܡܠܠܐ ܕܥܘܕܪܢܐ": {"canonical": "Help talk"},
        "ܣܕܪܐ": {"canonical": "Category"},
        "ܡܡܠܠܐ ܕܣܕܪܐ": {"canonical": "Category talk"},
    },
    "ary": {
        "ميديا": {"canonical": "Media", "aliases": ["وسائط"]},
        "خاص": {"canonical": "Special"},
        "مداكرة": {"canonical": "Talk", "aliases": ["نقاش"]},
        "خدايمي": {"canonical": "User", "aliases": ["مستخدم", "مستخدمة"]},
        "لمداكرة د لخدايمي": {
            "canonical": "User talk",
            "aliases": ["نقاش المستخدم", "نقاش المستخدمة"],
        },
        "ويكيپيديا": {"canonical": "Project"},
        "لمداكرة د ويكيپيديا": {
            "canonical": "Project talk",
            "aliases": ["نقاش ويكيپيديا"],
        },
        "فيشي": {"canonical": "File", "aliases": ["صورة", "ملف"]},
        "لمداكرة د لفيشي": {
            "canonical": "File talk",
            "aliases": ["نقاش الصورة", "نقاش الملف"],
        },
        "ميدياويكي": {"canonical": "MediaWiki"},
        "لمداكرة د ميدياويكي": {
            "canonical": "MediaWiki talk",
            "aliases": ["نقاش ميدياويكي"],
        },
        "موضيل": {"canonical": "Template", "aliases": ["قالب"]},
        "لمداكرة د لموضيل": {"canonical": "Template talk", "aliases": ["نقاش القالب"]},
        "معاونة": {"canonical": "Help", "aliases": ["مساعدة"]},
        "لمداكرة د لمعاونة": {"canonical": "Help talk", "aliases": ["نقاش المساعدة"]},
        "تصنيف": {"canonical": "Category"},
        "لمداكرة د تصنيف": {"canonical": "Category talk", "aliases": ["نقاش التصنيف"]},
        "قيسارية": {},
        "لمداكرة د لقيسارية": {},
        "واساخ": {},
        "لمداكرة د لواساخ": {},
        "مودول": {"canonical": "Module", "aliases": ["وحدة"]},
        "مداكرة د لمودول": {"canonical": "Module talk", "aliases": ["نقاش الوحدة"]},
        "إضافة": {"canonical": "Gadget"},
        "نقاش الإضافة": {"canonical": "Gadget talk"},
        "تعريف الإضافة": {"canonical": "Gadget definition"},
        "نقاش تعريف الإضافة": {"canonical": "Gadget definition talk"},
    },
    "arz": {
        "ميديا": {"canonical": "Media", "aliases": ["وسائط"]},
        "خاص": {"canonical": "Special"},
        "نقاش": {"canonical": "Talk"},
        "مستخدم": {"canonical": "User", "aliases": ["مستخدمة"]},
        "نقاش المستخدم": {"canonical": "User talk", "aliases": ["نقاش المستخدمة"]},
        "ويكيبيديا": {"canonical": "Project"},
        "نقاش ويكيبيديا": {"canonical": "Project talk"},
        "ملف": {"canonical": "File", "aliases": ["صورة"]},
        "نقاش الملف": {"canonical": "File talk", "aliases": ["نقاش الصورة"]},
        "ميدياويكى": {"canonical": "MediaWiki"},
        "نقاش ميدياويكى": {"canonical": "MediaWiki talk"},
        "قالب": {"canonical": "Template"},
        "نقاش القالب": {"canonical": "Template talk"},
        "مساعدة": {"canonical": "Help"},
        "نقاش المساعدة": {"canonical": "Help talk"},
        "تصنيف": {"canonical": "Category"},
        "نقاش التصنيف": {"canonical": "Category talk"},
        "بوابة": {"aliases": ["Portal"]},
        "مناقشة بوابة": {"aliases": ["Portal talk"]},
        "وحدة": {"canonical": "Module"},
        "نقاش الوحدة": {"canonical": "Module talk"},
        "إضافة": {"canonical": "Gadget"},
        "نقاش الإضافة": {"canonical": "Gadget talk"},
        "تعريف الإضافة": {"canonical": "Gadget definition"},
        "نقاش تعريف الإضافة": {"canonical": "Gadget definition talk"},
    },
    "as": {
        "মাধ্যম": {"canonical": "Media"},
        "বিশেষ": {"canonical": "Special", "aliases": ["विशेष"]},
        "বাৰ্তা": {"canonical": "Talk", "aliases": ["वार्ता", "বার্তা"]},
        "সদস্য": {"canonical": "User", "aliases": ["सदस्य"]},
        "সদস্য বাৰ্তা": {
            "canonical": "User talk",
            "aliases": ["सदस्य वार्ता", "সদস্য বার্তা"],
        },
        "ৱিকিপিডিয়া": {"canonical": "Project", "aliases": ["প্ৰকল্প"]},
        "ৱিকিপিডিয়া বাৰ্তা": {
            "canonical": "Project talk",
            "aliases": [
                "Wikipedia বার্তা",
                "প্ৰকল্প আলোচনা",
                "ৱিকিপিডিয়া वार्ता",
                "ৱিকিপিডিয়া বার্তা",
            ],
        },
        "চিত্ৰ": {"canonical": "File", "aliases": ["चित्र", "চিত্র"]},
        "চিত্ৰ বাৰ্তা": {
            "canonical": "File talk",
            "aliases": ["चित्र वार्ता", "চিত্র বার্তা"],
        },
        "মিডিয়াৱিকি": {"canonical": "MediaWiki", "aliases": ["মেডিয়াৱিকি"]},
        "মিডিয়াৱিকি আলোচনা": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki বার্তা", "মেডিয়াৱিকি বাৰ্তা"],
        },
        "সাঁচ": {"canonical": "Template", "aliases": ["साँचा"]},
        "সাঁচ বাৰ্তা": {
            "canonical": "Template talk",
            "aliases": ["साँचा वार्ता", "সাঁচ বার্তা"],
        },
        "সহায়": {"canonical": "Help"},
        "সহায় বাৰ্তা": {"canonical": "Help talk", "aliases": ["সহায় বার্তা"]},
        "শ্ৰেণী": {"canonical": "Category", "aliases": ["CAT", "श्रेणी", "শ্রেণী"]},
        "শ্ৰেণী বাৰ্তা": {
            "canonical": "Category talk",
            "aliases": ["श्रेणी वार्ता", "শ্রেণী বার্তা"],
        },
        "ৱিকিচ'ৰা": {"aliases": ["বাটচ'ৰা"]},
        "ৱিকিচ'ৰা আলোচনা": {"aliases": ["বাটচ'ৰা আলোচনা"]},
    },
    "ast": {
        "Medios": {"canonical": "Media"},
        "Especial": {"canonical": "Special"},
        "Alderique": {"canonical": "Talk", "aliases": ["Discusión"]},
        "Usuariu": {"canonical": "User", "aliases": ["Usuaria"]},
        "Usuariu alderique": {
            "canonical": "User talk",
            "aliases": ["Usuaria alderique", "Usuariu discusión"],
        },
        "Wikipedia": {"canonical": "Project", "aliases": ["Uiquipedia"]},
        "Wikipedia alderique": {
            "canonical": "Project talk",
            "aliases": ["Uiquipedia alderique", "Wikipedia discusión"],
        },
        "Ficheru": {
            "canonical": "File",
            "aliases": ["Archivu", "Imagen", "Imaxe", "Imaxen"],
        },
        "Ficheru alderique": {
            "canonical": "File talk",
            "aliases": [
                "Archivu alderique",
                "Imagen discusión",
                "Imaxe alderique",
                "Imaxen discusión",
            ],
        },
        "MediaWiki alderique": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki discusión"],
        },
        "Plantía": {"canonical": "Template", "aliases": ["Plantilla"]},
        "Plantía alderique": {
            "canonical": "Template talk",
            "aliases": ["Plantilla discusión"],
        },
        "Ayuda": {"canonical": "Help", "aliases": ["Aida"]},
        "Ayuda alderique": {
            "canonical": "Help talk",
            "aliases": ["Aida alderique", "Ayuda discusión"],
        },
        "Categoría": {"canonical": "Category"},
        "Categoría alderique": {
            "canonical": "Category talk",
            "aliases": ["Categoría discusión"],
        },
        "Módulu": {"canonical": "Module"},
        "Módulu alderique": {"canonical": "Module talk"},
        "Accesoriu": {"canonical": "Gadget"},
        "Accesoriu alderique": {"canonical": "Gadget talk"},
        "Accesoriu definición": {"canonical": "Gadget definition"},
        "Accesoriu definición alderique": {"canonical": "Gadget definition talk"},
    },
    "atj": {
        "Tipatcimoctakewin": {"canonical": "Media"},
        "Kotakahi": {"canonical": "Special"},
        "Ke ici aimihitonaniwok": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Ka notcitatc": {
            "canonical": "User",
            "aliases": ["Utilisateur", "Utilisatrice"],
        },
        "Ke ici aimihitonaniwok notcita iriniw": {
            "canonical": "User talk",
            "aliases": [
                "Discussion Utilisateur",
                "Discussion utilisateur",
                "Discussion utilisatrice",
            ],
        },
        "Wikipetcia": {"canonical": "Project"},
        "Ke ici aimihitonaniwok Wikipetcia": {"canonical": "Project talk"},
        "Natisinahikaniwoc": {"canonical": "File"},
        "Ke ici aimihitonaniwok natisinihikaniwoc": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Ke ici aimihitonaniwok MediaWiki": {"canonical": "MediaWiki talk"},
        "Tipapitcikesinihikan": {
            "canonical": "Template",
            "aliases": ["Tapapitcikesinihikan"],
        },
        "Ke ici arimotcikatek tipapitcikesinihikan": {
            "canonical": "Template talk",
            "aliases": [
                "Discussion Modèle",
                "Ke ici arimotcikatek tapapitcikesinihikan",
            ],
        },
        "Witcihikoiin": {"canonical": "Help"},
        "Ke ici aimihitonaniwok witcihewinik": {
            "canonical": "Help talk",
            "aliases": ["Discussion Aide"],
        },
        "Tipanictawin": {"canonical": "Category"},
        "Ke ici aimihitonaniwok tipanictawin": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Aitapihikewin": {"canonical": "Module"},
        "Aitapihikan ke ici aimihitonaniwok": {"canonical": "Module talk"},
        "Ka ici aimihitonaniwok gadget": {"canonical": "Gadget talk"},
        "Tipatcitcikan e icinakok gadget": {"canonical": "Gadget definition"},
        "Ka ici aimihitonaniwok tipatcitcikan gadget otci": {
            "canonical": "Gadget definition talk"
        },
    },
    "av": {
        "Медиа": {"canonical": "Media"},
        "Хъулухъалъулаб": {"canonical": "Special"},
        "БахӀс": {"canonical": "Talk"},
        "ГӀахьалчи": {"canonical": "User", "aliases": ["ГӀахьалчӀужу"]},
        "ГӀахьалчиясул бахӀс": {
            "canonical": "User talk",
            "aliases": ["ГӀахьалчӀужуялъул бахӀс"],
        },
        "Википедия": {"canonical": "Project"},
        "Википедиялъул бахӀс": {"canonical": "Project talk"},
        "Файл": {"canonical": "File", "aliases": ["Изображение"]},
        "Файлалъул бахӀс": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения"],
        },
        "MediaWiki-ялъул бахӀс": {"canonical": "MediaWiki talk"},
        "Халип": {"canonical": "Template"},
        "Халипалъул бахӀс": {"canonical": "Template talk"},
        "Кумек": {"canonical": "Help"},
        "Кумекалъул бахӀс": {"canonical": "Help talk"},
        "Категория": {"canonical": "Category"},
        "Категориялъул бахӀс": {"canonical": "Category talk"},
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Гаджеталъул бахӀс": {"canonical": "Gadget talk"},
        "Гаджеталъул баян чӀезаби": {"canonical": "Gadget definition"},
        "Гаджеталъул баян чӀезабиялъул бахӀс": {"canonical": "Gadget definition talk"},
    },
    "avk": {
        "Kanaca": {"canonical": "Media", "aliases": ["Mamind"]},
        "Aptaca": {"canonical": "Special"},
        "Prilara": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Favesik": {"canonical": "User", "aliases": ["Utilisateur", "Utilisatrice"]},
        "Favesikprilara": {
            "canonical": "User talk",
            "aliases": [
                "Discussion Utilisateur",
                "Discussion utilisateur",
                "Discussion utilisatrice",
            ],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia prilara": {"canonical": "Project talk"},
        "Iyeltak": {"canonical": "File", "aliases": ["Ewava", "Imagen", "Изображение"]},
        "Iyeltakprilara": {
            "canonical": "File talk",
            "aliases": [
                "Discussion Fichier",
                "Discussion Image",
                "Ewavaprilara",
                "Imagen discusión",
                "Обсуждение изображения",
            ],
        },
        "MediaWiki prilara": {"canonical": "MediaWiki talk"},
        "Teza": {"canonical": "Template"},
        "Tezaprilara": {"canonical": "Template talk", "aliases": ["Discussion Modèle"]},
        "Pomara": {"canonical": "Help"},
        "Pomaraprilara": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Loma": {"canonical": "Category"},
        "Lomaprilara": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Siba": {"canonical": "Module"},
        "Sibaprilara": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "awa": {
        "मीडिया": {"canonical": "Media"},
        "खास": {"canonical": "Special"},
        "बातचीत": {"canonical": "Talk"},
        "यूजर": {"canonical": "User"},
        "यूजर बातचीत": {"canonical": "User talk"},
        "विकिपीडिया": {"canonical": "Project"},
        "विकिपीडिया बातचीत": {"canonical": "Project talk"},
        "फाइल": {"canonical": "File"},
        "फाइल बातचीत": {"canonical": "File talk"},
        "मीडियाविकी": {"canonical": "MediaWiki"},
        "मीडियाविकी बातचीत": {"canonical": "MediaWiki talk"},
        "खाँचा": {"canonical": "Template"},
        "खाँचा बातचीत": {"canonical": "Template talk"},
        "मदद": {"canonical": "Help"},
        "मदद बातचीत": {"canonical": "Help talk"},
        "श्रेणी": {"canonical": "Category"},
        "श्रेणी बातचीत": {"canonical": "Category talk"},
        "गैजेट": {"canonical": "Gadget"},
        "गैजेट वार्ता": {"canonical": "Gadget talk"},
        "गैजेट परिभाषा": {"canonical": "Gadget definition"},
        "गैजेट परिभाषा वार्ता": {"canonical": "Gadget definition talk"},
    },
    "ay": {
        "Medio": {"canonical": "Media"},
        "Especial": {"canonical": "Special"},
        "Discusión": {"canonical": "Talk"},
        "Usuario": {"canonical": "User", "aliases": ["Usuaria"]},
        "Usuario discusión": {
            "canonical": "User talk",
            "aliases": ["Usuaria discusión"],
        },
        "Wikipidiya": {"canonical": "Project"},
        "Wikipidiyan Aruskipäwi": {"canonical": "Project talk"},
        "Archivo": {"canonical": "File", "aliases": ["Imagen"]},
        "Archivo discusión": {
            "canonical": "File talk",
            "aliases": ["Imagen discusión"],
        },
        "MediaWiki discusión": {"canonical": "MediaWiki talk"},
        "Plantilla": {"canonical": "Template"},
        "Plantilla discusión": {"canonical": "Template talk"},
        "Ayuda": {"canonical": "Help"},
        "Ayuda discusión": {"canonical": "Help talk"},
        "Categoría": {"canonical": "Category"},
        "Categoría discusión": {"canonical": "Category talk"},
        "Módulo": {"canonical": "Module"},
        "Módulo discusión": {"canonical": "Module talk"},
        "Accesorio": {"canonical": "Gadget"},
        "Accesorio discusión": {"canonical": "Gadget talk"},
        "Accesorio definición": {"canonical": "Gadget definition"},
        "Accesorio definición discusión": {"canonical": "Gadget definition talk"},
    },
    "az": {
        "Media": {"aliases": ["Mediya"]},
        "Xüsusi": {"canonical": "Special"},
        "Müzakirə": {"canonical": "Talk"},
        "İstifadəçi": {"canonical": "User"},
        "İstifadəçi müzakirəsi": {"canonical": "User talk"},
        "Vikipediya": {"canonical": "Project", "aliases": ["VP"]},
        "Vikipediya müzakirəsi": {"canonical": "Project talk"},
        "Fayl": {"canonical": "File", "aliases": ["Şəkil"]},
        "Fayl müzakirəsi": {"canonical": "File talk", "aliases": ["Şəkil müzakirəsi"]},
        "MediaViki": {"canonical": "MediaWiki", "aliases": ["MediyaViki"]},
        "MediaViki müzakirəsi": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki müzakirəsi", "MediyaViki müzakirəsi"],
        },
        "Şablon": {"canonical": "Template"},
        "Şablon müzakirəsi": {"canonical": "Template talk"},
        "Kömək": {"canonical": "Help"},
        "Kömək müzakirəsi": {"canonical": "Help talk"},
        "Kateqoriya": {"canonical": "Category"},
        "Kateqoriya müzakirəsi": {"canonical": "Category talk"},
        "Portal müzakirəsi": {},
        "Qaralama": {"aliases": ["Draft", "QA"]},
        "Qaralama müzakirəsi": {"aliases": ["Draft talk"]},
        "Modul": {"canonical": "Module"},
        "Modul müzakirəsi": {"canonical": "Module talk"},
        "Qadcet": {"canonical": "Gadget"},
        "Qadcet müzakirəsi": {"canonical": "Gadget talk"},
    },
    "azb": {
        "مدیا": {"canonical": "Media", "aliases": ["رسانه", "رسانه\u200cای"]},
        "اؤزل": {"canonical": "Special"},
        "دانیشیق": {"canonical": "Talk"},
        "ایشلدن": {"canonical": "User"},
        "ایشلدن دانیشیغی": {"canonical": "User talk"},
        "ویکی\u200cپدیا": {"canonical": "Project"},
        "ویکی\u200cپدیا دانیشیغی": {"canonical": "Project talk"},
        "فایل": {"canonical": "File", "aliases": ["تصویر"]},
        "فایل دانیشیغی": {"canonical": "File talk", "aliases": ["بحث تصویر"]},
        "مدیاویکی": {"canonical": "MediaWiki", "aliases": ["مدیا\u200cویکی"]},
        "مدیاویکی دانیشیغی": {
            "canonical": "MediaWiki talk",
            "aliases": ["مدیا\u200cویکی دانیشیغی"],
        },
        "شابلون": {"canonical": "Template"},
        "شابلون دانیشیغی": {"canonical": "Template talk"},
        "کؤمک": {"canonical": "Help"},
        "کؤمک دانیشیغی": {"canonical": "Help talk"},
        "بؤلمه": {"canonical": "Category"},
        "بؤلمه دانیشیغی": {"canonical": "Category talk"},
        "پوْرتال": {},
        "پوْرتال دانیشیغی": {},
        "ماژول": {"canonical": "Module"},
        "ماژول دانیشیغی": {"canonical": "Module talk"},
        "آلت": {"canonical": "Gadget"},
        "آلت دانیشیغی": {"canonical": "Gadget talk"},
        "آلت آچیقلاماسی": {"canonical": "Gadget definition"},
        "آلت آچیقلاماسی دانیشیغی": {"canonical": "Gadget definition talk"},
    },
    "ba": {
        "Медиа": {"canonical": "Media"},
        "Махсус": {"canonical": "Special", "aliases": ["Ярҙамсы"]},
        "Фекерләшеү": {"canonical": "Talk", "aliases": ["Фекер алышыу"]},
        "Ҡатнашыусы": {"canonical": "User"},
        "Ҡатнашыусы менән һөйләшеү": {
            "canonical": "User talk",
            "aliases": ["Ҡатнашыусы м-н фекер алышыу"],
        },
        "Википедия": {"canonical": "Project"},
        "Википедия буйынса фекерләшеү": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia буйынса фекерләшеү", "Википедия б-са фекер алышыу"],
        },
        "Файл": {"canonical": "File", "aliases": ["Изображение", "Рәсем"]},
        "Файл буйынса фекерләшеү": {
            "canonical": "File talk",
            "aliases": [
                "Обсуждение изображения",
                "Рәсем б-са фекер алышыу",
                "Рәсем буйынса фекерләшеү",
            ],
        },
        "MediaWiki буйынса фекерләшеү": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki б-са фекер алышыу"],
        },
        "Ҡалып": {"canonical": "Template"},
        "Ҡалып буйынса фекерләшеү": {
            "canonical": "Template talk",
            "aliases": ["Ҡалып б-са фекер алышыу"],
        },
        "Белешмә": {"canonical": "Help"},
        "Белешмә буйынса фекерләшеү": {
            "canonical": "Help talk",
            "aliases": ["Белешмә б-са фекер алышыу"],
        },
        "Категория": {"canonical": "Category", "aliases": ["Төркөм"]},
        "Категория буйынса фекерләшеү": {
            "canonical": "Category talk",
            "aliases": ["Категория б-са фекер алышыу", "Төркөм буйынса фекерләшеү"],
        },
        "Портал": {},
        "Портал буйынса фекерләшеү": {},
        "Проект": {},
        "Проект буйынса фекерләшеү": {},
        "Модуль": {"canonical": "Module"},
        "Модуль буйынса фекерләшеү": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Гаджет буйынса фекерләшеү": {"canonical": "Gadget talk"},
        "Гаджет билдәһе": {"canonical": "Gadget definition"},
        "Гаджет билдәһе буйынса фекерләшеү": {"canonical": "Gadget definition talk"},
    },
    "ban": {
        "Média": {"canonical": "Media"},
        "Kusus": {"canonical": "Special"},
        "Pabligbagan": {"canonical": "Talk", "aliases": ["Bicara"]},
        "Sang Anganggé": {"canonical": "User", "aliases": ["Sang Anganggé"]},
        "Pabligbagan Sang Anganggé": {
            "canonical": "User talk",
            "aliases": ["Bicara Pengguna", "Pabligbagan Sang Anganggé"],
        },
        "Wikipédia": {"canonical": "Project"},
        "Pabligbagan Wikipédia": {
            "canonical": "Project talk",
            "aliases": ["Pabligbagan Wikipédia", "Wikipédia talk"],
        },
        "Berkas": {"canonical": "File", "aliases": ["Gambar"]},
        "Pabligbagan Berkas": {
            "canonical": "File talk",
            "aliases": [
                "Gambar Pembicaraan",
                "Pabligbagan Berkas",
                "Pembicaraan Gambar",
            ],
        },
        "MédiaWiki": {"canonical": "MediaWiki"},
        "Pabligbagan MédiaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Pembicaraan", "Pabligbagan MédiaWiki"],
        },
        "Mal": {"canonical": "Template"},
        "Pabligbagan Mal": {
            "canonical": "Template talk",
            "aliases": ["Pabligbagan Mal", "Templat Pembicaraan"],
        },
        "Wantuan": {"canonical": "Help"},
        "Pabligbagan Wantuan": {
            "canonical": "Help talk",
            "aliases": ["Bantuan Pembicaraan", "Pabligbagan Wantuan"],
        },
        "Kategori": {"canonical": "Category"},
        "Pabligbagan Kategori": {
            "canonical": "Category talk",
            "aliases": ["Kategori Pembicaraan", "Pabligbagan Kategori"],
        },
        "Modul": {"canonical": "Module"},
        "Pabligbagan Modul": {
            "canonical": "Module talk",
            "aliases": ["Pabligbagan Modul"],
        },
    },
    "bar": {
        "Media": {"aliases": ["Medium"]},
        "Spezial": {"canonical": "Special"},
        "Dischkrian": {"canonical": "Talk", "aliases": ["Diskussion"]},
        "Nutza": {"canonical": "User", "aliases": ["Benutzer"]},
        "Nutza Dischkrian": {
            "canonical": "User talk",
            "aliases": ["Benutzer Diskussion"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia Dischkrian": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia Diskussion"],
        },
        "Datei": {"canonical": "File", "aliases": ["Bild"]},
        "Datei Dischkrian": {
            "canonical": "File talk",
            "aliases": ["Bild Diskussion", "Datei Diskussion"],
        },
        "MediaWiki Dischkrian": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Diskussion"],
        },
        "Vorlog": {"canonical": "Template", "aliases": ["Vorlage"]},
        "Vorlog Dischkrian": {
            "canonical": "Template talk",
            "aliases": ["Vorlage Diskussion"],
        },
        "Huif": {"canonical": "Help", "aliases": ["Hilfe"]},
        "Huif Dischkrian": {"canonical": "Help talk", "aliases": ["Hilfe Diskussion"]},
        "Kategorie": {"canonical": "Category"},
        "Kategorie Dischkrian": {
            "canonical": "Category talk",
            "aliases": ["Kategorie Diskussion"],
        },
        "Portal Dischkrian": {"aliases": ["Portal Diskussion"]},
        "Buach": {},
        "Buach Dischkrian": {},
        "Woat": {},
        "Woat Dischkrian": {},
        "Text": {},
        "Text Dischkrian": {},
        "Spruch": {},
        "Spruch Dischkrian": {},
        "Nochricht": {},
        "Nochricht Dischkrian": {},
        "Modul": {"canonical": "Module"},
        "Modul Diskussion": {"canonical": "Module talk"},
        "Gadget Diskussion": {"canonical": "Gadget talk"},
        "Gadget-Definition": {"canonical": "Gadget definition"},
        "Gadget-Definition Diskussion": {"canonical": "Gadget definition talk"},
    },
    "bat-smg": {
        "Medėjė": {"canonical": "Media"},
        "Specēlos": {"canonical": "Special", "aliases": ["Specialus"]},
        "Aptarėms": {"canonical": "Talk", "aliases": ["Aptarimas"]},
        "Nauduotuos": {"canonical": "User", "aliases": ["Naudotojas"]},
        "Nauduotuojė aptarėms": {
            "canonical": "User talk",
            "aliases": ["Naudotojo aptarimas"],
        },
        "Vikipedėjė": {"canonical": "Project"},
        "Vikipedėjės aptarėms": {
            "canonical": "Project talk",
            "aliases": ["Vikipedėjė aptarimas"],
        },
        "Abruozdielis": {"canonical": "File", "aliases": ["Vaizdas"]},
        "Abruozdielė aptarėms": {
            "canonical": "File talk",
            "aliases": ["Vaizdo aptarimas"],
        },
        "MediaWiki aptarėms": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki aptarimas"],
        },
        "Šabluons": {"canonical": "Template", "aliases": ["Šablonas"]},
        "Šabluona aptarėms": {
            "canonical": "Template talk",
            "aliases": ["Šablono aptarimas"],
        },
        "Pagelba": {"canonical": "Help", "aliases": ["Pagalba"]},
        "Pagelbas aptarėms": {
            "canonical": "Help talk",
            "aliases": ["Pagalbos aptarimas"],
        },
        "Kateguorėjė": {"canonical": "Category", "aliases": ["Kategorija"]},
        "Kateguorėjės aptarėms": {
            "canonical": "Category talk",
            "aliases": ["Kategorijos aptarimas"],
        },
    },
    "bcl": {
        "Medio": {"canonical": "Media"},
        "Espesyal": {"canonical": "Special"},
        "Olay": {"canonical": "Talk"},
        "Paragamit": {"canonical": "User"},
        "Olay kan paragamit": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Olay sa Wikipedia": {"canonical": "Project talk"},
        "Ladawan": {"canonical": "File"},
        "Olay sa ladawan": {"canonical": "File talk"},
        "Olay sa MediaWiki": {"canonical": "MediaWiki talk"},
        "Plantilya": {"canonical": "Template"},
        "Olay sa plantilya": {"canonical": "Template talk"},
        "Tabang": {"canonical": "Help"},
        "Olay sa tabang": {"canonical": "Help talk"},
        "Kategorya": {"canonical": "Category"},
        "Olay sa kategorya": {"canonical": "Category talk"},
    },
    "be": {
        "Мультымедыя": {"canonical": "Media"},
        "Адмысловае": {"canonical": "Special"},
        "Размовы": {"canonical": "Talk"},
        "Удзельнік": {"canonical": "User"},
        "Размовы з удзельнікам": {"canonical": "User talk"},
        "Вікіпедыя": {"canonical": "Project", "aliases": ["ВП"]},
        "Размовы пра Вікіпедыю": {
            "canonical": "Project talk",
            "aliases": ["Вікіпедыя размовы"],
        },
        "Файл": {"canonical": "File", "aliases": ["Выява"]},
        "Размовы пра файл": {
            "canonical": "File talk",
            "aliases": ["Размовы пра выяву"],
        },
        "Размовы пра MediaWiki": {"canonical": "MediaWiki talk"},
        "Шаблон": {"canonical": "Template"},
        "Размовы пра шаблон": {"canonical": "Template talk"},
        "Даведка": {"canonical": "Help"},
        "Размовы пра даведку": {"canonical": "Help talk"},
        "Катэгорыя": {"canonical": "Category"},
        "Размовы пра катэгорыю": {"canonical": "Category talk"},
        "Партал": {"aliases": ["Portal"]},
        "Размовы пра партал": {"aliases": ["Portal talk"]},
        "Модуль": {"canonical": "Module"},
        "Размовы пра модуль": {"canonical": "Module talk"},
    },
    "be-x-old": {
        "Мэдыя": {"canonical": "Media"},
        "Спэцыяльныя": {"canonical": "Special"},
        "Абмеркаваньне": {"canonical": "Talk"},
        "Удзельнік": {"canonical": "User", "aliases": ["Удзельніца"]},
        "Гутаркі ўдзельніка": {
            "canonical": "User talk",
            "aliases": ["Гутаркі ўдзельніцы"],
        },
        "Вікіпэдыя": {"canonical": "Project", "aliases": ["ВП"]},
        "Абмеркаваньне Вікіпэдыі": {
            "canonical": "Project talk",
            "aliases": ["Абмеркаваньне Вікіпэдыя", "Вікіпэдыя размовы"],
        },
        "Файл": {"canonical": "File", "aliases": ["Выява"]},
        "Абмеркаваньне файла": {
            "canonical": "File talk",
            "aliases": ["Абмеркаваньне выявы", "Размовы пра выяву"],
        },
        "Абмеркаваньне MediaWiki": {"canonical": "MediaWiki talk"},
        "Шаблён": {"canonical": "Template"},
        "Абмеркаваньне шаблёну": {"canonical": "Template talk"},
        "Дапамога": {"canonical": "Help"},
        "Абмеркаваньне дапамогі": {"canonical": "Help talk"},
        "Катэгорыя": {"canonical": "Category"},
        "Абмеркаваньне катэгорыі": {"canonical": "Category talk"},
        "Партал": {},
        "Абмеркаваньне парталу": {},
        "Модуль": {"canonical": "Module"},
        "Абмеркаваньне модулю": {"canonical": "Module talk"},
    },
    "bg": {
        "Медия": {"canonical": "Media"},
        "Специални": {"canonical": "Special"},
        "Беседа": {"canonical": "Talk"},
        "Потребител": {"canonical": "User"},
        "Потребител беседа": {"canonical": "User talk"},
        "Уикипедия": {"canonical": "Project"},
        "Уикипедия беседа": {"canonical": "Project talk"},
        "Файл": {"canonical": "File", "aliases": ["Картинка"]},
        "Файл беседа": {"canonical": "File talk", "aliases": ["Картинка беседа"]},
        "МедияУики": {"canonical": "MediaWiki"},
        "МедияУики беседа": {"canonical": "MediaWiki talk"},
        "Шаблон": {"canonical": "Template"},
        "Шаблон беседа": {"canonical": "Template talk"},
        "Помощ": {"canonical": "Help"},
        "Помощ беседа": {"canonical": "Help talk"},
        "Категория": {"canonical": "Category"},
        "Категория беседа": {"canonical": "Category talk"},
        "Портал": {},
        "Портал беседа": {},
        "Чернова": {"aliases": ["Draft"]},
        "Чернова беседа": {"aliases": ["Draft talk"]},
        "Модул": {"canonical": "Module"},
        "Модул беседа": {"canonical": "Module talk"},
    },
    "bh": {
        "मीडिया": {"canonical": "Media"},
        "विशेष": {"canonical": "Special", "aliases": ["बिसेस"]},
        "वार्तालाप": {"canonical": "Talk"},
        "प्रयोगकर्ता": {"canonical": "User", "aliases": ["U", "स", "सदस्य"]},
        "प्रयोगकर्ता वार्ता": {"canonical": "User talk"},
        "विकिपीडिया": {"canonical": "Project", "aliases": ["वि"]},
        "विकिपीडिया वार्ता": {"canonical": "Project talk"},
        "चित्र": {"canonical": "File"},
        "चित्र वार्ता": {"canonical": "File talk"},
        "मीडियाविकि": {"canonical": "MediaWiki"},
        "मीडियाविकि वार्ता": {"canonical": "MediaWiki talk"},
        "टेम्पलेट": {"canonical": "Template"},
        "टेम्पलेट वार्ता": {"canonical": "Template talk"},
        "मदद": {"canonical": "Help"},
        "मदद वार्ता": {"canonical": "Help talk"},
        "श्रेणी": {"canonical": "Category"},
        "श्रेणी वार्ता": {"canonical": "Category talk"},
    },
    "bi": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "bjn": {
        "Istimiwa": {"canonical": "Special", "aliases": ["Istimewa"]},
        "Pamandiran": {"canonical": "Talk", "aliases": ["Bicara", "Pembicaraan"]},
        "Pamakai": {"canonical": "User", "aliases": ["Pengguna"]},
        "Pamandiran Pamakai": {
            "canonical": "User talk",
            "aliases": ["Bicara Pengguna", "Pembicaraan Pengguna"],
        },
        "Wikipidia": {"canonical": "Project"},
        "Pamandiran Wikipidia": {
            "canonical": "Project talk",
            "aliases": ["Pembicaraan Wikipidia", "Wikipidia pamandiran"],
        },
        "Barakas": {"canonical": "File", "aliases": ["Berkas", "Gambar"]},
        "Pamandiran Barakas": {
            "canonical": "File talk",
            "aliases": [
                "Gambar Pembicaraan",
                "Pembicaraan Berkas",
                "Pembicaraan Gambar",
            ],
        },
        "Pamandiran MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Pembicaraan", "Pembicaraan MediaWiki"],
        },
        "Citakan": {"canonical": "Template", "aliases": ["Templat"]},
        "Pamandiran Citakan": {
            "canonical": "Template talk",
            "aliases": ["Pembicaraan Templat", "Templat Pembicaraan"],
        },
        "Patulung": {"canonical": "Help", "aliases": ["Bantuan"]},
        "Pamandiran Patulung": {
            "canonical": "Help talk",
            "aliases": ["Bantuan Pembicaraan", "Pembicaraan Bantuan"],
        },
        "Tumbung": {"canonical": "Category", "aliases": ["Kategori"]},
        "Pamandiran Tumbung": {
            "canonical": "Category talk",
            "aliases": ["Kategori Pembicaraan", "Pembicaraan Kategori"],
        },
        "Lawang": {},
        "Pamandiran Lawang": {},
        "Modul": {"canonical": "Module"},
        "Pembicaraan Modul": {"canonical": "Module talk"},
    },
    "blk": {
        "မီဒီယာ": {"canonical": "Media"},
        "တဲး၀ါး": {"canonical": "Special"},
        "အိုင်ကိုမ်ဒေါ့ꩻရီ": {"canonical": "Talk"},
        "ကေားသုင်ꩻသား": {"canonical": "User"},
        "ကေားသုင်ꩻသား အိုင်ကိုမ်ဒေါ့ꩻရီ": {"canonical": "User talk"},
        "ဝီခီပီးဒီးယား": {"canonical": "Project"},
        "ဝီခီပီးဒီးယား အိုင်ကိုမ်ဒေါ့ꩻရီ": {"canonical": "Project talk"},
        "ဖုဲင်": {"canonical": "File"},
        "ဖုဲင် အိုင်ကိုမ်ဒေါ့ꩻရီ": {"canonical": "File talk"},
        "မီဒီယာဝီခီ": {"canonical": "MediaWiki"},
        "မီဒီယာဝီခီ အိုင်ကိုမ်ဒေါ့ꩻရီ": {"canonical": "MediaWiki talk"},
        "တမ်းပလေက်": {"canonical": "Template"},
        "တမ်းပလေက် အိုင်ကိုမ်ဒေါ့ꩻရီ": {"canonical": "Template talk"},
        "စွဲးကမ်းကို": {"canonical": "Help"},
        "စွဲးကမ်းကို အိုင်ကိုမ်ဒေါ့ꩻရီ": {"canonical": "Help talk"},
        "ကဏ္ဍ": {"canonical": "Category"},
        "ကဏ္ဍ အိုင်ကိုမ်ဒေါ့ꩻရီ": {"canonical": "Category talk"},
        "မော်ဂျူး": {"canonical": "Module"},
        "မော်ဂျူး ဆွေးနွေးချက်": {"canonical": "Module talk"},
        "ကိရိယာငယ်": {"canonical": "Gadget"},
        "ကိရိယာငယ် ဆွေးနွေးချက်": {"canonical": "Gadget talk"},
        "ကိရိယာငယ် အဓိပ္ပာယ်": {"canonical": "Gadget definition"},
        "ကိရိယာငယ် အဓိပ္ပာယ် ဆွေးနွေးချက်": {"canonical": "Gadget definition talk"},
    },
    "bm": {
        "Média": {"canonical": "Media"},
        "Spécial": {"canonical": "Special"},
        "Discussion": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Utilisateur": {"canonical": "User"},
        "Discussion utilisateur": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Discussion Wikipedia": {"canonical": "Project talk"},
        "Fichier": {"canonical": "File"},
        "Discussion fichier": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Discussion MediaWiki": {"canonical": "MediaWiki talk"},
        "Modèle": {"canonical": "Template"},
        "Discussion modèle": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Aide": {"canonical": "Help"},
        "Discussion aide": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Catégorie": {"canonical": "Category"},
        "Discussion catégorie": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "bn": {
        "মিডিয়া": {"canonical": "Media"},
        "বিশেষ": {"canonical": "Special"},
        "আলাপ": {"canonical": "Talk"},
        "ব্যবহারকারী": {"canonical": "User"},
        "ব্যবহারকারী আলাপ": {"canonical": "User talk"},
        "উইকিপিডিয়া": {"canonical": "Project"},
        "উইকিপিডিয়া আলোচনা": {
            "canonical": "Project talk",
            "aliases": ["উইকিপিডিয়া আলাপ"],
        },
        "চিত্র": {"canonical": "File"},
        "চিত্র আলোচনা": {"canonical": "File talk", "aliases": ["চিত্র আলাপ"]},
        "মিডিয়াউইকি": {"canonical": "MediaWiki"},
        "মিডিয়াউইকি আলোচনা": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki আলাপ"],
        },
        "টেমপ্লেট": {"canonical": "Template"},
        "টেমপ্লেট আলোচনা": {"canonical": "Template talk"},
        "সাহায্য": {"canonical": "Help"},
        "সাহায্য আলোচনা": {"canonical": "Help talk"},
        "বিষয়শ্রেণী": {"canonical": "Category"},
        "বিষয়শ্রেণী আলোচনা": {"canonical": "Category talk"},
        "প্রবেশদ্বার": {"aliases": ["Portal"]},
        "প্রবেশদ্বার আলোচনা": {"aliases": ["Portal talk"]},
        "মডিউল": {"canonical": "Module"},
        "মডিউল আলাপ": {"canonical": "Module talk"},
        "গ্যাজেট": {"canonical": "Gadget"},
        "গ্যাজেট আলোচনা": {"canonical": "Gadget talk"},
        "গ্যাজেট সংজ্ঞা": {"canonical": "Gadget definition"},
        "গ্যাজেট সংজ্ঞার আলোচনা": {"canonical": "Gadget definition talk"},
    },
    "bo": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "bpy": {
        "মিডিয়া": {"canonical": "Media"},
        "বিশেষ": {"canonical": "Special"},
        "য়্যারী": {"canonical": "Talk"},
        "আতাকুরা": {"canonical": "User"},
        "আতাকুরার য়্যারী": {"canonical": "User talk"},
        "উইকিপিডিয়া": {"canonical": "Project"},
        "উইকিপিডিয়া য়্যারী": {
            "canonical": "Project talk",
            "aliases": ["উইকিপিডিয়া আলাপ"],
        },
        "ছবি": {"canonical": "File"},
        "ছবি য়্যারী": {"canonical": "File talk", "aliases": ["চিত্র আলাপ"]},
        "মিডিয়াউইকি": {"canonical": "MediaWiki"},
        "মিডিয়াউইকির য়্যারী": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki আলাপ"],
        },
        "মডেল": {"canonical": "Template"},
        "মডেলর য়্যারী": {"canonical": "Template talk"},
        "পাংলাক": {"canonical": "Help"},
        "পাংলাকর য়্যারী": {"canonical": "Help talk"},
        "থাক": {"canonical": "Category"},
        "থাকর য়্যারী": {"canonical": "Category talk"},
        "হমিলদুৱার": {"aliases": ["Portal"]},
        "হমিলদুৱার য়্যারী": {"aliases": ["Portal talk"]},
        "মডিউল": {"canonical": "Module"},
        "মডিউল আলাপ": {"canonical": "Module talk"},
        "গ্যাজেট": {"canonical": "Gadget"},
        "গ্যাজেট আলোচনা": {"canonical": "Gadget talk"},
        "গ্যাজেট সংজ্ঞা": {"canonical": "Gadget definition"},
        "গ্যাজেট সংজ্ঞার আলোচনা": {"canonical": "Gadget definition talk"},
    },
    "br": {
        "Dibar": {"canonical": "Special"},
        "Kaozeal": {"canonical": "Talk"},
        "Implijer": {"canonical": "User", "aliases": ["Implijerez"]},
        "Kaozeadenn Implijer": {
            "canonical": "User talk",
            "aliases": ["Kaozeadenn Implijerez"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Kaozeadenn Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Discussion Wikipedia"],
        },
        "Restr": {"canonical": "File", "aliases": ["Skeudenn"]},
        "Kaozeadenn Restr": {
            "canonical": "File talk",
            "aliases": ["Kaozeadenn Skeudenn"],
        },
        "Kaozeadenn MediaWiki": {"canonical": "MediaWiki talk"},
        "Patrom": {"canonical": "Template"},
        "Kaozeadenn Patrom": {"canonical": "Template talk"},
        "Skoazell": {"canonical": "Help"},
        "Kaozeadenn Skoazell": {"canonical": "Help talk"},
        "Rummad": {"canonical": "Category"},
        "Kaozeadenn Rummad": {"canonical": "Category talk"},
        "Modulenn": {"canonical": "Module"},
        "Kaozeadenn modulenn": {"canonical": "Module talk"},
    },
    "bs": {
        "Mediji": {"canonical": "Media", "aliases": ["Medija"]},
        "Posebno": {"canonical": "Special"},
        "Razgovor": {"canonical": "Talk"},
        "Korisnik": {"canonical": "User"},
        "Razgovor s korisnikom": {
            "canonical": "User talk",
            "aliases": ["Razgovor sa korisnikom"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Razgovor o Wikipediji": {
            "canonical": "Project talk",
            "aliases": [
                "Razgovor Wikipedijom",
                "Razgovor s Wikipedijom",
                "Razgovor s Wikipediom",
            ],
        },
        "Datoteka": {"canonical": "File", "aliases": ["Slika"]},
        "Razgovor o datoteci": {"canonical": "File talk"},
        "MediaWiki": {"aliases": ["MedijaViki"]},
        "Razgovor o MediaWikiju": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki razgovor", "Razgovor o MedijaVikiju"],
        },
        "Šablon": {"canonical": "Template"},
        "Razgovor o šablonu": {"canonical": "Template talk"},
        "Pomoć": {"canonical": "Help"},
        "Razgovor o pomoći": {"canonical": "Help talk"},
        "Kategorija": {"canonical": "Category"},
        "Razgovor o kategoriji": {"canonical": "Category talk"},
        "Razgovor o portalu": {"aliases": ["Portal talk"]},
        "Modul": {"canonical": "Module"},
        "Razgovor o modulu": {"canonical": "Module talk"},
        "Topic": {},
    },
    "bug": {
        "Istimewa": {"canonical": "Special"},
        "Pembicaraan": {"canonical": "Talk", "aliases": ["Bicara"]},
        "Pengguna": {"canonical": "User"},
        "Pembicaraan Pengguna": {
            "canonical": "User talk",
            "aliases": ["Bicara Pengguna"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Pembicaraan Wikipedia": {"canonical": "Project talk"},
        "Berkas": {"canonical": "File", "aliases": ["Gambar"]},
        "Pembicaraan Berkas": {
            "canonical": "File talk",
            "aliases": ["Gambar Pembicaraan", "Pembicaraan Gambar"],
        },
        "Pembicaraan MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Pembicaraan"],
        },
        "Templat": {"canonical": "Template"},
        "Pembicaraan Templat": {
            "canonical": "Template talk",
            "aliases": ["Templat Pembicaraan"],
        },
        "Bantuan": {"canonical": "Help"},
        "Pembicaraan Bantuan": {
            "canonical": "Help talk",
            "aliases": ["Bantuan Pembicaraan"],
        },
        "Kategori": {"canonical": "Category"},
        "Pembicaraan Kategori": {
            "canonical": "Category talk",
            "aliases": ["Kategori Pembicaraan"],
        },
        "Modul": {"canonical": "Module"},
        "Pembicaraan Modul": {"canonical": "Module talk"},
    },
    "bxr": {
        "Меди": {"canonical": "Media"},
        "Тусхай": {"canonical": "Special"},
        "Хэлэлсэхэ": {"canonical": "Talk", "aliases": ["Обсуждение"]},
        "Хэрэглэгшэ": {"canonical": "User", "aliases": ["Участник"]},
        "Хэрэглэгшые хэлэлсэхэ": {
            "canonical": "User talk",
            "aliases": ["Обсуждение участника"],
        },
        "Википеэди": {"canonical": "Project"},
        "Википеэди тухай хэлэлсэхэ": {
            "canonical": "Project talk",
            "aliases": ["Обсуждение Википеэди"],
        },
        "Файл": {"canonical": "File", "aliases": ["Изображение"]},
        "Файл хэлэлсэхэ": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения", "Обсуждение файла"],
        },
        "MediaWiki хэлэлсэхэ": {
            "canonical": "MediaWiki talk",
            "aliases": ["Обсуждение MediaWiki"],
        },
        "Загбар": {"canonical": "Template"},
        "Загбар хэлэлсэхэ": {
            "canonical": "Template talk",
            "aliases": ["Обсуждение шаблона"],
        },
        "Туһаламжа": {"canonical": "Help", "aliases": ["Справка"]},
        "Туһаламжа хэлэлсэл": {
            "canonical": "Help talk",
            "aliases": ["Обсуждение справки"],
        },
        "Категори": {"canonical": "Category", "aliases": ["Категория"]},
        "Категори хэлэлсэхэ": {
            "canonical": "Category talk",
            "aliases": ["Обсуждение категории"],
        },
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "ca": {
        "Especial": {"canonical": "Special"},
        "Discussió": {"canonical": "Talk"},
        "Usuari": {"canonical": "User", "aliases": ["Usuària", "Utilisator"]},
        "Usuari Discussió": {
            "canonical": "User talk",
            "aliases": [
                "Discussion Utilisator",
                "Discutida Utilisator",
                "Usuària Discussió",
            ],
        },
        "Viquipèdia": {"canonical": "Project"},
        "Viquipèdia Discussió": {"canonical": "Project talk"},
        "Fitxer": {"canonical": "File", "aliases": ["Imatge"]},
        "Fitxer Discussió": {
            "canonical": "File talk",
            "aliases": ["Discussion Imatge", "Discutida Imatge", "Imatge Discussió"],
        },
        "MediaWiki": {"aliases": ["Mediaòiqui"]},
        "MediaWiki Discussió": {
            "canonical": "MediaWiki talk",
            "aliases": ["Discussion Mediaòiqui", "Discutida Mediaòiqui"],
        },
        "Plantilla": {"canonical": "Template"},
        "Plantilla Discussió": {
            "canonical": "Template talk",
            "aliases": ["Discutida Modèl"],
        },
        "Ajuda": {"canonical": "Help"},
        "Ajuda Discussió": {"canonical": "Help talk", "aliases": ["Discutida Ajuda"]},
        "Categoria": {"canonical": "Category"},
        "Categoria Discussió": {
            "canonical": "Category talk",
            "aliases": ["Discutida Categoria"],
        },
        "Portal Discussió": {},
        "Viquiprojecte": {},
        "Viquiprojecte Discussió": {},
        "Mòdul": {"canonical": "Module"},
        "Mòdul Discussió": {"canonical": "Module talk"},
        "Tema": {"canonical": "Topic"},
    },
    "cbk-zam": {
        "Medio": {"canonical": "Media"},
        "Especial": {"canonical": "Special"},
        "Discusión": {"canonical": "Talk"},
        "Usuario": {"canonical": "User", "aliases": ["Usuaria"]},
        "Usuario discusión": {
            "canonical": "User talk",
            "aliases": ["Usuaria discusión"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia discusión": {"canonical": "Project talk"},
        "Archivo": {"canonical": "File", "aliases": ["Imagen"]},
        "Archivo discusión": {
            "canonical": "File talk",
            "aliases": ["Imagen discusión"],
        },
        "MediaWiki discusión": {"canonical": "MediaWiki talk"},
        "Plantilla": {"canonical": "Template"},
        "Plantilla discusión": {"canonical": "Template talk"},
        "Ayuda": {"canonical": "Help"},
        "Ayuda discusión": {"canonical": "Help talk"},
        "Categoría": {"canonical": "Category"},
        "Categoría discusión": {"canonical": "Category talk"},
        "Módulo": {"canonical": "Module"},
        "Módulo discusión": {"canonical": "Module talk"},
        "Accesorio": {"canonical": "Gadget"},
        "Accesorio discusión": {"canonical": "Gadget talk"},
        "Accesorio definición": {"canonical": "Gadget definition"},
        "Accesorio definición discusión": {"canonical": "Gadget definition talk"},
    },
    "cdo": {
        "媒體": {"canonical": "Media", "aliases": ["媒体"]},
        "特殊": {"canonical": "Special"},
        "討論": {"canonical": "Talk", "aliases": ["对话", "對話", "讨论"]},
        "用戶": {"canonical": "User", "aliases": ["用户"]},
        "用戶討論": {"canonical": "User talk", "aliases": ["用戶對話", "用户对话", "用户讨论"]},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia討論": {"canonical": "Project talk"},
        "文件": {"canonical": "File", "aliases": ["图像", "圖像", "档案", "檔案"]},
        "文件討論": {
            "canonical": "File talk",
            "aliases": [
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "文件对话",
                "文件對話",
                "文件讨论",
                "档案对话",
                "档案讨论",
                "檔案對話",
                "檔案討論",
            ],
        },
        "MediaWiki": {"aliases": ["媒體維基"]},
        "MediaWiki討論": {"canonical": "MediaWiki talk", "aliases": ["媒體維基討論"]},
        "模板": {"canonical": "Template", "aliases": ["样板", "樣板"]},
        "模板討論": {
            "canonical": "Template talk",
            "aliases": ["样板对话", "样板讨论", "模板对话", "模板對話", "模板讨论", "樣板對話", "樣板討論"],
        },
        "幫助": {"canonical": "Help", "aliases": ["帮助"]},
        "幫助討論": {"canonical": "Help talk", "aliases": ["帮助对话", "帮助讨论", "幫助對話"]},
        "分類": {"canonical": "Category", "aliases": ["分类"]},
        "分類討論": {"canonical": "Category talk", "aliases": ["分类对话", "分类讨论", "分類對話"]},
        "模組": {"canonical": "Module", "aliases": ["模块", "模塊", "模组"]},
        "模組討論": {
            "canonical": "Module talk",
            "aliases": ["模块对话", "模块讨论", "模塊對話", "模塊討論", "模組對話", "模组对话", "模组讨论"],
        },
    },
    "ce": {
        "Медиа": {"canonical": "Media", "aliases": ["Медйа"]},
        "Белхан": {"canonical": "Special", "aliases": ["Башхо"]},
        "Дийцаре": {"canonical": "Talk", "aliases": ["Дийца"]},
        "Декъашхо": {"canonical": "User", "aliases": ["Юзер"]},
        "Декъашхочун дийцаре": {
            "canonical": "User talk",
            "aliases": ["Декъашхон дийцаре", "Дийцаре декъашхо", "Юзери дийца"],
        },
        "Википеди": {"canonical": "Project", "aliases": ["Википедийа"]},
        "Википедин дийцаре": {
            "canonical": "Project talk",
            "aliases": ["Википеди Дийца", "Википедийа дийцаре", "Дийцаре Википеди"],
        },
        "Файл": {"canonical": "File", "aliases": ["Изображение", "Сурт", "Хlум"]},
        "Файлан дийцаре": {
            "canonical": "File talk",
            "aliases": [
                "Дийцаре хlуман",
                "Обсуждение изображения",
                "Сурти дийца",
                "Хlуман дийцаре",
            ],
        },
        "MediaWiki": {"aliases": ["МедйаВики"]},
        "MediaWiki дийцаре": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Дийцаре", "МедйаВики дийца"],
        },
        "Кеп": {"canonical": "Template", "aliases": ["Дакъан", "Куцкеп"]},
        "Кепан дийцаре": {
            "canonical": "Template talk",
            "aliases": ["Дакъан дийца", "Куцкеп дийцаре"],
        },
        "ГӀо": {"canonical": "Help", "aliases": ["Гlо", "ГІо"]},
        "ГӀо дийцаре": {
            "canonical": "Help talk",
            "aliases": ["Гlон дийцаре", "ГІодан дийца"],
        },
        "Категори": {"canonical": "Category", "aliases": ["Кадегар", "Тоба"]},
        "Категорин дийцаре": {
            "canonical": "Category talk",
            "aliases": ["Кадегар дийцаре", "Тобан дийца"],
        },
        "Ков": {},
        "Ков дийцаре": {},
        "Модуль": {"canonical": "Module"},
        "Модулин дийцаре": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "ceb": {
        "Medya": {"canonical": "Media"},
        "Espesyal": {"canonical": "Special"},
        "Hisgot": {"canonical": "Talk"},
        "Gumagamit": {"canonical": "User"},
        "Hisgot sa Gumagamit": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Hisgot sa Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Hisgot saWikipedia"],
        },
        "Payl": {"canonical": "File", "aliases": ["Imahen"]},
        "Hisgot sa Payl": {"canonical": "File talk", "aliases": ["Hisgot sa Imahen"]},
        "Hisgot sa MediaWiki": {"canonical": "MediaWiki talk"},
        "Plantilya": {"canonical": "Template"},
        "Hisgot sa Plantilya": {"canonical": "Template talk"},
        "Tabang": {"canonical": "Help"},
        "Hisgot sa Tabang": {"canonical": "Help talk"},
        "Kategoriya": {"canonical": "Category"},
        "Hisgot sa Kategoriya": {"canonical": "Category talk"},
    },
    "ch": {
        "Espesiat": {"canonical": "Special"},
        "Kombetsasion": {"canonical": "Talk"},
        "Muna'sesetbi": {"canonical": "User"},
        "Kombetsasion ni muna'sesetbi": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Kombetsasion nu Wikipedia": {"canonical": "Project talk"},
        "Litratu": {"canonical": "File"},
        "Kombetsasion ni litratu": {"canonical": "File talk"},
        "Ayudo": {"canonical": "Help"},
        "Kombetsasion ni ayudo": {"canonical": "Help talk"},
        "Katigoria": {"canonical": "Category"},
        "Kombetsasion ni katigoria": {"canonical": "Category talk"},
    },
    "chr": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "chy": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "ckb": {
        "میدیا": {"canonical": "Media"},
        "تایبەت": {"canonical": "Special"},
        "وتووێژ": {"canonical": "Talk", "aliases": ["لێدوان"]},
        "بەکارھێنەر": {"canonical": "User", "aliases": ["U", "ب"]},
        "لێدوانی بەکارھێنەر": {
            "canonical": "User talk",
            "aliases": ["UT", "قسەی بەکارھێنەر", "لب"],
        },
        "ویکیپیدیا": {"canonical": "Project", "aliases": ["وپ"]},
        "لێدوانی ویکیپیدیا": {"canonical": "Project talk", "aliases": ["لو"]},
        "پەڕگە": {"canonical": "File"},
        "وتووێژی پەڕگە": {"canonical": "File talk", "aliases": ["لێدوانی پەڕگە"]},
        "میدیاویکی": {"canonical": "MediaWiki", "aliases": ["مو"]},
        "وتووێژی میدیاویکی": {
            "canonical": "MediaWiki talk",
            "aliases": ["لێدوانی میدیاویکی"],
        },
        "داڕێژە": {"canonical": "Template", "aliases": ["T", "د", "قاڵب"]},
        "وتووێژی داڕێژە": {
            "canonical": "Template talk",
            "aliases": ["لێدوانی داڕێژە", "لێدوانی قاڵب"],
        },
        "یارمەتی": {"canonical": "Help", "aliases": ["H", "ی"]},
        "وتووێژی یارمەتی": {"canonical": "Help talk", "aliases": ["لێدوانی یارمەتی"]},
        "پۆل": {"canonical": "Category", "aliases": ["پ"]},
        "وتووێژی پۆل": {"canonical": "Category talk", "aliases": ["لێدوانی پۆل"]},
        "دەروازە": {"aliases": ["Portal"]},
        "لێدوانی دەروازە": {"aliases": ["Portal talk"]},
        "ویکیپرۆژە": {"aliases": ["Wikiproject", "وپر"]},
        "لێدوانی ویکیپرۆژە": {"aliases": ["Wikiproject talk"]},
        "مۆدیوول": {"canonical": "Module"},
        "لێدوانی مۆدیوول": {"canonical": "Module talk"},
        "ئامراز": {"canonical": "Gadget"},
        "وتووێژی ئامراز": {"canonical": "Gadget talk"},
        "پێناسه\u200cی ئامراز": {"canonical": "Gadget definition"},
        "وتووێژی پێناسه\u200cی ئامراز": {"canonical": "Gadget definition talk"},
    },
    "co": {
        "Speciale": {"canonical": "Special"},
        "Discussione": {"canonical": "Talk"},
        "Utente": {"canonical": "User"},
        "Discussioni utente": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Discussioni Wikipedia": {"canonical": "Project talk"},
        "File": {"aliases": ["Immagine"]},
        "Discussioni file": {
            "canonical": "File talk",
            "aliases": ["Discussioni immagine"],
        },
        "Discussioni MediaWiki": {"canonical": "MediaWiki talk"},
        "Discussioni template": {"canonical": "Template talk"},
        "Aiuto": {"canonical": "Help"},
        "Discussioni aiuto": {"canonical": "Help talk"},
        "Categoria": {"canonical": "Category"},
        "Discussioni categoria": {"canonical": "Category talk"},
        "Modulo": {"canonical": "Module"},
        "Discussioni modulo": {"canonical": "Module talk"},
        "Accessorio": {"canonical": "Gadget"},
        "Discussioni accessorio": {"canonical": "Gadget talk"},
        "Definizione accessorio": {"canonical": "Gadget definition"},
        "Discussioni definizione accessorio": {"canonical": "Gadget definition talk"},
    },
    "cr": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "crh": {
        "Media": {"aliases": ["Медиа"]},
        "Mahsus": {"canonical": "Special", "aliases": ["Махсус"]},
        "Muzakere": {"canonical": "Talk", "aliases": ["Музакере"]},
        "Qullanıcı": {"canonical": "User", "aliases": ["Къулланыджы"]},
        "Qullanıcı muzakeresi": {
            "canonical": "User talk",
            "aliases": [
                "Qullanıcı muzakeresi",
                "Къулланыджы музакереси",
                "Къулланыджы музакереси",
            ],
        },
        "Vikipediya": {"canonical": "Project"},
        "Vikipediya muzakeresi": {
            "canonical": "Project talk",
            "aliases": [
                "Vikipediya muzakeresi",
                "Vikipediya музакереси",
                "Vikipediya музакереси",
            ],
        },
        "Fayl": {"canonical": "File", "aliases": ["Resim", "Ресим", "Файл"]},
        "Fayl muzakeresi": {
            "canonical": "File talk",
            "aliases": [
                "Fayl muzakeresi",
                "Resim muzakeresi",
                "Ресим музакереси",
                "Файл музакереси",
            ],
        },
        "MediaViki": {"canonical": "MediaWiki", "aliases": ["МедиаВики"]},
        "MediaViki muzakeresi": {
            "canonical": "MediaWiki talk",
            "aliases": [
                "MediaViki muzakeresi",
                "МедиаВики музакереси",
                "МедиаВики музакереси",
            ],
        },
        "Şablon": {"canonical": "Template", "aliases": ["Шаблон"]},
        "Şablon muzakeresi": {
            "canonical": "Template talk",
            "aliases": ["Şablon muzakeresi", "Шаблон музакереси", "Шаблон музакереси"],
        },
        "Yardım": {"canonical": "Help", "aliases": ["Ярдым"]},
        "Yardım muzakeresi": {
            "canonical": "Help talk",
            "aliases": ["Yardım muzakeresi", "Разговор о помоћи", "Ярдым музакереси"],
        },
        "Kategoriya": {"canonical": "Category", "aliases": ["Категория"]},
        "Kategoriya muzakeresi": {
            "canonical": "Category talk",
            "aliases": [
                "Kategoriya muzakeresi",
                "Категория музакереси",
                "Категория музакереси",
            ],
        },
        "Modul": {"canonical": "Module", "aliases": ["Модуль"]},
        "Modul muzakeresi": {
            "canonical": "Module talk",
            "aliases": ["Обсуждение модуля"],
        },
        "Gadget": {"aliases": ["Гаджет"]},
        "Gadget talk": {"aliases": ["Обсуждение гаджета"]},
        "Gadget definition": {"aliases": ["Определение гаджета"]},
        "Gadget definition talk": {"aliases": ["Обсуждение определения гаджета"]},
    },
    "cs": {
        "Média": {"canonical": "Media"},
        "Speciální": {"canonical": "Special"},
        "Diskuse": {"canonical": "Talk", "aliases": ["Komentár"]},
        "Wikipedista": {
            "canonical": "User",
            "aliases": ["Redaktor", "Uživatel", "Wikipedistka"],
        },
        "Diskuse s wikipedistou": {
            "canonical": "User talk",
            "aliases": [
                "Diskuse s uživatelem",
                "Diskuse s wikipedistkou",
                "Diskusia s redaktorom",
                "Komentár k redaktorovi",
                "Uživatel diskuse",
                "Uživatelka diskuse",
                "Wikipedista diskuse",
                "Wikipedistka diskuse",
            ],
        },
        "Wikipedie": {"canonical": "Project"},
        "Diskuse k Wikipedii": {
            "canonical": "Project talk",
            "aliases": ["Komentár k Wikipédii", "Wikipedie diskuse"],
        },
        "Soubor": {"canonical": "File", "aliases": ["Obrázok"]},
        "Diskuse k souboru": {
            "canonical": "File talk",
            "aliases": ["Diskusia k obrázku", "Komentár k obrázku", "Soubor diskuse"],
        },
        "Diskuse k MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Komentár k MediaWiki", "MediaWiki diskuse"],
        },
        "Šablona": {"canonical": "Template"},
        "Diskuse k šabloně": {
            "canonical": "Template talk",
            "aliases": ["Šablona diskuse"],
        },
        "Nápověda": {"canonical": "Help"},
        "Diskuse k nápovědě": {
            "canonical": "Help talk",
            "aliases": ["Nápověda diskuse"],
        },
        "Kategorie": {"canonical": "Category"},
        "Diskuse ke kategorii": {
            "canonical": "Category talk",
            "aliases": ["Kategorie diskuse"],
        },
        "Portál": {"aliases": ["Portal"]},
        "Diskuse k portálu": {"aliases": ["Portal talk", "Portál diskuse"]},
        "Rejstřík": {},
        "Diskuse k rejstříku": {"aliases": ["Rejstřík diskuse"]},
        "Modul": {"canonical": "Module"},
        "Diskuse k modulu": {"canonical": "Module talk"},
        "Udělátko": {"canonical": "Gadget"},
        "Diskuse k udělátku": {"canonical": "Gadget talk"},
        "Definice udělátka": {"canonical": "Gadget definition"},
        "Diskuse k definici udělátka": {"canonical": "Gadget definition talk"},
        "Téma": {"canonical": "Topic"},
    },
    "csb": {
        "Specjalnô": {"canonical": "Special"},
        "Diskùsëjô": {"canonical": "Talk"},
        "Brëkòwnik": {"canonical": "User", "aliases": ["Użytkowniczka", "Użytkownik"]},
        "Diskùsëjô brëkòwnika": {
            "canonical": "User talk",
            "aliases": ["Dyskusja użytkowniczki", "Dyskusja użytkownika"],
        },
        "Wiki": {"canonical": "Project"},
        "Diskùsëjô Wiki": {"canonical": "Project talk"},
        "Òbrôzk": {"canonical": "File", "aliases": ["Grafika"]},
        "Diskùsëjô òbrôzków": {
            "canonical": "File talk",
            "aliases": ["Dyskusja grafiki"],
        },
        "Diskùsëjô MediaWiki": {"canonical": "MediaWiki talk"},
        "Szablóna": {"canonical": "Template"},
        "Diskùsëjô Szablónë": {"canonical": "Template talk"},
        "Pòmòc": {"canonical": "Help"},
        "Diskùsëjô Pòmòcë": {"canonical": "Help talk"},
        "Kategòrëjô": {"canonical": "Category"},
        "Diskùsëjô Kategòrëji": {"canonical": "Category talk"},
        "Moduł": {"canonical": "Module"},
        "Dyskusja modułu": {"canonical": "Module talk"},
        "Gadżet": {"canonical": "Gadget"},
        "Dyskusja gadżetu": {"canonical": "Gadget talk"},
        "Definicja gadżetu": {"canonical": "Gadget definition"},
        "Dyskusja definicji gadżetu": {"canonical": "Gadget definition talk"},
    },
    "cu": {
        "Срѣдьства": {"canonical": "Media"},
        "Нарочьна": {"canonical": "Special"},
        "Бєсѣда": {"canonical": "Talk", "aliases": ["Бесѣда"]},
        "Польꙃєватєл҄ь": {
            "canonical": "User",
            "aliases": ["Польѕевател҄ь", "Участник"],
        },
        "Польꙃєватєлꙗ бєсѣда": {
            "canonical": "User talk",
            "aliases": ["Польѕевател\uf011 бесѣда"],
        },
        "Википєдїꙗ": {"canonical": "Project", "aliases": ["Википє́дїꙗ"]},
        "Википєдїѩ бєсѣда": {
            "canonical": "Project talk",
            "aliases": ["Википє́дїѩ бєсѣ́да", "Википєдїѩ бєсѣ́да", "Википєдїꙗ бесѣда"],
        },
        "Дѣло": {"canonical": "File", "aliases": ["Ви́дъ", "Видъ"]},
        "Дѣла бєсѣда": {
            "canonical": "File talk",
            "aliases": ["Ви́да бєсѣ́да", "Вида бесѣда"],
        },
        "MediaWiki бєсѣда": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki бесѣда"],
        },
        "Обраꙁьць": {"canonical": "Template", "aliases": ["Образьць", "Шаблон"]},
        "Обраꙁьца бєсѣда": {
            "canonical": "Template talk",
            "aliases": ["Образьца бесѣда"],
        },
        "Помощь": {"canonical": "Help"},
        "Помощи бєсѣда": {"canonical": "Help talk", "aliases": ["Помощи бесѣда"]},
        "Катигорїꙗ": {
            "canonical": "Category",
            "aliases": ["Категория", "Катигорї\uf011"],
        },
        "Катигорїѩ бєсѣда": {
            "canonical": "Category talk",
            "aliases": ["Катигорїѩ бесѣда"],
        },
    },
    "cv": {
        "Медиа": {"canonical": "Media"},
        "Ятарлă": {"canonical": "Special"},
        "Сӳтсе явасси": {"canonical": "Talk"},
        "Хутшăнакан": {"canonical": "User"},
        "Хутшăнаканăн канашлу страници": {"canonical": "User talk"},
        "Википеди": {"canonical": "Project"},
        "Википеди сӳтсе явмалли": {"canonical": "Project talk"},
        "Ӳкерчĕк": {"canonical": "File", "aliases": ["Изображение"]},
        "Ӳкерчĕке сӳтсе явмалли": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения"],
        },
        "MediaWiki сӳтсе явмалли": {"canonical": "MediaWiki talk"},
        "Шаблон": {"canonical": "Template"},
        "Шаблона сӳтсе явмалли": {"canonical": "Template talk"},
        "Пулăшу": {"canonical": "Help"},
        "Пулăшăва сӳтсе явмалли": {"canonical": "Help talk"},
        "Категори": {"canonical": "Category"},
        "Категорине сӳтсе явмалли": {"canonical": "Category talk"},
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "cy": {
        "Arbennig": {"canonical": "Special"},
        "Sgwrs": {"canonical": "Talk"},
        "Defnyddiwr": {"canonical": "User"},
        "Sgwrs Defnyddiwr": {"canonical": "User talk"},
        "Wicipedia": {"canonical": "Project"},
        "Sgwrs Wicipedia": {"canonical": "Project talk"},
        "Delwedd": {"canonical": "File"},
        "Sgwrs Delwedd": {"canonical": "File talk"},
        "MediaWici": {"canonical": "MediaWiki"},
        "Sgwrs MediaWici": {"canonical": "MediaWiki talk"},
        "Nodyn": {"canonical": "Template"},
        "Sgwrs Nodyn": {"canonical": "Template talk"},
        "Cymorth": {"canonical": "Help"},
        "Sgwrs Cymorth": {"canonical": "Help talk"},
        "Categori": {"canonical": "Category"},
        "Sgwrs Categori": {"canonical": "Category talk"},
        "Porth": {},
        "Sgwrs Porth": {},
        "Modiwl": {"canonical": "Module"},
        "Sgwrs modiwl": {"canonical": "Module talk"},
    },
    "da": {
        "Speciel": {"canonical": "Special"},
        "Diskussion": {"canonical": "Talk"},
        "Bruger": {"canonical": "User"},
        "Brugerdiskussion": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia-diskussion": {"canonical": "Project talk"},
        "Fil": {"canonical": "File", "aliases": ["Billede"]},
        "Fildiskussion": {"canonical": "File talk", "aliases": ["Billeddiskussion"]},
        "MediaWiki-diskussion": {"canonical": "MediaWiki talk"},
        "Skabelon": {"canonical": "Template"},
        "Skabelondiskussion": {"canonical": "Template talk"},
        "Hjælp": {"canonical": "Help"},
        "Hjælp-diskussion": {"canonical": "Help talk"},
        "Kategori": {"canonical": "Category"},
        "Kategoridiskussion": {"canonical": "Category talk"},
        "Portaldiskussion": {"aliases": ["Portal diskussion"]},
        "Artikeldata": {},
        "Artikeldatadiskussion": {},
        "Modul": {"canonical": "Module"},
        "Moduldiskussion": {"canonical": "Module talk"},
    },
    "dag": {
        "Miidiya": {"canonical": "Media"},
        "Diŋ'gahim": {"canonical": "Special"},
        "Yɛltɔɣa": {"canonical": "Talk"},
        "Ŋun su": {"canonical": "User"},
        "Ŋun su yɛltɔɣa": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia yɛltɔɣa": {"canonical": "Project talk"},
        "Lahabali kɔligu": {"canonical": "File"},
        "Lahabali kɔligu yɛltɔɣa": {"canonical": "File talk"},
        "MiidiyaWiki": {"canonical": "MediaWiki"},
        "MiidiyaWiki yɛltɔɣa": {"canonical": "MediaWiki talk"},
        "Tɛmplet": {"canonical": "Template"},
        "Tɛmplet yɛltɔɣa": {"canonical": "Template talk"},
        "Sɔŋsim": {"canonical": "Help"},
        "Sɔŋsim yɛltɔɣa": {"canonical": "Help talk"},
        "Pubu": {"canonical": "Category"},
        "Pubu yɛltɔɣa": {"canonical": "Category talk"},
        "Salima": {},
        "Salima yɛltɔɣa": {},
    },
    "de": {
        "Medium": {"canonical": "Media"},
        "Spezial": {"canonical": "Special"},
        "Diskussion": {"canonical": "Talk"},
        "Benutzer": {"canonical": "User", "aliases": ["Benutzerin"]},
        "Benutzer Diskussion": {
            "canonical": "User talk",
            "aliases": ["BD", "Benutzerin Diskussion"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia Diskussion": {"canonical": "Project talk", "aliases": ["WD"]},
        "Datei": {"canonical": "File", "aliases": ["Bild"]},
        "Datei Diskussion": {"canonical": "File talk", "aliases": ["Bild Diskussion"]},
        "MediaWiki Diskussion": {"canonical": "MediaWiki talk"},
        "Vorlage": {"canonical": "Template"},
        "Vorlage Diskussion": {"canonical": "Template talk"},
        "Hilfe": {"canonical": "Help", "aliases": ["H"]},
        "Hilfe Diskussion": {"canonical": "Help talk", "aliases": ["HD"]},
        "Kategorie": {"canonical": "Category"},
        "Kategorie Diskussion": {"canonical": "Category talk"},
        "Portal": {"aliases": ["P"]},
        "Portal Diskussion": {"aliases": ["PD"]},
        "Modul": {"canonical": "Module"},
        "Modul Diskussion": {"canonical": "Module talk"},
        "Gadget Diskussion": {"canonical": "Gadget talk"},
        "Gadget-Definition": {"canonical": "Gadget definition"},
        "Gadget-Definition Diskussion": {"canonical": "Gadget definition talk"},
    },
    "din": {
        "Ciɛl": {"canonical": "Media"},
        "Këcëweek": {"canonical": "Special"},
        "Jam": {"canonical": "Talk"},
        "Dulooi": {"canonical": "User"},
        "Jam kekë dulooi": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Jam wɛ̈t ë Wikipedia": {"canonical": "Project talk"},
        "Apamduööt": {"canonical": "File"},
        "Jam wɛ̈t ë apamduööt": {"canonical": "File talk"},
        "Jam wɛ̈t ë MediaWiki": {"canonical": "MediaWiki talk"},
        "Macuëc": {"canonical": "Template"},
        "Jam wɛ̈t ë macuëc": {"canonical": "Template talk"},
        "Kuɔny": {"canonical": "Help"},
        "Jam wɛ̈t ë kuɔny": {"canonical": "Help talk"},
        "Bekätakthook": {"canonical": "Category"},
        "Jam wɛ̈t ë bekätakthook": {"canonical": "Category talk"},
        "Mukääcëtök": {"canonical": "Module"},
        "Jam wɛ̈t ë mukääcëtök": {"canonical": "Module talk"},
        "Muluuitet": {"canonical": "Gadget"},
        "Jam wɛ̈t ë muluuitet": {"canonical": "Gadget talk"},
        "Wɛ̈tdic ë muluuitet": {"canonical": "Gadget definition"},
        "Jam wɛ̈t ë wɛ̈tdic ë muluuitet": {"canonical": "Gadget definition talk"},
    },
    "diq": {
        "Medya": {"canonical": "Media"},
        "Bağse": {"canonical": "Special", "aliases": ["Xısusi"]},
        "Vaten": {"canonical": "Talk", "aliases": ["Mesac", "Werênayış"]},
        "Karber": {"canonical": "User"},
        "Karber vaten": {
            "canonical": "User talk",
            "aliases": ["Karber mesac", "Karber werênayış"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia vaten": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia mesac", "Wikipedia werênayış"],
        },
        "Dosya": {"canonical": "File"},
        "Dosya vaten": {
            "canonical": "File talk",
            "aliases": ["Dosya mesac", "Dosya werênayış"],
        },
        "MediaWiki vaten": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki mesac", "MediaWiki werênayış"],
        },
        "Şablon": {"canonical": "Template"},
        "Şablon vaten": {
            "canonical": "Template talk",
            "aliases": ["Şablon mesac", "Şablon werênayış"],
        },
        "Desteg": {"canonical": "Help", "aliases": ["Peşti"]},
        "Desteg vaten": {
            "canonical": "Help talk",
            "aliases": ["Desteg werênayış", "Peşti mesac", "Peşti werênayış"],
        },
        "Kategori": {"canonical": "Category", "aliases": ["Kategoriye"]},
        "Kategori vaten": {
            "canonical": "Category talk",
            "aliases": [
                "Kategori werênayış",
                "Kategoriye mesac",
                "Kategoriye werênayış",
            ],
        },
        "Portal vaten": {},
        "Modul": {"canonical": "Module"},
        "Modul vaten": {"canonical": "Module talk"},
        "Halet": {"canonical": "Gadget"},
        "Halet vaten": {"canonical": "Gadget talk"},
        "Halet şınasnayış": {"canonical": "Gadget definition"},
        "Halet şınasnayış vaten": {"canonical": "Gadget definition talk"},
    },
    "dsb": {
        "Medija": {"canonical": "Media"},
        "Specialne": {"canonical": "Special"},
        "Diskusija": {"canonical": "Talk"},
        "Wužywaŕ": {"canonical": "User", "aliases": ["Wužywarka"]},
        "Diskusija wužywarja": {
            "canonical": "User talk",
            "aliases": ["Diskusija wužywarki"],
        },
        "Wikipedija": {"canonical": "Project"},
        "Wikipedija diskusija": {"canonical": "Project talk"},
        "Dataja": {"canonical": "File", "aliases": ["Bild", "Wobraz"]},
        "Diskusija wó dataji": {
            "canonical": "File talk",
            "aliases": [
                "Bild Diskussion",
                "Diskusija k wobrazej",
                "Diskusija wó wobrazu",
            ],
        },
        "MediaWiki diskusija": {"canonical": "MediaWiki talk"},
        "Pśedłoga": {"canonical": "Template"},
        "Diskusija wó pśedłoze": {"canonical": "Template talk"},
        "Pomoc": {"canonical": "Help"},
        "Diskusija wó pomocy": {"canonical": "Help talk"},
        "Kategorija": {"canonical": "Category"},
        "Diskusija wó kategoriji": {"canonical": "Category talk"},
        "Modul": {"canonical": "Module"},
        "Modul diskusija": {"canonical": "Module talk"},
        "Gadget Diskussion": {"canonical": "Gadget talk"},
        "Gadget-Definition": {"canonical": "Gadget definition"},
        "Gadget-Definition Diskussion": {"canonical": "Gadget definition talk"},
    },
    "dty": {
        "मिडिया": {"canonical": "Media"},
        "बिशेष": {"canonical": "Special"},
        "कुरणि": {"canonical": "Talk"},
        "प्रयोगकर्ता": {"canonical": "User"},
        "प्रयोगकर्ता कुरणि": {"canonical": "User talk"},
        "विकिपिडिया": {"canonical": "Project"},
        "विकिपिडिया वार्ता": {"canonical": "Project talk"},
        "चित्र": {"canonical": "File"},
        "चित्र कुरणि": {"canonical": "File talk"},
        "मिडियाविकि": {"canonical": "MediaWiki"},
        "मिडियाविकि कुरणि": {"canonical": "MediaWiki talk"},
        "ढाँचा": {"canonical": "Template"},
        "ढाँचा कुरणि": {"canonical": "Template talk"},
        "मद्दत": {"canonical": "Help"},
        "मद्दत कुरणि": {"canonical": "Help talk"},
        "श्रेणी": {"canonical": "Category"},
        "श्रेणी कुरणि": {"canonical": "Category talk"},
        "मोड्युल": {"canonical": "Module"},
        "मोड्युल कुरणि": {"canonical": "Module talk"},
        "ग्याजेट": {"canonical": "Gadget"},
        "ग्याजेट कुरणि": {"canonical": "Gadget talk"},
        "ग्याजेट परिभाषा": {"canonical": "Gadget definition"},
        "ग्याजेट परिभाषा कुरणि": {"canonical": "Gadget definition talk"},
    },
    "dv": {
        "މީޑިއާ": {"canonical": "Media"},
        "ޚާއްސަ": {"canonical": "Special", "aliases": ["ހާއްޞަ"]},
        "ޚިޔާލު": {"canonical": "Talk"},
        "މެމްބަރު": {"canonical": "User"},
        "މެމްބަރުގެ ވާހަކަ": {"canonical": "User talk"},
        "ވިކިޕީޑިއާ": {"canonical": "Project"},
        "ވިކިޕީޑިއާ ޚިޔާލު": {"canonical": "Project talk"},
        "ފައިލު": {"canonical": "File", "aliases": ["ފައިލް"]},
        "ފައިލުގެ ޚިޔާލު": {"canonical": "File talk", "aliases": ["ފައިލް ޚިޔާލު"]},
        "މީޑިއާވިކީ": {"canonical": "MediaWiki"},
        "މިޑިއާވިކީ ޚިޔާލު": {
            "canonical": "MediaWiki talk",
            "aliases": ["މީޑިޔާވިކި ޚިޔާލު"],
        },
        "ފަންވަތް": {"canonical": "Template"},
        "ފަންވަތުގެ ޚިޔާލު": {
            "canonical": "Template talk",
            "aliases": ["ފަންވަތް ޚިޔާލު"],
        },
        "އެހީ": {"canonical": "Help"},
        "އެހީގެ ޚިޔާލު": {"canonical": "Help talk", "aliases": ["އެހީ ޚިޔާލު"]},
        "ޤިސްމު": {"canonical": "Category"},
        "ޤިސްމުގެ ޚިޔާލު": {"canonical": "Category talk", "aliases": ["ޤިސްމު ޚިޔާލު"]},
        "ނެރު": {"aliases": ["Portal"]},
        "ނެރު ޚިޔާލު": {"aliases": ["Portal talk"]},
        "މޮޑިއުލް": {"canonical": "Module"},
        "މޮޑިއުލް ޚިޔާލު": {"canonical": "Module talk"},
    },
    "dz": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "ee": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "el": {
        "Μέσο": {"canonical": "Media", "aliases": ["Μέσον"]},
        "Ειδικό": {"canonical": "Special"},
        "Συζήτηση": {"canonical": "Talk"},
        "Χρήστης": {"canonical": "User"},
        "Συζήτηση χρήστη": {"canonical": "User talk"},
        "Βικιπαίδεια": {"canonical": "Project", "aliases": ["ΒΠ"]},
        "Συζήτηση Βικιπαίδεια": {
            "canonical": "Project talk",
            "aliases": ["Βικιπαίδεια συζήτηση"],
        },
        "Αρχείο": {"canonical": "File", "aliases": ["Εικόνα"]},
        "Συζήτηση αρχείου": {"canonical": "File talk", "aliases": ["Συζήτηση εικόνας"]},
        "Συζήτηση MediaWiki": {"canonical": "MediaWiki talk"},
        "Πρότυπο": {"canonical": "Template"},
        "Συζήτηση προτύπου": {"canonical": "Template talk"},
        "Βοήθεια": {"canonical": "Help"},
        "Συζήτηση βοήθειας": {"canonical": "Help talk"},
        "Κατηγορία": {"canonical": "Category"},
        "Συζήτηση κατηγορίας": {"canonical": "Category talk"},
        "Πύλη": {},
        "Συζήτηση πύλης": {},
        "Education Program": {},
        "Education Program talk": {},
        "Topic": {},
    },
    "eml": {
        "Speciale": {"canonical": "Special"},
        "Discussione": {"canonical": "Talk"},
        "Utente": {"canonical": "User"},
        "Discussioni utente": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Discussioni Wikipedia": {"canonical": "Project talk"},
        "File": {"aliases": ["Immagine"]},
        "Discussioni file": {
            "canonical": "File talk",
            "aliases": ["Discussioni immagine"],
        },
        "Discussioni MediaWiki": {"canonical": "MediaWiki talk"},
        "Discussioni template": {"canonical": "Template talk"},
        "Aiuto": {"canonical": "Help"},
        "Discussioni aiuto": {"canonical": "Help talk"},
        "Categoria": {"canonical": "Category"},
        "Discussioni categoria": {"canonical": "Category talk"},
        "Mòdul": {"canonical": "Module"},
        "Discusiòun dal Mòdul": {"canonical": "Module talk"},
        "Accessorio": {"canonical": "Gadget"},
        "Discussioni accessorio": {"canonical": "Gadget talk"},
        "Definizione accessorio": {"canonical": "Gadget definition"},
        "Discussioni definizione accessorio": {"canonical": "Gadget definition talk"},
    },
    "en": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "eo": {
        "Aŭdvidaĵo": {"canonical": "Media"},
        "Specialaĵo": {"canonical": "Special", "aliases": ["Speciala"]},
        "Diskuto": {"canonical": "Talk"},
        "Uzanto": {
            "canonical": "User",
            "aliases": ["Uzantino", "Uzulo", "Vikipediisto"],
        },
        "Uzanto-Diskuto": {
            "canonical": "User talk",
            "aliases": [
                "Uzanta diskuto",
                "Uzantino-Diskuto",
                "Uzula diskuto",
                "Vikipediista diskuto",
            ],
        },
        "Vikipedio": {"canonical": "Project", "aliases": ["VP"]},
        "Vikipedia diskuto": {
            "canonical": "Project talk",
            "aliases": ["Vikipedio diskuto"],
        },
        "Dosiero": {"canonical": "File"},
        "Dosiero-Diskuto": {"canonical": "File talk", "aliases": ["Dosiera diskuto"]},
        "MediaWiki": {"aliases": ["MediaVikio"]},
        "MediaWiki-Diskuto": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaVikia diskuto", "MediaWiki diskuto"],
        },
        "Ŝablono": {"canonical": "Template"},
        "Ŝablono-Diskuto": {
            "canonical": "Template talk",
            "aliases": ["Ŝablona diskuto"],
        },
        "Helpo": {"canonical": "Help"},
        "Helpo-Diskuto": {"canonical": "Help talk", "aliases": ["Helpa diskuto"]},
        "Kategorio": {"canonical": "Category"},
        "Kategorio-Diskuto": {
            "canonical": "Category talk",
            "aliases": ["Kategoria diskuto"],
        },
        "Portalo": {},
        "Portala diskuto": {},
        "Projekto": {},
        "Projekta diskuto": {},
        "Modulo": {"canonical": "Module"},
        "Modulo-Diskuto": {"canonical": "Module talk"},
        "Topic": {},
    },
    "es": {
        "Medio": {"canonical": "Media"},
        "Especial": {"canonical": "Special"},
        "Discusión": {"canonical": "Talk"},
        "Usuario": {"canonical": "User", "aliases": ["Usuaria"]},
        "Usuario discusión": {
            "canonical": "User talk",
            "aliases": ["Usuaria discusión"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia discusión": {"canonical": "Project talk"},
        "Archivo": {"canonical": "File", "aliases": ["Imagen"]},
        "Archivo discusión": {
            "canonical": "File talk",
            "aliases": ["Imagen discusión"],
        },
        "MediaWiki discusión": {"canonical": "MediaWiki talk"},
        "Plantilla": {"canonical": "Template"},
        "Plantilla discusión": {"canonical": "Template talk"},
        "Ayuda": {"canonical": "Help"},
        "Ayuda discusión": {"canonical": "Help talk"},
        "Categoría": {"canonical": "Category", "aliases": ["CAT"]},
        "Categoría discusión": {"canonical": "Category talk"},
        "Portal discusión": {},
        "Wikiproyecto": {"aliases": ["PR"]},
        "Wikiproyecto discusión": {},
        "Anexo": {},
        "Anexo discusión": {},
        "Módulo": {"canonical": "Module"},
        "Módulo discusión": {"canonical": "Module talk"},
        "Accesorio": {"canonical": "Gadget"},
        "Accesorio discusión": {"canonical": "Gadget talk"},
        "Accesorio definición": {"canonical": "Gadget definition"},
        "Accesorio definición discusión": {"canonical": "Gadget definition talk"},
    },
    "et": {
        "Meedia": {"canonical": "Media"},
        "Eri": {"canonical": "Special"},
        "Arutelu": {"canonical": "Talk"},
        "Kasutaja": {"canonical": "User"},
        "Kasutaja arutelu": {"canonical": "User talk"},
        "Vikipeedia": {"canonical": "Project"},
        "Vikipeedia arutelu": {"canonical": "Project talk"},
        "Fail": {"canonical": "File", "aliases": ["Pilt"]},
        "Faili arutelu": {"canonical": "File talk", "aliases": ["Pildi arutelu"]},
        "MediaWiki arutelu": {"canonical": "MediaWiki talk"},
        "Mall": {"canonical": "Template"},
        "Malli arutelu": {"canonical": "Template talk"},
        "Juhend": {"canonical": "Help"},
        "Juhendi arutelu": {"canonical": "Help talk"},
        "Kategooria": {"canonical": "Category"},
        "Kategooria arutelu": {"canonical": "Category talk"},
        "Portaal": {"aliases": ["Portal"]},
        "Portaali arutelu": {"aliases": ["Portal talk"]},
        "Mustand": {"aliases": ["Draft"]},
        "Mustandi arutelu": {"aliases": ["Draft talk"]},
        "Moodul": {"canonical": "Module"},
        "Mooduli arutelu": {"canonical": "Module talk"},
        "Tööriist": {"canonical": "Gadget"},
        "Tööriista arutelu": {"canonical": "Gadget talk"},
        "Tööriista määratlus": {"canonical": "Gadget definition"},
        "Tööriista määratluse arutelu": {"canonical": "Gadget definition talk"},
    },
    "eu": {
        "Berezi": {"canonical": "Special", "aliases": ["Aparteko"]},
        "Eztabaida": {"canonical": "Talk"},
        "Lankide": {"canonical": "User"},
        "Lankide eztabaida": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia eztabaida": {"canonical": "Project talk"},
        "Fitxategi": {"canonical": "File", "aliases": ["Irudi"]},
        "Fitxategi eztabaida": {
            "canonical": "File talk",
            "aliases": ["Irudi eztabaida"],
        },
        "MediaWiki eztabaida": {"canonical": "MediaWiki talk"},
        "Txantiloi": {"canonical": "Template"},
        "Txantiloi eztabaida": {"canonical": "Template talk"},
        "Laguntza": {"canonical": "Help"},
        "Laguntza eztabaida": {"canonical": "Help talk"},
        "Kategoria": {"canonical": "Category"},
        "Kategoria eztabaida": {"canonical": "Category talk"},
        "Atari": {},
        "Atari eztabaida": {},
        "Wikiproiektu": {},
        "Wikiproiektu eztabaida": {},
        "Txikipedia": {},
        "Txikipedia eztabaida": {},
        "Zerrenda": {},
        "Zerrenda eztabaida": {},
        "Modulu": {"canonical": "Module"},
        "Modulu eztabaida": {"canonical": "Module talk"},
        "Gadget eztabaida": {"canonical": "Gadget talk"},
        "Gadget definizio": {"canonical": "Gadget definition"},
        "Gadget definizio eztabaida": {"canonical": "Gadget definition talk"},
        "Topic": {},
    },
    "ext": {
        "Mediu": {"canonical": "Media"},
        "Especial": {"canonical": "Special"},
        "Caraba": {"canonical": "Talk"},
        "Usuario": {"canonical": "User", "aliases": ["Usuaria"]},
        "Usuario caraba": {"canonical": "User talk", "aliases": ["Usuaria caraba"]},
        "Güiquipeya": {"canonical": "Project"},
        "Güiquipeya caraba": {"canonical": "Project talk"},
        "Archivu": {"canonical": "File", "aliases": ["Imagen"]},
        "Archivu caraba": {"canonical": "File talk", "aliases": ["Imagen discusión"]},
        "MediaWiki caraba": {"canonical": "MediaWiki talk"},
        "Prantilla": {"canonical": "Template"},
        "Prantilla caraba": {"canonical": "Template talk"},
        "Ayua": {"canonical": "Help"},
        "Ayua caraba": {"canonical": "Help talk"},
        "Categoría": {"canonical": "Category", "aliases": ["Categoria"]},
        "Categoría caraba": {
            "canonical": "Category talk",
            "aliases": ["Categoria caraba"],
        },
        "Módulo": {"canonical": "Module"},
        "Módulo discusión": {"canonical": "Module talk"},
        "Accesorio": {"canonical": "Gadget"},
        "Accesorio discusión": {"canonical": "Gadget talk"},
        "Accesorio definición": {"canonical": "Gadget definition"},
        "Accesorio definición discusión": {"canonical": "Gadget definition talk"},
    },
    "fa": {
        "مدیا": {"canonical": "Media", "aliases": ["رسانه", "رسانه\u200cای"]},
        "ویژه": {"canonical": "Special"},
        "بحث": {"canonical": "Talk"},
        "کاربر": {"canonical": "User", "aliases": ["كاربر"]},
        "بحث کاربر": {"canonical": "User talk", "aliases": ["بحث كاربر", "بک"]},
        "ویکی\u200cپدیا": {
            "canonical": "Project",
            "aliases": ["ويكي پديا", "ويکي\u200cپديا", "وپ", "ویکی پدیا"],
        },
        "بحث ویکی\u200cپدیا": {
            "canonical": "Project talk",
            "aliases": ["بحث ويکي پديا", "بحث ويکي\u200cپديا", "بحث ویکی پدیا", "بوپ"],
        },
        "پرونده": {"canonical": "File", "aliases": ["تصویر"]},
        "بحث پرونده": {"canonical": "File talk", "aliases": ["بحث تصویر"]},
        "مدیاویکی": {"canonical": "MediaWiki"},
        "بحث مدیاویکی": {"canonical": "MediaWiki talk"},
        "الگو": {"canonical": "Template"},
        "بحث الگو": {"canonical": "Template talk"},
        "راهنما": {"canonical": "Help"},
        "بحث راهنما": {"canonical": "Help talk"},
        "رده": {"canonical": "Category"},
        "بحث رده": {"canonical": "Category talk"},
        "درگاه": {},
        "بحث درگاه": {},
        "پیش\u200cنویس": {
            "aliases": [
                "Draft",
                "پيش نويس",
                "پيشنويس",
                "پيش\u200cنويس",
                "پیش نویس",
                "پیشنویس",
            ]
        },
        "بحث پیش\u200cنویس": {
            "aliases": [
                "Draft talk",
                "بحث پيش نويس",
                "بحث پيشنويس",
                "بحث پيش\u200cنويس",
                "بحث پیش نویس",
                "بحث پیشنویس",
            ]
        },
        "Education Program": {},
        "Education Program talk": {},
        "پودمان": {"canonical": "Module", "aliases": ["پود"]},
        "بحث پودمان": {"canonical": "Module talk"},
        "ابزار": {"canonical": "Gadget"},
        "بحث ابزار": {"canonical": "Gadget talk"},
        "توضیحات ابزار": {"canonical": "Gadget definition"},
        "بحث توضیحات ابزار": {"canonical": "Gadget definition talk"},
        "مبحث": {"canonical": "Topic"},
    },
    "ff": {
        "Media": {"aliases": ["Média"]},
        "Special": {"aliases": ["Spécial"]},
        "Talk": {"aliases": ["Discussion", "Discuter"]},
        "User": {"aliases": ["Utilisateur"]},
        "User talk": {"aliases": ["Discussion Utilisateur", "Discussion utilisateur"]},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {
            "canonical": "Project talk",
            "aliases": ["Discussion Wikipedia"],
        },
        "File": {"aliases": ["Fichier"]},
        "File talk": {
            "aliases": ["Discussion Fichier", "Discussion Image", "Discussion fichier"]
        },
        "MediaWiki talk": {"aliases": ["Discussion MediaWiki"]},
        "Template": {"aliases": ["Modèle"]},
        "Template talk": {"aliases": ["Discussion Modèle", "Discussion modèle"]},
        "Help": {"aliases": ["Aide"]},
        "Help talk": {"aliases": ["Discussion Aide", "Discussion aide"]},
        "Category": {"aliases": ["Catégorie"]},
        "Category talk": {"aliases": ["Discussion Catégorie", "Discussion catégorie"]},
    },
    "fi": {
        "Toiminnot": {"canonical": "Special"},
        "Keskustelu": {"canonical": "Talk"},
        "Käyttäjä": {"canonical": "User"},
        "Keskustelu käyttäjästä": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Keskustelu Wikipediasta": {"canonical": "Project talk"},
        "Tiedosto": {"canonical": "File", "aliases": ["Kuva"]},
        "Keskustelu tiedostosta": {
            "canonical": "File talk",
            "aliases": ["Keskustelu kuvasta"],
        },
        "Järjestelmäviesti": {"canonical": "MediaWiki"},
        "Keskustelu järjestelmäviestistä": {"canonical": "MediaWiki talk"},
        "Malline": {"canonical": "Template"},
        "Keskustelu mallineesta": {"canonical": "Template talk"},
        "Ohje": {"canonical": "Help"},
        "Keskustelu ohjeesta": {"canonical": "Help talk"},
        "Luokka": {"canonical": "Category"},
        "Keskustelu luokasta": {"canonical": "Category talk"},
        "Teemasivu": {},
        "Keskustelu teemasivusta": {},
        "Metasivu": {},
        "Keskustelu metasivusta": {},
        "Kirja": {},
        "Keskustelu kirjasta": {},
        "Wikiprojekti": {},
        "Keskustelu wikiprojektista": {},
        "Moduuli": {"canonical": "Module"},
        "Keskustelu moduulista": {"canonical": "Module talk"},
        "Pienoisohjelma": {"canonical": "Gadget"},
        "Keskustelu pienoisohjelmasta": {"canonical": "Gadget talk"},
        "Pienoisohjelman määritys": {"canonical": "Gadget definition"},
        "Keskustelu pienoisohjelman määrityksestä": {
            "canonical": "Gadget definition talk"
        },
        "Aihe": {"canonical": "Topic"},
    },
    "fiu-vro": {
        "Meediä": {"canonical": "Media"},
        "Tallituslehekülg": {"canonical": "Special"},
        "Arotus": {"canonical": "Talk"},
        "Pruukja": {"canonical": "User"},
        "Pruukja arotus": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia arotus": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia arutelu"],
        },
        "Pilt": {"canonical": "File"},
        "Pildi arotus": {"canonical": "File talk", "aliases": ["Pildi arutelu"]},
        "MediaWiki arotus": {"canonical": "MediaWiki talk"},
        "Näüdüs": {"canonical": "Template"},
        "Näüdüse arotus": {"canonical": "Template talk"},
        "Oppus": {"canonical": "Help"},
        "Oppusõ arotus": {"canonical": "Help talk"},
        "Katõgooria": {"canonical": "Category"},
        "Katõgooria arotus": {"canonical": "Category talk"},
        "Moodul": {"canonical": "Module"},
        "Mooduli arutelu": {"canonical": "Module talk"},
        "Tööriist": {"canonical": "Gadget"},
        "Tööriista arutelu": {"canonical": "Gadget talk"},
        "Tööriista määratlus": {"canonical": "Gadget definition"},
        "Tööriista määratluse arutelu": {"canonical": "Gadget definition talk"},
    },
    "fj": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "fo": {
        "Miðil": {"canonical": "Media"},
        "Serstakt": {"canonical": "Special", "aliases": ["Serstakur"]},
        "Kjak": {"canonical": "Talk"},
        "Brúkari": {"canonical": "User"},
        "Brúkarakjak": {"canonical": "User talk", "aliases": ["Brúkari kjak"]},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia-kjak": {"canonical": "Project talk", "aliases": ["Wikipedia kjak"]},
        "Mynd": {"canonical": "File"},
        "Myndakjak": {"canonical": "File talk", "aliases": ["Mynd kjak"]},
        "MediaWiki": {"aliases": ["MidiaWiki"]},
        "MediaWiki-kjak": {
            "canonical": "MediaWiki talk",
            "aliases": ["MidiaWiki kjak"],
        },
        "Fyrimynd": {"canonical": "Template"},
        "Fyrimyndakjak": {"canonical": "Template talk", "aliases": ["Fyrimynd kjak"]},
        "Hjálp": {"canonical": "Help"},
        "Hjálparkjak": {"canonical": "Help talk", "aliases": ["Hjálp kjak"]},
        "Bólkur": {"canonical": "Category"},
        "Bólkakjak": {"canonical": "Category talk", "aliases": ["Bólkur kjak"]},
    },
    "fr": {
        "Média": {"canonical": "Media"},
        "Spécial": {"canonical": "Special"},
        "Discussion": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Utilisateur": {"canonical": "User", "aliases": ["Utilisatrice"]},
        "Discussion utilisateur": {
            "canonical": "User talk",
            "aliases": [
                "Discussion Utilisateur",
                "Discussion Utilisatrice",
                "Discussion utilisatrice",
            ],
        },
        "Wikipédia": {"canonical": "Project"},
        "Discussion Wikipédia": {
            "canonical": "Project talk",
            "aliases": ["DW", "Discussion Wikipedia"],
        },
        "Fichier": {"canonical": "File"},
        "Discussion fichier": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Discussion MediaWiki": {"canonical": "MediaWiki talk"},
        "Modèle": {"canonical": "Template"},
        "Discussion modèle": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Aide": {"canonical": "Help"},
        "Discussion aide": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Catégorie": {"canonical": "Category"},
        "Discussion catégorie": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Portail": {},
        "Discussion Portail": {},
        "Projet": {},
        "Discussion Projet": {},
        "Référence": {},
        "Discussion Référence": {},
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
        "Sujet": {"canonical": "Topic"},
    },
    "frp": {
        "Mèdia": {"canonical": "Media"},
        "Spèciâl": {"canonical": "Special"},
        "Discussion": {"canonical": "Talk", "aliases": ["Discutar", "Discuter"]},
        "Utilisator": {"canonical": "User", "aliases": ["Usanciér"]},
        "Discussion utilisator": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur", "Discussion usanciér"],
        },
        "Vouiquipèdia": {"canonical": "Project"},
        "Discussion Vouiquipèdia": {"canonical": "Project talk"},
        "Fichiér": {"canonical": "File", "aliases": ["Émâge"]},
        "Discussion fichiér": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image", "Discussion Émâge"],
        },
        "Discussion MediaWiki": {"canonical": "MediaWiki talk"},
        "Modèlo": {"canonical": "Template"},
        "Discussion modèlo": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle", "Discussion Modèlo"],
        },
        "Éde": {"canonical": "Help"},
        "Discussion éde": {
            "canonical": "Help talk",
            "aliases": ["Discussion Aide", "Discussion Éde"],
        },
        "Catègorie": {"canonical": "Category"},
        "Discussion catègorie": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catègorie", "Discussion Catégorie"],
        },
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "frr": {
        "Medium": {"canonical": "Media"},
        "Spezial": {"canonical": "Special"},
        "Diskussion": {"canonical": "Talk"},
        "Benutzer": {"canonical": "User", "aliases": ["Benutzerin"]},
        "Benutzer Diskussion": {
            "canonical": "User talk",
            "aliases": ["Benutzerin Diskussion"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia Diskussion": {"canonical": "Project talk"},
        "Datei": {"canonical": "File", "aliases": ["Bild"]},
        "Datei Diskussion": {"canonical": "File talk", "aliases": ["Bild Diskussion"]},
        "MediaWiki Diskussion": {"canonical": "MediaWiki talk"},
        "Vorlage": {"canonical": "Template"},
        "Vorlage Diskussion": {"canonical": "Template talk"},
        "Hilfe": {"canonical": "Help"},
        "Hilfe Diskussion": {"canonical": "Help talk"},
        "Kategorie": {"canonical": "Category"},
        "Kategorie Diskussion": {"canonical": "Category talk"},
        "Seite": {"canonical": "Page"},
        "Seite Diskussion": {"canonical": "Page talk"},
        "Index": {},
        "Index Diskussion": {"canonical": "Index talk"},
        "Text": {},
        "Text Diskussion": {},
        "Modul": {"canonical": "Module"},
        "Modul Diskussion": {"canonical": "Module talk"},
        "Gadget Diskussion": {"canonical": "Gadget talk"},
        "Gadget-Definition": {"canonical": "Gadget definition"},
        "Gadget-Definition Diskussion": {"canonical": "Gadget definition talk"},
    },
    "fur": {
        "Speciâl": {"canonical": "Special"},
        "Discussion": {"canonical": "Talk"},
        "Utent": {"canonical": "User"},
        "Discussion utent": {"canonical": "User talk"},
        "Vichipedie": {"canonical": "Project"},
        "Discussion Vichipedie": {"canonical": "Project talk"},
        "Figure": {"canonical": "File", "aliases": ["Immagine"]},
        "Discussion figure": {
            "canonical": "File talk",
            "aliases": ["Discussioni immagine"],
        },
        "Discussion MediaWiki": {"canonical": "MediaWiki talk"},
        "Model": {"canonical": "Template"},
        "Discussion model": {"canonical": "Template talk"},
        "Jutori": {"canonical": "Help"},
        "Discussion jutori": {"canonical": "Help talk"},
        "Categorie": {"canonical": "Category"},
        "Discussion categorie": {"canonical": "Category talk"},
        "Modulo": {"canonical": "Module"},
        "Discussioni modulo": {"canonical": "Module talk"},
        "Accessorio": {"canonical": "Gadget"},
        "Discussioni accessorio": {"canonical": "Gadget talk"},
        "Definizione accessorio": {"canonical": "Gadget definition"},
        "Discussioni definizione accessorio": {"canonical": "Gadget definition talk"},
    },
    "fy": {
        "Wiki": {"canonical": "Special"},
        "Oerlis": {"canonical": "Talk"},
        "Meidogger": {"canonical": "User", "aliases": ["Brûker"]},
        "Meidogger oerlis": {"canonical": "User talk", "aliases": ["Brûker oerlis"]},
        "Wikipedy": {"canonical": "Project"},
        "Wikipedy oerlis": {"canonical": "Project talk"},
        "Ofbyld": {"canonical": "File"},
        "Ofbyld oerlis": {"canonical": "File talk"},
        "MediaWiki oerlis": {"canonical": "MediaWiki talk"},
        "Berjocht": {"canonical": "Template"},
        "Berjocht oerlis": {"canonical": "Template talk"},
        "Hulp": {"canonical": "Help"},
        "Hulp oerlis": {"canonical": "Help talk"},
        "Kategory": {"canonical": "Category"},
        "Kategory oerlis": {"canonical": "Category talk"},
    },
    "ga": {
        "Meán": {"canonical": "Media"},
        "Speisialta": {"canonical": "Special"},
        "Plé": {"canonical": "Talk"},
        "Úsáideoir": {"canonical": "User"},
        "Plé úsáideora": {"canonical": "User talk"},
        "Vicipéid": {"canonical": "Project"},
        "Plé Vicipéide": {"canonical": "Project talk"},
        "Íomhá": {"canonical": "File"},
        "Plé íomhá": {"canonical": "File talk", "aliases": ["Plé í\xadomhá"]},
        "Plé MediaWiki": {"canonical": "MediaWiki talk"},
        "Teimpléad": {"canonical": "Template", "aliases": ["Múnla"]},
        "Plé teimpléid": {"canonical": "Template talk", "aliases": ["Plé múnla"]},
        "Cabhair": {"canonical": "Help"},
        "Plé cabhrach": {"canonical": "Help talk"},
        "Catagóir": {"canonical": "Category", "aliases": ["Rang"]},
        "Plé catagóire": {"canonical": "Category talk"},
    },
    "gag": {
        "Mediya": {"canonical": "Media", "aliases": ["Medya"]},
        "Maasus": {"canonical": "Special", "aliases": ["Özel"]},
        "Dartışma": {"canonical": "Talk", "aliases": ["Tartışma"]},
        "Kullanıcı": {"canonical": "User"},
        "Kullanıcı dartışma": {
            "canonical": "User talk",
            "aliases": ["Kullanıcı mesaj"],
        },
        "Vikipediya": {"canonical": "Project"},
        "Vikipediyanın laflanması": {
            "canonical": "Project talk",
            "aliases": ["Vikipediya tartışma"],
        },
        "Dosye": {"canonical": "File", "aliases": ["Dosya", "Resim"]},
        "Dosye dartışma": {
            "canonical": "File talk",
            "aliases": ["Dosya tartışma", "Resim tartışma"],
        },
        "MediaWiki": {"aliases": ["MedyaViki"]},
        "MediaWiki dartışma": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki tartışma", "MedyaViki tartışma"],
        },
        "Şablon": {"canonical": "Template"},
        "Şablon dartışma": {
            "canonical": "Template talk",
            "aliases": ["Şablon tartışma"],
        },
        "Yardım": {"canonical": "Help"},
        "Yardım dartışma": {"canonical": "Help talk", "aliases": ["Yardım tartışma"]},
        "Kategoriya": {"canonical": "Category", "aliases": ["Kategori"]},
        "Kategoriya dartışma": {
            "canonical": "Category talk",
            "aliases": ["Kategori tartışma"],
        },
        "Modül": {"canonical": "Module"},
        "Modül tartışma": {"canonical": "Module talk"},
    },
    "gan": {
        "媒體": {"canonical": "Media", "aliases": ["媒体"]},
        "特別": {"canonical": "Special", "aliases": ["特殊"]},
        "談詑": {"canonical": "Talk", "aliases": ["对话", "對話", "討論", "讨论", "谈詑"]},
        "用戶": {"canonical": "User", "aliases": ["用户"]},
        "用戶・談詑": {
            "canonical": "User talk",
            "aliases": ["用戶對話", "用戶討論", "用戶談詑", "用户对话", "用户讨论", "用户谈詑"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia・談詑": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia 談詑", "Wikipedia談詑", "Wikipedia谈詑"],
        },
        "文檔": {"canonical": "File", "aliases": ["图像", "圖像", "文件", "档案", "檔案"]},
        "文檔・談詑": {
            "canonical": "File talk",
            "aliases": [
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "文件对话",
                "文件對話",
                "文件討論",
                "文件讨论",
                "文件谈詑",
                "档案对话",
                "档案讨论",
                "檔案對話",
                "檔案討論",
                "檔案談詑",
            ],
        },
        "MediaWiki・談詑": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki談詑", "MediaWiki谈詑"],
        },
        "模板": {"canonical": "Template", "aliases": ["样板", "樣板"]},
        "模板・談詑": {
            "canonical": "Template talk",
            "aliases": [
                "样板对话",
                "样板讨论",
                "模板对话",
                "模板對話",
                "模板討論",
                "模板談詑",
                "模板讨论",
                "模板谈詑",
                "樣板對話",
                "樣板討論",
            ],
        },
        "幫助": {"canonical": "Help", "aliases": ["帮助"]},
        "幫助・談詑": {
            "canonical": "Help talk",
            "aliases": ["帮助对话", "帮助讨论", "帮助谈詑", "幫助對話", "幫助討論", "幫助談詑"],
        },
        "分類": {"canonical": "Category", "aliases": ["分类"]},
        "分類・談詑": {
            "canonical": "Category talk",
            "aliases": ["分类对话", "分类讨论", "分类谈詑", "分類對話", "分類討論", "分類談詑"],
        },
        "模組": {"canonical": "Module", "aliases": ["模块", "模塊", "模组"]},
        "模組討論": {
            "canonical": "Module talk",
            "aliases": ["模块对话", "模块讨论", "模塊對話", "模塊討論", "模組對話", "模组对话", "模组讨论"],
        },
    },
    "gcr": {
        "Médja": {"canonical": "Media"},
        "Èspésyal": {"canonical": "Special"},
        "Diskisyon": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Itilizatò": {"canonical": "User", "aliases": ["Utilisateur", "Utilisatrice"]},
        "Diskisyon itilizatò": {
            "canonical": "User talk",
            "aliases": [
                "Discussion Utilisateur",
                "Discussion utilisateur",
                "Discussion utilisatrice",
            ],
        },
        "Wikipédja": {"canonical": "Project"},
        "Diskisyon Wikipédja": {"canonical": "Project talk"},
        "Fiché": {"canonical": "File"},
        "Diskisyon fiché": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Diskisyon MediaWiki": {"canonical": "MediaWiki talk"},
        "Modèl": {"canonical": "Template"},
        "Diskisyon modèl": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Lèd": {"canonical": "Help"},
        "Diskisyon lèd": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Katégori": {"canonical": "Category"},
        "Diskisyon katégori": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Modjoul": {"canonical": "Module"},
        "Diskisyon modjoul": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "gd": {
        "Meadhan": {"canonical": "Media"},
        "Sònraichte": {"canonical": "Special"},
        "Deasbaireachd": {"canonical": "Talk"},
        "Cleachdaiche": {"canonical": "User"},
        "Deasbaireachd a' chleachdaiche": {"canonical": "User talk"},
        "Uicipeid": {"canonical": "Project"},
        "An deasbaireachd aig Uicipeid": {"canonical": "Project talk"},
        "Faidhle": {"canonical": "File"},
        "Deasbaireachd an fhaidhle": {"canonical": "File talk"},
        "Deasbaireachd MediaWiki": {"canonical": "MediaWiki talk"},
        "Teamplaid": {"canonical": "Template"},
        "Deasbaireachd na teamplaid": {"canonical": "Template talk"},
        "Cobhair": {"canonical": "Help"},
        "Deasbaireachd na cobharach": {"canonical": "Help talk"},
        "Roinn-seòrsa": {"canonical": "Category"},
        "Deasbaireachd na roinn-seòrsa": {"canonical": "Category talk"},
        "Mòideal": {"canonical": "Module"},
        "Deasbaireachd mòideil": {"canonical": "Module talk"},
    },
    "gl": {
        "Especial": {"canonical": "Special"},
        "Conversa": {"canonical": "Talk"},
        "Usuario": {"canonical": "User", "aliases": ["Usuaria", "Usuário"]},
        "Conversa usuario": {
            "canonical": "User talk",
            "aliases": ["Conversa Usuario", "Conversa usuaria", "Usuário Discussão"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Conversa Wikipedia": {"canonical": "Project talk"},
        "Ficheiro": {"canonical": "File", "aliases": ["Arquivo", "Imagem", "Imaxe"]},
        "Conversa ficheiro": {
            "canonical": "File talk",
            "aliases": ["Arquivo Discussão", "Conversa Imaxe", "Imagem Discussão"],
        },
        "Conversa MediaWiki": {"canonical": "MediaWiki talk"},
        "Modelo": {"canonical": "Template"},
        "Conversa modelo": {
            "canonical": "Template talk",
            "aliases": ["Conversa Modelo"],
        },
        "Axuda": {"canonical": "Help"},
        "Conversa axuda": {"canonical": "Help talk", "aliases": ["Conversa Axuda"]},
        "Categoría": {"canonical": "Category"},
        "Conversa categoría": {
            "canonical": "Category talk",
            "aliases": ["Conversa Categoría"],
        },
        "Conversa portal": {"aliases": ["Portal talk"]},
        "Libro": {},
        "Conversa libro": {},
        "Módulo": {"canonical": "Module"},
        "Conversa módulo": {"canonical": "Module talk"},
    },
    "glk": {
        "مديا": {"canonical": "Media", "aliases": ["رسانه", "رسانه\u200cای"]},
        "خاص": {"canonical": "Special", "aliases": ["ویژه"]},
        "گب": {"canonical": "Talk", "aliases": ["بحث"]},
        "کارگير": {"canonical": "User", "aliases": ["کاربر"]},
        "کارگيرˇ گب": {"canonical": "User talk", "aliases": ["بحث کاربر"]},
        "Wikipedia": {"canonical": "Project"},
        "مدي Wikipedia": {"canonical": "Project talk", "aliases": ["بحث Wikipedia"]},
        "فاىل": {"canonical": "File", "aliases": ["تصویر", "پرونده"]},
        "فاىلˇ گب": {"canonical": "File talk", "aliases": ["بحث تصویر", "بحث پرونده"]},
        "مدياويکي": {"canonical": "MediaWiki"},
        "مدياويکي گب": {"canonical": "MediaWiki talk", "aliases": ["بحث مدیاویکی"]},
        "قالب": {"canonical": "Template", "aliases": ["الگو"]},
        "قالبˇ گب": {"canonical": "Template talk", "aliases": ["بحث الگو"]},
        "رانما": {"canonical": "Help", "aliases": ["راهنما"]},
        "رانما گب": {"canonical": "Help talk", "aliases": ["بحث راهنما"]},
        "جرگه": {"canonical": "Category", "aliases": ["رده"]},
        "جرگه گب": {"canonical": "Category talk", "aliases": ["بحث رده"]},
        "پودمان": {"canonical": "Module"},
        "بحث پودمان": {"canonical": "Module talk"},
        "ابزار": {"canonical": "Gadget"},
        "بحث ابزار": {"canonical": "Gadget talk"},
        "توضیحات ابزار": {"canonical": "Gadget definition"},
        "بحث توضیحات ابزار": {"canonical": "Gadget definition talk"},
    },
    "gn": {
        "Medio": {"canonical": "Media"},
        "Mba'echĩchĩ": {"canonical": "Special"},
        "Myangekõi": {"canonical": "Talk"},
        "Puruhára": {"canonical": "User"},
        "Puruhára myangekõi": {"canonical": "User talk"},
        "Vikipetã": {"canonical": "Project"},
        "Vikipetã myangekõi": {"canonical": "Project talk"},
        "Ta'ãnga": {"canonical": "File", "aliases": ["Imagen"]},
        "Ta'ãnga myangekõi": {
            "canonical": "File talk",
            "aliases": ["Imagen discusión"],
        },
        "MediaWiki myangekõi": {"canonical": "MediaWiki talk"},
        "Tembiecharã": {"canonical": "Template"},
        "Tembiecharã myangekõi": {"canonical": "Template talk"},
        "Pytyvõ": {"canonical": "Help"},
        "Pytyvõ myangekõi": {"canonical": "Help talk"},
        "Ñemohenda": {"canonical": "Category"},
        "Ñemohenda myangekõi": {"canonical": "Category talk"},
        "Módulo": {"canonical": "Module"},
        "Módulo discusión": {"canonical": "Module talk"},
        "Accesorio": {"canonical": "Gadget"},
        "Accesorio discusión": {"canonical": "Gadget talk"},
        "Accesorio definición": {"canonical": "Gadget definition"},
        "Accesorio definición discusión": {"canonical": "Gadget definition talk"},
    },
    "gom": {
        "माध्यम": {"canonical": "Media", "aliases": ["मिडिया"]},
        "विशेश": {"canonical": "Special"},
        "चर्चा": {"canonical": "Talk"},
        "वापरपी": {"canonical": "User", "aliases": ["उपेगकर्तो"]},
        "वापरपी चर्चा": {"canonical": "User talk", "aliases": ["उपेगकर्तो चर्चा"]},
        "विकिपीडिया": {"canonical": "Project"},
        "विकिपीडिया चर्चा": {"canonical": "Project talk"},
        "फायल": {"canonical": "File"},
        "फायल चर्चा": {"canonical": "File talk"},
        "मिडियाविकी": {"canonical": "MediaWiki"},
        "मिडियाविकी चर्चा": {"canonical": "MediaWiki talk"},
        "सांचो": {"canonical": "Template", "aliases": ["प्रारूप"]},
        "सांचो चर्चा": {"canonical": "Template talk", "aliases": ["प्रारूप चर्चा"]},
        "आदार": {"canonical": "Help", "aliases": ["मजत"]},
        "आदार चर्चा": {"canonical": "Help talk", "aliases": ["मजत चर्चा"]},
        "वर्ग": {"canonical": "Category", "aliases": ["श्रेणी"]},
        "वर्ग चर्चा": {"canonical": "Category talk", "aliases": ["श्रेणी चर्चा"]},
        "एकक": {"canonical": "Module"},
        "एकक चर्चा": {"canonical": "Module talk"},
        "विशय": {"canonical": "Topic"},
    },
    "gor": {
        "Spesial": {"canonical": "Special"},
        "Lo'iya": {"canonical": "Talk", "aliases": ["Bicara"]},
        "Ta ohu'uwo": {"canonical": "User"},
        "Lo'iya ta ohu'uwo": {
            "canonical": "User talk",
            "aliases": ["Bicara Pengguna", "Lo'iya ta ohu'owo"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Lo'iya Wikipedia": {"canonical": "Project talk"},
        "Berkas": {"canonical": "File", "aliases": ["Gambar"]},
        "Lo'iya berkas": {
            "canonical": "File talk",
            "aliases": ["Gambar Pembicaraan", "Pembicaraan Gambar"],
        },
        "Lo'iya MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Pembicaraan"],
        },
        "Templat": {"canonical": "Template"},
        "Lo'iya templat": {
            "canonical": "Template talk",
            "aliases": ["Templat Pembicaraan"],
        },
        "Wubodu": {"canonical": "Help"},
        "Lo'iya wubodu": {"canonical": "Help talk", "aliases": ["Bantuan Pembicaraan"]},
        "Dalala": {"canonical": "Category"},
        "Lo'iya dalala": {
            "canonical": "Category talk",
            "aliases": ["Kategori Pembicaraan"],
        },
        "Modul": {"canonical": "Module"},
        "Pembicaraan Modul": {"canonical": "Module talk"},
    },
    "got": {
        "𐌽𐌹𐌿𐍄𐌰𐌽𐌳𐍃": {"canonical": "User"},
        "𐌽𐌹𐌿𐍄𐌰𐌽𐌳𐌹𐍃 𐌲𐌰𐍅𐌰𐌿𐍂𐌳𐌾𐌰": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "𐌸𐌹𐍃 Wikipedia 𐌲𐌰𐍅𐌰𐌿𐍂𐌳𐌾𐌰": {"canonical": "Project talk"},
        "𐍆𐌴𐌹𐌻𐌰": {"canonical": "File"},
        "𐍆𐌴𐌹𐌻𐌹𐌽𐍃 𐌲𐌰𐍅𐌰𐌿𐍂𐌳𐌾𐌰": {"canonical": "File talk"},
        "𐍆𐌰𐌿𐍂𐌰𐌼𐌴𐌻𐌴𐌹𐌽𐍃": {"canonical": "Template"},
        "𐍆𐌰𐌿𐍂𐌰𐌼𐌴𐌻𐌴𐌹𐌽𐌰𐌹𐍃 𐌲𐌰𐍅𐌰𐌿𐍂𐌳𐌾𐌰": {"canonical": "Template talk"},
        "𐌷𐌹𐌻𐍀𐌰": {"canonical": "Help"},
        "𐌷𐌹𐌻𐍀𐍉𐍃 𐌲𐌰𐍅𐌰𐌿𐍂𐌳𐌾𐌰": {"canonical": "Help talk"},
        "𐌷𐌰𐌽𐍃𐌰": {"canonical": "Category"},
        "𐌷𐌰𐌽𐍃𐍉𐍃 𐌲𐌰𐍅𐌰𐌿𐍂𐌳𐌾𐌰": {"canonical": "Category talk"},
    },
    "gu": {
        "દ્રશ્ય-શ્રાવ્ય (મિડિયા)": {"canonical": "Media"},
        "વિશેષ": {"canonical": "Special"},
        "ચર્ચા": {"canonical": "Talk"},
        "સભ્ય": {"canonical": "User", "aliases": ["સ"]},
        "સભ્યની ચર્ચા": {"canonical": "User talk"},
        "વિકિપીડિયા": {"canonical": "Project", "aliases": ["વિ"]},
        "વિકિપીડિયા ચર્ચા": {"canonical": "Project talk"},
        "ચિત્ર": {"canonical": "File"},
        "ચિત્રની ચર્ચા": {"canonical": "File talk"},
        "મીડિયાવિકિ": {"canonical": "MediaWiki"},
        "મીડિયાવિકિ ચર્ચા": {"canonical": "MediaWiki talk"},
        "ઢાંચો": {"canonical": "Template"},
        "ઢાંચાની ચર્ચા": {"canonical": "Template talk"},
        "મદદ": {"canonical": "Help"},
        "મદદની ચર્ચા": {"canonical": "Help talk"},
        "શ્રેણી": {"canonical": "Category", "aliases": ["CAT", "શ્રે"]},
        "શ્રેણીની ચર્ચા": {"canonical": "Category talk"},
        "વિભાગ": {"canonical": "Module"},
        "વિભાગ ચર્ચા": {"canonical": "Module talk"},
    },
    "guw": {
        "Vonọtaun": {"canonical": "Special"},
        "Hodidọ": {"canonical": "Talk"},
        "Zinzantọ": {"canonical": "User"},
        "Zinzantọ hodidọ": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia hodidọ": {"canonical": "Project talk"},
        "Wepo": {"canonical": "File"},
        "Wepo hodidọ": {"canonical": "File talk"},
        "MediaWiki hodidọ": {"canonical": "MediaWiki talk"},
        "Ohia": {"canonical": "Template"},
        "Ohia hodidọ": {"canonical": "Template talk"},
        "Alọgọ": {"canonical": "Help"},
        "Alọgọ hodidọ": {"canonical": "Help talk"},
        "Adà": {"canonical": "Category"},
        "Adà hodidọ": {"canonical": "Category talk"},
    },
    "gv": {
        "Meanyn": {"canonical": "Media"},
        "Er lheh": {"canonical": "Special"},
        "Resooney": {"canonical": "Talk"},
        "Ymmydeyr": {"canonical": "User"},
        "Resooney ymmydeyr": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Resooney Wikipedia": {"canonical": "Project talk"},
        "Coadan": {"canonical": "File"},
        "Resooney coadan": {"canonical": "File talk"},
        "Resooney MediaWiki": {"canonical": "MediaWiki talk"},
        "Clowan": {"canonical": "Template"},
        "Resooney clowan": {"canonical": "Template talk"},
        "Cooney": {"canonical": "Help"},
        "Resooney cooney": {"canonical": "Help talk"},
        "Ronney": {"canonical": "Category"},
        "Resooney ronney": {"canonical": "Category talk"},
    },
    "ha": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "hak": {
        "媒體": {"canonical": "Media", "aliases": ["媒体"]},
        "特殊": {"canonical": "Special"},
        "討論": {"canonical": "Talk", "aliases": ["对话", "對話", "讨论"]},
        "用戶": {"canonical": "User", "aliases": ["用户"]},
        "用戶討論": {"canonical": "User talk", "aliases": ["用戶對話", "用户对话", "用户讨论"]},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia討論": {"canonical": "Project talk"},
        "檔案": {"canonical": "File", "aliases": ["图像", "圖像", "文件", "档案"]},
        "檔案討論": {
            "canonical": "File talk",
            "aliases": [
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "文件对话",
                "文件對話",
                "文件討論",
                "文件讨论",
                "档案对话",
                "档案讨论",
                "檔案對話",
            ],
        },
        "MediaWiki討論": {"canonical": "MediaWiki talk"},
        "模板": {"canonical": "Template", "aliases": ["样板", "樣板"]},
        "模板討論": {
            "canonical": "Template talk",
            "aliases": ["样板对话", "样板讨论", "模板对话", "模板對話", "模板讨论", "樣板對話", "樣板討論"],
        },
        "幫助": {"canonical": "Help", "aliases": ["帮助"]},
        "幫助討論": {"canonical": "Help talk", "aliases": ["帮助对话", "帮助讨论", "幫助對話"]},
        "分類": {"canonical": "Category", "aliases": ["分类"]},
        "分類討論": {"canonical": "Category talk", "aliases": ["分类对话", "分类讨论", "分類對話"]},
        "模組": {"canonical": "Module", "aliases": ["模块", "模塊", "模组"]},
        "模組討論": {
            "canonical": "Module talk",
            "aliases": ["模块对话", "模块讨论", "模塊對話", "模塊討論", "模組對話", "模组对话", "模组讨论"],
        },
    },
    "haw": {
        "Pāpaho": {"canonical": "Media"},
        "Papa nui": {"canonical": "Special"},
        "Kūkākūkā": {"canonical": "Talk"},
        "Mea hoʻohana": {"canonical": "User"},
        "Kūkākūkā o mea hoʻohana": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Kūkākūkā o Wikipikia": {"canonical": "Project talk"},
        "Waihona": {"canonical": "File", "aliases": ["Kiʻi"]},
        "Kūkākūkā o waihona": {
            "canonical": "File talk",
            "aliases": ["Kūkākūkā o kiʻi"],
        },
        "Kūkākūkā o MediaWiki": {"canonical": "MediaWiki talk"},
        "Anakuhi": {"canonical": "Template"},
        "Kūkākūkā o anakuhi": {"canonical": "Template talk"},
        "Kōkua": {"canonical": "Help"},
        "Kūkākūkā o kōkua": {"canonical": "Help talk"},
        "Māhele": {"canonical": "Category"},
        "Kūkākūkā o māhele": {"canonical": "Category talk"},
    },
    "he": {
        "מדיה": {"canonical": "Media"},
        "מיוחד": {"canonical": "Special", "aliases": ["מי"]},
        "שיחה": {"canonical": "Talk", "aliases": ["ש"]},
        "משתמש": {"canonical": "User", "aliases": ["U", "מש", "משתמשת"]},
        "שיחת משתמש": {"canonical": "User talk", "aliases": ["שיחת משתמשת", "שמש"]},
        "ויקיפדיה": {"canonical": "Project", "aliases": ["וק"]},
        "שיחת ויקיפדיה": {"canonical": "Project talk", "aliases": ["שוק"]},
        "קובץ": {"canonical": "File", "aliases": ["קו", "תמונה"]},
        "שיחת קובץ": {"canonical": "File talk", "aliases": ["שיחת תמונה", "שקו"]},
        "מדיה ויקי": {"canonical": "MediaWiki", "aliases": ["מו"]},
        "שיחת מדיה ויקי": {"canonical": "MediaWiki talk", "aliases": ["שמו"]},
        "תבנית": {"canonical": "Template", "aliases": ["תב"]},
        "שיחת תבנית": {"canonical": "Template talk", "aliases": ["שתב"]},
        "עזרה": {"canonical": "Help", "aliases": ["עז"]},
        "שיחת עזרה": {"canonical": "Help talk", "aliases": ["שעז"]},
        "קטגוריה": {"canonical": "Category", "aliases": ["קט"]},
        "שיחת קטגוריה": {"canonical": "Category talk", "aliases": ["שקט"]},
        "פורטל": {"aliases": ["פ"]},
        "שיחת פורטל": {"aliases": ["שפ"]},
        "ספר": {},
        "שיחת ספר": {},
        "טיוטה": {"aliases": ["Draft", "טי"]},
        "שיחת טיוטה": {"aliases": ["Draft talk", "שטי"]},
        "יחידה": {"canonical": "Module", "aliases": ["י"]},
        "שיחת יחידה": {"canonical": "Module talk", "aliases": ["שי"]},
        "גאדג'ט": {"canonical": "Gadget"},
        "שיחת גאדג'ט": {"canonical": "Gadget talk"},
        "הגדרת גאדג'ט": {"canonical": "Gadget definition"},
        "שיחת הגדרת גאדג'ט": {"canonical": "Gadget definition talk"},
        "נושא": {"canonical": "Topic", "aliases": ["נ"]},
    },
    "hi": {
        "मीडिया": {"canonical": "Media"},
        "विशेष": {"canonical": "Special"},
        "वार्ता": {"canonical": "Talk"},
        "सदस्य": {"canonical": "User", "aliases": ["U", "स"]},
        "सदस्य वार्ता": {"canonical": "User talk", "aliases": ["UT", "सवा"]},
        "विकिपीडिया": {"canonical": "Project", "aliases": ["वि"]},
        "विकिपीडिया वार्ता": {"canonical": "Project talk", "aliases": ["WPT", "विवा"]},
        "चित्र": {"canonical": "File"},
        "चित्र वार्ता": {"canonical": "File talk"},
        "मीडियाविकि": {"canonical": "MediaWiki", "aliases": ["मी"]},
        "मीडियाविकि वार्ता": {"canonical": "MediaWiki talk", "aliases": ["मीवा"]},
        "साँचा": {"canonical": "Template", "aliases": ["T", "सा"]},
        "साँचा वार्ता": {"canonical": "Template talk", "aliases": ["सावा"]},
        "सहायता": {"canonical": "Help"},
        "सहायता वार्ता": {"canonical": "Help talk"},
        "श्रेणी": {"canonical": "Category", "aliases": ["श्र"]},
        "श्रेणी वार्ता": {"canonical": "Category talk", "aliases": ["CT", "श्रवा"]},
        "प्रवेशद्वार": {"aliases": ["P", "Portal", "प्र"]},
        "प्रवेशद्वार वार्ता": {"aliases": ["Portal talk", "प्रवा"]},
        "गैजेट": {"canonical": "Gadget"},
        "गैजेट वार्ता": {"canonical": "Gadget talk"},
        "गैजेट परिभाषा": {"canonical": "Gadget definition"},
        "गैजेट परिभाषा वार्ता": {"canonical": "Gadget definition talk"},
    },
    "hif": {
        "saadhan": {"canonical": "Media"},
        "khaas": {"canonical": "Special"},
        "baat": {"canonical": "Talk"},
        "sadasya": {"canonical": "User"},
        "sadasya ke baat": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia baat": {"canonical": "Project talk"},
        "file": {"canonical": "File"},
        "file ke baat": {"canonical": "File talk"},
        "Mediawiki ke baat": {"canonical": "MediaWiki talk"},
        "Template ke baat": {"canonical": "Template talk"},
        "madat": {"canonical": "Help"},
        "madat ke baat": {"canonical": "Help talk"},
        "vibhag": {"canonical": "Category"},
        "voibhag ke baat": {"canonical": "Category talk"},
    },
    "hr": {
        "Mediji": {"canonical": "Media"},
        "Posebno": {"canonical": "Special"},
        "Razgovor": {"canonical": "Talk"},
        "Suradnik": {"canonical": "User", "aliases": ["SUR", "Suradnica", "U"]},
        "Razgovor sa suradnikom": {
            "canonical": "User talk",
            "aliases": ["RSS", "RSUR", "Razgovor sa suradnicom"],
        },
        "Wikipedija": {"canonical": "Project"},
        "Razgovor Wikipedija": {"canonical": "Project talk", "aliases": ["RWP"]},
        "Datoteka": {"canonical": "File", "aliases": ["DT", "F", "Slika"]},
        "Razgovor o datoteci": {
            "canonical": "File talk",
            "aliases": ["RDT", "RF", "Razgovor o slici"],
        },
        "MediaWiki": {"aliases": ["ME"]},
        "MediaWiki razgovor": {"canonical": "MediaWiki talk", "aliases": ["RME"]},
        "Predložak": {"canonical": "Template"},
        "Razgovor o predlošku": {"canonical": "Template talk"},
        "Pomoć": {"canonical": "Help", "aliases": ["H", "PM"]},
        "Razgovor o pomoći": {"canonical": "Help talk", "aliases": ["RH", "RPM"]},
        "Kategorija": {"canonical": "Category", "aliases": ["CT", "KT"]},
        "Razgovor o kategoriji": {
            "canonical": "Category talk",
            "aliases": ["RCT", "RKT"],
        },
        "Razgovor o portalu": {},
        "Dodatak": {},
        "Razgovor o dodatku": {},
        "Nacrt": {"aliases": ["Draft"]},
        "Razgovor o nacrtu": {"aliases": ["Draft talk"]},
        "Modul": {"canonical": "Module", "aliases": ["MD", "MOD"]},
        "Razgovor o modulu": {"canonical": "Module talk", "aliases": ["RMD", "RMOD"]},
    },
    "hsb": {
        "Specialnje": {"canonical": "Special"},
        "Diskusija": {"canonical": "Talk"},
        "Wužiwar": {"canonical": "User", "aliases": ["Wužiwarka"]},
        "Diskusija z wužiwarjom": {
            "canonical": "User talk",
            "aliases": ["Diskusija z wužiwarku"],
        },
        "Wikipedija": {"canonical": "Project"},
        "Wikipedija diskusija": {"canonical": "Project talk"},
        "Dataja": {"canonical": "File", "aliases": ["Bild", "Wobraz"]},
        "Diskusija k dataji": {
            "canonical": "File talk",
            "aliases": [
                "Bild Diskussion",
                "Diskusija k wobrazej",
                "Diskusija wó wobrazu",
            ],
        },
        "MediaWiki diskusija": {"canonical": "MediaWiki talk"},
        "Předłoha": {"canonical": "Template"},
        "Diskusija k předłoze": {"canonical": "Template talk"},
        "Pomoc": {"canonical": "Help"},
        "Pomoc diskusija": {"canonical": "Help talk"},
        "Kategorija": {"canonical": "Category"},
        "Diskusija ke kategoriji": {"canonical": "Category talk"},
        "Modul": {"canonical": "Module"},
        "Modul diskusija": {"canonical": "Module talk"},
        "Gadget Diskussion": {"canonical": "Gadget talk"},
        "Gadget-Definition": {"canonical": "Gadget definition"},
        "Gadget-Definition Diskussion": {"canonical": "Gadget definition talk"},
    },
    "ht": {
        "Medya": {"canonical": "Media"},
        "Espesyal": {"canonical": "Special"},
        "Diskite": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Itilizatè": {"canonical": "User"},
        "Diskisyon Itilizatè": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur"],
        },
        "Wikipedya": {"canonical": "Project"},
        "Diskisyon Wikipedya": {"canonical": "Project talk"},
        "Fichye": {"canonical": "File", "aliases": ["Imaj"]},
        "Diskisyon Fichye": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image", "Diskisyon Imaj"],
        },
        "MedyaWiki": {"canonical": "MediaWiki"},
        "Diskisyon MedyaWiki": {"canonical": "MediaWiki talk"},
        "Modèl": {"canonical": "Template"},
        "Diskisyon Modèl": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Èd": {"canonical": "Help"},
        "Diskisyon Èd": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Kategori": {"canonical": "Category"},
        "Diskisyon Kategori": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "hu": {
        "Média": {"canonical": "Media"},
        "Speciális": {"canonical": "Special"},
        "Vita": {"canonical": "Talk"},
        "Szerkesztő": {"canonical": "User"},
        "Szerkesztővita": {"canonical": "User talk", "aliases": ["User vita"]},
        "Wikipédia": {"canonical": "Project"},
        "Wikipédia-vita": {"canonical": "Project talk", "aliases": ["Wikipédia vita"]},
        "Fájl": {"canonical": "File", "aliases": ["Kép"]},
        "Fájlvita": {"canonical": "File talk", "aliases": ["Kép vita", "Képvita"]},
        "MediaWiki-vita": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki vita"],
        },
        "Sablon": {"canonical": "Template"},
        "Sablonvita": {"canonical": "Template talk", "aliases": ["Sablon vita"]},
        "Segítség": {"canonical": "Help"},
        "Segítségvita": {"canonical": "Help talk", "aliases": ["Segítség vita"]},
        "Kategória": {"canonical": "Category"},
        "Kategóriavita": {"canonical": "Category talk", "aliases": ["Kategória vita"]},
        "Szál": {"canonical": "Thread"},
        "Szálvita": {"canonical": "Thread talk"},
        "Összefoglaló": {"canonical": "Summary"},
        "Összefoglaló-vita": {"canonical": "Summary talk"},
        "Portál": {},
        "Portálvita": {"aliases": ["Portál vita"]},
        "Modul": {"canonical": "Module"},
        "Modulvita": {"canonical": "Module talk"},
    },
    "hy": {
        "Մեդիա": {"canonical": "Media"},
        "Սպասարկող": {"canonical": "Special"},
        "Քննարկում": {"canonical": "Talk"},
        "Մասնակից": {"canonical": "User"},
        "Մասնակցի քննարկում": {"canonical": "User talk"},
        "Վիքիպեդիա": {"canonical": "Project"},
        "Վիքիպեդիայի քննարկում": {"canonical": "Project talk"},
        "Պատկեր": {"canonical": "File"},
        "Պատկերի քննարկում": {"canonical": "File talk"},
        "MediaWiki քննարկում": {"canonical": "MediaWiki talk"},
        "Կաղապար": {"canonical": "Template"},
        "Կաղապարի քննարկում": {"canonical": "Template talk"},
        "Օգնություն": {"canonical": "Help"},
        "Օգնության քննարկում": {"canonical": "Help talk"},
        "Կատեգորիա": {"canonical": "Category"},
        "Կատեգորիայի քննարկում": {"canonical": "Category talk"},
        "Պորտալ": {},
        "Պորտալի քննարկում": {},
        "Վիքինախագիծ": {},
        "Վիքինախագծի քննարկում": {},
        "Սևագիր": {},
        "Սևագրի քննարկում": {},
        "Մոդուլ": {"canonical": "Module"},
        "Մոդուլի քննարկում": {"canonical": "Module talk"},
    },
    "hyw": {
        "Մեդիա": {"canonical": "Media"},
        "Սպասարկող": {"canonical": "Special"},
        "Քննարկում": {"canonical": "Talk"},
        "Մասնակից": {"canonical": "User"},
        "Մասնակցի քննարկում": {"canonical": "User talk"},
        "Ուիքիփետիա": {"canonical": "Project"},
        "Ուիքիփետիայի քննարկում": {"canonical": "Project talk"},
        "Պատկեր": {"canonical": "File"},
        "Պատկերի քննարկում": {"canonical": "File talk"},
        "MediaWiki քննարկում": {"canonical": "MediaWiki talk"},
        "Կաղապար": {"canonical": "Template"},
        "Կաղապարի քննարկում": {"canonical": "Template talk"},
        "Օգնություն": {"canonical": "Help"},
        "Օգնության քննարկում": {"canonical": "Help talk"},
        "Ստորոգութիւն": {"canonical": "Category"},
        "Կատեգորիայի քննարկում": {"canonical": "Category talk"},
        "Մոդուլ": {"canonical": "Module"},
        "Մոդուլի քննարկում": {"canonical": "Module talk"},
    },
    "ia": {
        "Multimedia": {"canonical": "Media"},
        "Discussion": {"canonical": "Talk"},
        "Usator": {"canonical": "User"},
        "Discussion Usator": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Discussion Wikipedia": {"canonical": "Project talk"},
        "File": {"aliases": ["Imagine"]},
        "Discussion File": {
            "canonical": "File talk",
            "aliases": ["Discussion Imagine"],
        },
        "Discussion MediaWiki": {"canonical": "MediaWiki talk"},
        "Patrono": {"canonical": "Template"},
        "Discussion Patrono": {"canonical": "Template talk"},
        "Adjuta": {"canonical": "Help"},
        "Discussion Adjuta": {"canonical": "Help talk"},
        "Categoria": {"canonical": "Category"},
        "Discussion Categoria": {"canonical": "Category talk"},
        "Discussion Portal": {},
        "Appendice": {},
        "Discussion Appendice": {},
    },
    "id": {
        "Istimewa": {"canonical": "Special"},
        "Pembicaraan": {"canonical": "Talk", "aliases": ["Bicara"]},
        "Pengguna": {"canonical": "User"},
        "Pembicaraan Pengguna": {
            "canonical": "User talk",
            "aliases": ["Bicara Pengguna"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Pembicaraan Wikipedia": {"canonical": "Project talk"},
        "Berkas": {"canonical": "File", "aliases": ["Gambar"]},
        "Pembicaraan Berkas": {
            "canonical": "File talk",
            "aliases": ["Gambar Pembicaraan", "Pembicaraan Gambar"],
        },
        "Pembicaraan MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Pembicaraan"],
        },
        "Templat": {"canonical": "Template"},
        "Pembicaraan Templat": {
            "canonical": "Template talk",
            "aliases": ["Templat Pembicaraan"],
        },
        "Bantuan": {"canonical": "Help"},
        "Pembicaraan Bantuan": {
            "canonical": "Help talk",
            "aliases": ["Bantuan Pembicaraan"],
        },
        "Kategori": {"canonical": "Category"},
        "Pembicaraan Kategori": {
            "canonical": "Category talk",
            "aliases": ["Kategori Pembicaraan"],
        },
        "Pembicaraan Portal": {},
        "Modul": {"canonical": "Module"},
        "Pembicaraan Modul": {"canonical": "Module talk"},
        "Story": {},
        "Pembicaraan Story": {"canonical": "Story Talk"},
        "Topik": {"canonical": "Topic"},
    },
    "ie": {
        "Discussion": {"canonical": "Talk"},
        "Usator": {"canonical": "User"},
        "Usator Discussion": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia Discussion": {"canonical": "Project talk"},
        "File Discussion": {"canonical": "File talk"},
        "MediaWiki Discussion": {"canonical": "MediaWiki talk"},
        "Avise": {"canonical": "Template"},
        "Avise Discussion": {"canonical": "Template talk"},
        "Auxilie": {"canonical": "Help"},
        "Auxilie Discussion": {"canonical": "Help talk"},
        "Categorie": {"canonical": "Category"},
        "Categorie Discussion": {"canonical": "Category talk"},
    },
    "ig": {
        "Midia": {"canonical": "Media", "aliases": ["Nká"]},
        "Ihü kárírí": {"canonical": "Special"},
        "Okwu": {"canonical": "Talk"},
        "Ọbanife": {"canonical": "User", "aliases": ["Ọ'bànifé"]},
        "Okwu ọbanife": {"canonical": "User talk", "aliases": ["Okwu ọ'bànifé"]},
        "Wikipedia": {"canonical": "Project"},
        "Okwu Wikipedia": {"canonical": "Project talk"},
        "Usòrò": {"canonical": "File", "aliases": ["Ákwúkwó orünotu"]},
        "Okwu usòrò": {"canonical": "File talk", "aliases": ["Okwu ákwúkwó orünotu"]},
        "MidiaWiki": {"canonical": "MediaWiki", "aliases": ["NkáWiki"]},
        "Okwu MidiaWiki": {"canonical": "MediaWiki talk", "aliases": ["Okwu NkáWiki"]},
        "Àtụ": {"canonical": "Template"},
        "Okwu àtụ": {"canonical": "Template talk"},
        "Nkwadọ": {"canonical": "Help", "aliases": ["Nkwádọ"]},
        "Okwu nkwadọ": {"canonical": "Help talk", "aliases": ["Okwu nkwádọ"]},
        "Òtù": {"canonical": "Category", "aliases": ["Ébéonọr"]},
        "Okwu òtù": {"canonical": "Category talk", "aliases": ["Okwu ébéonọr"]},
    },
    "ik": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "ilo": {
        "Midia": {"canonical": "Media"},
        "Espesial": {"canonical": "Special"},
        "Tungtungan": {"canonical": "Talk"},
        "Agar-aramat": {"canonical": "User"},
        "Agar-aramat tungtungan": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia tungtungan": {"canonical": "Project talk"},
        "Papeles": {"canonical": "File"},
        "Papeles tungtungan": {"canonical": "File talk"},
        "MediaWiki tungtungan": {"canonical": "MediaWiki talk"},
        "Plantilia": {"canonical": "Template"},
        "Plantilia tungtungan": {"canonical": "Template talk"},
        "Tulong": {"canonical": "Help"},
        "Tulong tungtungan": {"canonical": "Help talk"},
        "Kategoria": {"canonical": "Category"},
        "Kategoria tungtungan": {"canonical": "Category talk"},
        "Modulo": {"canonical": "Module"},
        "Modulo tungtungan": {"canonical": "Module talk"},
    },
    "inh": {
        "Медиа": {"canonical": "Media"},
        "Гӏулакха": {"canonical": "Special"},
        "Ювцар": {"canonical": "Talk"},
        "Доакъашхо": {"canonical": "User", "aliases": ["Участник", "Участница"]},
        "Доакъашхочун дувцар": {
            "canonical": "User talk",
            "aliases": ["Обсуждение участника", "Обсуждение участницы"],
        },
        "Википеди": {"canonical": "Project"},
        "Википеди ювцар": {"canonical": "Project talk"},
        "Файл": {"canonical": "File", "aliases": ["Изображение"]},
        "Файл ювцар": {"canonical": "File talk", "aliases": ["Обсуждение изображения"]},
        "MediaWiki ювцар": {"canonical": "MediaWiki talk"},
        "Ло": {"canonical": "Template"},
        "Ло бувцар": {"canonical": "Template talk"},
        "Новкъостал": {"canonical": "Help"},
        "Новкъостал дувцар": {"canonical": "Help talk"},
        "ОагӀат": {"canonical": "Category"},
        "ОагӀат ювцар": {"canonical": "Category talk"},
        "Модуль": {"canonical": "Module"},
        "Модуль ювцар": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Гаджет ювцар": {"canonical": "Gadget talk"},
        "Гаджета къоастадар": {"canonical": "Gadget definition"},
        "Гаджета къоастадар дувцар": {"canonical": "Gadget definition talk"},
    },
    "io": {
        "Specala": {"canonical": "Special", "aliases": ["Speciala"]},
        "Debato": {"canonical": "Talk"},
        "Uzanto": {
            "canonical": "User",
            "aliases": ["Uzantino", "Uzulo", "Vikipediisto"],
        },
        "Uzanto Debato": {
            "canonical": "User talk",
            "aliases": [
                "Uzanta diskuto",
                "Uzantino Debato",
                "Uzula diskuto",
                "Vikipediista diskuto",
            ],
        },
        "Wikipedio": {"canonical": "Project"},
        "Wikipedio Debato": {
            "canonical": "Project talk",
            "aliases": ["Wikipedio diskuto"],
        },
        "Arkivo": {"canonical": "File", "aliases": ["Imajo"]},
        "Arkivo Debato": {
            "canonical": "File talk",
            "aliases": ["Dosiera diskuto", "Imajo Debato"],
        },
        "MediaWiki": {"aliases": ["MediaVikio"]},
        "MediaWiki Debato": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaVikia diskuto", "MediaWiki diskuto"],
        },
        "Shablono": {"canonical": "Template", "aliases": ["Modelo"]},
        "Shablono Debato": {
            "canonical": "Template talk",
            "aliases": ["Modelo Debato", "Ŝablona diskuto"],
        },
        "Helpo": {"canonical": "Help"},
        "Helpo Debato": {"canonical": "Help talk", "aliases": ["Helpa diskuto"]},
        "Kategorio": {"canonical": "Category"},
        "Kategorio Debato": {
            "canonical": "Category talk",
            "aliases": ["Kategoria diskuto"],
        },
        "Modulo": {"canonical": "Module"},
        "Modulo-Diskuto": {"canonical": "Module talk"},
    },
    "is": {
        "Miðill": {"canonical": "Media"},
        "Kerfissíða": {"canonical": "Special"},
        "Spjall": {"canonical": "Talk"},
        "Notandi": {"canonical": "User"},
        "Notandaspjall": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipediaspjall": {"canonical": "Project talk"},
        "Mynd": {"canonical": "File"},
        "Myndaspjall": {"canonical": "File talk"},
        "Melding": {"canonical": "MediaWiki"},
        "Meldingarspjall": {"canonical": "MediaWiki talk"},
        "Snið": {"canonical": "Template"},
        "Sniðaspjall": {"canonical": "Template talk"},
        "Hjálp": {"canonical": "Help"},
        "Hjálparspjall": {"canonical": "Help talk"},
        "Flokkur": {"canonical": "Category"},
        "Flokkaspjall": {"canonical": "Category talk"},
        "Gátt": {},
        "Gáttaspjall": {},
        "Smától": {"canonical": "Gadget"},
        "Smátólaspjall": {"canonical": "Gadget talk"},
        "Smátóla skilgreining": {"canonical": "Gadget definition"},
        "Smátóla skilgreiningarspjall": {"canonical": "Gadget definition talk"},
    },
    "it": {
        "Speciale": {"canonical": "Special"},
        "Discussione": {"canonical": "Talk"},
        "Utente": {"canonical": "User"},
        "Discussioni utente": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Discussioni Wikipedia": {"canonical": "Project talk", "aliases": ["DW"]},
        "File": {"aliases": ["Immagine"]},
        "Discussioni file": {
            "canonical": "File talk",
            "aliases": ["Discussioni immagine"],
        },
        "Discussioni MediaWiki": {"canonical": "MediaWiki talk"},
        "Template": {"aliases": ["T"]},
        "Discussioni template": {"canonical": "Template talk"},
        "Aiuto": {"canonical": "Help"},
        "Discussioni aiuto": {"canonical": "Help talk"},
        "Categoria": {"canonical": "Category", "aliases": ["CAT"]},
        "Discussioni categoria": {"canonical": "Category talk"},
        "Portale": {},
        "Discussioni portale": {},
        "Progetto": {},
        "Discussioni progetto": {"aliases": ["DP"]},
        "Bozza": {},
        "Discussioni bozza": {},
        "Modulo": {"canonical": "Module"},
        "Discussioni modulo": {"canonical": "Module talk"},
        "Accessorio": {"canonical": "Gadget"},
        "Discussioni accessorio": {"canonical": "Gadget talk"},
        "Definizione accessorio": {"canonical": "Gadget definition"},
        "Discussioni definizione accessorio": {"canonical": "Gadget definition talk"},
    },
    "iu": {
        "ᐅᐃᑭᐱᑎᐊ": {"canonical": "Project"},
        "ᐅᐃᑭᐱᑎᐊ talk": {"canonical": "Project talk", "aliases": ["ᐅᐃᑭᐱᑎᐊ talk"]},
    },
    "ja": {
        "メディア": {"canonical": "Media"},
        "特別": {"canonical": "Special"},
        "ノート": {"canonical": "Talk", "aliases": ["トーク"]},
        "利用者": {"canonical": "User"},
        "利用者‐会話": {"canonical": "User talk", "aliases": ["利用者・トーク"]},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia‐ノート": {"canonical": "Project talk", "aliases": ["Wikipedia・トーク"]},
        "ファイル": {"canonical": "File", "aliases": ["画像"]},
        "ファイル‐ノート": {"canonical": "File talk", "aliases": ["ファイル・トーク", "画像‐ノート"]},
        "MediaWiki‐ノート": {"canonical": "MediaWiki talk", "aliases": ["MediaWiki・トーク"]},
        "Template": {"aliases": ["テンプレート"]},
        "Template‐ノート": {"canonical": "Template talk", "aliases": ["テンプレート・トーク"]},
        "Help": {"aliases": ["ヘルプ"]},
        "Help‐ノート": {"canonical": "Help talk", "aliases": ["ヘルプ・トーク"]},
        "Category": {"aliases": ["カテゴリ"]},
        "Category‐ノート": {"canonical": "Category talk", "aliases": ["カテゴリ・トーク"]},
        "Portal‐ノート": {"aliases": ["Portal・トーク", "ポータル‐ノート"]},
        "プロジェクト": {},
        "プロジェクト‐ノート": {"aliases": ["プロジェクト・トーク"]},
        "モジュール": {"canonical": "Module"},
        "モジュール‐ノート": {"canonical": "Module talk", "aliases": ["モジュール・トーク"]},
    },
    "jam": {
        "Wikipidia": {"canonical": "Project"},
        "Wikipidia diskoshan": {"canonical": "Project talk"},
        "Puotal": {},
        "Puotal diskoshan": {},
    },
    "jbo": {
        "velsku": {"canonical": "Media"},
        "rirci": {"canonical": "Special"},
        "casnu": {"canonical": "Talk"},
        "pilno": {"canonical": "User"},
        "casnu lo pilno": {"canonical": "User talk"},
        "uikipedi'as": {"canonical": "Project"},
        "casnu la .uikipedi'as.": {"canonical": "Project talk"},
        "datnyvei": {"canonical": "File"},
        "casnu lo datnyvei": {"canonical": "File talk"},
        "medi'auikis": {"canonical": "MediaWiki"},
        "casnu la .medi'auikis.": {"canonical": "MediaWiki talk"},
        "termo'a": {"canonical": "Template"},
        "casnu lo termo'a": {"canonical": "Template talk"},
        "nundju": {"canonical": "Help"},
        "casnu lo nundju": {"canonical": "Help talk"},
        "klesi": {"canonical": "Category"},
        "casnu lo klesi": {"canonical": "Category talk"},
    },
    "jv": {
        "Médhia": {"canonical": "Media", "aliases": ["Medhia"]},
        "Mirunggan": {"canonical": "Special", "aliases": ["Astamiwa"]},
        "Parembugan": {"canonical": "Talk", "aliases": ["Bicara", "Dhiskusi"]},
        "Naraguna": {"canonical": "User", "aliases": ["Panganggo"]},
        "Parembugan Naraguna": {
            "canonical": "User talk",
            "aliases": [
                "Bicara Pengguna",
                "Dhiskusi Panganggo",
                "Parembugan Panganggo",
            ],
        },
        "Wikipédia": {"canonical": "Project"},
        "Parembugan Wikipédia": {
            "canonical": "Project talk",
            "aliases": ["Dhiskusi Wikipédia"],
        },
        "Barkas": {"canonical": "File", "aliases": ["Gambar"]},
        "Parembugan Barkas": {
            "canonical": "File talk",
            "aliases": [
                "Dhiskusi Gambar",
                "Gambar Dhiskusi",
                "Gambar Pembicaraan",
                "Parembugan Gambar",
                "Pembicaraan Gambar",
            ],
        },
        "MédhiaWiki": {"canonical": "MediaWiki", "aliases": ["MedhiaWiki"]},
        "Parembugan MédhiaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": [
                "Dhiskusi MediaWiki",
                "MediaWiki Dhiskusi",
                "MediaWiki Pembicaraan",
                "Parembugan MedhiaWiki",
                "Parembugan MediaWiki",
            ],
        },
        "Cithakan": {"canonical": "Template"},
        "Parembugan Cithakan": {
            "canonical": "Template talk",
            "aliases": [
                "Cithakan Dhiskusi",
                "Dhiskusi Cithakan",
                "Templat Pembicaraan",
            ],
        },
        "Pitulung": {"canonical": "Help"},
        "Parembugan Pitulung": {
            "canonical": "Help talk",
            "aliases": [
                "Bantuan Pembicaraan",
                "Dhiskusi Pitulung",
                "Pitulung Dhiskusi",
            ],
        },
        "Kategori": {"canonical": "Category"},
        "Parembugan Kategori": {
            "canonical": "Category talk",
            "aliases": [
                "Dhiskusi Kategori",
                "Kategori Dhiskusi",
                "Kategori Pembicaraan",
            ],
        },
        "Gapura": {},
        "Parembugan Gapura": {},
        "Modhul": {"canonical": "Module"},
        "Parembugan Modhul": {"canonical": "Module talk"},
    },
    "ka": {
        "მედია": {"canonical": "Media"},
        "სპეციალური": {"canonical": "Special"},
        "განხილვა": {"canonical": "Talk"},
        "მომხმარებელი": {"canonical": "User", "aliases": ["მონაწილე"]},
        "მომხმარებლის განხილვა": {
            "canonical": "User talk",
            "aliases": ["მომხმარებელი განხილვა", "მონაწილის განხილვა"],
        },
        "ვიკიპედია": {"canonical": "Project"},
        "ვიკიპედია განხილვა": {"canonical": "Project talk"},
        "ფაილი": {"canonical": "File", "aliases": ["სურათი"]},
        "ფაილის განხილვა": {"canonical": "File talk", "aliases": ["სურათი განხილვა"]},
        "მედიავიკი": {"canonical": "MediaWiki"},
        "მედიავიკის განხილვა": {
            "canonical": "MediaWiki talk",
            "aliases": ["მედიავიკი განხილვა"],
        },
        "თარგი": {"canonical": "Template"},
        "თარგის განხილვა": {
            "canonical": "Template talk",
            "aliases": ["თარგი განხილვა"],
        },
        "დახმარება": {"canonical": "Help"},
        "დახმარების განხილვა": {
            "canonical": "Help talk",
            "aliases": ["დახმარება განხილვა"],
        },
        "კატეგორია": {"canonical": "Category"},
        "კატეგორიის განხილვა": {
            "canonical": "Category talk",
            "aliases": ["კატეგორია განხილვა"],
        },
        "პორტალი": {},
        "პორტალი განხილვა": {},
        "მოდული": {"canonical": "Module"},
        "მოდულის განხილვა": {"canonical": "Module talk"},
    },
    "kaa": {
        "Media": {"aliases": ["Taspa", "Таспа", "تاسپا"]},
        "Arnawlı": {"canonical": "Special", "aliases": ["Arnaýı", "Арнайы", "ارنايى"]},
        "Sa'wbet": {
            "canonical": "Talk",
            "aliases": ["Talqılaw", "Талқылау", "تالقىلاۋ"],
        },
        "Paydalanıwshı": {
            "canonical": "User",
            "aliases": ["Qatıswşı", "Қатысушы", "قاتىسۋشى"],
        },
        "Paydalanıwshı sa'wbeti": {
            "canonical": "User talk",
            "aliases": [
                "Qatıswşı talqılawı",
                "Қатысушы талқылауы",
                "قاتىسۋشى تالقىلاۋى",
            ],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia sa'wbeti": {
            "canonical": "Project talk",
            "aliases": [
                "Wikipedia talqılawı",
                "Wikipedia талқылауы",
                "Wikipedia تالقىلاۋى",
            ],
        },
        "Su'wret": {"canonical": "File", "aliases": ["Swret", "Сурет", "سۋرەت"]},
        "Su'wret sa'wbeti": {
            "canonical": "File talk",
            "aliases": ["Swret talqılawı", "Сурет талқылауы", "سۋرەت تالقىلاۋى"],
        },
        "MediaWiki": {"aliases": ["MedïaWïkï", "МедиаУики", "مەدياۋيكي"]},
        "MediaWiki sa'wbeti": {
            "canonical": "MediaWiki talk",
            "aliases": [
                "MedïaWïkï talqılawı",
                "МедиаУики талқылауы",
                "مەدياۋيكي تالقىلاۋى",
            ],
        },
        "Shablon": {
            "canonical": "Template",
            "aliases": ["Ülgi", "Үлгі", "ٴۇلگٴى", "ٷلگٸ"],
        },
        "Shablon sa'wbeti": {
            "canonical": "Template talk",
            "aliases": [
                "Ülgi talqılawı",
                "Үлгі талқылауы",
                "ٴۇلگٴى تالقىلاۋى",
                "ٷلگٸ تالقىلاۋى",
            ],
        },
        "Anıqlama": {
            "canonical": "Help",
            "aliases": ["Anıqtama", "Анықтама", "انىقتاما"],
        },
        "Anıqlama sa'wbeti": {
            "canonical": "Help talk",
            "aliases": [
                "Anıqtama talqılawı",
                "Анықтама талқылауы",
                "انىقتاما تالقىلاۋى",
            ],
        },
        "Kategoriya": {"canonical": "Category", "aliases": ["Sanat", "Санат", "سانات"]},
        "Kategoriya sa'wbeti": {
            "canonical": "Category talk",
            "aliases": ["Sanat talqılawı", "Санат талқылауы", "سانات تالقىلاۋى"],
        },
    },
    "kab": {
        "Uslig": {"canonical": "Special"},
        "Mmeslay": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Amseqdac": {"canonical": "User", "aliases": ["Utilisateur", "Utilisatrice"]},
        "Amyannan umsqedac": {
            "canonical": "User talk",
            "aliases": [
                "Discussion Utilisateur",
                "Discussion utilisateur",
                "Discussion utilisatrice",
            ],
        },
        "Wikipedia": {"canonical": "Project"},
        "Amyannan n Wikipedia": {"canonical": "Project talk"},
        "Tugna": {"canonical": "File"},
        "Amyannan n tugna": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Amyannan n MediaWiki": {"canonical": "MediaWiki talk"},
        "Talɣa": {"canonical": "Template", "aliases": ["Talγa"]},
        "Amyannan n talɣa": {
            "canonical": "Template talk",
            "aliases": ["Amyannan n talγa", "Discussion Modèle"],
        },
        "Tallat": {"canonical": "Help"},
        "Amyannan n tallat": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Taggayt": {"canonical": "Category"},
        "Amyannan n taggayt": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Awwur": {},
        "Amyannan uwwur": {},
        "Asenfaṛ": {},
        "Amyannan usenfaṛ": {},
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
        "Sujet": {"canonical": "Topic"},
    },
    "kbd": {
        "Медиа": {"canonical": "Media"},
        "Служебная": {"canonical": "Special"},
        "Тепсэлъэхьыгъуэ": {"canonical": "Talk", "aliases": ["Обсуждение"]},
        "ЦӀыхухэт": {"canonical": "User", "aliases": ["Участник"]},
        "ЦӀыхухэт тепсэлъэхьыгъуэ": {
            "canonical": "User talk",
            "aliases": ["Обсуждение участника"],
        },
        "Уикипедиэ": {"canonical": "Project"},
        "Уикипедиэм и тепсэлъыхьыгъуэ": {
            "canonical": "Project talk",
            "aliases": ["Обсуждение Уикипедиэ"],
        },
        "Файл": {"canonical": "File"},
        "Файл тепсэлъэхьыгъуэ": {
            "canonical": "File talk",
            "aliases": ["Обсуждение файла"],
        },
        "MediaWiki тепсэлъэхьыгъуэ": {
            "canonical": "MediaWiki talk",
            "aliases": ["Обсуждение MediaWiki"],
        },
        "Шаблон": {"canonical": "Template"},
        "Шаблон тепсэлъэхьыгъуэ": {
            "canonical": "Template talk",
            "aliases": ["Обсуждение шаблона"],
        },
        "ДэӀэпыкъуэгъуэ": {"canonical": "Help", "aliases": ["Справка"]},
        "ДэӀэпыкъуэгъуэ тепсэлъэхьыгъуэ": {
            "canonical": "Help talk",
            "aliases": ["Обсуждение справки"],
        },
        "Категориэ": {"canonical": "Category", "aliases": ["Категория"]},
        "Категориэ тепсэлъэхьыгъуэ": {
            "canonical": "Category talk",
            "aliases": ["Обсуждение категории"],
        },
    },
    "kbp": {
        "Média": {"canonical": "Media"},
        "Spécial": {"canonical": "Special"},
        "Discussion": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Utilisateur": {"canonical": "User", "aliases": ["Utilisatrice"]},
        "Discussion utilisateur": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur", "Discussion utilisatrice"],
        },
        "Wikipediya": {"canonical": "Project"},
        "Wikipediya ndɔnjɔɔlɩyɛ": {"canonical": "Project talk"},
        "Fichier": {"canonical": "File"},
        "Discussion fichier": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Discussion MediaWiki": {"canonical": "MediaWiki talk"},
        "Modèle": {"canonical": "Template"},
        "Discussion modèle": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Aide": {"canonical": "Help"},
        "Discussion aide": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Catégorie": {"canonical": "Category"},
        "Discussion catégorie": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "kcg": {
        "Wat khwo": {"canonical": "Special"},
        "A\u200c̱lyiat": {"canonical": "Talk"},
        "A\u200c̱tyunta̱m": {"canonical": "User"},
        "A\u200c̱lyiat a\u200c̱tyunta\u200c̱m": {"canonical": "User talk"},
        "Wukipedia": {"canonical": "Project"},
        "A\u200c̱lyiat Wukipedia": {"canonical": "Project talk"},
        "Fail": {"canonical": "File"},
        "A\u200c̱lyiat fail": {"canonical": "File talk"},
        "A\u200c̱lyiat MediaWiki": {"canonical": "MediaWiki talk"},
        "Ta\u200c̱mpi\u200c̱let": {"canonical": "Template"},
        "A\u200c̱lyiat ta\u200c̱mpi\u200c̱let": {"canonical": "Template talk"},
        "Beang": {"canonical": "Help"},
        "A\u200c̱lyiat beang": {"canonical": "Help talk"},
        "Sa": {"canonical": "Category"},
        "A\u200c̱lyiat nsa": {"canonical": "Category talk"},
    },
    "kg": {
        "Disolo": {"canonical": "Talk"},
        "Kisadi": {"canonical": "User"},
        "Disolo kisadi": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Disolo Wikipedia": {"canonical": "Project talk"},
        "Fisye": {"canonical": "File"},
        "Disolo fisye": {"canonical": "File talk"},
        "Lusadisu": {"canonical": "Help"},
        "Disolo lusadisu": {"canonical": "Help talk"},
        "Kalasi": {"canonical": "Category"},
        "Disolo kalasi": {"canonical": "Category talk"},
    },
    "ki": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "kk": {
        "Таспа": {"canonical": "Media", "aliases": ["Taspa", "تاسپا"]},
        "Арнайы": {"canonical": "Special", "aliases": ["Arnaýı", "ارنايى"]},
        "Талқылау": {"canonical": "Talk", "aliases": ["Talqılaw", "تالقىلاۋ"]},
        "Қатысушы": {"canonical": "User", "aliases": ["Qatıswşı", "قاتىسۋشى"]},
        "Қатысушы талқылауы": {
            "canonical": "User talk",
            "aliases": [
                "Qatıswşı talqılawı",
                "Qatıswşı talqılawı",
                "Қатысушы талқылауы",
                "قاتىسۋشى تالقىلاۋى",
                "قاتىسۋشى تالقىلاۋى",
            ],
        },
        "Уикипедия": {"canonical": "Project"},
        "Уикипедия талқылауы": {
            "canonical": "Project talk",
            "aliases": [
                "Уикипедия talqılawı",
                "Уикипедия talqılawı",
                "Уикипедия талқылауы",
                "Уикипедия تالقىلاۋى",
                "Уикипедия تالقىلاۋى",
            ],
        },
        "Сурет": {"canonical": "File", "aliases": ["Swret", "سۋرەت"]},
        "Сурет талқылауы": {
            "canonical": "File talk",
            "aliases": [
                "Swret talqılawı",
                "Swret talqılawı",
                "Сурет талқылауы",
                "سۋرەت تالقىلاۋى",
                "سۋرەت تالقىلاۋى",
            ],
        },
        "МедиаУики": {
            "canonical": "MediaWiki",
            "aliases": ["MedïaWïkï", "مەدىياۋىيكىي", "مەدياۋيكي"],
        },
        "МедиаУики талқылауы": {
            "canonical": "MediaWiki talk",
            "aliases": [
                "MedïaWïkï talqılawı",
                "MedïaWïkï talqılawı",
                "МедиаУики талқылауы",
                "مەدىياۋىيكىي تالقىلاۋى",
                "مەدياۋيكي تالقىلاۋى",
            ],
        },
        "Үлгі": {
            "canonical": "Template",
            "aliases": ["Ülgi", "ٴۇلگٴى", "ٷلگٸ", "ۇلگى"],
        },
        "Үлгі талқылауы": {
            "canonical": "Template talk",
            "aliases": [
                "Ülgi talqılawı",
                "Ülgi talqılawı",
                "Үлгі талқылауы",
                "ٴۇلگٴى تالقىلاۋى",
                "ٷلگٸ تالقىلاۋى",
                "ۇلگى تالقىلاۋى",
            ],
        },
        "Анықтама": {"canonical": "Help", "aliases": ["Anıqtama", "انىقتاما"]},
        "Анықтама талқылауы": {
            "canonical": "Help talk",
            "aliases": [
                "Anıqtama talqılawı",
                "Anıqtama talqılawı",
                "Анықтама талқылауы",
                "انىقتاما تالقىلاۋى",
                "انىقتاما تالقىلاۋى",
            ],
        },
        "Санат": {"canonical": "Category", "aliases": ["Sanat", "سانات"]},
        "Санат талқылауы": {
            "canonical": "Category talk",
            "aliases": [
                "Sanat talqılawı",
                "Sanat talqılawı",
                "Санат талқылауы",
                "سانات تالقىلاۋى",
                "سانات تالقىلاۋى",
            ],
        },
        "Портал": {},
        "Портал талқылауы": {"aliases": ["Портал талқылауы"]},
        "Жоба": {"aliases": ["Joba", "جوبا"]},
        "Жоба талқылауы": {
            "aliases": ["Joba talqılawı", "Жоба талқылауы", "جوبا تالقىلاۋى"]
        },
        "Topic": {},
    },
    "kl": {
        "Immikkut": {"canonical": "Special", "aliases": ["Speciel"]},
        "Oqallinneq": {"canonical": "Talk", "aliases": ["Diskussion"]},
        "Atuisoq": {"canonical": "User", "aliases": ["Bruger"]},
        "Atuisup oqalliffia": {
            "canonical": "User talk",
            "aliases": ["Brugerdiskussion"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia-p oqalliffia": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia-diskussion", "Wikipediaip oqalliffia"],
        },
        "Fiileq": {"canonical": "File", "aliases": ["Billede", "Fil"]},
        "Fiilip oqalliffia": {
            "canonical": "File talk",
            "aliases": ["Billeddiskussion", "Fildiskussion"],
        },
        "Mediawikip oqalliffia": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki-diskussion"],
        },
        "Ilisserut": {"canonical": "Template", "aliases": ["Skabelon"]},
        "Ilisserummi oqallinneq": {
            "canonical": "Template talk",
            "aliases": ["Skabelondiskussion"],
        },
        "Ikiuutit": {"canonical": "Help", "aliases": ["Hjælp"]},
        "Ikiuutini oqallinneq": {
            "canonical": "Help talk",
            "aliases": ["Hjælp-diskussion"],
        },
        "Sumut atassuseq": {"canonical": "Category", "aliases": ["Kategori"]},
        "Sumut atassusermi oqallinneq": {
            "canonical": "Category talk",
            "aliases": ["Kategoridiskussion"],
        },
        "Modul": {"canonical": "Module"},
        "Moduldiskussion": {"canonical": "Module talk"},
    },
    "km": {
        "មេឌា": {"canonical": "Media", "aliases": ["មីឌា"]},
        "ពិសេស": {"canonical": "Special"},
        "ការពិភាក្សា": {"canonical": "Talk", "aliases": ["ពិភាក្សា"]},
        "អ្នកប្រើប្រាស់": {"canonical": "User"},
        "ការពិភាក្សារបស់អ្នកប្រើប្រាស់": {
            "canonical": "User talk",
            "aliases": ["អ្នកប្រើប្រាស់-ពិភាក្សា"],
        },
        "វិគីភីឌា": {"canonical": "Project"},
        "ការពិភាក្សាអំពីវិគីភីឌា": {
            "canonical": "Project talk",
            "aliases": ["វិគីភីឌា ពិភាក្ស"],
        },
        "ឯកសារ": {"canonical": "File", "aliases": ["រូបភាព"]},
        "ការពិភាក្សាអំពីឯកសារ": {
            "canonical": "File talk",
            "aliases": ["ការពិភាក្សាអំពីរូបភាព", "រូបភាព-ពិភាក្សា"],
        },
        "មេឌាវិគី": {"canonical": "MediaWiki", "aliases": ["មីឌាវិគី"]},
        "ការពិភាក្សាអំពីមេឌាវិគី": {
            "canonical": "MediaWiki talk",
            "aliases": ["មីឌាវិគី-ពិភាក្សា"],
        },
        "ទំព័រគំរូ": {"canonical": "Template"},
        "ការពិភាក្សាអំពីទំព័រគំរូ": {
            "canonical": "Template talk",
            "aliases": ["ទំព័រគំរូ-ពិភាក្សា"],
        },
        "ជំនួយ": {"canonical": "Help"},
        "ការពិភាក្សាអំពីជំនួយ": {
            "canonical": "Help talk",
            "aliases": ["ជំនួយ-ពិភាក្សា"],
        },
        "ចំណាត់ថ្នាក់ក្រុម": {
            "canonical": "Category",
            "aliases": ["ចំណាត់ក្រុម", "ចំនាត់ថ្នាក់ក្រុម"],
        },
        "ការពិភាក្សាអំពីចំណាត់ថ្នាក់ក្រុម": {
            "canonical": "Category talk",
            "aliases": ["ការពិភាក្សាអំពីចំនាត់ថ្នាក់ក្រុម", "ចំណាត់ក្រុម-ពិភាក្សា"],
        },
    },
    "kn": {
        "ಮೀಡಿಯ": {"canonical": "Media"},
        "ವಿಶೇಷ": {"canonical": "Special"},
        "ಚರ್ಚೆಪುಟ": {"canonical": "Talk"},
        "ಸದಸ್ಯ": {"canonical": "User"},
        "ಸದಸ್ಯರ ಚರ್ಚೆಪುಟ": {"canonical": "User talk"},
        "ವಿಕಿಪೀಡಿಯ": {"canonical": "Project"},
        "ವಿಕಿಪೀಡಿಯ ಚರ್ಚೆ": {"canonical": "Project talk"},
        "ಚಿತ್ರ": {"canonical": "File"},
        "ಚಿತ್ರ ಚರ್ಚೆಪುಟ": {"canonical": "File talk"},
        "ಮೀಡಿಯವಿಕಿ": {"canonical": "MediaWiki"},
        "ಮೀಡೀಯವಿಕಿ ಚರ್ಚೆ": {"canonical": "MediaWiki talk"},
        "ಟೆಂಪ್ಲೇಟು": {"canonical": "Template"},
        "ಟೆಂಪ್ಲೇಟು ಚರ್ಚೆ": {"canonical": "Template talk"},
        "ಸಹಾಯ": {"canonical": "Help"},
        "ಸಹಾಯ ಚರ್ಚೆ": {"canonical": "Help talk"},
        "ವರ್ಗ": {"canonical": "Category"},
        "ವರ್ಗ ಚರ್ಚೆ": {"canonical": "Category talk"},
        "ಕರಡು": {"aliases": ["Draft"]},
        "ಕರಡು ಚರ್ಚೆ": {"aliases": ["Draft talk"]},
        "ಮಾಡ್ಯೂಲ್": {"canonical": "Module"},
        "ಮಾಡ್ಯೂಲ್ ಚರ್ಚೆ": {"canonical": "Module talk"},
    },
    "ko": {
        "미디어": {"canonical": "Media"},
        "특수": {"canonical": "Special", "aliases": ["특", "특수기능"]},
        "토론": {"canonical": "Talk"},
        "사용자": {"canonical": "User", "aliases": ["사"]},
        "사용자토론": {"canonical": "User talk", "aliases": ["사토"]},
        "위키백과": {"canonical": "Project", "aliases": ["백"]},
        "위키백과토론": {"canonical": "Project talk", "aliases": ["백토"]},
        "파일": {"canonical": "File", "aliases": ["그림"]},
        "파일토론": {"canonical": "File talk", "aliases": ["그림토론"]},
        "미디어위키": {"canonical": "MediaWiki"},
        "미디어위키토론": {"canonical": "MediaWiki talk", "aliases": ["MediaWiki토론"]},
        "틀": {"canonical": "Template"},
        "틀토론": {"canonical": "Template talk"},
        "도움말": {"canonical": "Help"},
        "도움말토론": {"canonical": "Help talk"},
        "분류": {"canonical": "Category"},
        "분류토론": {"canonical": "Category talk"},
        "포털": {"aliases": ["들", "들머리"]},
        "포털토론": {"aliases": ["들머리토론", "들토"]},
        "위키프로젝트": {"aliases": ["프"]},
        "위키프로젝트토론": {"aliases": ["프토"]},
        "초안": {"aliases": ["Draft"]},
        "초안토론": {"aliases": ["Draft talk"]},
        "모듈": {"canonical": "Module"},
        "모듈토론": {"canonical": "Module talk"},
        "소도구": {"canonical": "Gadget"},
        "소도구토론": {"canonical": "Gadget talk"},
        "소도구정의": {"canonical": "Gadget definition"},
        "소도구정의토론": {"canonical": "Gadget definition talk"},
    },
    "koi": {
        "Медиа": {"canonical": "Media"},
        "Служебная": {"canonical": "Special"},
        "Обсуждение": {"canonical": "Talk"},
        "Участник": {"canonical": "User", "aliases": ["Участница"]},
        "Обсуждение участника": {
            "canonical": "User talk",
            "aliases": ["Обсуждение участницы"],
        },
        "Википедия": {"canonical": "Project"},
        "Баитам Википедия йылiсь": {"canonical": "Project talk"},
        "Файл": {"canonical": "File", "aliases": ["Изображение"]},
        "Обсуждение файла": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения"],
        },
        "Обсуждение MediaWiki": {"canonical": "MediaWiki talk"},
        "Шаблон": {"canonical": "Template"},
        "Обсуждение шаблона": {"canonical": "Template talk"},
        "Справка": {"canonical": "Help"},
        "Обсуждение справки": {"canonical": "Help talk"},
        "Категория": {"canonical": "Category"},
        "Обсуждение категории": {"canonical": "Category talk"},
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "krc": {
        "Медиа": {"canonical": "Media"},
        "Къуллукъ": {"canonical": "Special"},
        "Сюзюу": {"canonical": "Talk"},
        "Къошулуучу": {"canonical": "User"},
        "Къошулуучуну сюзюу": {"canonical": "User talk"},
        "Википедия": {"canonical": "Project"},
        "Википедия сюзюу": {"canonical": "Project talk"},
        "Файл": {"canonical": "File", "aliases": ["Изображение"]},
        "Файлны сюзюу": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения"],
        },
        "MediaWiki-ни сюзюу": {"canonical": "MediaWiki talk"},
        "Шаблон": {"canonical": "Template"},
        "Шаблонну сюзюу": {"canonical": "Template talk"},
        "Болушлукъ": {"canonical": "Help"},
        "Болушлукъну сюзюу": {"canonical": "Help talk"},
        "Категория": {"canonical": "Category"},
        "Категорияны сюзюу": {"canonical": "Category talk"},
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "ks": {
        "میڈیا": {"canonical": "Media"},
        "خاص": {"canonical": "Special"},
        "کَتھ": {"canonical": "Talk", "aliases": ["بَحَژ"]},
        "رُکُن": {"canonical": "User"},
        "رُکُن کَتھ": {"canonical": "User talk", "aliases": ["رُکُن بَحَژ"]},
        "وِکیٖپیٖڈیا": {"canonical": "Project", "aliases": ["وپ"]},
        "وِکیٖپیٖڈیا کَتھ": {
            "canonical": "Project talk",
            "aliases": ["وب", "وِکیٖپیٖڈیا بَحَژ"],
        },
        "فَیِل": {"canonical": "File"},
        "فَیِل کَتھ": {"canonical": "File talk", "aliases": ["فَیِل بَحَژ"]},
        "میٖڈیاوِکی": {"canonical": "MediaWiki", "aliases": ["میڈیاوکی"]},
        "میٖڈیاوِکی کَتھ": {
            "canonical": "MediaWiki talk",
            "aliases": ["میڈیاوکی بَحَژ"],
        },
        "فرما": {"canonical": "Template"},
        "فرما کَتھ": {"canonical": "Template talk", "aliases": ["فرما بَحَژ"]},
        "مَدَتھ": {"canonical": "Help", "aliases": ["پَلزُن"]},
        "مَدَتھ کَتھ": {"canonical": "Help talk", "aliases": ["پَلزُن بَحَژ"]},
        "زٲژ": {"canonical": "Category"},
        "زٲژ کَتھ": {"canonical": "Category talk", "aliases": ["زٲژ بَحَژ"]},
    },
    "ksh": {
        "Medie": {"canonical": "Media", "aliases": ["Medium", "Meedije", "Meedijum"]},
        "Extra": {"canonical": "Special", "aliases": ["Shpezjal", "Spezial"]},
        "Klaaf": {"canonical": "Talk"},
        "Metmaacher": {
            "canonical": "User",
            "aliases": [
                "Medmaacher",
                "Medmaacheren",
                "Medmaacherin",
                "Metmaacheren",
                "Metmaacherin",
            ],
        },
        "Metmaacher Klaaf": {"canonical": "User talk", "aliases": ["Medmaacher Klaaf"]},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia Klaaf": {"canonical": "Project talk"},
        "Datei": {"canonical": "File", "aliases": ["Beld", "Belld", "Bild"]},
        "Dateie Klaaf": {
            "canonical": "File talk",
            "aliases": ["Belder Klaaf", "Bellder Klaaf", "Bild Diskussion"],
        },
        "MediaWiki": {"aliases": ["MedijaWikki"]},
        "MediaWiki Klaaf": {
            "canonical": "MediaWiki talk",
            "aliases": ["MedijaWikki Klaaf"],
        },
        "Schablon": {"canonical": "Template"},
        "Schablone Klaaf": {"canonical": "Template talk"},
        "Hölp": {"canonical": "Help", "aliases": ["Hülp"]},
        "Hölp Klaaf": {"canonical": "Help talk", "aliases": ["Hülp Klaaf"]},
        "Saachjrupp": {
            "canonical": "Category",
            "aliases": [
                "Kategorie",
                "Katejori",
                "Kattejori",
                "Saachjrop",
                "Saachjropp",
                "Sachjrop",
            ],
        },
        "Saachjruppe Klaaf": {
            "canonical": "Category talk",
            "aliases": [
                "Kategorie Klaaf",
                "Katejorije Klaaf",
                "Kattejori Klaaf",
                "Kattejorije Klaaf",
                "Saachjroppe Klaaf",
                "Saachjrupp Klaaf",
                "Sachjrop Klaaf",
            ],
        },
        "Modul": {"canonical": "Module"},
        "Modul Diskussion": {"canonical": "Module talk"},
        "Gadget Diskussion": {"canonical": "Gadget talk"},
        "Gadget-Definition": {"canonical": "Gadget definition"},
        "Gadget-Definition Diskussion": {"canonical": "Gadget definition talk"},
    },
    "ku": {
        "Medya": {"canonical": "Media", "aliases": ["میدیا"]},
        "Taybet": {"canonical": "Special", "aliases": ["تایبەت"]},
        "Gotûbêj": {"canonical": "Talk", "aliases": ["Nîqaş", "وتووێژ"]},
        "Bikarhêner": {"canonical": "User", "aliases": ["بەکارھێنەر"]},
        "Gotûbêja bikarhêner": {
            "canonical": "User talk",
            "aliases": [
                "Bikarhêner nîqaş",
                "Gotûbêja bikarhêner",
                "لێدوانی بەکارھێنەر",
            ],
        },
        "Wîkîpediya": {"canonical": "Project"},
        "Gotûbêja Wîkîpediyayê": {
            "canonical": "Project talk",
            "aliases": ["Gotûbêja Wîkîpediyayê", "Wîkîpediya nîqaş"],
        },
        "Wêne": {"canonical": "File", "aliases": ["پەڕگە"]},
        "Gotûbêja wêneyî": {
            "canonical": "File talk",
            "aliases": ["Gotûbêja wêneyî", "Wêne nîqaş", "وتووێژی پەڕگە"],
        },
        "MediaWiki": {"aliases": ["میدیاویکی"]},
        "Gotûbêja MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Gotûbêja MediaWiki", "MediaWiki nîqaş", "وتووێژی میدیاویکی"],
        },
        "Şablon": {"canonical": "Template", "aliases": ["داڕێژە"]},
        "Gotûbêja şablonê": {
            "canonical": "Template talk",
            "aliases": ["Gotûbêja şablonê", "Şablon nîqaş", "وتووێژی داڕێژە"],
        },
        "Alîkarî": {"canonical": "Help", "aliases": ["یارمەتی"]},
        "Gotûbêja alîkariyê": {
            "canonical": "Help talk",
            "aliases": ["Alîkarî nîqaş", "Gotûbêja alîkariyê", "وتووێژی یارمەتی"],
        },
        "Kategorî": {"canonical": "Category", "aliases": ["پۆل"]},
        "Gotûbêja kategoriyê": {
            "canonical": "Category talk",
            "aliases": ["Gotûbêja kategoriyê", "Kategorî nîqaş", "وتووێژی پۆل"],
        },
        "Gotûbêja portalê": {"aliases": ["Gotûbêja portalê", "Portal nîqaş"]},
        "Modul": {"canonical": "Module"},
        "Gotûbêja modulê": {"canonical": "Module talk", "aliases": ["Gotûbêja modulê"]},
        "Gadget": {"aliases": ["ئامراز"]},
        "Gadget talk": {"aliases": ["وتووێژی ئامراز"]},
        "Gadget definition": {"aliases": ["پێناسه\u200cی ئامراز"]},
        "Gadget definition talk": {"aliases": ["وتووێژی پێناسه\u200cی ئامراز"]},
    },
    "kv": {
        "Медиа": {"canonical": "Media"},
        "Отсасян": {"canonical": "Special", "aliases": ["Служебная"]},
        "Сёрнитанiн": {"canonical": "Talk", "aliases": ["Обсуждение"]},
        "Пырысь": {"canonical": "User", "aliases": ["Участник", "Участница"]},
        "Пырыськӧд сёрнитанiн": {
            "canonical": "User talk",
            "aliases": ["Обсуждение участника", "Обсуждение участницы"],
        },
        "Википедия": {"canonical": "Project"},
        "Википедия донъялӧм": {
            "canonical": "Project talk",
            "aliases": ["Обсуждение Wikipedia", "Обсуждение Википедия"],
        },
        "Файл": {"canonical": "File", "aliases": ["Изображение"]},
        "Файл донъялӧм": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения", "Обсуждение файла"],
        },
        "МедиаВики": {"canonical": "MediaWiki"},
        "МедиаВики донъялӧм": {
            "canonical": "MediaWiki talk",
            "aliases": ["Обсуждение MediaWiki"],
        },
        "Шаблон": {"canonical": "Template"},
        "Шаблон донъялӧм": {
            "canonical": "Template talk",
            "aliases": ["Обсуждение шаблона"],
        },
        "Справка": {"canonical": "Help"},
        "Обсуждение справки": {"canonical": "Help talk"},
        "Категория": {"canonical": "Category"},
        "Обсуждение категории": {"canonical": "Category talk"},
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "kw": {
        "Arbennek": {"canonical": "Special", "aliases": ["Arbednek"]},
        "Keskows": {"canonical": "Talk", "aliases": ["Cows", "Kescows"]},
        "Devnydhyer": {"canonical": "User"},
        "Keskows Devnydhyer": {
            "canonical": "User talk",
            "aliases": ["Cows Devnydhyer", "Kescows Devnydhyer"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Keskows Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Cows Wikipedia", "Kescows Wikipedia"],
        },
        "Restren": {"canonical": "File"},
        "Keskows Restren": {
            "canonical": "File talk",
            "aliases": ["Cows Restren", "Kescows Restren"],
        },
        "Keskows MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Cows MediaWiki", "Kescows MediaWiki"],
        },
        "Skantlyn": {"canonical": "Template", "aliases": ["Scantlyn"]},
        "Keskows Skantlyn": {
            "canonical": "Template talk",
            "aliases": ["Cows Scantlyn", "Kescows Skantlyn"],
        },
        "Gweres": {"canonical": "Help"},
        "Keskows Gweres": {
            "canonical": "Help talk",
            "aliases": ["Cows Gweres", "Kescows Gweres"],
        },
        "Klass": {"canonical": "Category", "aliases": ["Class"]},
        "Keskows Klass": {
            "canonical": "Category talk",
            "aliases": ["Cows Class", "Kescows Class"],
        },
        "Porth": {},
        "Keskows Porth": {},
    },
    "ky": {
        "Медиа": {"canonical": "Media"},
        "Атайын": {"canonical": "Special"},
        "Талкуу": {"canonical": "Talk"},
        "Колдонуучу": {"canonical": "User"},
        "Колдонуучунун баарлашуулары": {"canonical": "User talk"},
        "Википедия": {"canonical": "Project"},
        "Википедияны талкуулоо": {"canonical": "Project talk"},
        "Файл": {"canonical": "File"},
        "Файлды талкуулоо": {"canonical": "File talk"},
        "МедиаВики": {"canonical": "MediaWiki"},
        "МедиаВикини талкуулоо": {"canonical": "MediaWiki talk"},
        "Калып": {"canonical": "Template"},
        "Калыпты талкуулоо": {"canonical": "Template talk"},
        "Жардам": {"canonical": "Help"},
        "Жардамды талкуулоо": {"canonical": "Help talk"},
        "Категория": {"canonical": "Category"},
        "Категорияны талкуулоо": {"canonical": "Category talk"},
        "Модуль": {"canonical": "Module"},
        "Модулду талкуулоо": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Гаджетти талкуулоо": {"canonical": "Gadget talk"},
        "Гаджеттин түшүндүрмөсү": {"canonical": "Gadget definition"},
        "Гаджеттин түшүндүрмөсүн талкуулоо": {"canonical": "Gadget definition talk"},
    },
    "la": {
        "Specialis": {"canonical": "Special"},
        "Disputatio": {"canonical": "Talk"},
        "Usor": {"canonical": "User"},
        "Disputatio Usoris": {"canonical": "User talk"},
        "Vicipaedia": {"canonical": "Project"},
        "Disputatio Vicipaediae": {
            "canonical": "Project talk",
            "aliases": ["Disputatio Wikipedia"],
        },
        "Fasciculus": {"canonical": "File", "aliases": ["Imago"]},
        "Disputatio Fasciculi": {
            "canonical": "File talk",
            "aliases": ["Disputatio Imaginis"],
        },
        "Disputatio MediaWiki": {"canonical": "MediaWiki talk"},
        "Formula": {"canonical": "Template"},
        "Disputatio Formulae": {"canonical": "Template talk"},
        "Auxilium": {"canonical": "Help"},
        "Disputatio Auxilii": {"canonical": "Help talk"},
        "Categoria": {"canonical": "Category"},
        "Disputatio Categoriae": {"canonical": "Category talk"},
        "Porta": {},
        "Disputatio Portae": {},
    },
    "lad": {
        "Medya": {"canonical": "Media", "aliases": ["Meddia"]},
        "Especial": {"canonical": "Special"},
        "Diskusyón": {"canonical": "Talk", "aliases": ["Discusión", "Diskussión"]},
        "Usador": {"canonical": "User", "aliases": ["Empleador", "Usuario"]},
        "Messaje de Usador": {
            "canonical": "User talk",
            "aliases": ["Message de Empleador", "Usuario Discusión"],
        },
        "Vikipedya": {"canonical": "Project"},
        "Diskusyón de Vikipedya": {
            "canonical": "Project talk",
            "aliases": ["Diskussión de Vikipedya", "Vikipedya Discusión"],
        },
        "Dosya": {"canonical": "File", "aliases": ["Archivo", "Dossia", "Imagen"]},
        "Diskusyón de Dosya": {
            "canonical": "File talk",
            "aliases": [
                "Archivo Discusión",
                "Diskussión de Dossia",
                "Imagen discusión",
            ],
        },
        "MedyaViki": {"canonical": "MediaWiki"},
        "Diskusyón de MedyaViki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Diskussión de Xabblón", "MediaWiki Discusión"],
        },
        "Xablón": {"canonical": "Template", "aliases": ["Plantilla", "Xabblón"]},
        "Diskusyón de Xablón": {
            "canonical": "Template talk",
            "aliases": ["Diskusyón de Xabblón", "Plantilla Discusión"],
        },
        "Ayudo": {"canonical": "Help", "aliases": ["Ayuda"]},
        "Diskusyón de Ayudo": {
            "canonical": "Help talk",
            "aliases": ["Ayuda Discusión", "Diskussión de Ayudo"],
        },
        "Kateggoría": {"canonical": "Category", "aliases": ["Categoría", "Katēggoría"]},
        "Diskusyón de Kateggoría": {
            "canonical": "Category talk",
            "aliases": ["Categoría Discusión", "Diskusyón de Katēggoría"],
        },
        "Diskusyón de Portal": {},
        "Módulo": {"canonical": "Module"},
        "Módulo discusión": {"canonical": "Module talk"},
        "Accesorio": {"canonical": "Gadget"},
        "Accesorio discusión": {"canonical": "Gadget talk"},
        "Accesorio definición": {"canonical": "Gadget definition"},
        "Accesorio definición discusión": {"canonical": "Gadget definition talk"},
    },
    "lb": {
        "Spezial": {"canonical": "Special"},
        "Diskussioun": {"canonical": "Talk"},
        "Benotzer": {"canonical": "User"},
        "Benotzer Diskussioun": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia Diskussioun": {"canonical": "Project talk"},
        "Fichier": {"canonical": "File", "aliases": ["Bild"]},
        "Fichier Diskussioun": {
            "canonical": "File talk",
            "aliases": ["Bild Diskussion", "Bild Diskussioun"],
        },
        "MediaWiki Diskussioun": {"canonical": "MediaWiki talk"},
        "Schabloun": {"canonical": "Template"},
        "Schabloun Diskussioun": {"canonical": "Template talk"},
        "Hëllef": {"canonical": "Help"},
        "Hëllef Diskussioun": {"canonical": "Help talk"},
        "Kategorie": {"canonical": "Category"},
        "Kategorie Diskussioun": {"canonical": "Category talk"},
        "Modul": {"canonical": "Module"},
        "Modul Diskussioun": {"canonical": "Module talk"},
        "Gadget Diskussion": {"canonical": "Gadget talk"},
        "Gadget-Definition": {"canonical": "Gadget definition"},
        "Gadget-Definition Diskussion": {"canonical": "Gadget definition talk"},
    },
    "lbe": {
        "Медиа": {"canonical": "Media"},
        "Къуллугъирал лажин": {"canonical": "Special"},
        "Ихтилат": {"canonical": "Talk"},
        "Гьуртту хьума": {"canonical": "User"},
        "Гьуртту хьуминнал ихтилат": {"canonical": "User talk"},
        "Википедия": {"canonical": "Project"},
        "Википедиялиясса ихтилат": {"canonical": "Project talk"},
        "Сурат": {"canonical": "File", "aliases": ["Изображение"]},
        "Суратраясса ихтилат": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения"],
        },
        "MediaWikiлиясса ихтилат": {"canonical": "MediaWiki talk"},
        "Шаблон": {"canonical": "Template"},
        "Шаблондалиясса ихтилат": {"canonical": "Template talk"},
        "Кумаг": {"canonical": "Help"},
        "Кумаграясса ихтилат": {"canonical": "Help talk"},
        "Категория": {"canonical": "Category"},
        "Категориялиясса ихтилат": {"canonical": "Category talk"},
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "lez": {
        "Медиа": {"canonical": "Media", "aliases": ["Mediya"]},
        "Служебная": {"canonical": "Special"},
        "Веревирд авун": {"canonical": "Talk", "aliases": ["Обсуждение"]},
        "Уртах": {"canonical": "User", "aliases": ["Участник"]},
        "Уртахдин веревирд авун": {
            "canonical": "User talk",
            "aliases": ["Обсуждение участника"],
        },
        "Википедия": {"canonical": "Project"},
        "Википедия веревирд авун": {
            "canonical": "Project talk",
            "aliases": ["Обсуждение Википедия"],
        },
        "Файл": {"canonical": "File", "aliases": ["Şəkil", "Изображение"]},
        "Файл веревирд авун": {
            "canonical": "File talk",
            "aliases": [
                "Şəkil müzakirəsi",
                "Обсуждение изображения",
                "Обсуждение файла",
            ],
        },
        "MediaWiki": {"aliases": ["MediyaViki"]},
        "MediaWiki веревирд авун": {
            "canonical": "MediaWiki talk",
            "aliases": [
                "MediaWiki müzakirəsi",
                "MediyaViki müzakirəsi",
                "Обсуждение MediaWiki",
            ],
        },
        "Шаблон": {"canonical": "Template"},
        "Шаблон веревирд авун": {
            "canonical": "Template talk",
            "aliases": ["Обсуждение шаблона"],
        },
        "Справка": {"canonical": "Help"},
        "Обсуждение справки": {"canonical": "Help talk"},
        "Категория": {"canonical": "Category"},
        "Категория веревирд авун": {
            "canonical": "Category talk",
            "aliases": ["Обсуждение категории"],
        },
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "lfn": {
        "Spesial": {"canonical": "Special"},
        "Discute": {"canonical": "Talk"},
        "Usor": {"canonical": "User"},
        "Usor Discute": {"canonical": "User talk"},
        "Vicipedia": {"canonical": "Project"},
        "Vicipedia Discute": {"canonical": "Project talk"},
        "Fix": {"canonical": "File"},
        "Fix Discute": {"canonical": "File talk"},
        "Model": {"canonical": "Template"},
        "Model Discute": {"canonical": "Template talk"},
        "Aida": {"canonical": "Help"},
        "Aida Discute": {"canonical": "Help talk"},
        "Categoria": {"canonical": "Category"},
        "Categoria Discute": {"canonical": "Category talk"},
        "Modulo": {"canonical": "Module"},
        "Modulo Discute": {"canonical": "Module talk"},
        "Macineta": {"canonical": "Gadget"},
        "Macineta Discute": {"canonical": "Gadget talk"},
        "Defini de macineta": {"canonical": "Gadget definition"},
        "Defini de macineta Discute": {"canonical": "Gadget definition talk"},
    },
    "lg": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "li": {
        "Speciaal": {"canonical": "Special"},
        "Euverlèk": {"canonical": "Talk"},
        "Gebroeker": {"canonical": "User"},
        "Euverlèk gebroeker": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Euverlèk Wikipedia": {"canonical": "Project talk"},
        "Plaetje": {"canonical": "File", "aliases": ["Aafbeilding", "Afbeelding"]},
        "Euverlèk plaetje": {
            "canonical": "File talk",
            "aliases": ["Euverlèk afbeelding", "Overleg afbeelding"],
        },
        "Euverlèk MediaWiki": {"canonical": "MediaWiki talk"},
        "Sjabloon": {"canonical": "Template"},
        "Euverlèk sjabloon": {"canonical": "Template talk"},
        "Euverlèk help": {"canonical": "Help talk"},
        "Categorie": {"canonical": "Category", "aliases": ["Kategorie"]},
        "Euverlèk categorie": {
            "canonical": "Category talk",
            "aliases": ["Euverlèk kategorie"],
        },
        "Portaol": {},
        "Euverlèk portaol": {},
        "Overleg module": {"canonical": "Module talk"},
        "Uitbreiding": {"canonical": "Gadget"},
        "Overleg uitbreiding": {"canonical": "Gadget talk"},
        "Uitbreidingsdefinitie": {"canonical": "Gadget definition"},
        "Overleg uitbreidingsdefinitie": {"canonical": "Gadget definition talk"},
    },
    "lij": {
        "Speçiale": {"canonical": "Special", "aliases": ["Speciale"]},
        "Discûscion": {"canonical": "Talk", "aliases": ["Discussione"]},
        "Utente": {"canonical": "User"},
        "Discûscioîn ûtente": {
            "canonical": "User talk",
            "aliases": ["Discussioni utente"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Discûscioîn Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Discussioni Wikipedia"],
        },
        "Immaggine": {"canonical": "File", "aliases": ["Immagine"]},
        "Discûscioîn immaggine": {
            "canonical": "File talk",
            "aliases": ["Discussioni immagine"],
        },
        "Discûscioîn MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Discussioni MediaWiki"],
        },
        "Discûscioîn template": {
            "canonical": "Template talk",
            "aliases": ["Discussioni template"],
        },
        "Agiûtto": {"canonical": "Help", "aliases": ["Aiuto"]},
        "Discûscioîn agiûtto": {
            "canonical": "Help talk",
            "aliases": ["Discussioni aiuto"],
        },
        "Categorîa": {"canonical": "Category", "aliases": ["Categoria"]},
        "Discûscioîn categorîa": {
            "canonical": "Category talk",
            "aliases": ["Discussioni categoria"],
        },
        "Modulo": {"canonical": "Module"},
        "Discussioni modulo": {"canonical": "Module talk"},
        "Accessorio": {"canonical": "Gadget"},
        "Discussioni accessorio": {"canonical": "Gadget talk"},
        "Definizione accessorio": {"canonical": "Gadget definition"},
        "Discussioni definizione accessorio": {"canonical": "Gadget definition talk"},
    },
    "lld": {
        "Speciale": {"canonical": "Special"},
        "Discussione": {"canonical": "Talk"},
        "Utente": {"canonical": "User"},
        "Discussioni utente": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Discussioni Wikipedia": {"canonical": "Project talk"},
        "File": {"aliases": ["Immagine"]},
        "Discussioni file": {
            "canonical": "File talk",
            "aliases": ["Discussioni immagine"],
        },
        "Discussioni MediaWiki": {"canonical": "MediaWiki talk"},
        "Discussioni template": {"canonical": "Template talk"},
        "Aiuto": {"canonical": "Help"},
        "Discussioni aiuto": {"canonical": "Help talk"},
        "Categoria": {"canonical": "Category"},
        "Discussioni categoria": {"canonical": "Category talk"},
        "Modulo": {"canonical": "Module"},
        "Discussioni modulo": {"canonical": "Module talk"},
        "Accessorio": {"canonical": "Gadget"},
        "Discussioni accessorio": {"canonical": "Gadget talk"},
        "Definizione accessorio": {"canonical": "Gadget definition"},
        "Discussioni definizione accessorio": {"canonical": "Gadget definition talk"},
    },
    "lmo": {
        "Special": {"aliases": ["Speciale"]},
        "Ciciarada": {"canonical": "Talk", "aliases": ["Discussion", "Discussione"]},
        "Utent": {
            "canonical": "User",
            "aliases": ["Dovrat", "Druvadur", "Druvat", "Utente"],
        },
        "Ciciarada Utent": {
            "canonical": "User talk",
            "aliases": [
                "Ciciarada Dovrat",
                "Ciciarada Druvadur",
                "Ciciarada Druvat",
                "Discussion utente",
                "Discussioni utente",
            ],
        },
        "Wikipedia": {"canonical": "Project"},
        "Ciciarada Wikipedia": {
            "canonical": "Project talk",
            "aliases": [
                "Discussion Wikipedia",
                "Discussioni Wikipedia",
                "Wikipedia Ciciarada",
            ],
        },
        "Archivi": {"canonical": "File", "aliases": ["Immagine", "Imàjine"]},
        "Ciciarada Archivi": {
            "canonical": "File talk",
            "aliases": [
                "Discusion Imàjine",
                "Discussion file",
                "Discussion imagine",
                "Discussioni file",
                "Discussioni immagine",
            ],
        },
        "Ciciarada MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Discussion MediaWiki", "Discussioni MediaWiki"],
        },
        "Modell": {"canonical": "Template", "aliases": ["Model", "Modèl", "Mudel"]},
        "Ciciarada Modell": {
            "canonical": "Template talk",
            "aliases": [
                "Ciciarada Model",
                "Ciciarada Mudel",
                "Discussion modèl",
                "Discussion template",
                "Discussioni template",
            ],
        },
        "Jut": {"canonical": "Help", "aliases": ["Aida", "Aiuto", "Ajuto", "Jüt"]},
        "Ciciarada Jut": {
            "canonical": "Help talk",
            "aliases": [
                "Ciciarada Aida",
                "Ciciarada Jüt",
                "Discussion aiuto",
                "Discussion ajuto",
                "Discussioni aiuto",
            ],
        },
        "Categoria": {"canonical": "Category", "aliases": ["Categuria"]},
        "Ciciarada Categoria": {
            "canonical": "Category talk",
            "aliases": [
                "Ciciarada Categuria",
                "Discussion categoria",
                "Discussioni categoria",
            ],
        },
        "Descüssiú Portal": {},
        "Purtaal": {},
        "Descüssiun Purtaal": {},
        "Mòdul": {"canonical": "Module"},
        "Ciciarada Mòdul": {"canonical": "Module talk"},
        "Accessorio": {"canonical": "Gadget"},
        "Discussioni accessorio": {"canonical": "Gadget talk"},
        "Definizione accessorio": {"canonical": "Gadget definition"},
        "Discussioni definizione accessorio": {"canonical": "Gadget definition talk"},
    },
    "ln": {
        "Média": {"canonical": "Media"},
        "Spécial": {"canonical": "Special"},
        "Discussion": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Utilisateur": {"canonical": "User"},
        "Discussion utilisateur": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Discussion Wikipedia": {"canonical": "Project talk"},
        "Fichier": {"canonical": "File"},
        "Discussion fichier": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Discussion MediaWiki": {"canonical": "MediaWiki talk"},
        "Modèle": {"canonical": "Template"},
        "Discussion modèle": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Aide": {"canonical": "Help"},
        "Discussion aide": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Catégorie": {"canonical": "Category"},
        "Discussion catégorie": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "lo": {
        "ສື່": {"canonical": "Media", "aliases": ["ສື່ອ"]},
        "ພິເສດ": {"canonical": "Special"},
        "ສົນທະນາ": {"canonical": "Talk"},
        "ຜູ້ໃຊ້": {"canonical": "User"},
        "ສົນທະນາຂອງຜູ້ໃຊ້": {"canonical": "User talk"},
        "ວິກິພີເດຍ": {"canonical": "Project"},
        "ສົນທະນາກ່ຽວກັບວິກິພີເດຍ": {"canonical": "Project talk"},
        "ຮູບ": {"canonical": "File"},
        "ສົນທະນາກ່ຽວກັບຮູບ": {"canonical": "File talk"},
        "ມີເດຍວິກິ": {"canonical": "MediaWiki"},
        "ສົນທະນາກ່ຽວກັບມີເດຍວິກິ": {"canonical": "MediaWiki talk"},
        "ແມ່ແບບ": {"canonical": "Template"},
        "ສົນທະນາກ່ຽວກັບແມ່ແບບ": {"canonical": "Template talk"},
        "ຊ່ວຍເຫຼືອ": {"canonical": "Help"},
        "ສົນທະນາກ່ຽວກັບຊ່ວຍເຫຼືອ": {"canonical": "Help talk"},
        "ໝວດ": {"canonical": "Category"},
        "ສົນທະນາກ່ຽວກັບໝວດ": {"canonical": "Category talk"},
    },
    "lt": {
        "Medija": {"canonical": "Media"},
        "Specialus": {"canonical": "Special"},
        "Aptarimas": {"canonical": "Talk"},
        "Naudotojas": {"canonical": "User", "aliases": ["Naudotoja"]},
        "Naudotojo aptarimas": {
            "canonical": "User talk",
            "aliases": ["Naudotojos aptarimas"],
        },
        "Vikipedija": {"canonical": "Project"},
        "Vikipedijos aptarimas": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia aptarimas"],
        },
        "Vaizdas": {"canonical": "File"},
        "Vaizdo aptarimas": {"canonical": "File talk"},
        "MediaWiki aptarimas": {"canonical": "MediaWiki talk"},
        "Šablonas": {"canonical": "Template"},
        "Šablono aptarimas": {"canonical": "Template talk"},
        "Pagalba": {"canonical": "Help"},
        "Pagalbos aptarimas": {"canonical": "Help talk"},
        "Kategorija": {"canonical": "Category"},
        "Kategorijos aptarimas": {"canonical": "Category talk"},
        "Vikisritis": {},
        "Vikisrities aptarimas": {},
        "Vikiprojektas": {},
        "Vikiprojekto aptarimas": {},
        "Sąrašas": {},
        "Sąrašo aptarimas": {},
    },
    "ltg": {
        "Medeja": {"canonical": "Media"},
        "Seviškuo": {"canonical": "Special"},
        "Sprīža": {"canonical": "Talk"},
        "Lītuotuojs": {
            "canonical": "User",
            "aliases": ["Dalībniece", "Dalībnieks", "Lietotājs"],
        },
        "Sprīža ap lītuotuoju": {
            "canonical": "User talk",
            "aliases": [
                "Dalībnieces diskusija",
                "Dalībnieka diskusija",
                "Lietotāja diskusija",
            ],
        },
        "Vikipedeja": {"canonical": "Project"},
        "Vikipedejis sprīža": {"canonical": "Project talk"},
        "Fails": {"canonical": "File"},
        "Sprīža ap failu": {"canonical": "File talk"},
        "Sprīža ap MediaWiki": {"canonical": "MediaWiki talk"},
        "Taiss": {"canonical": "Template"},
        "Sprīža ap taisu": {"canonical": "Template talk"},
        "Paleigs": {"canonical": "Help"},
        "Sprīža ap paleigu": {"canonical": "Help talk"},
        "Kategoreja": {"canonical": "Category"},
        "Sprīža ap kategoreju": {"canonical": "Category talk"},
        "Modulis": {"canonical": "Module"},
        "Moduļa diskusija": {"canonical": "Module talk"},
    },
    "lv": {
        "Diskusija": {"canonical": "Talk"},
        "Dalībnieks": {"canonical": "User", "aliases": ["Dalībniece", "Lietotājs"]},
        "Dalībnieka diskusija": {
            "canonical": "User talk",
            "aliases": ["Dalībnieces diskusija", "Lietotāja diskusija"],
        },
        "Vikipēdija": {"canonical": "Project", "aliases": ["VP"]},
        "Vikipēdijas diskusija": {"canonical": "Project talk"},
        "Attēls": {"canonical": "File"},
        "Attēla diskusija": {"canonical": "File talk"},
        "MediaWiki diskusija": {"canonical": "MediaWiki talk"},
        "Veidne": {"canonical": "Template"},
        "Veidnes diskusija": {"canonical": "Template talk"},
        "Palīdzība": {"canonical": "Help"},
        "Palīdzības diskusija": {"canonical": "Help talk"},
        "Kategorija": {"canonical": "Category"},
        "Kategorijas diskusija": {"canonical": "Category talk"},
        "Portāls": {},
        "Portāla diskusija": {},
        "Vikiprojekts": {},
        "Vikiprojekta diskusija": {},
        "Education Program": {},
        "Education Program talk": {},
        "Modulis": {"canonical": "Module"},
        "Moduļa diskusija": {"canonical": "Module talk"},
        "Tēma": {"canonical": "Topic"},
    },
    "mad": {
        "Mèḍia": {"canonical": "Media"},
        "Spesial": {"canonical": "Special"},
        "Pakanḍhâ'ân": {"canonical": "Talk", "aliases": ["Bicara"]},
        "Pangangghuy": {"canonical": "User"},
        "Pakanḍhâ'ânna pangangghuy": {
            "canonical": "User talk",
            "aliases": ["Bicara Pengguna"],
        },
        "Wikipèḍia": {"canonical": "Project"},
        "Pakanḍhâ'ânna Wikipèḍia": {"canonical": "Project talk"},
        "Bhengkek": {"canonical": "File", "aliases": ["Gambar"]},
        "Pakanḍhâ'ânna bhengkek": {
            "canonical": "File talk",
            "aliases": ["Gambar Pembicaraan", "Pembicaraan Gambar"],
        },
        "MèḍiaWiki": {"canonical": "MediaWiki"},
        "Pakanḍhâ'ânna MèḍiaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Pembicaraan"],
        },
        "Cèṭa'an": {"canonical": "Template"},
        "Pakanḍhâ'ânna cèṭa'an": {
            "canonical": "Template talk",
            "aliases": ["Templat Pembicaraan"],
        },
        "Bhântowan": {"canonical": "Help"},
        "Pakanḍhâ'ânna bhântowan": {
            "canonical": "Help talk",
            "aliases": ["Bantuan Pembicaraan"],
        },
        "Bhângsa": {"canonical": "Category"},
        "Pakanḍhâ'ânna bhângsa": {
            "canonical": "Category talk",
            "aliases": ["Kategori Pembicaraan"],
        },
        "Modul": {"canonical": "Module"},
        "Pembicaraan Modul": {"canonical": "Module talk"},
    },
    "mai": {
        "मेडिया": {"canonical": "Media"},
        "विशेष": {"canonical": "Special"},
        "वार्ता": {"canonical": "Talk"},
        "प्रयोगकर्ता": {"canonical": "User", "aliases": ["u", "प्र"]},
        "प्रयोगकर्ता वार्ता": {"canonical": "User talk", "aliases": ["ut", "प्र वा"]},
        "विकिपिडिया": {"canonical": "Project", "aliases": ["वि"]},
        "विकिपिडिया वार्ता": {"canonical": "Project talk", "aliases": ["वि वा"]},
        "फाइल": {"canonical": "File"},
        "फाइल वार्ता": {"canonical": "File talk"},
        "मेडियाविकि": {"canonical": "MediaWiki"},
        "मेडियाविकि वार्ता": {"canonical": "MediaWiki talk"},
        "आकृति": {"canonical": "Template", "aliases": ["आ"]},
        "आकृति वार्ता": {"canonical": "Template talk", "aliases": ["आ वा"]},
        "मद्दत": {"canonical": "Help"},
        "मद्दत वार्ता": {"canonical": "Help talk"},
        "श्रेणी": {"canonical": "Category", "aliases": ["CA"]},
        "श्रेणी वार्ता": {"canonical": "Category talk", "aliases": ["CT"]},
        "मोड्युल": {"canonical": "Module"},
        "मोड्युल वार्ता": {"canonical": "Module talk"},
        "गैजेट": {"canonical": "Gadget"},
        "गैजेट वार्ता": {"canonical": "Gadget talk"},
        "गैजेट परिभाषा": {"canonical": "Gadget definition"},
        "गैजेट परिभाषा वार्ता": {"canonical": "Gadget definition talk"},
    },
    "map-bms": {
        "Médhia": {"canonical": "Media", "aliases": ["Medhia"]},
        "Mirunggan": {"canonical": "Special", "aliases": ["Astamiwa"]},
        "Parembugan": {"canonical": "Talk", "aliases": ["Bicara", "Dhiskusi"]},
        "Naraguna": {"canonical": "User", "aliases": ["Panganggo"]},
        "Parembugan Naraguna": {
            "canonical": "User talk",
            "aliases": [
                "Bicara Pengguna",
                "Dhiskusi Panganggo",
                "Parembugan Panganggo",
            ],
        },
        "Wikipedia": {"canonical": "Project"},
        "Parembugan Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Dhiskusi Wikipedia"],
        },
        "Barkas": {"canonical": "File", "aliases": ["Gambar"]},
        "Parembugan Barkas": {
            "canonical": "File talk",
            "aliases": [
                "Dhiskusi Gambar",
                "Gambar Dhiskusi",
                "Gambar Pembicaraan",
                "Parembugan Gambar",
                "Pembicaraan Gambar",
            ],
        },
        "MédhiaWiki": {"canonical": "MediaWiki", "aliases": ["MedhiaWiki"]},
        "Parembugan MédhiaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": [
                "Dhiskusi MediaWiki",
                "MediaWiki Dhiskusi",
                "MediaWiki Pembicaraan",
                "Parembugan MedhiaWiki",
                "Parembugan MediaWiki",
            ],
        },
        "Cithakan": {"canonical": "Template"},
        "Parembugan Cithakan": {
            "canonical": "Template talk",
            "aliases": [
                "Cithakan Dhiskusi",
                "Dhiskusi Cithakan",
                "Templat Pembicaraan",
            ],
        },
        "Pitulung": {"canonical": "Help"},
        "Parembugan Pitulung": {
            "canonical": "Help talk",
            "aliases": [
                "Bantuan Pembicaraan",
                "Dhiskusi Pitulung",
                "Pitulung Dhiskusi",
            ],
        },
        "Kategori": {"canonical": "Category"},
        "Parembugan Kategori": {
            "canonical": "Category talk",
            "aliases": [
                "Dhiskusi Kategori",
                "Kategori Dhiskusi",
                "Kategori Pembicaraan",
            ],
        },
        "Modhul": {"canonical": "Module"},
        "Parembugan Modhul": {"canonical": "Module talk"},
    },
    "mdf": {
        "Медиа": {"canonical": "Media"},
        "Башка": {"canonical": "Special", "aliases": ["Служебная"]},
        "Корхнема": {"canonical": "Talk", "aliases": ["Обсуждение"]},
        "Тиись": {"canonical": "User", "aliases": ["Участник"]},
        "Тиись корхнема": {
            "canonical": "User talk",
            "aliases": ["Обсуждение участника"],
        },
        "Википедиесь": {"canonical": "Project"},
        "Википедиесь корхнема": {
            "canonical": "Project talk",
            "aliases": ["Обсуждение Википедиесь"],
        },
        "Няйф": {"canonical": "File", "aliases": ["Изображение"]},
        "Няйф корхнема": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения"],
        },
        "МедиаВики": {"canonical": "MediaWiki"},
        "МедиаВики корхнема": {
            "canonical": "MediaWiki talk",
            "aliases": ["Обсуждение MediaWiki"],
        },
        "Шаблон": {"canonical": "Template"},
        "Шаблон корхнема": {
            "canonical": "Template talk",
            "aliases": ["Обсуждение шаблона"],
        },
        "Лезкс": {"canonical": "Help", "aliases": ["Справка"]},
        "Лезкс корхнема": {"canonical": "Help talk", "aliases": ["Обсуждение справки"]},
        "Категорие": {"canonical": "Category", "aliases": ["Категория"]},
        "Категорие корхнема": {
            "canonical": "Category talk",
            "aliases": ["Обсуждение категории"],
        },
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "mg": {
        "Rakitra": {"canonical": "Media", "aliases": ["Média"]},
        "Manokana": {"canonical": "Special"},
        "Dinika": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Mpikambana": {"canonical": "User", "aliases": ["Utilisateur"]},
        "Dinika amin'ny mpikambana": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Dinika amin'ny Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Discussion Wikipedia"],
        },
        "Sary": {"canonical": "File"},
        "Dinika amin'ny sary": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Dinika amin'ny MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Discussion MediaWiki"],
        },
        "Endrika": {"canonical": "Template", "aliases": ["Modèle"]},
        "Dinika amin'ny endrika": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Fanoroana": {"canonical": "Help", "aliases": ["Aide", "Fanampiana"]},
        "Dinika amin'ny fanoroana": {
            "canonical": "Help talk",
            "aliases": ["Dinika amin'ny fanampiana", "Discussion Aide"],
        },
        "Sokajy": {"canonical": "Category", "aliases": ["Catégorie"]},
        "Dinika amin'ny sokajy": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "mhr": {
        "Медиа": {"canonical": "Media"},
        "Лӱмын ыштыме": {"canonical": "Special", "aliases": ["Служебная"]},
        "Каҥашымаш": {"canonical": "Talk", "aliases": ["Обсуждение"]},
        "Пайдаланыше": {"canonical": "User", "aliases": ["Участник"]},
        "Пайдаланышын каҥашымашыже": {
            "canonical": "User talk",
            "aliases": [
                "Обсуждение участника",
                "Пайдаланышын каҥашымаш",
                "Сирӹшӹн кӓнгӓшӹмӓшӹжӹ",
            ],
        },
        "Википедий": {"canonical": "Project"},
        "Википедийын каҥашымашыже": {
            "canonical": "Project talk",
            "aliases": ["Википедийын каҥашымаш", "Обсуждение Википедий"],
        },
        "Файл": {"canonical": "File", "aliases": ["Изображение"]},
        "Файл шотышто каҥашымаш": {
            "canonical": "File talk",
            "aliases": [
                "Обсуждение изображения",
                "Обсуждение файла",
                "Файл кӓнгӓшӹмӓш",
                "Файлын каҥашымаш",
            ],
        },
        "MediaWiki-м кӓнгӓшӹмӓш": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki кӓнгӓшӹмӓш", "Обсуждение MediaWiki"],
        },
        "Кышкар": {"canonical": "Template", "aliases": ["Шаблон", "Ямдылык"]},
        "Кышкар шотышто каҥашымаш": {
            "canonical": "Template talk",
            "aliases": [
                "Обсуждение шаблона",
                "Шаблон кӓнгӓшӹмӓш",
                "Ямдылык шотышто каҥашымаш",
                "Ямдылыкын каҥашымаш",
            ],
        },
        "Полшык": {"canonical": "Help", "aliases": ["Справка"]},
        "Полшык шотышто каҥашымаш": {
            "canonical": "Help talk",
            "aliases": [
                "Обсуждение справки",
                "Палшыкын кӓнгӓшӹмӓш",
                "Полшыкын каҥашымаш",
            ],
        },
        "Категорий": {"canonical": "Category", "aliases": ["Категория"]},
        "Категорий шотышто каҥашымаш": {
            "canonical": "Category talk",
            "aliases": [
                "Категори кӓнгӓшӹмӓш",
                "Категорийын каҥашымаш",
                "Обсуждение категории",
            ],
        },
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "mi": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "min": {
        "Istimewa": {"canonical": "Special"},
        "Rundiang": {
            "canonical": "Talk",
            "aliases": ["Bicara", "Maota", "Pembicaraan"],
        },
        "Pangguno": {"canonical": "User", "aliases": ["Pengguna"]},
        "Rundiang Pangguno": {
            "canonical": "User talk",
            "aliases": ["Bicara Pengguna", "Pembicaraan Pengguna"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Rundiang Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Pembicaraan Wikipedia"],
        },
        "Berkas": {"canonical": "File", "aliases": ["Gambar"]},
        "Rundiang Berkas": {
            "canonical": "File talk",
            "aliases": [
                "Gambar Pembicaraan",
                "Pembicaraan Berkas",
                "Pembicaraan Gambar",
            ],
        },
        "Rundiang MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Pembicaraan", "Pembicaraan MediaWiki"],
        },
        "Templat": {"canonical": "Template"},
        "Rundiang Templat": {
            "canonical": "Template talk",
            "aliases": ["Pembicaraan Templat", "Templat Pembicaraan"],
        },
        "Bantuan": {"canonical": "Help"},
        "Rundiang Bantuan": {
            "canonical": "Help talk",
            "aliases": ["Bantuan Pembicaraan", "Pembicaraan Bantuan"],
        },
        "Kategori": {"canonical": "Category"},
        "Rundiang Kategori": {
            "canonical": "Category talk",
            "aliases": ["Kategori Pembicaraan", "Pembicaraan Kategori"],
        },
        "Diskusi Portal": {},
        "Modul": {"canonical": "Module"},
        "Rundiang Modul": {"canonical": "Module talk"},
    },
    "mk": {
        "Медиум": {"canonical": "Media", "aliases": ["Медија"]},
        "Специјална": {"canonical": "Special", "aliases": ["Специјални"]},
        "Разговор": {"canonical": "Talk"},
        "Корисник": {"canonical": "User"},
        "Разговор со корисник": {"canonical": "User talk"},
        "Википедија": {"canonical": "Project"},
        "Разговор за Википедија": {"canonical": "Project talk"},
        "Податотека": {"canonical": "File", "aliases": ["Слика"]},
        "Разговор за податотека": {
            "canonical": "File talk",
            "aliases": ["Разговор за слика"],
        },
        "МедијаВики": {"canonical": "MediaWiki"},
        "Разговор за МедијаВики": {"canonical": "MediaWiki talk"},
        "Предлошка": {"canonical": "Template", "aliases": ["Шаблон"]},
        "Разговор за предлошка": {
            "canonical": "Template talk",
            "aliases": ["Разговор за шаблон"],
        },
        "Помош": {"canonical": "Help"},
        "Разговор за помош": {"canonical": "Help talk"},
        "Категорија": {"canonical": "Category"},
        "Разговор за категорија": {"canonical": "Category talk"},
        "Портал": {},
        "Разговор за Портал": {},
        "Модул": {"canonical": "Module"},
        "Разговор за модул": {"canonical": "Module talk"},
    },
    "ml": {
        "മീഡിയ": {"canonical": "Media"},
        "പ്രത്യേകം": {"canonical": "Special", "aliases": ["പ്രത്യേ"]},
        "സംവാദം": {"canonical": "Talk", "aliases": ["സം"]},
        "ഉപയോക്താവ്": {"canonical": "User", "aliases": ["അംഗം", "ഉ"]},
        "ഉപയോക്താവിന്റെ സംവാദം": {
            "canonical": "User talk",
            "aliases": ["അംഗങ്ങളുടെ സംവാദം", "ഉസം"],
        },
        "വിക്കിപീഡിയ": {"canonical": "Project", "aliases": ["വിക്കി"]},
        "വിക്കിപീഡിയ സംവാദം": {"canonical": "Project talk", "aliases": ["വിക്കിസം"]},
        "പ്രമാണം": {"canonical": "File", "aliases": ["ചി", "ചിത്രം", "പ്ര"]},
        "പ്രമാണത്തിന്റെ സംവാദം": {
            "canonical": "File talk",
            "aliases": ["ചിത്രത്തിന്റെ സംവാദം", "ചിസം", "പ്രസം"],
        },
        "മീഡിയവിക്കി": {"canonical": "MediaWiki", "aliases": ["മീ"]},
        "മീഡിയവിക്കി സംവാദം": {"canonical": "MediaWiki talk", "aliases": ["മീസം"]},
        "ഫലകം": {"canonical": "Template", "aliases": ["ഫ"]},
        "ഫലകത്തിന്റെ സംവാദം": {"canonical": "Template talk", "aliases": ["ഫസം"]},
        "സഹായം": {"canonical": "Help", "aliases": ["സ"]},
        "സഹായത്തിന്റെ സംവാദം": {"canonical": "Help talk", "aliases": ["സസം"]},
        "വർഗ്ഗം": {"canonical": "Category", "aliases": ["വ", "വി", "വിഭാഗം"]},
        "വർഗ്ഗത്തിന്റെ സംവാദം": {
            "canonical": "Category talk",
            "aliases": ["വസം", "വിഭാഗത്തിന്റെ സംവാദം", "വിസം"],
        },
        "കവാടം": {"aliases": ["Portal"]},
        "കവാടത്തിന്റെ സംവാദം": {"aliases": ["Portal talk"]},
        "ഘടകം": {"canonical": "Module", "aliases": ["ഘ"]},
        "ഘടകത്തിന്റെ സംവാദം": {"canonical": "Module talk", "aliases": ["ഘസം"]},
    },
    "mn": {
        "Медиа": {"canonical": "Media"},
        "Тусгай": {"canonical": "Special"},
        "Хэлэлцүүлэг": {"canonical": "Talk"},
        "Хэрэглэгч": {"canonical": "User"},
        "Хэрэглэгчийн яриа": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia-н хэлэлцүүлэг": {"canonical": "Project talk"},
        "Файл": {"canonical": "File", "aliases": ["Зураг"]},
        "Файлын хэлэлцүүлэг": {
            "canonical": "File talk",
            "aliases": ["Зургийн хэлэлцүүлэг"],
        },
        "МедиаВики": {"canonical": "MediaWiki"},
        "МедиаВикигийн хэлэлцүүлэг": {"canonical": "MediaWiki talk"},
        "Загвар": {"canonical": "Template"},
        "Загварын хэлэлцүүлэг": {"canonical": "Template talk"},
        "Тусламж": {"canonical": "Help"},
        "Тусламжийн хэлэлцүүлэг": {"canonical": "Help talk"},
        "Ангилал": {"canonical": "Category"},
        "Ангиллын хэлэлцүүлэг": {"canonical": "Category talk"},
    },
    "mni": {
        "ꯃꯦꯗꯤꯌꯥ": {"canonical": "Media"},
        "ꯑꯈꯟꯅꯕ": {"canonical": "Special"},
        "ꯋꯥ ꯍꯥꯏꯐꯝ": {"canonical": "Talk"},
        "ꯁꯤꯖꯤꯟꯅꯔꯤꯕ": {"canonical": "User"},
        "ꯁꯤꯖꯤꯟꯅꯔꯤꯕ ꯋꯥ ꯍꯥꯏꯐꯝ": {"canonical": "User talk"},
        "ꯋꯤꯀꯤꯄꯦꯗꯤꯌꯥ": {"canonical": "Project"},
        "ꯋꯤꯀꯤꯄꯦꯗꯤꯌꯥ ꯋꯥ ꯍꯥꯏꯐꯝ": {"canonical": "Project talk"},
        "ꯐꯥꯏꯜ": {"canonical": "File"},
        "ꯐꯥꯏꯜ ꯋꯥ ꯍꯥꯏꯐꯝ": {"canonical": "File talk"},
        "ꯃꯦꯗꯤꯌꯥꯋꯤꯀꯤ": {"canonical": "MediaWiki"},
        "ꯃꯦꯗꯤꯌꯥꯋꯤꯀꯤ ꯋꯥ ꯍꯥꯏꯐꯝ": {"canonical": "MediaWiki talk"},
        "ꯇꯦꯝꯄ꯭ꯂꯦꯠ": {"canonical": "Template"},
        "ꯇꯦꯝꯄ꯭ꯂꯦꯠ ꯋꯥ ꯍꯥꯏꯐꯝ": {"canonical": "Template talk"},
        "ꯃꯇꯦꯡ": {"canonical": "Help"},
        "ꯃꯇꯦꯡ ꯋꯥ ꯍꯥꯏꯐꯝ": {"canonical": "Help talk"},
        "ꯃꯆꯥꯈꯥꯏꯕ": {"canonical": "Category"},
        "ꯃꯆꯥꯈꯥꯏꯕ ꯋꯥ ꯍꯥꯏꯐꯝ": {"canonical": "Category talk"},
    },
    "mnw": {
        "မဳဒဳယာ": {"canonical": "Media"},
        "တၟေင်": {"canonical": "Special"},
        "ဓရီုကျာ": {"canonical": "Talk"},
        "ညးလွပ်": {"canonical": "User"},
        "ညးလွပ် ဓရီုကျာ": {"canonical": "User talk"},
        "ဝဳကဳပဳဒဳယာ": {"canonical": "Project"},
        "ဝဳကဳပဳဒဳယာ ဓရီုကျာ": {"canonical": "Project talk"},
        "ဝှာင်": {"canonical": "File"},
        "ဝှာင် ဓရီုကျာ": {"canonical": "File talk"},
        "မဳဒဳယာဝဳကဳ": {"canonical": "MediaWiki"},
        "မဳဒဳယာဝဳကဳ ဓရီုကျာ": {"canonical": "MediaWiki talk"},
        "ထာမ်ပလိက်": {"canonical": "Template"},
        "ထာမ်ပလိက် ဓရီုကျာ": {"canonical": "Template talk"},
        "ရီု": {"canonical": "Help"},
        "ရီု ဓရီုကျာ": {"canonical": "Help talk"},
        "ကဏ္ဍ": {"canonical": "Category"},
        "ကဏ္ဍ ဓရီုကျာ": {"canonical": "Category talk"},
        "ပါင်မုက်": {"aliases": ["Portal"]},
        "ပါင်မုက် ဓရီုကျာ": {"aliases": ["Portal talk"]},
        "မဝ်ဂျူ": {"canonical": "Module"},
        "မဝ်ဂျူ ဓရီုကျာ": {"canonical": "Module talk"},
        "ကိရိယာငယ်": {"canonical": "Gadget"},
        "ကိရိယာငယ် ဆွေးနွေးချက်": {"canonical": "Gadget talk"},
        "ကိရိယာငယ် အဓိပ္ပာယ်": {"canonical": "Gadget definition"},
        "ကိရိယာငယ် အဓိပ္ပာယ် ဆွေးနွေးချက်": {"canonical": "Gadget definition talk"},
    },
    "mr": {
        "मिडिया": {"canonical": "Media"},
        "विशेष": {"canonical": "Special"},
        "चर्चा": {"canonical": "Talk"},
        "सदस्य": {"canonical": "User"},
        "सदस्य चर्चा": {"canonical": "User talk"},
        "विकिपीडिया": {"canonical": "Project", "aliases": ["विपी"]},
        "विकिपीडिया चर्चा": {"canonical": "Project talk"},
        "चित्र": {"canonical": "File"},
        "चित्र चर्चा": {"canonical": "File talk"},
        "मिडियाविकी": {"canonical": "MediaWiki"},
        "मिडियाविकी चर्चा": {"canonical": "MediaWiki talk"},
        "साचा": {"canonical": "Template"},
        "साचा चर्चा": {"canonical": "Template talk"},
        "सहाय्य": {"canonical": "Help", "aliases": ["साहाय्य"]},
        "सहाय्य चर्चा": {"canonical": "Help talk", "aliases": ["साहाय्य चर्चा"]},
        "वर्ग": {"canonical": "Category"},
        "वर्ग चर्चा": {"canonical": "Category talk"},
        "दालन": {},
        "दालन चर्चा": {},
        "विभाग": {"canonical": "Module"},
        "विभाग चर्चा": {"canonical": "Module talk"},
    },
    "mrj": {
        "Медиа": {"canonical": "Media"},
        "Спецӹлӹштӓш": {"canonical": "Special", "aliases": ["Служебная"]},
        "Кӓнгӓшӹмӓш": {"canonical": "Talk", "aliases": ["Обсуждение"]},
        "Сирӹшӹ": {"canonical": "User", "aliases": ["Участник"]},
        "Сирӹшӹм кӓнгӓшӹмӓш": {
            "canonical": "User talk",
            "aliases": [
                "Обсуждение участника",
                "Пайдаланышын каҥашымаш",
                "Сирӹшӹн кӓнгӓшӹмӓшӹжӹ",
            ],
        },
        "Википеди": {"canonical": "Project"},
        "Википедим кӓнгӓшӹмӓш": {
            "canonical": "Project talk",
            "aliases": ["Википедиын каҥашымаш", "Обсуждение Википеди"],
        },
        "Файл": {"canonical": "File", "aliases": ["Изображение"]},
        "Файлым кӓнгӓшӹмӓш": {
            "canonical": "File talk",
            "aliases": [
                "Обсуждение изображения",
                "Обсуждение файла",
                "Файл кӓнгӓшӹмӓш",
                "Файлын каҥашымаш",
            ],
        },
        "MediaWiki-м кӓнгӓшӹмӓш": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki кӓнгӓшӹмӓш", "Обсуждение MediaWiki"],
        },
        "Шаблон": {"canonical": "Template", "aliases": ["Ямдылык"]},
        "Шаблоным кӓнгӓшӹмӓш": {
            "canonical": "Template talk",
            "aliases": [
                "Обсуждение шаблона",
                "Шаблон кӓнгӓшӹмӓш",
                "Ямдылык шотышто каҥашымаш",
                "Ямдылыкын каҥашымаш",
            ],
        },
        "Палшык": {"canonical": "Help", "aliases": ["Справка"]},
        "Палшыкым кӓнгӓшӹмӓш": {
            "canonical": "Help talk",
            "aliases": [
                "Обсуждение справки",
                "Палшыкын кӓнгӓшӹмӓш",
                "Полшыкын каҥашымаш",
            ],
        },
        "Категори": {"canonical": "Category", "aliases": ["Категория"]},
        "Категорим кӓнгӓшӹмӓш": {
            "canonical": "Category talk",
            "aliases": [
                "Категори кӓнгӓшӹмӓш",
                "Категорийын каҥашымаш",
                "Обсуждение категории",
            ],
        },
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "ms": {
        "Khas": {"canonical": "Special", "aliases": ["Istimewa"]},
        "Perbincangan": {"canonical": "Talk", "aliases": ["Perbualan"]},
        "Pengguna": {"canonical": "User"},
        "Perbincangan pengguna": {
            "canonical": "User talk",
            "aliases": ["Perbualan Pengguna"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Perbincangan Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Perbualan Wikipedia"],
        },
        "Fail": {"canonical": "File", "aliases": ["Imej"]},
        "Perbincangan fail": {
            "canonical": "File talk",
            "aliases": ["Imej Perbualan", "Perbincangan Imej"],
        },
        "Perbincangan MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Perbualan"],
        },
        "Templat": {"canonical": "Template"},
        "Perbincangan templat": {
            "canonical": "Template talk",
            "aliases": ["Perbualan Templat"],
        },
        "Bantuan": {"canonical": "Help"},
        "Perbincangan bantuan": {
            "canonical": "Help talk",
            "aliases": ["Perbualan Bantuan"],
        },
        "Kategori": {"canonical": "Category"},
        "Perbincangan kategori": {
            "canonical": "Category talk",
            "aliases": ["Perbualan Kategori"],
        },
        "Perbincangan portal": {"aliases": ["Perbualan Portal", "Portal talk"]},
        "Modul": {"canonical": "Module"},
        "Perbincangan modul": {"canonical": "Module talk"},
        "Alat": {"canonical": "Gadget"},
        "Perbincangan alat": {"canonical": "Gadget talk"},
        "Penerangan alat": {"canonical": "Gadget definition"},
        "Perbincangan penerangan alat": {"canonical": "Gadget definition talk"},
    },
    "mt": {
        "Medja": {"canonical": "Media", "aliases": ["Midja"]},
        "Speċjali": {"canonical": "Special"},
        "Diskussjoni": {"canonical": "Talk", "aliases": ["Diskuti"]},
        "Utent": {"canonical": "User"},
        "Diskussjoni utent": {"canonical": "User talk", "aliases": ["Diskuti utent"]},
        "Wikipedija": {"canonical": "Project"},
        "Diskussjoni Wikipedija": {
            "canonical": "Project talk",
            "aliases": ["Wikipedija diskussjoni", "Wikipedija diskuti"],
        },
        "Stampa": {"canonical": "File"},
        "Diskussjoni stampa": {"canonical": "File talk", "aliases": ["Diskuti stampa"]},
        "MediaWiki": {"aliases": ["MedjaWiki"]},
        "Diskussjoni MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Diskuti MedjaWiki"],
        },
        "Mudell": {"canonical": "Template"},
        "Diskussjoni mudell": {
            "canonical": "Template talk",
            "aliases": ["Diskuti template"],
        },
        "Għajnuna": {"canonical": "Help"},
        "Diskussjoni għajnuna": {
            "canonical": "Help talk",
            "aliases": ["Diskuti għajnuna"],
        },
        "Kategorija": {"canonical": "Category"},
        "Diskussjoni kategorija": {
            "canonical": "Category talk",
            "aliases": ["Diskuti kategorija"],
        },
        "Diskussjoni portal": {},
    },
    "mwl": {
        "Multimédia": {"canonical": "Media"},
        "Special": {"aliases": ["Especial"]},
        "Cumbersa": {"canonical": "Talk", "aliases": ["Discussão"]},
        "Outelizador(a)": {
            "canonical": "User",
            "aliases": [
                "Outelizador",
                "Outelizadora",
                "Usuário",
                "Utilizador",
                "Utilizadora",
            ],
        },
        "Cumbersa outelizador(a)": {
            "canonical": "User talk",
            "aliases": [
                "Cumbersa outelizador",
                "Cumbersa outelizadora",
                "Usuário Discussão",
            ],
        },
        "Biquipédia": {"canonical": "Project", "aliases": ["BP"]},
        "Cumbersa Biquipédia": {
            "canonical": "Project talk",
            "aliases": [
                "Biquipédia Discussão",
                "Biquipédia cumbersa",
                "Wikipedia cumbersa",
            ],
        },
        "Fexeiro": {"canonical": "File", "aliases": ["Arquivo", "Ficheiro", "Imagem"]},
        "Cumbersa fexeiro": {
            "canonical": "File talk",
            "aliases": ["Arquivo Discussão", "Ficheiro Discussão", "Imagem Discussão"],
        },
        "Biqui": {"canonical": "MediaWiki"},
        "Cumbersa Biqui": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Discussão"],
        },
        "Modelo": {"canonical": "Template", "aliases": ["Predefinição"]},
        "Cumbersa modelo": {
            "canonical": "Template talk",
            "aliases": ["Cumbersa Modelo", "Predefinição Discussão"],
        },
        "Ajuda": {"canonical": "Help"},
        "Cumbersa ajuda": {"canonical": "Help talk", "aliases": ["Ajuda Discussão"]},
        "Catadorie": {"canonical": "Category", "aliases": ["Categoria"]},
        "Cumbersa catadorie": {
            "canonical": "Category talk",
            "aliases": ["Categoria Discussão"],
        },
        "Cumbersa portal": {},
        "Módulo": {"canonical": "Module"},
        "Cumbersa módulo": {"canonical": "Module talk"},
        "Cumbersa gadget": {"canonical": "Gadget talk"},
        "Defeniçon gadget": {"canonical": "Gadget definition"},
        "Cumbersa defeniçon gadget": {"canonical": "Gadget definition talk"},
    },
    "my": {
        "မီဒီယာ": {"canonical": "Media"},
        "အထူး": {"canonical": "Special"},
        "ဆွေးနွေးချက်": {"canonical": "Talk"},
        "အသုံးပြုသူ": {"canonical": "User"},
        "အသုံးပြုသူ ဆွေးနွေးချက်": {"canonical": "User talk"},
        "ဝီကီပီးဒီးယား": {"canonical": "Project"},
        "ဝီကီပီးဒီးယား ဆွေးနွေးချက်": {"canonical": "Project talk"},
        "ဖိုင်": {"canonical": "File"},
        "ဖိုင် ဆွေးနွေးချက်": {"canonical": "File talk"},
        "မီဒီယာဝီကီ": {"canonical": "MediaWiki"},
        "မီဒီယာဝီကီ ဆွေးနွေးချက်": {"canonical": "MediaWiki talk"},
        "တမ်းပလိတ်": {"canonical": "Template"},
        "တမ်းပလိတ် ဆွေးနွေးချက်": {"canonical": "Template talk"},
        "အကူအညီ": {"canonical": "Help"},
        "အကူအညီ ဆွေးနွေးချက်": {"canonical": "Help talk"},
        "ကဏ္ဍ": {"canonical": "Category"},
        "ကဏ္ဍ ဆွေးနွေးချက်": {"canonical": "Category talk"},
        "မော်ဂျူး": {"canonical": "Module"},
        "မော်ဂျူး ဆွေးနွေးချက်": {"canonical": "Module talk"},
        "ကိရိယာငယ်": {"canonical": "Gadget"},
        "ကိရိယာငယ် ဆွေးနွေးချက်": {"canonical": "Gadget talk"},
        "ကိရိယာငယ် အဓိပ္ပာယ်": {"canonical": "Gadget definition"},
        "ကိရိယာငယ် အဓိပ္ပာယ် ဆွေးနွေးချက်": {"canonical": "Gadget definition talk"},
    },
    "myv": {
        "Медия": {"canonical": "Media"},
        "Башка тевень": {"canonical": "Special", "aliases": ["Служебная"]},
        "Кортамо": {"canonical": "Talk", "aliases": ["Обсуждение"]},
        "Теиця": {"canonical": "User", "aliases": ["Участник"]},
        "Теицянь кортамось": {
            "canonical": "User talk",
            "aliases": ["Обсуждение участника"],
        },
        "Википедиясь": {"canonical": "Project"},
        "Википедиясь кортамось": {
            "canonical": "Project talk",
            "aliases": ["Обсуждение Википедиясь"],
        },
        "Артовкс": {"canonical": "File", "aliases": ["Изображение"]},
        "Артовксто кортамось": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения"],
        },
        "MediaWiki-нь кортамось": {
            "canonical": "MediaWiki talk",
            "aliases": ["Обсуждение MediaWiki"],
        },
        "ЛопаПарцун": {"canonical": "Template", "aliases": ["Шаблон"]},
        "ЛопаПарцундо кортамось": {
            "canonical": "Template talk",
            "aliases": ["Обсуждение шаблона"],
        },
        "Лезкс": {"canonical": "Help", "aliases": ["Справка"]},
        "Лезкстэ кортамось": {
            "canonical": "Help talk",
            "aliases": ["Обсуждение справки"],
        },
        "Категория": {"canonical": "Category"},
        "Категориядо кортамось": {
            "canonical": "Category talk",
            "aliases": ["Обсуждение категории"],
        },
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "mzn": {
        "مدیا": {
            "canonical": "Media",
            "aliases": ["رسانه", "رسانه\u200cای", "مه\u200cدیا"],
        },
        "شا": {"canonical": "Special", "aliases": ["ویژه"]},
        "گپ": {"canonical": "Talk", "aliases": ["بحث"]},
        "کارور": {"canonical": "User", "aliases": ["کاربر"]},
        "کارور گپ": {"canonical": "User talk", "aliases": ["بحث کاربر"]},
        "ویکی\u200cپدیا": {"canonical": "Project", "aliases": ["وپ"]},
        "ویکی\u200cپدیا گپ": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia گپ", "بحث ویکی\u200cپدیا"],
        },
        "پرونده": {"canonical": "File", "aliases": ["تصویر"]},
        "پرونده گپ": {"canonical": "File talk", "aliases": ["بحث تصویر", "بحث پرونده"]},
        "مدیاویکی": {
            "canonical": "MediaWiki",
            "aliases": ["مه\u200cدیا ویکی", "مه\u200cدیاویکی"],
        },
        "مدیاویکی گپ": {
            "canonical": "MediaWiki talk",
            "aliases": ["بحث مدیاویکی", "مه\u200cدیا ویکی گپ", "مه\u200cدیاویکی گپ"],
        },
        "شابلون": {"canonical": "Template", "aliases": ["الگو"]},
        "شابلون گپ": {"canonical": "Template talk", "aliases": ["بحث الگو"]},
        "رانما": {"canonical": "Help", "aliases": ["رانه\u200cما", "راهنما"]},
        "رانما گپ": {
            "canonical": "Help talk",
            "aliases": ["بحث راهنما", "رانه\u200cمائه گپ", "رانه\u200cمای گپ"],
        },
        "رج": {"canonical": "Category", "aliases": ["رده"]},
        "رج گپ": {"canonical": "Category talk", "aliases": ["بحث رده"]},
        "پورتال": {"aliases": ["Portal"]},
        "پورتال گپ": {"aliases": ["Portal talk"]},
        "ماژول": {"canonical": "Module"},
        "ماژول گپ": {"canonical": "Module talk"},
        "گجت": {"canonical": "Gadget"},
        "گجت گپ": {"canonical": "Gadget talk"},
        "گجت توضیحات": {"canonical": "Gadget definition"},
        "گجت توضیحات گپ": {"canonical": "Gadget definition talk"},
    },
    "na": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "nah": {
        "Mēdiatl": {"canonical": "Media"},
        "Nōncuahquīzqui": {"canonical": "Special", "aliases": ["Especial"]},
        "Tēixnāmiquiliztli": {"canonical": "Talk", "aliases": ["Discusión"]},
        "Tlatequitiltilīlli": {"canonical": "User", "aliases": ["Usuario"]},
        "Tlatequitiltilīlli tēixnāmiquiliztli": {
            "canonical": "User talk",
            "aliases": ["Usuario Discusión"],
        },
        "Huiquipedia": {"canonical": "Project"},
        "Huiquipedia tēixnāmiquiliztli": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia Discusión", "Wikipedia tēixnāmiquiliztli"],
        },
        "Īxiptli": {"canonical": "File", "aliases": ["Imagen"]},
        "Īxiptli tēixnāmiquiliztli": {
            "canonical": "File talk",
            "aliases": ["Imagen Discusión", "Imagen discusión"],
        },
        "Huiquimedia": {"canonical": "MediaWiki"},
        "Huiquimedia tēixnāmiquiliztli": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Discusión"],
        },
        "Nemachiyōtīlli": {"canonical": "Template", "aliases": ["Plantilla"]},
        "Nemachiyōtīlli tēixnāmiquiliztli": {
            "canonical": "Template talk",
            "aliases": ["Plantilla Discusión"],
        },
        "Tēpalēhuiliztli": {"canonical": "Help", "aliases": ["Ayuda"]},
        "Tēpalēhuiliztli tēixnāmiquiliztli": {
            "canonical": "Help talk",
            "aliases": ["Ayuda Discusión"],
        },
        "Neneuhcāyōtl": {"canonical": "Category", "aliases": ["Categoría"]},
        "Neneuhcāyōtl tēixnāmiquiliztli": {
            "canonical": "Category talk",
            "aliases": ["Categoría Discusión"],
        },
        "Módulo": {"canonical": "Module"},
        "Módulo discusión": {"canonical": "Module talk"},
        "Accesorio": {"canonical": "Gadget"},
        "Accesorio discusión": {"canonical": "Gadget talk"},
        "Accesorio definición": {"canonical": "Gadget definition"},
        "Accesorio definición discusión": {"canonical": "Gadget definition talk"},
    },
    "nap": {
        "Speciàle": {"canonical": "Special", "aliases": ["Speciale"]},
        "Chiàcchiera": {"canonical": "Talk", "aliases": ["Discussione"]},
        "Utente": {"canonical": "User"},
        "Utente chiàcchiera": {
            "canonical": "User talk",
            "aliases": ["Discussioni utente"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia chiàcchiera": {
            "canonical": "Project talk",
            "aliases": ["Discussioni Wikipedia"],
        },
        "Fiùra": {"canonical": "File", "aliases": ["Immagine"]},
        "Fiùra chiàcchiera": {
            "canonical": "File talk",
            "aliases": ["Discussioni immagine"],
        },
        "MediaWiki chiàcchiera": {
            "canonical": "MediaWiki talk",
            "aliases": ["Discussioni MediaWiki"],
        },
        "Modello": {"canonical": "Template"},
        "Modello chiàcchiera": {
            "canonical": "Template talk",
            "aliases": ["Discussioni template"],
        },
        "Ajùto": {"canonical": "Help", "aliases": ["Aiuto"]},
        "Ajùto chiàcchiera": {
            "canonical": "Help talk",
            "aliases": ["Discussioni aiuto"],
        },
        "Categurìa": {"canonical": "Category", "aliases": ["Categoria"]},
        "Categurìa chiàcchiera": {
            "canonical": "Category talk",
            "aliases": ["Discussioni categoria"],
        },
        "Modulo": {"canonical": "Module"},
        "Modulo chiàcchiera": {"canonical": "Module talk"},
        "Pazziella": {"canonical": "Gadget"},
        "Pazziella chiàcchiera": {"canonical": "Gadget talk"},
        "Pazziella definizzione": {"canonical": "Gadget definition"},
        "Pazziella definizzione chiàcchiera": {"canonical": "Gadget definition talk"},
    },
    "nds": {
        "Spezial": {"canonical": "Special"},
        "Diskuschoon": {"canonical": "Talk", "aliases": ["Diskussion"]},
        "Bruker": {"canonical": "User", "aliases": ["Benutzer"]},
        "Bruker Diskuschoon": {
            "canonical": "User talk",
            "aliases": ["Benutzer Diskussion"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia Diskuschoon": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia Diskussion"],
        },
        "Bild": {"canonical": "File", "aliases": ["Datei"]},
        "Bild Diskuschoon": {
            "canonical": "File talk",
            "aliases": ["Bild Diskussion", "Datei Diskuschoon"],
        },
        "MediaWiki Diskuschoon": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Diskussion"],
        },
        "Vörlaag": {"canonical": "Template", "aliases": ["Vorlage"]},
        "Vörlaag Diskuschoon": {
            "canonical": "Template talk",
            "aliases": ["Vorlage Diskussion"],
        },
        "Hülp": {"canonical": "Help", "aliases": ["Hilfe"]},
        "Hülp Diskuschoon": {"canonical": "Help talk", "aliases": ["Hilfe Diskussion"]},
        "Kategorie": {"canonical": "Category"},
        "Kategorie Diskuschoon": {
            "canonical": "Category talk",
            "aliases": ["Kategorie Diskussion"],
        },
        "Portal Diskuschoon": {},
        "Modul": {"canonical": "Module"},
        "Modul Diskussion": {"canonical": "Module talk"},
        "Gadget Diskussion": {"canonical": "Gadget talk"},
        "Gadget-Definition": {"canonical": "Gadget definition"},
        "Gadget-Definition Diskussion": {"canonical": "Gadget definition talk"},
    },
    "nds-nl": {
        "Spesiaal": {"canonical": "Special", "aliases": ["Speciaal", "Speciaol"]},
        "Overleg": {"canonical": "Talk"},
        "Gebruker": {"canonical": "User"},
        "Overleg gebruker": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Overleg Wikipedia": {"canonical": "Project talk"},
        "Bestaand": {"canonical": "File", "aliases": ["Afbeelding", "Ofbeelding"]},
        "Overleg bestaand": {
            "canonical": "File talk",
            "aliases": ["Overleg afbeelding", "Overleg ofbeelding"],
        },
        "Overleg MediaWiki": {"canonical": "MediaWiki talk"},
        "Mal": {"canonical": "Template", "aliases": ["Sjabloon"]},
        "Overleg mal": {"canonical": "Template talk", "aliases": ["Overleg sjabloon"]},
        "Hulpe": {"canonical": "Help"},
        "Overleg hulpe": {"canonical": "Help talk"},
        "Kategorie": {"canonical": "Category", "aliases": ["Categorie", "Kattegerie"]},
        "Overleg kategorie": {
            "canonical": "Category talk",
            "aliases": ["Overleg categorie", "Overleg kattegerie"],
        },
        "Overleg module": {"canonical": "Module talk"},
        "Uitbreiding": {"canonical": "Gadget"},
        "Overleg uitbreiding": {"canonical": "Gadget talk"},
        "Uitbreidingsdefinitie": {"canonical": "Gadget definition"},
        "Overleg uitbreidingsdefinitie": {"canonical": "Gadget definition talk"},
    },
    "ne": {
        "मीडिया": {"canonical": "Media"},
        "विशेष": {"canonical": "Special"},
        "वार्तालाप": {"canonical": "Talk"},
        "प्रयोगकर्ता": {"canonical": "User", "aliases": ["U", "प्र", "प्रवा"]},
        "प्रयोगकर्ता वार्ता": {"canonical": "User talk", "aliases": ["UT"]},
        "विकिपिडिया": {"canonical": "Project", "aliases": ["वि", "विकिपीडिया"]},
        "विकिपिडिया वार्ता": {
            "canonical": "Project talk",
            "aliases": ["विकिपीडिया वार्ता", "विवा"],
        },
        "चित्र": {"canonical": "File"},
        "चित्र वार्ता": {"canonical": "File talk"},
        "मीडियाविकि": {"canonical": "MediaWiki"},
        "मीडियाविकि वार्ता": {"canonical": "MediaWiki talk"},
        "ढाँचा": {"canonical": "Template", "aliases": ["T", "ढाँ"]},
        "ढाँचा वार्ता": {"canonical": "Template talk", "aliases": ["ढाँवा"]},
        "मद्दत": {"canonical": "Help"},
        "मद्दत वार्ता": {"canonical": "Help talk"},
        "श्रेणी": {"canonical": "Category"},
        "श्रेणी वार्ता": {"canonical": "Category talk", "aliases": ["CT"]},
        "पोर्टल": {},
        "पोर्टल वार्ता": {},
        "मस्यौदा": {"aliases": ["Draft"]},
        "मस्यौदा वार्ता": {"aliases": ["Draft talk"]},
        "मोड्युल": {"canonical": "Module"},
        "मोड्युल वार्तालाप": {"canonical": "Module talk"},
    },
    "new": {
        "माध्यम": {"canonical": "Media"},
        "विशेष": {"canonical": "Special"},
        "खँलाबँला": {"canonical": "Talk"},
        "छ्येलेमि": {"canonical": "User"},
        "छ्येलेमि खँलाबँला": {"canonical": "User talk"},
        "विकिपिडिया": {"canonical": "Project"},
        "विकिपिडिया खँलाबँला": {"canonical": "Project talk"},
        "किपा": {"canonical": "File"},
        "किपा खँलाबँला": {"canonical": "File talk"},
        "मिडियाविकि": {"canonical": "MediaWiki"},
        "मिडियाविकि खँलाबँला": {"canonical": "MediaWiki talk"},
        "ग्वाहालि": {"canonical": "Help"},
        "ग्वाहालि खँलाबँला": {"canonical": "Help talk"},
        "पुचः": {"canonical": "Category"},
        "पुचः खँलाबँला": {"canonical": "Category talk"},
        "दबू": {},
        "दबू खँलाबँला": {},
    },
    "nia": {
        "Si tohude": {"canonical": "Special"},
        "Huhuo": {"canonical": "Talk", "aliases": ["Bicara"]},
        "Sangoguna": {"canonical": "User"},
        "Huhuo zangoguna": {"canonical": "User talk", "aliases": ["Bicara Pengguna"]},
        "Wikipedia": {"canonical": "Project"},
        "Huhuo Wikipedia": {"canonical": "Project talk"},
        "Berkas": {"canonical": "File", "aliases": ["Gambar"]},
        "Huhuo berkas": {
            "canonical": "File talk",
            "aliases": ["Gambar Pembicaraan", "Pembicaraan Gambar"],
        },
        "Huhuo MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Pembicaraan"],
        },
        "Templat": {"canonical": "Template"},
        "Huhuo templat": {
            "canonical": "Template talk",
            "aliases": ["Templat Pembicaraan"],
        },
        "Fanolo": {"canonical": "Help"},
        "Huhuo wanolo": {"canonical": "Help talk", "aliases": ["Bantuan Pembicaraan"]},
        "Kategori": {"canonical": "Category"},
        "Huhuo kategori": {
            "canonical": "Category talk",
            "aliases": ["Kategori Pembicaraan"],
        },
        "Huhuo portal": {},
        "Modul": {"canonical": "Module"},
        "Pembicaraan Modul": {"canonical": "Module talk"},
    },
    "nl": {
        "Speciaal": {"canonical": "Special"},
        "Overleg": {"canonical": "Talk"},
        "Gebruiker": {"canonical": "User"},
        "Overleg gebruiker": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Overleg Wikipedia": {"canonical": "Project talk"},
        "Bestand": {"canonical": "File", "aliases": ["Afbeelding"]},
        "Overleg bestand": {
            "canonical": "File talk",
            "aliases": ["Overleg afbeelding"],
        },
        "Overleg MediaWiki": {"canonical": "MediaWiki talk"},
        "Sjabloon": {"canonical": "Template"},
        "Overleg sjabloon": {"canonical": "Template talk"},
        "Help": {"aliases": ["H"]},
        "Overleg help": {"canonical": "Help talk"},
        "Categorie": {"canonical": "Category"},
        "Overleg categorie": {"canonical": "Category talk"},
        "Portaal": {"aliases": ["P"]},
        "Overleg portaal": {},
        "Overleg module": {"canonical": "Module talk"},
        "Uitbreiding": {"canonical": "Gadget"},
        "Overleg uitbreiding": {"canonical": "Gadget talk"},
        "Uitbreidingsdefinitie": {"canonical": "Gadget definition"},
        "Overleg uitbreidingsdefinitie": {"canonical": "Gadget definition talk"},
    },
    "nn": {
        "Filpeikar": {"canonical": "Media"},
        "Spesial": {"canonical": "Special"},
        "Diskusjon": {"canonical": "Talk"},
        "Brukar": {"canonical": "User"},
        "Brukardiskusjon": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia-diskusjon": {"canonical": "Project talk"},
        "Fil": {"canonical": "File", "aliases": ["Bilde"]},
        "Fildiskusjon": {"canonical": "File talk", "aliases": ["Bildediskusjon"]},
        "MediaWiki-diskusjon": {"canonical": "MediaWiki talk"},
        "Mal": {"canonical": "Template"},
        "Maldiskusjon": {"canonical": "Template talk"},
        "Hjelp": {"canonical": "Help"},
        "Hjelpdiskusjon": {"canonical": "Help talk"},
        "Kategori": {"canonical": "Category"},
        "Kategoridiskusjon": {"canonical": "Category talk"},
        "Tema": {},
        "Temadiskusjon": {},
        "Modul": {"canonical": "Module"},
        "Moduldiskusjon": {"canonical": "Module talk"},
    },
    "no": {
        "Medium": {"canonical": "Media"},
        "Spesial": {"canonical": "Special"},
        "Diskusjon": {"canonical": "Talk"},
        "Bruker": {"canonical": "User"},
        "Brukerdiskusjon": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia-diskusjon": {"canonical": "Project talk"},
        "Fil": {"canonical": "File", "aliases": ["Bilde"]},
        "Fildiskusjon": {"canonical": "File talk", "aliases": ["Bildediskusjon"]},
        "MediaWiki-diskusjon": {"canonical": "MediaWiki talk"},
        "Mal": {"canonical": "Template"},
        "Maldiskusjon": {"canonical": "Template talk"},
        "Hjelp": {"canonical": "Help"},
        "Hjelpdiskusjon": {"canonical": "Help talk"},
        "Kategori": {"canonical": "Category"},
        "Kategoridiskusjon": {"canonical": "Category talk"},
        "Portaldiskusjon": {},
        "Modul": {"canonical": "Module"},
        "Moduldiskusjon": {"canonical": "Module talk"},
        "Sak": {"canonical": "Topic"},
    },
    "nov": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "nqo": {
        "ߟߊߛߋߢߊߥߙߍ": {"canonical": "Media"},
        "ߞߙߍߞߙߍߣߍ߲": {"canonical": "Special"},
        "ߢߊߝߐߞߣߍ": {"canonical": "Talk"},
        "ߟߊߓߊ߯ߙߟߊ": {"canonical": "User"},
        "ߟߊߓߊ߯ߙߟߊ ߟߊ߫ ߢߊߝߐߞߣߍ": {"canonical": "User talk"},
        "ߥߞߌߔߘߋߞߎ": {"canonical": "Project"},
        "ߥߞߌߔߘߋߞߎ ߢߊߝߐߞߣߍ": {"canonical": "Project talk"},
        "ߞߐߕߐ߮": {"canonical": "File"},
        "ߞߐߕߐ߮ ߢߊߝߐߞߣߍ": {"canonical": "File talk"},
        "ߡߘߌߦߊߥߞߌ": {"canonical": "MediaWiki"},
        "ߡߘߌߦߊߥߞߌ ߢߊߝߐߞߣߍ": {"canonical": "MediaWiki talk"},
        "ߞߙߊߞߏ": {"canonical": "Template"},
        "ߞߙߊߞߏ ߢߊߝߐߞߣߍ": {"canonical": "Template talk"},
        "ߡߊ߬ߘߍ߬ߡߍ߲߬ߠߌ߲": {"canonical": "Help"},
        "ߡߊ߬ߘߍ߬ߡߍ߲߬ߠߌ߲ ߢߊߝߐߞߣߍ": {"canonical": "Help talk"},
        "ߦߌߟߡߊ": {"canonical": "Category"},
        "ߦߌߟߡߊ ߢߊߝߐߞߣߍ": {"canonical": "Category talk"},
        "ߗߋ߬ߞߙߊߞߏ": {"canonical": "Module"},
        "ߗߋ߬ߞߙߊߞߏ ߢߊߝߐߞߣߍ": {"canonical": "Module talk"},
    },
    "nrm": {
        "Média": {"canonical": "Media"},
        "Spécial": {"canonical": "Special"},
        "Discussion": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Utilisateur": {"canonical": "User", "aliases": ["Utilisatrice"]},
        "Discussion utilisateur": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur", "Discussion utilisatrice"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Discussion Wikipedia": {"canonical": "Project talk"},
        "Fichier": {"canonical": "File"},
        "Discussion fichier": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Discussion MediaWiki": {"canonical": "MediaWiki talk"},
        "Modèle": {"canonical": "Template"},
        "Discussion modèle": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Aide": {"canonical": "Help"},
        "Discussion aide": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Catégorie": {"canonical": "Category"},
        "Discussion catégorie": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "nso": {
        "Bolediša": {"canonical": "Talk"},
        "Mošomi": {"canonical": "User"},
        "Boledišana le Mošomi": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Dipolelo tša Wikipedia": {"canonical": "Project talk"},
        "Seswantšho": {"canonical": "File"},
        "Poledišano ya Seswantšho": {"canonical": "File talk"},
        "Poledišano ya MediaWiki": {"canonical": "MediaWiki talk"},
        "Poledišano ya Template": {"canonical": "Template talk"},
        "Thušo": {"canonical": "Help"},
        "Poledišano ya Thušo": {"canonical": "Help talk"},
        "Setensele": {"canonical": "Category"},
        "Poledišano ya Setensele": {"canonical": "Category talk"},
    },
    "nv": {
        "Naaltsoos baa yáshtiʼ": {"canonical": "Talk"},
        "Choyoołʼįįhí": {"canonical": "User"},
        "Choyoołʼįįhí bichʼįʼ yáshtiʼ": {"canonical": "User talk"},
        "Wikiibíídiiya": {"canonical": "Project"},
        "Wikiibíídiiya baa yáshtiʼ": {"canonical": "Project talk"},
        "Eʼelyaaígíí": {"canonical": "File"},
        "Eʼelyaaígíí baa yáshtiʼ": {"canonical": "File talk"},
        "MediaWiki baa yáshtiʼ": {"canonical": "MediaWiki talk"},
        "Bee álnééhí": {"canonical": "Template"},
        "Bee álnééhí baa yáshtiʼ": {"canonical": "Template talk"},
        "Anáʼálwoʼ": {"canonical": "Help"},
        "Anáʼálwoʼ baa yáshtiʼ": {"canonical": "Help talk"},
        "Tʼááłáhági átʼéego": {"canonical": "Category"},
        "Tʼááłáhági átʼéego baa yáshtiʼ": {"canonical": "Category talk"},
    },
    "ny": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "oc": {
        "Mèdia": {"canonical": "Media"},
        "Especial": {"canonical": "Special"},
        "Discutir": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Utilizaire": {"canonical": "User", "aliases": ["Utilisator"]},
        "Discussion Utilizaire": {
            "canonical": "User talk",
            "aliases": [
                "Discussion Utilisateur",
                "Discussion Utilisator",
                "Discutida Utilisator",
            ],
        },
        "Wikipèdia": {"canonical": "Project"},
        "Discussion Wikipèdia": {"canonical": "Project talk"},
        "Fichièr": {"canonical": "File", "aliases": ["Imatge"]},
        "Discussion Fichièr": {
            "canonical": "File talk",
            "aliases": [
                "Discussion Fichier",
                "Discussion Image",
                "Discussion Imatge",
                "Discutida Imatge",
                "Imatge Discussió",
            ],
        },
        "MediaWiki": {"aliases": ["Mediaòiqui"]},
        "Discussion MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Discussion Mediaòiqui", "Discutida Mediaòiqui"],
        },
        "Modèl": {"canonical": "Template"},
        "Discussion Modèl": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle", "Discutida Modèl"],
        },
        "Ajuda": {"canonical": "Help"},
        "Discussion Ajuda": {
            "canonical": "Help talk",
            "aliases": ["Discussion Aide", "Discutida Ajuda"],
        },
        "Categoria": {"canonical": "Category"},
        "Discussion Categoria": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie", "Discutida Categoria"],
        },
        "Discussion Portal": {},
        "Projècte": {},
        "Discussion Projècte": {},
        "Mòdul": {"canonical": "Module"},
        "Mòdul Discussió": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "olo": {
        "Medii": {"canonical": "Media"},
        "Erikoine": {"canonical": "Special"},
        "Pagin": {"canonical": "Talk"},
        "Käyttäi": {"canonical": "User"},
        "Käyttäi pagin": {"canonical": "User talk"},
        "Wikipedii": {"canonical": "Project"},
        "Wikipedien paginat": {"canonical": "Project talk"},
        "Failu": {"canonical": "File", "aliases": ["Kuva"]},
        "Failu pagin": {"canonical": "File talk", "aliases": ["Keskustelu kuvasta"]},
        "MediiWiki": {"canonical": "MediaWiki"},
        "MediiWiki pagin": {"canonical": "MediaWiki talk"},
        "Šablonu": {"canonical": "Template"},
        "Šablonu pagin": {"canonical": "Template talk"},
        "Abu": {"canonical": "Help"},
        "Abu pagin": {"canonical": "Help talk"},
        "Kategourii": {"canonical": "Category"},
        "Kategourii pagin": {"canonical": "Category talk"},
        "Moduuli": {"canonical": "Module"},
        "Keskustelu moduulista": {"canonical": "Module talk"},
        "Pienoisohjelma": {"canonical": "Gadget"},
        "Keskustelu pienoisohjelmasta": {"canonical": "Gadget talk"},
        "Pienoisohjelman määritys": {"canonical": "Gadget definition"},
        "Keskustelu pienoisohjelman määrityksestä": {
            "canonical": "Gadget definition talk"
        },
    },
    "om": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "or": {
        "ମାଧ୍ୟମ": {"canonical": "Media"},
        "ବିଶେଷ": {"canonical": "Special"},
        "ଆଲୋଚନା": {"canonical": "Talk"},
        "ବ୍ୟବହାରକାରୀ": {
            "canonical": "User",
            "aliases": ["ବ୍ୟବହାରକାରି", "ବ୍ୟବାହାରକାରୀ"],
        },
        "ବ୍ୟବହାରକାରୀଙ୍କ ଆଲୋଚନା": {
            "canonical": "User talk",
            "aliases": ["ବ୍ୟବହାରକାରିଁକ ଆଲୋଚନା", "ବ୍ୟବାହାରକାରୀଙ୍କ ଆଲୋଚନା"],
        },
        "ଉଇକିପିଡ଼ିଆ": {"canonical": "Project"},
        "ଉଇକିପିଡ଼ିଆ ଆଲୋଚନା": {"canonical": "Project talk"},
        "ଫାଇଲ": {"canonical": "File"},
        "ଫାଇଲ ଆଲୋଚନା": {"canonical": "File talk"},
        "ମିଡ଼ିଆଉଇକି": {"canonical": "MediaWiki"},
        "ମିଡ଼ିଆଉଇକି ଆଲୋଚନା": {"canonical": "MediaWiki talk"},
        "ଛାଞ୍ଚ": {"canonical": "Template", "aliases": ["ଟେଁପଲେଟ", "ଟେମ୍ପଲେଟ"]},
        "ଛାଞ୍ଚ ଆଲୋଚନା": {
            "canonical": "Template talk",
            "aliases": ["ଟେଁପଲେଟ ଆଲୋଚନା", "ଟେମ୍ପଲେଟ ଆଲୋଚନା"],
        },
        "ସହଯୋଗ": {"canonical": "Help", "aliases": ["ସାହାଯ୍ୟ"]},
        "ସହଯୋଗ ଆଲୋଚନା": {"canonical": "Help talk", "aliases": ["ସାହାଯ୍ୟ ଆଲୋଚନା"]},
        "ଶ୍ରେଣୀ": {"canonical": "Category", "aliases": ["ବିଭାଗ"]},
        "ଶ୍ରେଣୀ ଆଲୋଚନା": {"canonical": "Category talk", "aliases": ["ବିଭାଗିୟ ଆଲୋଚନା"]},
        "ପୋର୍ଟାଲ": {},
        "ପୋର୍ଟାଲ ଆଲୋଚନା": {},
        "ମଡ୍ୟୁଲ": {"canonical": "Module"},
        "ମଡ୍ୟୁଲ ଆଲୋଚନା": {"canonical": "Module talk"},
        "ଗ୍ୟାଜେଟ": {"canonical": "Gadget"},
        "ଗ୍ୟାଜେଟ ଆଲୋଚନା": {"canonical": "Gadget talk"},
        "ଗ୍ୟାଜେଟ ସଂଜ୍ଞା": {"canonical": "Gadget definition"},
        "ଗ୍ୟାଜେଟ ସଂଜ୍ଞା ଆଲୋଚନା": {"canonical": "Gadget definition talk"},
        "ବିଷୟ": {"canonical": "Topic"},
    },
    "os": {
        "Медиа": {"canonical": "Media"},
        "Сæрмагонд": {"canonical": "Special"},
        "Тæрхон": {"canonical": "Talk", "aliases": ["Дискусси"]},
        "Архайæг": {"canonical": "User", "aliases": ["Участник", "Участница"]},
        "Архайæджы ныхас": {
            "canonical": "User talk",
            "aliases": [
                "Архайæджы дискусси",
                "Обсуждение участника",
                "Обсуждение участницы",
            ],
        },
        "Википеди": {"canonical": "Project"},
        "Википедийы тæрхон": {
            "canonical": "Project talk",
            "aliases": ["Дискусси Википеди"],
        },
        "Файл": {"canonical": "File", "aliases": ["Изображение", "Ныв"]},
        "Файлы тæрхон": {
            "canonical": "File talk",
            "aliases": [
                "Нывы тæрхон",
                "Нывы тыххæй дискусси",
                "Обсуждение изображения",
            ],
        },
        "MediaWiki-йы тæрхон": {
            "canonical": "MediaWiki talk",
            "aliases": ["Дискусси MediaWiki", "Тæрхон MediaWiki"],
        },
        "Хуызæг": {"canonical": "Template", "aliases": ["Шаблон"]},
        "Хуызæджы тæрхон": {
            "canonical": "Template talk",
            "aliases": ["Шаблоны тæрхон", "Шаблоны тыххæй дискусси"],
        },
        "Æххуыс": {"canonical": "Help"},
        "Æххуысы тæрхон": {
            "canonical": "Help talk",
            "aliases": ["Æххуысы тыххæй дискусси"],
        },
        "Категори": {"canonical": "Category"},
        "Категорийы тæрхон": {
            "canonical": "Category talk",
            "aliases": ["Категорийы тыххæй дискусси"],
        },
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "pa": {
        "ਮੀਡੀਆ": {"canonical": "Media"},
        "ਖ਼ਾਸ": {"canonical": "Special", "aliases": ["ਖਾਸ"]},
        "ਗੱਲ-ਬਾਤ": {"canonical": "Talk", "aliases": ["ਚਰਚਾ"]},
        "ਵਰਤੋਂਕਾਰ": {"canonical": "User", "aliases": ["ਮੈਂਬਰ", "ਵਰਤੌਂਕਾਰ"]},
        "ਵਰਤੋਂਕਾਰ ਗੱਲ-ਬਾਤ": {
            "canonical": "User talk",
            "aliases": ["ਮੈਂਬਰ ਚਰਚਾ", "ਵਰਤੌਂਕਾਰ ਗੱਲ-ਬਾਤ"],
        },
        "ਵਿਕੀਪੀਡੀਆ": {"canonical": "Project"},
        "ਵਿਕੀਪੀਡੀਆ ਗੱਲ-ਬਾਤ": {
            "canonical": "Project talk",
            "aliases": ["ਵਿਕੀਪੀਡੀਆ ਚਰਚਾ"],
        },
        "ਤਸਵੀਰ": {"canonical": "File"},
        "ਤਸਵੀਰ ਗੱਲ-ਬਾਤ": {"canonical": "File talk", "aliases": ["ਤਸਵੀਰ ਚਰਚਾ"]},
        "ਮੀਡੀਆਵਿਕੀ": {"canonical": "MediaWiki", "aliases": ["ਮੀਡੀਆਵਿਕਿ"]},
        "ਮੀਡੀਆਵਿਕੀ ਗੱਲ-ਬਾਤ": {
            "canonical": "MediaWiki talk",
            "aliases": ["ਮੀਡੀਆਵਿਕਿ ਚਰਚਾ"],
        },
        "ਫਰਮਾ": {"canonical": "Template", "aliases": ["ਨਮੂਨਾ"]},
        "ਫਰਮਾ ਗੱਲ-ਬਾਤ": {"canonical": "Template talk", "aliases": ["ਨਮੂਨਾ ਚਰਚਾ"]},
        "ਮਦਦ": {"canonical": "Help"},
        "ਮਦਦ ਗੱਲ-ਬਾਤ": {"canonical": "Help talk", "aliases": ["ਮਦਦ ਚਰਚਾ"]},
        "ਸ਼੍ਰੇਣੀ": {"canonical": "Category"},
        "ਸ਼੍ਰੇਣੀ ਗੱਲ-ਬਾਤ": {"canonical": "Category talk", "aliases": ["ਸ਼੍ਰੇਣੀ ਚਰਚਾ"]},
        "ਫਾਟਕ": {},
        "ਫਾਟਕ ਗੱਲ-ਬਾਤ": {},
        "ਮੌਡਿਊਲ": {"canonical": "Module"},
        "ਮੌਡਿਊਲ ਗੱਲ-ਬਾਤ": {"canonical": "Module talk"},
        "ਗੈਜਟ": {"canonical": "Gadget"},
        "ਗੈਜਟ ਗੱਲ-ਬਾਤ": {"canonical": "Gadget talk"},
        "ਗੈਜਟ ਪਰਿਭਾਸ਼ਾ": {"canonical": "Gadget definition"},
        "ਗੈਜਟ ਪਰਿਭਾਸ਼ਾ ਗੱਲ-ਬਾਤ": {"canonical": "Gadget definition talk"},
        "Topic": {},
    },
    "pag": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "pam": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "pap": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "pcd": {
        "Média": {"canonical": "Media"},
        "Spécial": {"canonical": "Special"},
        "Discussion": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Utilisateur": {"canonical": "User"},
        "Discussion utilisateur": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Discussion Wikipedia": {"canonical": "Project talk"},
        "Fichier": {"canonical": "File"},
        "Discussion fichier": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Discussion MediaWiki": {"canonical": "MediaWiki talk"},
        "Modèle": {"canonical": "Template"},
        "Discussion modèle": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Aide": {"canonical": "Help"},
        "Discussion aide": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Catégorie": {"canonical": "Category"},
        "Discussion catégorie": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "pcm": {
        "Impotant": {"canonical": "Special"},
        "Tok abaut am": {"canonical": "Talk"},
        "Yuza": {"canonical": "User"},
        "Yuza tok abaut am": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia tok abaut am": {"canonical": "Project talk"},
        "File tok abaut am": {"canonical": "File talk"},
        "MediaWiki tok abaut am": {"canonical": "MediaWiki talk"},
        "Templet": {"canonical": "Template"},
        "Templet tok abaut am": {"canonical": "Template talk"},
        "Hep": {"canonical": "Help"},
        "Hep tok abaut am": {"canonical": "Help talk"},
        "Katigori": {"canonical": "Category"},
        "Katigori tok abaut am": {"canonical": "Category talk"},
        "Modul": {"canonical": "Module"},
        "Modul tok abaut am": {"canonical": "Module talk"},
        "Gajet": {"canonical": "Gadget"},
        "Gajet tok abaut am": {"canonical": "Gadget talk"},
        "Gajet definishon": {"canonical": "Gadget definition"},
        "Gajet definishon tok abaut am": {"canonical": "Gadget definition talk"},
    },
    "pdc": {
        "Medium": {"canonical": "Media"},
        "Spezial": {"canonical": "Special"},
        "Dischbedutt": {"canonical": "Talk", "aliases": ["Diskussion"]},
        "Yuuser": {"canonical": "User", "aliases": ["Benutzer"]},
        "Yuuser Dischbedutt": {
            "canonical": "User talk",
            "aliases": ["Benutzer Diskussion"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia Dischbedutt": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia Diskussion"],
        },
        "Feil": {"canonical": "File", "aliases": ["Bild", "Datei"]},
        "Feil Dischbedutt": {
            "canonical": "File talk",
            "aliases": ["Bild Diskussion", "Datei Diskussion"],
        },
        "MediaWiki Dischbedutt": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Diskussion"],
        },
        "Moddel": {"canonical": "Template", "aliases": ["Vorlage"]},
        "Moddel Dischbedutt": {
            "canonical": "Template talk",
            "aliases": ["Vorlage Diskussion"],
        },
        "Hilf": {"canonical": "Help", "aliases": ["Hilfe"]},
        "Hilf Dischbedutt": {"canonical": "Help talk", "aliases": ["Hilfe Diskussion"]},
        "Abdeeling": {"canonical": "Category", "aliases": ["Kategorie"]},
        "Abdeeling Dischbedutt": {
            "canonical": "Category talk",
            "aliases": ["Kategorie Diskussion"],
        },
        "Modul": {"canonical": "Module"},
        "Modul Diskussion": {"canonical": "Module talk"},
        "Gadget Diskussion": {"canonical": "Gadget talk"},
        "Gadget-Definition": {"canonical": "Gadget definition"},
        "Gadget-Definition Diskussion": {"canonical": "Gadget definition talk"},
    },
    "pfl": {
        "Medium": {"canonical": "Media"},
        "Schbezial": {"canonical": "Special", "aliases": ["Spezial"]},
        "Babble": {"canonical": "Talk", "aliases": ["Diskussion"]},
        "Middawaida": {"canonical": "User", "aliases": ["Benudzer", "Benutzer"]},
        "Middawaida Dischbediere": {
            "canonical": "User talk",
            "aliases": ["Benudzer Dischbediere", "Benutzer Diskussion"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia Dischbediere": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia Diskussion"],
        },
        "Dadai": {"canonical": "File", "aliases": ["Bild", "Datei"]},
        "Dadai Dischbediere": {
            "canonical": "File talk",
            "aliases": ["Bild Diskussion", "Datei Diskussion"],
        },
        "MediaWiki Dischbediere": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Diskussion"],
        },
        "Vorlach": {"canonical": "Template", "aliases": ["Vorlage"]},
        "Vorlach Dischbediere": {
            "canonical": "Template talk",
            "aliases": ["Vorlage Diskussion"],
        },
        "Hilf": {"canonical": "Help", "aliases": ["Hilfe"]},
        "Hilf Dischbediere": {
            "canonical": "Help talk",
            "aliases": ["Hilfe Diskussion"],
        },
        "Sachgrubb": {"canonical": "Category", "aliases": ["Kadegorie", "Kategorie"]},
        "Sachgrubb Dischbediere": {
            "canonical": "Category talk",
            "aliases": ["Kadegorie Dischbediere", "Kategorie Diskussion"],
        },
        "Portal Diskussion": {},
        "Buch": {},
        "Buch Dischbediere": {},
        "Wort": {},
        "Wort Dischbediere": {},
        "Text": {},
        "Text Dischbediere": {},
        "Spruch": {},
        "Spruch Dischbediere": {},
        "Nochricht": {},
        "Nochricht Dischbediere": {},
        "Modul": {"canonical": "Module"},
        "Modul Diskussion": {"canonical": "Module talk"},
        "Gadget Diskussion": {"canonical": "Gadget talk"},
        "Gadget-Definition": {"canonical": "Gadget definition"},
        "Gadget-Definition Diskussion": {"canonical": "Gadget definition talk"},
    },
    "pi": {
        "मीडिया": {"canonical": "Media"},
        "विसेस": {"canonical": "Special"},
        "सम्भासित": {"canonical": "Talk"},
        "अवयव": {"canonical": "User"},
        "अवयव सम्भासित": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia सम्भासित": {"canonical": "Project talk"},
        "पटिमा": {"canonical": "File"},
        "पटिमा सम्भासित": {"canonical": "File talk"},
        "मीडियाविकि": {"canonical": "MediaWiki"},
        "मीडियाविकि सम्भासित": {"canonical": "MediaWiki talk"},
        "पटिरूप": {"canonical": "Template"},
        "पटिरूप सम्भासित": {"canonical": "Template talk"},
        "अवस्सय": {"canonical": "Help"},
        "अवस्सय सम्भासित": {"canonical": "Help talk"},
        "विभाग": {"canonical": "Category"},
        "विभाग सम्भासित": {"canonical": "Category talk"},
    },
    "pih": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "pl": {
        "Specjalna": {"canonical": "Special"},
        "Dyskusja": {"canonical": "Talk"},
        "Wikipedysta": {"canonical": "User", "aliases": ["Wikipedystka"]},
        "Dyskusja wikipedysty": {
            "canonical": "User talk",
            "aliases": ["Dyskusja wikipedystki"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Dyskusja Wikipedii": {"canonical": "Project talk"},
        "Plik": {"canonical": "File", "aliases": ["Grafika"]},
        "Dyskusja pliku": {"canonical": "File talk", "aliases": ["Dyskusja grafiki"]},
        "Dyskusja MediaWiki": {"canonical": "MediaWiki talk"},
        "Szablon": {"canonical": "Template"},
        "Dyskusja szablonu": {"canonical": "Template talk"},
        "Pomoc": {"canonical": "Help"},
        "Dyskusja pomocy": {"canonical": "Help talk"},
        "Kategoria": {"canonical": "Category"},
        "Dyskusja kategorii": {"canonical": "Category talk"},
        "Dyskusja portalu": {},
        "Wikiprojekt": {},
        "Dyskusja wikiprojektu": {},
        "Moduł": {"canonical": "Module"},
        "Dyskusja modułu": {"canonical": "Module talk"},
        "Gadżet": {"canonical": "Gadget"},
        "Dyskusja gadżetu": {"canonical": "Gadget talk"},
        "Definicja gadżetu": {"canonical": "Gadget definition"},
        "Dyskusja definicji gadżetu": {"canonical": "Gadget definition talk"},
        "Wątek": {"canonical": "Topic"},
    },
    "pms": {
        "Discussion": {"canonical": "Talk"},
        "Utent": {"canonical": "User"},
        "Ciaciarade": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Discussion ant sla Wikipedia": {"canonical": "Project talk"},
        "Figura": {"canonical": "File", "aliases": ["Immagine"]},
        "Discussion dla figura": {
            "canonical": "File talk",
            "aliases": ["Discussioni immagine"],
        },
        "Discussion dla MediaWiki": {"canonical": "MediaWiki talk"},
        "Stamp": {"canonical": "Template"},
        "Discussion dlë stamp": {"canonical": "Template talk"},
        "Agiut": {"canonical": "Help"},
        "Discussion ant sl'agiut": {"canonical": "Help talk"},
        "Categorìa": {"canonical": "Category"},
        "Discussion ant sla categorìa": {"canonical": "Category talk"},
        "Modulo": {"canonical": "Module"},
        "Discussioni modulo": {"canonical": "Module talk"},
        "Accessorio": {"canonical": "Gadget"},
        "Discussioni accessorio": {"canonical": "Gadget talk"},
        "Definizione accessorio": {"canonical": "Gadget definition"},
        "Discussioni definizione accessorio": {"canonical": "Gadget definition talk"},
    },
    "pnb": {
        "میڈیا": {"canonical": "Media"},
        "خاص": {"canonical": "Special"},
        "گل بات": {"canonical": "Talk"},
        "ورتنوالا": {"canonical": "User"},
        "ورتن گل بات": {"canonical": "User talk"},
        "وکیپیڈیا": {"canonical": "Project"},
        "ویونت گل بات": {"canonical": "Project talk"},
        "فائل": {"canonical": "File", "aliases": ["تصویر"]},
        "فائل گل بات": {"canonical": "File talk"},
        "میڈیا وکی": {"canonical": "MediaWiki"},
        "میڈیاوکی گل بات": {"canonical": "MediaWiki talk"},
        "سانچہ": {"canonical": "Template"},
        "سانچہ گل بات": {"canonical": "Template talk"},
        "ہتھونڈائی": {"canonical": "Help"},
        "ہتھونڈائی گل بات": {"canonical": "Help talk"},
        "گٹھ": {"canonical": "Category"},
        "گٹھ گل بات": {"canonical": "Category talk"},
        "ماڈیول": {"canonical": "Module"},
        "ماڈیول گل بات": {"canonical": "Module talk"},
        "آلہ": {"canonical": "Gadget"},
        "آلہ گل بات": {"canonical": "Gadget talk"},
        "آلہ تعریف": {"canonical": "Gadget definition"},
        "آلہ تعریف گل بات": {"canonical": "Gadget definition talk"},
    },
    "pnt": {
        "Μέσον": {"canonical": "Media"},
        "Ειδικόν": {"canonical": "Special"},
        "Καλάτσεμαν": {"canonical": "Talk"},
        "Χρήστες": {"canonical": "User"},
        "Καλάτσεμαν χρήστε": {"canonical": "User talk"},
        "Βικιπαίδεια": {"canonical": "Project"},
        "Βικιπαίδεια καλάτσεμαν": {
            "canonical": "Project talk",
            "aliases": ["Βικιπαίδεια συζήτηση"],
        },
        "Αρχείον": {"canonical": "File", "aliases": ["Εικόνα", "Εικόναν"]},
        "Καλάτσεμαν αρχείονος": {
            "canonical": "File talk",
            "aliases": ["Καλάτσεμαν εικόνας", "Συζήτηση εικόνας"],
        },
        "Πρότυπον": {"canonical": "Template"},
        "Καλάτσεμαν πρότυπι": {"canonical": "Template talk"},
        "Βοήθειαν": {"canonical": "Help"},
        "Καλάτσεμαν βοήθειας": {"canonical": "Help talk"},
        "Κατηγορίαν": {"canonical": "Category"},
        "Καλάτσεμαν κατηγορίας": {"canonical": "Category talk"},
    },
    "ps": {
        "رسنۍ": {"canonical": "Media"},
        "ځانگړی": {"canonical": "Special", "aliases": ["ځﺎﻧګړی"]},
        "خبرې اترې": {"canonical": "Talk"},
        "کارن": {"canonical": "User", "aliases": ["کارونکی"]},
        "د کارن خبرې اترې": {
            "canonical": "User talk",
            "aliases": ["د کارونکي خبرې اترې"],
        },
        "ويکيپېډيا": {"canonical": "Project"},
        "د ويکيپېډيا خبرې اترې": {"canonical": "Project talk"},
        "دوتنه": {"canonical": "File", "aliases": ["انځور"]},
        "د دوتنې خبرې اترې": {
            "canonical": "File talk",
            "aliases": ["د انځور خبرې اترې"],
        },
        "ميډياويکي": {"canonical": "MediaWiki"},
        "د ميډياويکي خبرې اترې": {"canonical": "MediaWiki talk"},
        "کينډۍ": {"canonical": "Template"},
        "د کينډۍ خبرې اترې": {"canonical": "Template talk"},
        "لارښود": {"canonical": "Help"},
        "د لارښود خبرې اترې": {"canonical": "Help talk"},
        "وېشنيزه": {"canonical": "Category"},
        "د وېشنيزې خبرې اترې": {"canonical": "Category talk"},
        "تانبه": {},
        "د تانبې خبرې اترې": {},
    },
    "pt": {
        "Multimédia": {"canonical": "Media"},
        "Especial": {"canonical": "Special"},
        "Discussão": {"canonical": "Talk"},
        "Usuário(a)": {
            "canonical": "User",
            "aliases": ["Usuária", "Usuário", "Utilizador"],
        },
        "Usuário(a) Discussão": {
            "canonical": "User talk",
            "aliases": [
                "Usuária Discussão",
                "Usuário Discussão",
                "Utilizador Discussão",
            ],
        },
        "Wikipédia": {"canonical": "Project"},
        "Wikipédia Discussão": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia Discussão"],
        },
        "Ficheiro": {"canonical": "File", "aliases": ["Arquivo", "Imagem"]},
        "Ficheiro Discussão": {
            "canonical": "File talk",
            "aliases": ["Arquivo Discussão", "Imagem Discussão"],
        },
        "MediaWiki Discussão": {"canonical": "MediaWiki talk"},
        "Predefinição": {"canonical": "Template"},
        "Predefinição Discussão": {"canonical": "Template talk"},
        "Ajuda": {"canonical": "Help"},
        "Ajuda Discussão": {"canonical": "Help talk"},
        "Categoria": {"canonical": "Category"},
        "Categoria Discussão": {"canonical": "Category talk"},
        "Portal Discussão": {"aliases": ["Discussão Portal"]},
        "Livro": {},
        "Livro Discussão": {},
        "Education Program": {},
        "Education Program talk": {},
        "Módulo": {"canonical": "Module"},
        "Módulo Discussão": {"canonical": "Module talk"},
        "Tópico": {"canonical": "Topic"},
    },
    "pwn": {
        "mitiya": {"canonical": "Media", "aliases": ["媒体", "媒體"]},
        "pinakisumaljiyan": {"canonical": "Special", "aliases": ["特殊"]},
        "kakaljavaran": {"canonical": "Talk", "aliases": ["对话", "對話", "討論", "讨论"]},
        "avan a kipakamanguanguaq": {"canonical": "User", "aliases": ["用戶", "用户"]},
        "kipakamanguanguaq kakaljavaran": {
            "canonical": "User talk",
            "aliases": ["用戶對話", "用戶討論", "用户对话", "用户讨论"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia kakaljavaran": {"canonical": "Project talk"},
        "sineqetj a vecik": {
            "canonical": "File",
            "aliases": ["图像", "圖像", "圖片", "文件", "档案", "檔案"],
        },
        "sineqetj a vecik kakaljavaran": {
            "canonical": "File talk",
            "aliases": [
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "圖片討論",
                "文件对话",
                "文件對話",
                "文件討論",
                "文件讨论",
                "档案对话",
                "档案讨论",
                "檔案對話",
                "檔案討論",
            ],
        },
        "MediaWiki kakaljavaran": {"canonical": "MediaWiki talk"},
        "kakivauvaljan": {"canonical": "Template", "aliases": ["样板", "模板", "樣板"]},
        "kakivauvaljan kakaljavaran": {
            "canonical": "Template talk",
            "aliases": ["样板对话", "样板讨论", "模板对话", "模板對話", "模板討論", "模板讨论", "樣板對話", "樣板討論"],
        },
        "remasudj": {"canonical": "Help", "aliases": ["帮助", "幫助"]},
        "remasudj kakaljavaran": {
            "canonical": "Help talk",
            "aliases": ["帮助对话", "帮助讨论", "幫助對話", "幫助討論"],
        },
        "pinapapilipiliqan": {"canonical": "Category", "aliases": ["分类", "分類"]},
        "pinapapilipiliqan kakaljavaran": {
            "canonical": "Category talk",
            "aliases": ["分类对话", "分类讨论", "分類對話", "分類討論"],
        },
        "模組": {"canonical": "Module", "aliases": ["模块", "模塊", "模组"]},
        "模組討論": {
            "canonical": "Module talk",
            "aliases": ["模块对话", "模块讨论", "模塊對話", "模塊討論", "模組對話", "模组对话", "模组讨论"],
        },
    },
    "qu": {
        "Midya": {"canonical": "Media"},
        "Sapaq": {"canonical": "Special"},
        "Rimanakuy": {"canonical": "Talk"},
        "Ruraq": {"canonical": "User"},
        "Ruraq rimanakuy": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia rimanakuy": {"canonical": "Project talk"},
        "Rikcha": {"canonical": "File", "aliases": ["Imagen"]},
        "Rikcha rimanakuy": {"canonical": "File talk", "aliases": ["Imagen discusión"]},
        "MediaWiki rimanakuy": {"canonical": "MediaWiki talk"},
        "Plantilla": {"canonical": "Template"},
        "Plantilla rimanakuy": {"canonical": "Template talk"},
        "Yanapa": {"canonical": "Help"},
        "Yanapa rimanakuy": {"canonical": "Help talk"},
        "Katiguriya": {"canonical": "Category"},
        "Katiguriya rimanakuy": {"canonical": "Category talk"},
        "Módulo": {"canonical": "Module"},
        "Módulo discusión": {"canonical": "Module talk"},
        "Accesorio": {"canonical": "Gadget"},
        "Accesorio discusión": {"canonical": "Gadget talk"},
        "Accesorio definición": {"canonical": "Gadget definition"},
        "Accesorio definición discusión": {"canonical": "Gadget definition talk"},
    },
    "rm": {
        "Multimedia": {"canonical": "Media"},
        "Spezial": {"canonical": "Special"},
        "Discussiun": {"canonical": "Talk"},
        "Utilisader": {"canonical": "User"},
        "Utilisader discussiun": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia discussiun": {"canonical": "Project talk"},
        "Datoteca": {"canonical": "File"},
        "Datoteca discussiun": {"canonical": "File talk"},
        "MediaWiki discussiun": {"canonical": "MediaWiki talk"},
        "Model": {"canonical": "Template"},
        "Model discussiun": {"canonical": "Template talk"},
        "Agid": {"canonical": "Help"},
        "Agid discussiun": {"canonical": "Help talk"},
        "Categoria": {"canonical": "Category"},
        "Categoria discussiun": {"canonical": "Category talk"},
    },
    "rmy": {
        "Mediya": {"canonical": "Media"},
        "Uzalutno": {"canonical": "Special"},
        "Vakyarimata": {"canonical": "Talk", "aliases": ["Discuţie"]},
        "Jeno": {"canonical": "User"},
        "Jeno vakyarimata": {
            "canonical": "User talk",
            "aliases": ["Discuţie Utilizator"],
        },
        "Vikipidiya": {"canonical": "Project"},
        "Vikipidiyake vakyarimata": {
            "canonical": "Project talk",
            "aliases": ["Discuţie Vikipidiya"],
        },
        "Chitro": {"canonical": "File", "aliases": ["Fişier", "Imagine"]},
        "Chitro vakyarimata": {
            "canonical": "File talk",
            "aliases": ["Discuţie Fişier", "Discuţie Imagine"],
        },
        "MediyaViki": {"canonical": "MediaWiki"},
        "MediyaViki vakyarimata": {
            "canonical": "MediaWiki talk",
            "aliases": ["Discuţie MediaWiki"],
        },
        "Sikavno": {"canonical": "Template"},
        "Sikavno vakyarimata": {
            "canonical": "Template talk",
            "aliases": ["Discuţie Format"],
        },
        "Zhutipen": {"canonical": "Help"},
        "Zhutipen vakyarimata": {
            "canonical": "Help talk",
            "aliases": ["Discuţie Ajutor"],
        },
        "Shopni": {"canonical": "Category"},
        "Shopni vakyarimata": {
            "canonical": "Category talk",
            "aliases": ["Discuţie Categorie"],
        },
        "Modul": {"canonical": "Module"},
        "Discuție Modul": {"canonical": "Module talk"},
        "Discuție Gadget": {"canonical": "Gadget talk"},
        "Definiție gadget": {"canonical": "Gadget definition"},
        "Discuție Definiție gadget": {"canonical": "Gadget definition talk"},
    },
    "rn": {
        "Vyisangije": {"canonical": "Special"},
        "Ikiyago": {"canonical": "Talk"},
        "Uwukoresha": {"canonical": "User"},
        "Ikiyago c'uwukoresha": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Ikiyago kuri Wikipedia": {"canonical": "Project talk"},
        "Dosiye": {"canonical": "File"},
        "Ikiyago kw'idosiye": {"canonical": "File talk"},
        "Ikiyago kuri MediaWiki": {"canonical": "MediaWiki talk"},
        "Ingero": {"canonical": "Template"},
        "Ikiyago cerekeye ingero": {"canonical": "Template talk"},
        "Ubufasha": {"canonical": "Help"},
        "Ikiyago k'ubufasha": {"canonical": "Help talk"},
        "Umuce": {"canonical": "Category"},
        "Ikiyago cerekeye umuce": {"canonical": "Category talk"},
    },
    "ro": {
        "Discuție": {"canonical": "Talk", "aliases": ["Discuţie"]},
        "Utilizator": {"canonical": "User"},
        "Discuție Utilizator": {
            "canonical": "User talk",
            "aliases": ["Discuţie Utilizator"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Discuție Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Discuţie Wikipedia"],
        },
        "Fișier": {"canonical": "File", "aliases": ["Fişier", "Imagine"]},
        "Discuție Fișier": {
            "canonical": "File talk",
            "aliases": ["Discuţie Fişier", "Discuţie Imagine"],
        },
        "Discuție MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Discuţie MediWiki", "Discuţie MediaWiki"],
        },
        "Format": {"canonical": "Template"},
        "Discuție Format": {
            "canonical": "Template talk",
            "aliases": ["Discuţie Format"],
        },
        "Ajutor": {"canonical": "Help"},
        "Discuție Ajutor": {"canonical": "Help talk", "aliases": ["Discuţie Ajutor"]},
        "Categorie": {"canonical": "Category"},
        "Discuție Categorie": {
            "canonical": "Category talk",
            "aliases": ["Discuţie Categorie"],
        },
        "Discuţie Portal": {"aliases": ["Portal talk"]},
        "Proiect": {"aliases": ["WikiProject"]},
        "Discuţie Proiect": {"aliases": ["WikiProject talk"]},
        "Cod": {"aliases": ["Code"]},
        "Discuție Cod": {"aliases": ["Code talk"]},
        "Carte": {"aliases": ["Book"]},
        "Discuţie Carte": {"aliases": ["Book talk"]},
        "Campaign": {},
        "Campaign talk": {},
        "Modul": {"canonical": "Module"},
        "Discuție Modul": {"canonical": "Module talk"},
        "Discuție Gadget": {"canonical": "Gadget talk"},
        "Definiție gadget": {"canonical": "Gadget definition"},
        "Discuție Definiție gadget": {"canonical": "Gadget definition talk"},
    },
    "roa-rup": {
        "Discuție": {"canonical": "Talk", "aliases": ["Discuţie"]},
        "Utilizator": {"canonical": "User"},
        "Discuție Utilizator": {
            "canonical": "User talk",
            "aliases": ["Discuţie Utilizator"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Discuție Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Discuţie Wikipedia"],
        },
        "Fișier": {"canonical": "File", "aliases": ["Fişier", "Imagine"]},
        "Discuție Fișier": {
            "canonical": "File talk",
            "aliases": ["Discuţie Fişier", "Discuţie Imagine"],
        },
        "Discuție MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Discuţie MediaWiki"],
        },
        "Format": {"canonical": "Template"},
        "Discuție Format": {
            "canonical": "Template talk",
            "aliases": ["Discuţie Format"],
        },
        "Ajutor": {"canonical": "Help"},
        "Discuție Ajutor": {"canonical": "Help talk", "aliases": ["Discuţie Ajutor"]},
        "Categorie": {"canonical": "Category"},
        "Discuție Categorie": {
            "canonical": "Category talk",
            "aliases": ["Discuţie Categorie"],
        },
        "Modul": {"canonical": "Module"},
        "Discuție Modul": {"canonical": "Module talk"},
        "Discuție Gadget": {"canonical": "Gadget talk"},
        "Definiție gadget": {"canonical": "Gadget definition"},
        "Discuție Definiție gadget": {"canonical": "Gadget definition talk"},
    },
    "roa-tara": {
        "Speciale": {"canonical": "Special"},
        "Discussione": {"canonical": "Talk"},
        "Utente": {"canonical": "User"},
        "Discussioni utente": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Discussioni Wikipedia": {"canonical": "Project talk"},
        "File": {"aliases": ["Immagine"]},
        "Discussioni file": {
            "canonical": "File talk",
            "aliases": ["Discussioni immagine"],
        },
        "Discussioni MediaWiki": {"canonical": "MediaWiki talk"},
        "Discussioni template": {"canonical": "Template talk"},
        "Aiuto": {"canonical": "Help"},
        "Discussioni aiuto": {"canonical": "Help talk"},
        "Categoria": {"canonical": "Category"},
        "Discussioni categoria": {"canonical": "Category talk"},
        "Portale": {},
        "'Ngazzaminde d'u Portale": {},
        "Modulo": {"canonical": "Module"},
        "Discussioni modulo": {"canonical": "Module talk"},
        "Accessorio": {"canonical": "Gadget"},
        "Discussioni accessorio": {"canonical": "Gadget talk"},
        "Definizione accessorio": {"canonical": "Gadget definition"},
        "Discussioni definizione accessorio": {"canonical": "Gadget definition talk"},
    },
    "ru": {
        "Медиа": {"canonical": "Media"},
        "Служебная": {"canonical": "Special"},
        "Обсуждение": {"canonical": "Talk"},
        "Участник": {"canonical": "User", "aliases": ["U", "У", "Участница"]},
        "Обсуждение участника": {
            "canonical": "User talk",
            "aliases": ["UT", "ОУ", "Обсуждение участницы"],
        },
        "Википедия": {"canonical": "Project", "aliases": ["ВП"]},
        "Обсуждение Википедии": {"canonical": "Project talk"},
        "Файл": {"canonical": "File", "aliases": ["Изображение"]},
        "Обсуждение файла": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения"],
        },
        "Обсуждение MediaWiki": {"canonical": "MediaWiki talk"},
        "Шаблон": {"canonical": "Template", "aliases": ["T", "Ш"]},
        "Обсуждение шаблона": {"canonical": "Template talk"},
        "Справка": {"canonical": "Help"},
        "Обсуждение справки": {"canonical": "Help talk"},
        "Категория": {"canonical": "Category", "aliases": ["К"]},
        "Обсуждение категории": {"canonical": "Category talk"},
        "Портал": {},
        "Обсуждение портала": {},
        "Инкубатор": {"aliases": ["И"]},
        "Обсуждение Инкубатора": {},
        "Проект": {"aliases": ["ПРО"]},
        "Обсуждение проекта": {"aliases": ["ОПРО"]},
        "Арбитраж": {"aliases": ["Arbcom", "АК"]},
        "Обсуждение арбитража": {},
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "rue": {
        "Медіа": {"canonical": "Media", "aliases": ["Медиа"]},
        "Шпеціална": {"canonical": "Special", "aliases": ["Служебная", "Спеціальні"]},
        "Діскузія": {"canonical": "Talk", "aliases": ["Діскузіа", "Обсуждение"]},
        "Хоснователь": {
            "canonical": "User",
            "aliases": ["Користувач", "Користувачка", "Участник"],
        },
        "Діскузія з хоснователём": {
            "canonical": "User talk",
            "aliases": [
                "Діскузіа з хоснователём",
                "Обговорення користувача",
                "Обговорення користувачки",
                "Обсуждение участника",
            ],
        },
        "Вікіпедія": {"canonical": "Project"},
        "Діскузія ку Вікіпедії": {"canonical": "Project talk"},
        "Файл": {"canonical": "File", "aliases": ["Зображення", "Изображение"]},
        "Діскузія ку файлу": {
            "canonical": "File talk",
            "aliases": [
                "Обговорення зображення",
                "Обсуждение изображения",
                "Обсуждение файла",
            ],
        },
        "Діскузія ку MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Дізкузія ку MediaWiki", "Обсуждение MediaWiki"],
        },
        "Шаблона": {"canonical": "Template"},
        "Діскузія ку шаблонї": {
            "canonical": "Template talk",
            "aliases": ["Обговорення шаблона", "Обсуждение шаблона"],
        },
        "Поміч": {"canonical": "Help", "aliases": ["Справка"]},
        "Діскузія ку помочі": {
            "canonical": "Help talk",
            "aliases": ["Обсуждение справки"],
        },
        "Катеґорія": {"canonical": "Category", "aliases": ["Категория"]},
        "Діскузія ку катеґорії": {
            "canonical": "Category talk",
            "aliases": ["Обсуждение категории"],
        },
        "Модуль": {"canonical": "Module"},
        "Обговорення модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "rw": {
        "Itangazamakuru": {"canonical": "Media"},
        "Ibidasanzwe": {"canonical": "Special"},
        "Ibiganiro": {"canonical": "Talk"},
        "Umukoresha": {"canonical": "User"},
        "Ibiganiro by'umukoresha": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Ibiganiro kuri Wikipedia": {"canonical": "Project talk"},
        "Dosiye": {"canonical": "File"},
        "Ibiganiro kuri dosiye": {"canonical": "File talk"},
        "MediyaWiki": {"canonical": "MediaWiki"},
        "Ibiganiro kuri MediyaWiki": {"canonical": "MediaWiki talk"},
        "Inyandikorugero": {"canonical": "Template"},
        "Ibiganiro ku nyandikorugero": {"canonical": "Template talk"},
        "Ubufasha": {"canonical": "Help"},
        "Ibiganiro ku bufasha": {"canonical": "Help talk"},
        "Ikiciro": {"canonical": "Category"},
        "Ibiganiro ku byiciro": {"canonical": "Category talk"},
    },
    "sa": {
        "माध्यमम्": {"canonical": "Media", "aliases": ["माध्यम"]},
        "विशेषः": {"canonical": "Special", "aliases": ["विशेष", "विशेषम्"]},
        "सम्भाषणम्": {"canonical": "Talk", "aliases": ["संभाषणं"]},
        "सदस्यः": {"canonical": "User", "aliases": ["योजकः"]},
        "सदस्यसम्भाषणम्": {
            "canonical": "User talk",
            "aliases": ["योजकसंभाषणं", "योजकसम्भाषणम्"],
        },
        "विकिपीडिया": {"canonical": "Project"},
        "विकिपीडियासम्भाषणम्": {
            "canonical": "Project talk",
            "aliases": ["विकिपीडियासंभाषणं"],
        },
        "सञ्चिका": {"canonical": "File", "aliases": ["चित्रं", "चित्रम्"]},
        "सञ्चिकासम्भाषणम्": {
            "canonical": "File talk",
            "aliases": ["चित्रसंभाषणं", "चित्रसम्भाषणम्"],
        },
        "मीडियाविकि": {"canonical": "MediaWiki", "aliases": ["मिडीयाविकी"]},
        "मीडियाविकिसम्भाषणम्": {
            "canonical": "MediaWiki talk",
            "aliases": ["मिडियाविकीसंभाषणं", "मिडियाविकीसम्भाषणम्"],
        },
        "फलकम्": {"canonical": "Template", "aliases": ["बिंबधर"]},
        "फलकसम्भाषणम्": {
            "canonical": "Template talk",
            "aliases": ["फलकस्य सम्भाषणम्", "बिंबधर संभाषणं"],
        },
        "साहाय्यम्": {"canonical": "Help", "aliases": ["उपकारः", "सहाय्य", "सहाय्यम्"]},
        "साहाय्यसम्भाषणम्": {
            "canonical": "Help talk",
            "aliases": ["उपकारसंभाषणं", "सहाय्यसंभाषणं", "सहाय्यस्य सम्भाषणम्"],
        },
        "वर्गः": {"canonical": "Category"},
        "वर्गसम्भाषणम्": {"canonical": "Category talk", "aliases": ["वर्गसंभाषणं"]},
        "प्रवेशद्वारम्": {},
        "प्रवेशद्वारसम्भाषणम्": {"aliases": ["सहाय्यस्य प्रवेशद्वारम्"]},
        "पटलम्": {"canonical": "Module"},
        "पटलसम्भाषणम्": {"canonical": "Module talk"},
        "गैजेट": {"canonical": "Gadget"},
        "गैजेट वार्ता": {"canonical": "Gadget talk"},
        "गैजेट परिभाषा": {"canonical": "Gadget definition"},
        "गैजेट परिभाषा वार्ता": {"canonical": "Gadget definition talk"},
    },
    "sah": {
        "Миэдьийэ": {"canonical": "Media"},
        "Аналлаах": {"canonical": "Special"},
        "Ырытыы": {"canonical": "Talk"},
        "Кыттааччы": {"canonical": "User"},
        "Кыттааччы ырытыыта": {"canonical": "User talk"},
        "Бикипиэдьийэ": {"canonical": "Project"},
        "Бикипиэдьийэ ырытыыта": {"canonical": "Project talk"},
        "Билэ": {"canonical": "File", "aliases": ["Изображение", "Ойуу"]},
        "Билэ ырытыыта": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения", "Ойуу ырытыыта", "Ойууну ырытыы"],
        },
        "MediaWiki-ни ырытыы": {"canonical": "MediaWiki talk"},
        "Халыып": {"canonical": "Template"},
        "Халыыбы ырытыы": {
            "canonical": "Template talk",
            "aliases": ["Халыып ырытыыта"],
        },
        "Көмө": {"canonical": "Help"},
        "Көмөнү ырытыы": {"canonical": "Help talk", "aliases": ["Көмө ырытыыта"]},
        "Категория": {"canonical": "Category"},
        "Категорияны ырытыы": {
            "canonical": "Category talk",
            "aliases": ["Категория ырытыыта"],
        },
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "sat": {
        "ᱢᱤᱰᱤᱭᱟ": {"canonical": "Media"},
        "ᱟᱥᱚᱠᱟᱭ": {"canonical": "Special"},
        "ᱜᱟᱞᱢᱟᱨᱟᱣ": {"canonical": "Talk"},
        "ᱵᱮᱵᱷᱟᱨᱤᱭᱟᱹ": {"canonical": "User"},
        "ᱵᱮᱵᱷᱟᱨᱤᱭᱟᱹ ᱜᱟᱞᱢᱟᱨᱟᱣ": {"canonical": "User talk"},
        "ᱣᱤᱠᱤᱯᱤᱰᱤᱭᱟ": {"canonical": "Project"},
        "ᱣᱤᱠᱤᱯᱤᱰᱤᱭᱟ ᱨᱚᱲ": {"canonical": "Project talk"},
        "ᱨᱮᱫ": {"canonical": "File"},
        "ᱨᱮᱫ ᱜᱟᱞᱢᱟᱨᱟᱣ": {"canonical": "File talk"},
        "ᱢᱤᱰᱤᱭᱟᱣᱤᱠᱤ": {"canonical": "MediaWiki"},
        "ᱢᱤᱰᱤᱭᱟᱣᱤᱠᱤ ᱜᱟᱞᱢᱟᱨᱟᱣ": {"canonical": "MediaWiki talk"},
        "ᱪᱷᱟᱸᱪ": {"canonical": "Template"},
        "ᱪᱷᱟᱸᱪ ᱜᱟᱞᱢᱟᱨᱟᱣ": {"canonical": "Template talk"},
        "ᱜᱚᱸᱲᱚᱸ": {"canonical": "Help"},
        "ᱜᱚᱸᱲᱚᱸ ᱜᱟᱞᱢᱟᱨᱟᱣ": {"canonical": "Help talk"},
        "ᱛᱷᱚᱠ": {"canonical": "Category"},
        "ᱛᱷᱚᱠ ᱜᱟᱞᱢᱟᱨᱟᱣ": {"canonical": "Category talk"},
        "ᱢᱳᱰᱩᱞ": {"canonical": "Module"},
        "ᱢᱳᱰᱩᱞ ᱜᱟᱞᱢᱟᱨᱟᱣ": {"canonical": "Module talk"},
        "ᱥᱟᱢᱟᱱᱚᱢ": {"canonical": "Gadget"},
        "ᱥᱟᱢᱟᱱᱚᱢ ᱜᱟᱞᱢᱟᱨᱟᱣ": {"canonical": "Gadget talk"},
        "ᱥᱟᱢᱟᱱᱚᱢ ᱢᱮᱱᱮᱛᱮᱫ": {"canonical": "Gadget definition"},
        "ᱥᱟᱢᱟᱱᱚᱢ ᱢᱮᱱᱮᱛᱮᱫ ᱜᱟᱞᱢᱟᱨᱟᱣ": {"canonical": "Gadget definition talk"},
    },
    "sc": {
        "Ispetziale": {"canonical": "Special", "aliases": ["Speciale"]},
        "Cuntierra": {"canonical": "Talk", "aliases": ["Contièndha"]},
        "Usuàriu": {"canonical": "User", "aliases": ["Utente"]},
        "Cuntierra usuàriu": {
            "canonical": "User talk",
            "aliases": ["Utente discussioni"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Cuntierra Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia discussioni"],
        },
        "File": {"aliases": ["Immàgini"]},
        "Cuntierra file": {
            "canonical": "File talk",
            "aliases": ["Immàgini contièndha"],
        },
        "Cuntierra MediaWiki": {"canonical": "MediaWiki talk"},
        "Cuntierra template": {"canonical": "Template talk"},
        "Agiudu": {"canonical": "Help"},
        "Cuntierra agiudu": {"canonical": "Help talk"},
        "Categoria": {"canonical": "Category"},
        "Cuntierra categoria": {"canonical": "Category talk"},
    },
    "scn": {
        "Mèdia": {"canonical": "Media"},
        "Spiciali": {"canonical": "Special"},
        "Discussioni": {"canonical": "Talk"},
        "Utenti": {"canonical": "User"},
        "Discussioni utenti": {
            "canonical": "User talk",
            "aliases": ["Discussioni Utenti"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Discussioni Wikipedia": {"canonical": "Project talk"},
        "File": {"aliases": ["Immagine", "Mmàggini"]},
        "Discussioni file": {
            "canonical": "File talk",
            "aliases": ["Discussioni immagine", "Discussioni mmàggini"],
        },
        "Discussioni MediaWiki": {"canonical": "MediaWiki talk"},
        "Discussioni template": {
            "canonical": "Template talk",
            "aliases": ["Discussioni Template"],
        },
        "Aiutu": {"canonical": "Help"},
        "Discussioni aiutu": {
            "canonical": "Help talk",
            "aliases": ["Discussioni Aiutu"],
        },
        "Catigurìa": {"canonical": "Category"},
        "Discussioni catigurìa": {
            "canonical": "Category talk",
            "aliases": ["Discussioni Catigurìa"],
        },
        "Purtali": {},
        "Discussioni purtali": {},
        "Pruggettu": {},
        "Discussioni pruggettu": {},
        "Mòdulu": {"canonical": "Module", "aliases": ["Modulo"]},
        "Discussioni mòdulu": {
            "canonical": "Module talk",
            "aliases": ["Discussioni modulo"],
        },
        "Accessorio": {"canonical": "Gadget"},
        "Discussioni accessorio": {"canonical": "Gadget talk"},
        "Definizione accessorio": {"canonical": "Gadget definition"},
        "Discussioni definizione accessorio": {"canonical": "Gadget definition talk"},
    },
    "sco": {
        "Collogue": {"canonical": "Talk"},
        "Uiser": {"canonical": "User"},
        "Uiser collogue": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia collogue": {"canonical": "Project talk"},
        "File collogue": {"canonical": "File talk"},
        "MediaWiki collogue": {"canonical": "MediaWiki talk"},
        "Template collogue": {"canonical": "Template talk"},
        "Help collogue": {"canonical": "Help talk"},
        "Category collogue": {"canonical": "Category talk"},
        "Define": {},
        "Define talk": {},
    },
    "sd": {
        "ذريعات": {"canonical": "Media"},
        "خاص": {"canonical": "Special"},
        "بحث": {"canonical": "Talk"},
        "واپرائيندڙ": {"canonical": "User", "aliases": ["يوزر"]},
        "واپرائيندڙ بحث": {"canonical": "User talk", "aliases": ["يوزر بحث"]},
        "وڪيپيڊيا": {"canonical": "Project"},
        "وڪيپيڊيا بحث": {"canonical": "Project talk"},
        "فائل": {"canonical": "File", "aliases": ["عڪس"]},
        "فائل بحث": {"canonical": "File talk", "aliases": ["عڪس بحث"]},
        "ذريعات وڪي": {"canonical": "MediaWiki"},
        "ذريعات وڪي بحث": {"canonical": "MediaWiki talk"},
        "سانچو": {"canonical": "Template", "aliases": ["سنچو"]},
        "سانچو بحث": {"canonical": "Template talk", "aliases": ["سنچو بحث"]},
        "مدد": {"canonical": "Help"},
        "مدد بحث": {"canonical": "Help talk"},
        "زمرو": {"canonical": "Category"},
        "زمرو بحث": {"canonical": "Category talk"},
        "باب": {},
        "باب بحث": {},
        "ماڊيول": {"canonical": "Module"},
        "ماڊيول بحث": {"canonical": "Module talk"},
        "گيجيٽ": {"canonical": "Gadget"},
        "گيجيٽ بحث": {"canonical": "Gadget talk"},
        "گيجيٽ وصف": {"canonical": "Gadget definition"},
        "گيجيٽ وصف بحث": {"canonical": "Gadget definition talk"},
    },
    "se": {
        "Erenoamáš": {"canonical": "Special", "aliases": ["Doaimmat"]},
        "Ságastallan": {"canonical": "Talk"},
        "Geavaheaddji": {"canonical": "User"},
        "Geavaheaddjeságastallan": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia-ságastallan": {"canonical": "Project talk"},
        "Fiila": {"canonical": "File", "aliases": ["Bilde", "Kuva"]},
        "Fiilaságastallan": {
            "canonical": "File talk",
            "aliases": ["Bildediskusjon", "Keskustelu kuvasta"],
        },
        "MediaWiki-ságastallan": {"canonical": "MediaWiki talk"},
        "Málle": {"canonical": "Template"},
        "Málleságastallan": {"canonical": "Template talk"},
        "Veahkki": {"canonical": "Help"},
        "Veahkkeságastallan": {"canonical": "Help talk"},
        "Kategoriija": {"canonical": "Category"},
        "Kategoriijaságastallan": {"canonical": "Category talk"},
        "Portála": {"aliases": ["Temasiidu"]},
        "Portálaságastallan": {"aliases": ["Temasiidoságastallan"]},
        "Modula": {"canonical": "Module"},
        "Modulaságastallan": {"canonical": "Module talk"},
        "Pienoisohjelma": {"canonical": "Gadget"},
        "Keskustelu pienoisohjelmasta": {"canonical": "Gadget talk"},
        "Pienoisohjelman määritys": {"canonical": "Gadget definition"},
        "Keskustelu pienoisohjelman määrityksestä": {
            "canonical": "Gadget definition talk"
        },
    },
    "sg": {
        "Média": {"canonical": "Media"},
        "Spécial": {"canonical": "Special"},
        "Discussion": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Utilisateur": {"canonical": "User"},
        "Discussion utilisateur": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Discussion Wikipedia": {"canonical": "Project talk"},
        "Fichier": {"canonical": "File"},
        "Discussion fichier": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Discussion MediaWiki": {"canonical": "MediaWiki talk"},
        "Modèle": {"canonical": "Template"},
        "Discussion modèle": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Aide": {"canonical": "Help"},
        "Discussion aide": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Catégorie": {"canonical": "Category"},
        "Discussion catégorie": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "sh": {
        "Mediji": {"canonical": "Media", "aliases": ["Medija", "Медија"]},
        "Posebno": {"canonical": "Special", "aliases": ["Посебно"]},
        "Razgovor": {"canonical": "Talk", "aliases": ["Разговор"]},
        "Korisnik": {"canonical": "User", "aliases": ["Корисник"]},
        "Razgovor sa korisnikom": {
            "canonical": "User talk",
            "aliases": ["Razgovor sa korisnikom", "Разговор са корисником"],
        },
        "Wikipedia": {
            "canonical": "Project",
            "aliases": ["VP", "Vikipedija", "Wikipedija", "ВП", "Википедија"],
        },
        "Razgovor o Wikipedia": {
            "canonical": "Project talk",
            "aliases": [
                "Razgovor Wikipedija",
                "Razgovor Wikipedijom",
                "Razgovor o Wikipedia",
                "Razgovor o Wikipediji",
                "Razgovor s Wikipedijom",
                "Разговор о Wikipedia",
                "Разговор о Википедији",
            ],
        },
        "Datoteka": {"canonical": "File", "aliases": ["Slika", "Слика"]},
        "Razgovor o datoteci": {
            "canonical": "File talk",
            "aliases": ["Razgovor o datoteci", "Razgovor o slici", "Разговор о слици"],
        },
        "MediaWiki": {"aliases": ["MedijaViki", "МедијаВики"]},
        "Mediawiki razgovor": {
            "canonical": "MediaWiki talk",
            "aliases": [
                "MediaWiki razgovor",
                "Mediawiki razgovor",
                "Razgovor o MedijaVikiju",
                "Разговор о МедијаВикију",
            ],
        },
        "Šablon": {"canonical": "Template", "aliases": ["Шаблон"]},
        "Razgovor o šablonu": {
            "canonical": "Template talk",
            "aliases": ["Razgovor o šablonu", "Разговор о шаблону"],
        },
        "Pomoć": {"canonical": "Help", "aliases": ["Помоћ"]},
        "Razgovor o pomoći": {
            "canonical": "Help talk",
            "aliases": ["Razgovor o pomoći", "Разговор о помоћи"],
        },
        "Kategorija": {"canonical": "Category", "aliases": ["Категорија"]},
        "Razgovor o kategoriji": {
            "canonical": "Category talk",
            "aliases": ["Razgovor o kategoriji", "Разговор о категорији"],
        },
        "Portal": {"aliases": ["Портал"]},
        "Razgovor o portalu": {"aliases": ["Razgovor o portalu", "Разговор о порталу"]},
        "Modul": {"canonical": "Module"},
        "Razgovor o modulu": {
            "canonical": "Module talk",
            "aliases": ["Razgovor o modulu"],
        },
        "Spravica": {"canonical": "Gadget"},
        "Razgovor o spravici": {
            "canonical": "Gadget talk",
            "aliases": ["Razgovor o spravici"],
        },
        "Definicija spravice": {
            "canonical": "Gadget definition",
            "aliases": ["Definicija spravice"],
        },
        "Razgovor o definiciji spravice": {
            "canonical": "Gadget definition talk",
            "aliases": ["Razgovor o definiciji spravice"],
        },
    },
    "shi": {
        "Midya": {"canonical": "Media"},
        "Amẓli": {"canonical": "Special"},
        "Amsawal": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Asmras": {"canonical": "User"},
        "Amsawal n usmras": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur"],
        },
        "Wikipidya": {"canonical": "Project"},
        "Amsawal n Wikipidya": {
            "canonical": "Project talk",
            "aliases": ["Wikipidya talk"],
        },
        "Afaylu": {"canonical": "File"},
        "Amsawal n ufaylu": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "MidyaWiki": {"canonical": "MediaWiki"},
        "Amsawal n MidyaWiki": {"canonical": "MediaWiki talk"},
        "Talɣa": {"canonical": "Template"},
        "Amsawal n talɣa": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Tiwisi": {"canonical": "Help"},
        "Amsawal n twisi": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Taggayt": {"canonical": "Category"},
        "Amsawal n taggayt": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Aggur": {"aliases": ["Portal"]},
        "Amsawal n waggur": {"aliases": ["Amsawal n waggur", "Portal talk"]},
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "shn": {
        "သိုဝ်ႇၶၢဝ်ႇ": {"canonical": "Media"},
        "ၶိုၵ်ႉတွၼ်း": {"canonical": "Special"},
        "ဢုပ်ႇၵုမ်": {"canonical": "Talk"},
        "ၽူႈၸႂ်ႉတိုဝ်း": {"canonical": "User"},
        "ဢုပ်ႇၵုမ် ၽူႈၸႂ်ႉတိုဝ်း": {"canonical": "User talk"},
        "ဝီႇၶီႇၽီးတီးယႃး": {"canonical": "Project"},
        "ဢုပ်ႇၵုမ် ဝီႇၶီႇၽီးတီးယႃး": {"canonical": "Project talk"},
        "ၾၢႆႇ": {"canonical": "File"},
        "ဢုပ်ႇၵုမ် ၾၢႆႇ": {"canonical": "File talk"},
        "မီႇတီႇယႃႇဝီႇၶီႇ": {"canonical": "MediaWiki", "aliases": ["သိုဝ်ႇၶၢဝ်ႇဝီႇၶီႇ"]},
        "ဢုပ်ႇၵုမ် မီႇတီႇယႃႇဝီႇၶီႇ": {
            "canonical": "MediaWiki talk",
            "aliases": ["ဢုပ်ႇၵုမ် သိုဝ်ႇၶၢဝ်ႇဝီႇၶီႇ"],
        },
        "ထႅမ်းပလဵတ်ႉ": {"canonical": "Template", "aliases": ["ထႅမ်းပလဵၵ်ႉ"]},
        "ဢုပ်ႇၵုမ် ထႅမ်းပလဵတ်ႉ": {
            "canonical": "Template talk",
            "aliases": ["ဢုပ်ႇၵုမ် ထႅမ်းပလဵၵ်ႉ"],
        },
        "လွင်ႈၸွႆႈထႅမ်": {"canonical": "Help"},
        "ဢုပ်ႇၵုမ် လွင်ႈၸွႆႈထႅမ်": {"canonical": "Help talk"},
        "ပိူင်ထၢၼ်ႈ": {"canonical": "Category"},
        "ဢုပ်ႇၵုမ် ပိူင်ထၢၼ်ႈ": {"canonical": "Category talk"},
        "ၵိူၼ်ႇတူ": {},
        "တွၼ်ႈဢုပ်ႇ ၵိူၼ်ႇတူ": {},
        "မေႃႇၵျူး": {"canonical": "Module"},
        "ဢုပ်ႇၵုမ် မေႃႇၵျူး": {"canonical": "Module talk"},
        "ၶိူင်ႈပိတ်းပွတ်း": {"canonical": "Gadget"},
        "ဢုပ်ႇၵုမ် ၶိူင်ႈပိတ်းပွတ်း": {"canonical": "Gadget talk"},
        "ပိုတ်ႇတီႈပွင်ႇ ၶိူင်ႈပိတ်းပွတ်း": {"canonical": "Gadget definition"},
        "ဢုပ်ႇၵုမ် ပိုတ်ႇတီႈပွင်ႇ ၶိူင်ႈပိတ်းပွတ်း": {
            "canonical": "Gadget definition talk"
        },
    },
    "si": {
        "මාධ්\u200dයය": {"canonical": "Media"},
        "විශේෂ": {"canonical": "Special"},
        "සාකච්ඡාව": {"canonical": "Talk"},
        "පරිශීලක": {"canonical": "User"},
        "පරිශීලක සාකච්ඡාව": {"canonical": "User talk"},
        "විකිපීඩියා": {"canonical": "Project"},
        "විකිපීඩියා සාකච්ඡාව": {"canonical": "Project talk"},
        "ගොනුව": {"canonical": "File", "aliases": ["රූපය"]},
        "ගොනුව සාකච්ඡාව": {"canonical": "File talk", "aliases": ["රූපය සාකච්ඡාව"]},
        "මාධ්\u200dයවිකි": {"canonical": "MediaWiki", "aliases": ["විකිමාධ්\u200dය"]},
        "මාධ්\u200dයවිකි සාකච්ඡාව": {
            "canonical": "MediaWiki talk",
            "aliases": ["විකිමාධ්\u200dය සාකච්ඡාව"],
        },
        "සැකිල්ල": {"canonical": "Template"},
        "සැකිලි සාකච්ඡාව": {"canonical": "Template talk"},
        "උදවු": {"canonical": "Help"},
        "උදවු සාකච්ඡාව": {"canonical": "Help talk", "aliases": ["උදව සාකච්ඡාව"]},
        "ප්\u200dරවර්ගය": {"canonical": "Category"},
        "ප්\u200dරවර්ග සාකච්ඡාව": {"canonical": "Category talk"},
        "ද්වාරය": {"aliases": ["Portal"]},
        "ද්වාරය සාකච්ඡාව": {"aliases": ["Portal talk"]},
    },
    "simple": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "sk": {
        "Médiá": {"canonical": "Media"},
        "Špeciálne": {"canonical": "Special"},
        "Diskusia": {"canonical": "Talk", "aliases": ["Komentár"]},
        "Redaktor": {"canonical": "User", "aliases": ["Redaktorka", "Užívateľ"]},
        "Diskusia s redaktorom": {
            "canonical": "User talk",
            "aliases": [
                "Diskusia s redaktorkou",
                "Diskusia s užívateľom",
                "Komentár k redaktorovi",
                "Uživatel diskuse",
                "Uživatelka diskuse",
            ],
        },
        "Wikipédia": {"canonical": "Project"},
        "Diskusia k Wikipédii": {
            "canonical": "Project talk",
            "aliases": ["Komentár k Wikipédii", "Wikipédia diskuse"],
        },
        "Súbor": {"canonical": "File", "aliases": ["Obrázok"]},
        "Diskusia k súboru": {
            "canonical": "File talk",
            "aliases": ["Diskusia k obrázku", "Komentár k obrázku", "Soubor diskuse"],
        },
        "Diskusia k MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Komentár k MediaWiki", "MediaWiki diskuse"],
        },
        "Šablóna": {"canonical": "Template"},
        "Diskusia k šablóne": {
            "canonical": "Template talk",
            "aliases": ["Šablona diskuse"],
        },
        "Pomoc": {"canonical": "Help"},
        "Diskusia k pomoci": {
            "canonical": "Help talk",
            "aliases": ["Nápověda diskuse"],
        },
        "Kategória": {"canonical": "Category"},
        "Diskusia ku kategórii": {
            "canonical": "Category talk",
            "aliases": ["Kategorie diskuse"],
        },
        "Portál": {},
        "Diskusia k portálu": {},
        "Modul": {"canonical": "Module"},
        "Diskusia k modulu": {"canonical": "Module talk"},
        "Udělátko": {"canonical": "Gadget"},
        "Diskuse k udělátku": {"canonical": "Gadget talk"},
        "Definice udělátka": {"canonical": "Gadget definition"},
        "Diskuse k definici udělátka": {"canonical": "Gadget definition talk"},
    },
    "skr": {
        "میڈیا": {"canonical": "Media"},
        "خاص": {"canonical": "Special"},
        "ڳالھ مہاڑ": {"canonical": "Talk"},
        "ورتݨ آلا": {"canonical": "User"},
        "ورتݨ آلے دی ڳالھ مہاڑ": {"canonical": "User talk"},
        "وکیپیڈیا": {"canonical": "Project"},
        "وکیپیڈیا ڳالھ مہاڑ": {"canonical": "Project talk"},
        "فائل": {"canonical": "File"},
        "فائل ڳالھ مہاڑ": {"canonical": "File talk"},
        "میڈیا وکی": {"canonical": "MediaWiki"},
        "میڈیا وکی ڳالھ مہاڑ": {"canonical": "MediaWiki talk"},
        "سانچہ": {"canonical": "Template"},
        "سانچہ ڳالھ مہاڑ": {"canonical": "Template talk"},
        "مدد": {"canonical": "Help"},
        "مدد ڳالھ مہاڑ": {"canonical": "Help talk"},
        "ونکی": {"canonical": "Category"},
        "ونکی ڳالھ مہاڑ": {"canonical": "Category talk"},
        "ماڈیول": {"canonical": "Module"},
        "ماڈیول ڳالھ مہاڑ": {"canonical": "Module talk"},
    },
    "sl": {
        "Datoteka": {"canonical": "Media"},
        "Posebno": {"canonical": "Special"},
        "Pogovor": {"canonical": "Talk"},
        "Uporabnik": {"canonical": "User"},
        "Uporabniški pogovor": {"canonical": "User talk"},
        "Wikipedija": {"canonical": "Project"},
        "Pogovor o Wikipediji": {"canonical": "Project talk"},
        "Slika": {"canonical": "File"},
        "Pogovor o sliki": {"canonical": "File talk"},
        "Pogovor o MediaWiki": {"canonical": "MediaWiki talk"},
        "Predloga": {"canonical": "Template"},
        "Pogovor o predlogi": {"canonical": "Template talk"},
        "Pomoč": {"canonical": "Help"},
        "Pogovor o pomoči": {"canonical": "Help talk"},
        "Kategorija": {"canonical": "Category"},
        "Pogovor o kategoriji": {"canonical": "Category talk"},
        "Pogovor o portalu": {},
        "Modul": {"canonical": "Module"},
        "Pogovor o modulu": {"canonical": "Module talk"},
    },
    "sm": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "smn": {
        "Tooimah": {"canonical": "Special"},
        "Savâstâllâm": {"canonical": "Talk"},
        "Kevttee": {"canonical": "User"},
        "Savâstâllâm kevttest": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Savâstâllâm Wikipedia": {"canonical": "Project talk"},
        "Tiätuvuárkká": {"canonical": "File", "aliases": ["Kuva"]},
        "Savâstâllâm tiätuvuárhást": {
            "canonical": "File talk",
            "aliases": ["Keskustelu kuvasta"],
        },
        "Systeemviestâ": {"canonical": "MediaWiki"},
        "Savâstâllâm systeemviestâst": {"canonical": "MediaWiki talk"},
        "Myenster": {"canonical": "Template"},
        "Savâstâllâm myensterist": {"canonical": "Template talk"},
        "Raavâ": {"canonical": "Help"},
        "Savâstâllâm ravvust": {"canonical": "Help talk"},
        "Luokka": {"canonical": "Category"},
        "Savâstâllâm luokkaast": {"canonical": "Category talk"},
        "Mooduul": {"canonical": "Module"},
        "Savâstâllâm modulist": {"canonical": "Module talk"},
        "Pienoisohjelma": {"canonical": "Gadget"},
        "Keskustelu pienoisohjelmasta": {"canonical": "Gadget talk"},
        "Pienoisohjelman määritys": {"canonical": "Gadget definition"},
        "Keskustelu pienoisohjelman määrityksestä": {
            "canonical": "Gadget definition talk"
        },
    },
    "sn": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "so": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "sq": {
        "Speciale": {"canonical": "Special"},
        "Diskutim": {"canonical": "Talk"},
        "Përdoruesi": {"canonical": "User", "aliases": ["Perdoruesi", "Përdoruesja"]},
        "Përdoruesi diskutim": {
            "canonical": "User talk",
            "aliases": ["Perdoruesi diskutim", "Përdoruesja diskutim"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia diskutim": {"canonical": "Project talk"},
        "Skeda": {"canonical": "File", "aliases": ["Figura"]},
        "Skeda diskutim": {"canonical": "File talk", "aliases": ["Figura diskutim"]},
        "MediaWiki diskutim": {"canonical": "MediaWiki talk"},
        "Stampa": {"canonical": "Template"},
        "Stampa diskutim": {"canonical": "Template talk"},
        "Ndihmë": {"canonical": "Help", "aliases": ["Ndihme"]},
        "Ndihmë diskutim": {"canonical": "Help talk", "aliases": ["Ndihme diskutim"]},
        "Kategoria": {"canonical": "Category", "aliases": ["Kategori"]},
        "Kategoria diskutim": {
            "canonical": "Category talk",
            "aliases": ["Kategori Diskutim"],
        },
        "Portal diskutim": {},
        "Moduli": {"canonical": "Module"},
        "Moduli diskutim": {"canonical": "Module talk"},
    },
    "sr": {
        "Медиј": {"canonical": "Media", "aliases": ["Medij", "Medija", "Медија"]},
        "Посебно": {"canonical": "Special", "aliases": ["Posebno"]},
        "Разговор": {"canonical": "Talk", "aliases": ["Razgovor"]},
        "Корисник": {"canonical": "User", "aliases": ["Korisnik"]},
        "Разговор са корисником": {
            "canonical": "User talk",
            "aliases": [
                "Razgovor sa korisnikom",
                "Razgovor sa korisnikom",
                "Разговор са корисником",
            ],
        },
        "Википедија": {"canonical": "Project", "aliases": ["VP", "Vikipedija", "ВП"]},
        "Разговор о Википедији": {
            "canonical": "Project talk",
            "aliases": ["Razgovor o Википедија", "Разговор о Википедији"],
        },
        "Датотека": {"canonical": "File", "aliases": ["Datoteka", "Slika", "Слика"]},
        "Разговор о датотеци": {
            "canonical": "File talk",
            "aliases": [
                "Razgovor o datoteci",
                "Razgovor o slici",
                "Разговор о датотеци",
                "Разговор о слици",
            ],
        },
        "Медијавики": {
            "canonical": "MediaWiki",
            "aliases": ["MedijaViki", "Medijaviki", "МедијаВики"],
        },
        "Разговор о Медијавикију": {
            "canonical": "MediaWiki talk",
            "aliases": [
                "Razgovor o MedijaVikiju",
                "Razgovor o Medijavikiju",
                "Разговор о МедијаВикију",
                "Разговор о Медијавикију",
            ],
        },
        "Шаблон": {"canonical": "Template", "aliases": ["Šablon"]},
        "Разговор о шаблону": {
            "canonical": "Template talk",
            "aliases": [
                "Razgovor o šablonu",
                "Razgovor o šablonu",
                "Разговор о шаблону",
            ],
        },
        "Помоћ": {"canonical": "Help", "aliases": ["Pomoć"]},
        "Разговор о помоћи": {
            "canonical": "Help talk",
            "aliases": ["Razgovor o pomoći", "Razgovor o pomoći", "Разговор о помоћи"],
        },
        "Категорија": {"canonical": "Category", "aliases": ["Kategorija"]},
        "Разговор о категорији": {
            "canonical": "Category talk",
            "aliases": [
                "Razgovor o kategoriji",
                "Razgovor o kategoriji",
                "Разговор о категорији",
            ],
        },
        "Портал": {},
        "Разговор о порталу": {"aliases": ["Разговор о порталу"]},
        "Нацрт": {"aliases": ["Draft"]},
        "Разговор о нацрту": {"aliases": ["Draft talk", "Разговор о нацрту"]},
        "Модул": {"canonical": "Module", "aliases": ["Modul"]},
        "Разговор о модулу": {
            "canonical": "Module talk",
            "aliases": ["Razgovor o modulu", "Разговор о модулу"],
        },
        "Справица": {"canonical": "Gadget", "aliases": ["Spravica"]},
        "Разговор о справици": {
            "canonical": "Gadget talk",
            "aliases": ["Razgovor o spravici", "Разговор о справици"],
        },
        "Дефиниција справице": {
            "canonical": "Gadget definition",
            "aliases": ["Definicija spravice", "Дефиниција справице"],
        },
        "Разговор о дефиницији справице": {
            "canonical": "Gadget definition talk",
            "aliases": [
                "Razgovor o definiciji spravice",
                "Разговор о дефиницији справице",
            ],
        },
    },
    "srn": {
        "Spesyal": {"canonical": "Special", "aliases": ["Speciaal"]},
        "Taki": {"canonical": "Talk", "aliases": ["Overleg"]},
        "Masyin": {"canonical": "User", "aliases": ["Gebruiker"]},
        "Taki fu masyin": {"canonical": "User talk", "aliases": ["Overleg gebruiker"]},
        "Wikipedia": {"canonical": "Project"},
        "Taki fu Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Overleg Wikipedia"],
        },
        "Gefre": {"canonical": "File", "aliases": ["Afbeelding"]},
        "Taki fu gefre": {"canonical": "File talk", "aliases": ["Overleg afbeelding"]},
        "Taki fu MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Overleg MediaWiki"],
        },
        "Ankra": {"canonical": "Template", "aliases": ["Sjabloon"]},
        "Taki fu ankra": {
            "canonical": "Template talk",
            "aliases": ["Overleg sjabloon"],
        },
        "Yepi": {"canonical": "Help"},
        "Taki fu yepi": {"canonical": "Help talk", "aliases": ["Overleg help"]},
        "Guru": {"canonical": "Category", "aliases": ["Categorie"]},
        "Taki fu guru": {
            "canonical": "Category talk",
            "aliases": ["Overleg categorie"],
        },
        "Overleg module": {"canonical": "Module talk"},
        "Uitbreiding": {"canonical": "Gadget"},
        "Overleg uitbreiding": {"canonical": "Gadget talk"},
        "Uitbreidingsdefinitie": {"canonical": "Gadget definition"},
        "Overleg uitbreidingsdefinitie": {"canonical": "Gadget definition talk"},
    },
    "ss": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "st": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "stq": {
        "Spezial": {"canonical": "Special"},
        "Diskussion": {"canonical": "Talk"},
        "Benutser": {"canonical": "User", "aliases": ["Benutserske"]},
        "Benutser Diskussion": {
            "canonical": "User talk",
            "aliases": ["Benutserske Diskussion"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia Diskussion": {"canonical": "Project talk"},
        "Bielde": {"canonical": "File", "aliases": ["Bild"]},
        "Bielde Diskussion": {"canonical": "File talk", "aliases": ["Bild Diskussion"]},
        "MediaWiki Diskussion": {"canonical": "MediaWiki talk"},
        "Foarloage": {"canonical": "Template"},
        "Foarloage Diskussion": {"canonical": "Template talk"},
        "Hälpe": {"canonical": "Help"},
        "Hälpe Diskussion": {"canonical": "Help talk"},
        "Kategorie": {"canonical": "Category"},
        "Kategorie Diskussion": {"canonical": "Category talk"},
        "Modul": {"canonical": "Module"},
        "Modul Diskussion": {"canonical": "Module talk"},
        "Gadget Diskussion": {"canonical": "Gadget talk"},
        "Gadget-Definition": {"canonical": "Gadget definition"},
        "Gadget-Definition Diskussion": {"canonical": "Gadget definition talk"},
    },
    "su": {
        "Média": {"canonical": "Media"},
        "Husus": {"canonical": "Special"},
        "Obrolan": {"canonical": "Talk", "aliases": ["Bicara"]},
        "Pamaké": {"canonical": "User"},
        "Obrolan pamaké": {"canonical": "User talk", "aliases": ["Bicara Pengguna"]},
        "Wikipedia": {"canonical": "Project"},
        "Obrolan Wikipedia": {"canonical": "Project talk"},
        "Gambar": {"canonical": "File"},
        "Obrolan gambar": {
            "canonical": "File talk",
            "aliases": ["Gambar Pembicaraan", "Pembicaraan Gambar"],
        },
        "MédiaWiki": {"canonical": "MediaWiki"},
        "Obrolan MédiaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki Pembicaraan", "Obrolan MediaWiki"],
        },
        "Citakan": {"canonical": "Template"},
        "Obrolan citakan": {
            "canonical": "Template talk",
            "aliases": ["Templat Pembicaraan"],
        },
        "Pitulung": {"canonical": "Help"},
        "Obrolan pitulung": {
            "canonical": "Help talk",
            "aliases": ["Bantuan Pembicaraan"],
        },
        "Kategori": {"canonical": "Category"},
        "Obrolan kategori": {
            "canonical": "Category talk",
            "aliases": ["Kategori Pembicaraan"],
        },
        "Obrolan portal": {},
        "Modul": {"canonical": "Module"},
        "Pembicaraan Modul": {"canonical": "Module talk"},
    },
    "sv": {
        "Diskussion": {"canonical": "Talk"},
        "Användare": {"canonical": "User"},
        "Användardiskussion": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipediadiskussion": {"canonical": "Project talk"},
        "Fil": {"canonical": "File", "aliases": ["Bild"]},
        "Fildiskussion": {"canonical": "File talk", "aliases": ["Bilddiskussion"]},
        "MediaWiki-diskussion": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki diskussion"],
        },
        "Mall": {"canonical": "Template"},
        "Malldiskussion": {"canonical": "Template talk"},
        "Hjälp": {"canonical": "Help"},
        "Hjälpdiskussion": {"canonical": "Help talk", "aliases": ["Hjälp diskussion"]},
        "Kategori": {"canonical": "Category"},
        "Kategoridiskussion": {"canonical": "Category talk"},
        "Portaldiskussion": {},
        "Education Program": {},
        "Education Program talk": {},
        "Modul": {"canonical": "Module"},
        "Moduldiskussion": {"canonical": "Module talk"},
        "Ämne": {"canonical": "Topic"},
    },
    "sw": {
        "Maalum": {"canonical": "Special"},
        "Majadiliano": {"canonical": "Talk"},
        "Mtumiaji": {"canonical": "User"},
        "Majadiliano ya mtumiaji": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Majadiliano ya Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia majadiliano"],
        },
        "Faili": {"canonical": "File", "aliases": ["Picha"]},
        "Majadiliano ya faili": {
            "canonical": "File talk",
            "aliases": ["Majadiliano faili"],
        },
        "Majadiliano ya MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki majadiliano"],
        },
        "Kigezo": {"canonical": "Template"},
        "Majadiliano ya kigezo": {
            "canonical": "Template talk",
            "aliases": ["Kigezo majadiliano"],
        },
        "Msaada": {"canonical": "Help"},
        "Majadiliano ya msaada": {
            "canonical": "Help talk",
            "aliases": ["Msaada majadiliano"],
        },
        "Jamii": {"canonical": "Category"},
        "Majadiliano ya jamii": {
            "canonical": "Category talk",
            "aliases": ["Jamii majadiliano"],
        },
        "Lango": {"aliases": ["Portal"]},
        "Majadiliano ya lango": {"aliases": ["Portal talk"]},
        "Wikichanzo": {},
        "Majadiliano ya Wikichanzo": {},
    },
    "szl": {
        "Szpecyjalna": {"canonical": "Special", "aliases": ["Specjalna"]},
        "Dyskusyjo": {"canonical": "Talk", "aliases": ["Dyskusja"]},
        "Używacz": {"canonical": "User", "aliases": ["Użytkownik"]},
        "Dyskusyjo używacza": {
            "canonical": "User talk",
            "aliases": ["Dyskusja użytkownika"],
        },
        "Wikipedyjo": {"canonical": "Project"},
        "Dyskusyjo Wikipedyjo": {
            "canonical": "Project talk",
            "aliases": ["Dyskusja Wikipedyjo"],
        },
        "Plik": {"canonical": "File", "aliases": ["Grafika"]},
        "Dyskusyjo plika": {
            "canonical": "File talk",
            "aliases": ["Dyskusja grafiki", "Dyskusja pliku"],
        },
        "Dyskusyjo MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Dyskusja MediaWiki"],
        },
        "Muster": {"canonical": "Template", "aliases": ["Szablon"]},
        "Dyskusyjo mustra": {
            "canonical": "Template talk",
            "aliases": ["Dyskusja szablonu"],
        },
        "Půmoc": {"canonical": "Help", "aliases": ["Pomoc"]},
        "Dyskusyjo půmocy": {"canonical": "Help talk", "aliases": ["Dyskusja pomocy"]},
        "Kategoryjo": {"canonical": "Category", "aliases": ["Kategoria"]},
        "Dyskusyjo kategoryji": {
            "canonical": "Category talk",
            "aliases": ["Dyskusja kategorii"],
        },
        "Moduł": {"canonical": "Module"},
        "Dyskusja modułu": {"canonical": "Module talk"},
        "Gadżet": {"canonical": "Gadget"},
        "Dyskusja gadżetu": {"canonical": "Gadget talk"},
        "Definicja gadżetu": {"canonical": "Gadget definition"},
        "Dyskusja definicji gadżetu": {"canonical": "Gadget definition talk"},
    },
    "szy": {
        "myiti": {"canonical": "Media", "aliases": ["媒体", "媒體"]},
        "sazumaay": {"canonical": "Special", "aliases": ["特殊"]},
        "sasukamu": {"canonical": "Talk", "aliases": ["对话", "對話", "討論", "讨论"]},
        "misaungayay": {"canonical": "User", "aliases": ["用戶", "用户"]},
        "pisubelidan tu kamu ni misaungayay sapimatatengil": {
            "canonical": "User talk",
            "aliases": ["用戶對話", "用戶討論", "用户对话", "用户讨论"],
        },
        "Wikipitiya": {"canonical": "Project"},
        "Wikipitiya sasukamu": {"canonical": "Project talk"},
        "tangan": {
            "canonical": "File",
            "aliases": ["图像", "圖像", "圖片", "文件", "档案", "檔案"],
        },
        "pisubelidan tu kamu tu tangan sapimatatengil": {
            "canonical": "File talk",
            "aliases": [
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "圖片討論",
                "文件对话",
                "文件對話",
                "文件討論",
                "文件讨论",
                "档案对话",
                "档案讨论",
                "檔案對話",
                "檔案討論",
            ],
        },
        "MyitiWyici": {"canonical": "MediaWiki"},
        "matatengil tu MyitiWyici": {"canonical": "MediaWiki talk"},
        "taazihan mitudung": {"canonical": "Template", "aliases": ["样板", "模板", "樣板"]},
        "pisubelidan tu kamu i taazihan mitudung sapimatatengil": {
            "canonical": "Template talk",
            "aliases": ["样板对话", "样板讨论", "模板对话", "模板對話", "模板討論", "模板讨论", "樣板對話", "樣板討論"],
        },
        "buhci tu kamu": {"canonical": "Help", "aliases": ["帮助", "幫助"]},
        "matatengil tu buhci tu kamu": {
            "canonical": "Help talk",
            "aliases": ["帮助对话", "帮助讨论", "幫助對話", "幫助討論"],
        },
        "kakuniza": {"canonical": "Category", "aliases": ["分类", "分類"]},
        "sacacayen kakuniza tu pisubelidan tu kamu sapimatatengil": {
            "canonical": "Category talk",
            "aliases": ["分类对话", "分类讨论", "分類對話", "分類討論"],
        },
        "bacu-saupu": {"canonical": "Module", "aliases": ["模块", "模塊", "模組", "模组"]},
        "pisubelidan tu kamu i bacu-saupu sapimatatengil": {
            "canonical": "Module talk",
            "aliases": ["模块对话", "模块讨论", "模塊對話", "模塊討論", "模組對話", "模組討論", "模组对话", "模组讨论"],
        },
    },
    "ta": {
        "ஊடகம்": {"canonical": "Media"},
        "சிறப்பு": {"canonical": "Special"},
        "பேச்சு": {"canonical": "Talk"},
        "பயனர்": {"canonical": "User"},
        "பயனர் பேச்சு": {"canonical": "User talk"},
        "விக்கிப்பீடியா": {"canonical": "Project", "aliases": ["விக்கிபீடியா"]},
        "விக்கிப்பீடியா பேச்சு": {
            "canonical": "Project talk",
            "aliases": ["விக்கிபீடியா பேச்சு"],
        },
        "படிமம்": {"canonical": "File"},
        "படிமப் பேச்சு": {"canonical": "File talk", "aliases": ["உருவப் பேச்சு"]},
        "மீடியாவிக்கி": {"canonical": "MediaWiki"},
        "மீடியாவிக்கி பேச்சு": {"canonical": "MediaWiki talk"},
        "வார்ப்புரு": {"canonical": "Template"},
        "வார்ப்புரு பேச்சு": {"canonical": "Template talk"},
        "உதவி": {"canonical": "Help"},
        "உதவி பேச்சு": {"canonical": "Help talk"},
        "பகுப்பு": {"canonical": "Category"},
        "பகுப்பு பேச்சு": {"canonical": "Category talk"},
        "வலைவாசல்": {},
        "வலைவாசல் பேச்சு": {},
    },
    "tay": {
        "media": {"canonical": "Media", "aliases": ["媒体", "媒體"]},
        "kin iniptnaq": {"canonical": "Special", "aliases": ["特殊"]},
        "spkayal": {"canonical": "Talk", "aliases": ["对话", "對話", "討論", "讨论"]},
        "cinzyuwaw": {"canonical": "User", "aliases": ["用戶", "用户"]},
        "spkayal cinzyuwaw": {
            "canonical": "User talk",
            "aliases": ["用戶對話", "用戶討論", "用户对话", "用户讨论"],
        },
        "Wikibitia": {"canonical": "Project"},
        "spkayal Wikibitia": {"canonical": "Project talk"},
        "biru’ na zayzyuwaw": {
            "canonical": "File",
            "aliases": ["biru' na zayzyuwaw", "图像", "圖像", "圖片", "文件", "档案", "檔案"],
        },
        "spkayal squ biru’ na zayzyuwaw": {
            "canonical": "File talk",
            "aliases": [
                "spkayal squ biru' na zayzyuwaw",
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "圖片討論",
                "文件对话",
                "文件對話",
                "文件討論",
                "文件讨论",
                "档案对话",
                "档案讨论",
                "檔案對話",
                "檔案討論",
            ],
        },
        "mediawiki": {"canonical": "MediaWiki"},
        "spkayal qu mediawiki": {"canonical": "MediaWiki talk"},
        "panmwo": {"canonical": "Template", "aliases": ["样板", "模板", "樣板"]},
        "spkayal sa panmwo": {
            "canonical": "Template talk",
            "aliases": ["样板对话", "样板讨论", "模板对话", "模板對話", "模板討論", "模板讨论", "樣板對話", "樣板討論"],
        },
        "sni sa pinraw nya smbbaq": {"canonical": "Help", "aliases": ["帮助", "幫助"]},
        "spkayal sa sni sa pinraw nya smbbaq": {
            "canonical": "Help talk",
            "aliases": ["帮助对话", "帮助讨论", "幫助對話", "幫助討論"],
        },
        "zyuwaw na": {"canonical": "Category", "aliases": ["分类", "分類"]},
        "spkayal sa zyuwaw na": {
            "canonical": "Category talk",
            "aliases": ["分类对话", "分类讨论", "分類對話", "分類討論"],
        },
        "模組": {"canonical": "Module", "aliases": ["模块", "模塊", "模组"]},
        "模組討論": {
            "canonical": "Module talk",
            "aliases": ["模块对话", "模块讨论", "模塊對話", "模塊討論", "模組對話", "模组对话", "模组讨论"],
        },
    },
    "tcy": {
        "ಮಾದ್ಯಮೊ": {"canonical": "Media"},
        "ವಿಸೇಸೊ": {"canonical": "Special"},
        "ಪಾತೆರ": {"canonical": "Talk"},
        "ಬಳಕೆದಾರೆ": {"canonical": "User"},
        "ಬಳಕೆದಾರೆ ಪಾತೆರ": {"canonical": "User talk"},
        "ವಿಕಿಪೀಡಿಯ": {"canonical": "Project"},
        "ವಿಕಿಪೀಡಿಯ ಪಾತೆರ": {"canonical": "Project talk"},
        "ಫೈಲ್": {"canonical": "File"},
        "ಫೈಲ್ ಪಾತೆರ": {"canonical": "File talk"},
        "ಮಾದ್ಯಮೊ ವಿಕಿ": {"canonical": "MediaWiki"},
        "ಮಾದ್ಯಮೊ ವಿಕಿ ಪಾತೆರ": {"canonical": "MediaWiki talk"},
        "ಟೆಂಪ್ಲೇಟ್": {"canonical": "Template"},
        "ಟೆಂಪ್ಲೇಟ್ ಪಾತೆರ": {"canonical": "Template talk"},
        "ಸಕಾಯೊ": {"canonical": "Help"},
        "ಸಕಾಯೊ ಪಾತೆರ": {"canonical": "Help talk"},
        "ವರ್ಗೊ": {"canonical": "Category"},
        "ವರ್ಗೊ ಪಾತೆರ": {"canonical": "Category talk"},
        "ಮೋಡ್ಯೂಲ್": {"canonical": "Module"},
        "ಮೋಡ್ಯೂಲ್ ಪಾತೆರ": {"canonical": "Module talk"},
    },
    "te": {
        "మీడియా": {"canonical": "Media"},
        "ప్రత్యేక": {"canonical": "Special"},
        "చర్చ": {"canonical": "Talk"},
        "వాడుకరి": {"canonical": "User", "aliases": ["సభ్యుడు", "సభ్యులు"]},
        "వాడుకరి చర్చ": {
            "canonical": "User talk",
            "aliases": ["సభ్యునిపై చర్చ", "సభ్యులపై చర్చ"],
        },
        "వికీపీడియా": {"canonical": "Project"},
        "వికీపీడియా చర్చ": {"canonical": "Project talk"},
        "దస్త్రం": {"canonical": "File", "aliases": ["ఫైలు", "బొమ్మ"]},
        "దస్త్రంపై చర్చ": {
            "canonical": "File talk",
            "aliases": ["ఫైలుపై చర్చ", "బొమ్మపై చర్చ"],
        },
        "మీడియావికీ": {"canonical": "MediaWiki"},
        "మీడియావికీ చర్చ": {"canonical": "MediaWiki talk"},
        "మూస": {"canonical": "Template"},
        "మూస చర్చ": {"canonical": "Template talk"},
        "సహాయం": {"canonical": "Help", "aliases": ["సహాయము"]},
        "సహాయం చర్చ": {"canonical": "Help talk", "aliases": ["సహాయము చర్చ"]},
        "వర్గం": {"canonical": "Category"},
        "వర్గం చర్చ": {"canonical": "Category talk"},
        "వేదిక": {},
        "వేదిక చర్చ": {},
        "మాడ్యూల్": {"canonical": "Module"},
        "మాడ్యూల్ చర్చ": {"canonical": "Module talk"},
        "Topic": {},
    },
    "tet": {
        "Espesiál": {"canonical": "Special"},
        "Diskusaun": {"canonical": "Talk"},
        "Uza-na'in": {
            "canonical": "User",
            "aliases": ["Usuário", "Utilizador", "Utilizadora"],
        },
        "Diskusaun Uza-na'in": {
            "canonical": "User talk",
            "aliases": [
                "Usuário Discussão",
                "Utilizador Discussão",
                "Utilizadora Discussão",
            ],
        },
        "Wikipedia": {"canonical": "Project"},
        "Diskusaun Wikipedia": {"canonical": "Project talk"},
        "Imajen": {"canonical": "File", "aliases": ["Arquivo", "Imagem"]},
        "Diskusaun Imajen": {
            "canonical": "File talk",
            "aliases": ["Arquivo Discussão", "Imagem Discussão"],
        },
        "Diskusaun MediaWiki": {"canonical": "MediaWiki talk"},
        "Diskusaun Template": {"canonical": "Template talk"},
        "Ajuda": {"canonical": "Help"},
        "Diskusaun Ajuda": {"canonical": "Help talk"},
        "Kategoria": {"canonical": "Category", "aliases": ["Kategoría"]},
        "Diskusaun Kategoria": {
            "canonical": "Category talk",
            "aliases": ["Diskusaun Kategoría"],
        },
        "Módulo": {"canonical": "Module"},
        "Módulo Discussão": {"canonical": "Module talk"},
    },
    "tg": {
        "Медиа": {"canonical": "Media"},
        "Вижа": {"canonical": "Special"},
        "Баҳс": {"canonical": "Talk"},
        "Корбар": {"canonical": "User"},
        "Баҳси корбар": {"canonical": "User talk"},
        "Википедиа": {"canonical": "Project"},
        "Баҳси Википедиа": {"canonical": "Project talk", "aliases": ["Википедиа talk"]},
        "Акс": {"canonical": "File"},
        "Баҳси акс": {"canonical": "File talk"},
        "Медиавики": {"canonical": "MediaWiki"},
        "Баҳси медиавики": {"canonical": "MediaWiki talk"},
        "Шаблон": {"canonical": "Template"},
        "Баҳси шаблон": {"canonical": "Template talk"},
        "Роҳнамо": {"canonical": "Help"},
        "Баҳси роҳнамо": {"canonical": "Help talk"},
        "Гурӯҳ": {"canonical": "Category"},
        "Баҳси гурӯҳ": {"canonical": "Category talk"},
        "Портал": {},
        "Баҳси портал": {"aliases": ["Баҳси портал"]},
        "Лоиҳа": {},
        "Баҳси Лоиҳа": {"aliases": ["Баҳси Лоиҳа"]},
        "Модул": {"canonical": "Module"},
        "Баҳси Модул": {"canonical": "Module talk", "aliases": ["Баҳси Модул"]},
    },
    "th": {
        "สื่อ": {"canonical": "Media"},
        "พิเศษ": {"canonical": "Special"},
        "พูดคุย": {"canonical": "Talk"},
        "ผู้ใช้": {"canonical": "User"},
        "คุยกับผู้ใช้": {"canonical": "User talk"},
        "วิกิพีเดีย": {"canonical": "Project"},
        "คุยเรื่องวิกิพีเดีย": {"canonical": "Project talk"},
        "ไฟล์": {"canonical": "File", "aliases": ["ภาพ"]},
        "คุยเรื่องไฟล์": {"canonical": "File talk", "aliases": ["คุยเรื่องภาพ"]},
        "มีเดียวิกิ": {"canonical": "MediaWiki"},
        "คุยเรื่องมีเดียวิกิ": {"canonical": "MediaWiki talk"},
        "แม่แบบ": {"canonical": "Template"},
        "คุยเรื่องแม่แบบ": {"canonical": "Template talk"},
        "วิธีใช้": {"canonical": "Help", "aliases": ["H"]},
        "คุยเรื่องวิธีใช้": {"canonical": "Help talk"},
        "หมวดหมู่": {"canonical": "Category"},
        "คุยเรื่องหมวดหมู่": {"canonical": "Category talk"},
        "สถานีย่อย": {},
        "คุยเรื่องสถานีย่อย": {},
        "หนังสือ": {},
        "คุยเรื่องหนังสือ": {},
        "ฉบับร่าง": {},
        "คุยเรื่องฉบับร่าง": {},
        "มอดูล": {"canonical": "Module"},
        "คุยเรื่องมอดูล": {"canonical": "Module talk"},
    },
    "ti": {
        "ሜድያ": {"canonical": "Media"},
        "ፍሉይ": {"canonical": "Special"},
        "ምይይጥ": {"canonical": "Talk"},
        "ተጠቃሚ": {"canonical": "User", "aliases": ["ተጠቃሚት"]},
        "ምይይጥ ተጠቃሚ": {"canonical": "User talk", "aliases": ["ምይይጥ ተጠቃሚት", "ተጠቃሚ ምይይጥ"]},
        "ዊኪፐድያ": {"canonical": "Project", "aliases": ["ዊኪፔዲያ"]},
        "ምይይጥ ዊኪፐድያ": {"canonical": "Project talk", "aliases": ["ዊኪፔዲያ ምይይጥ"]},
        "ፋይል": {"canonical": "File"},
        "ምይይጥ ፋይል": {"canonical": "File talk", "aliases": ["ፋይል ምይይጥ"]},
        "ሜድያዊኪ": {"canonical": "MediaWiki", "aliases": ["ሜዲያዊኪ"]},
        "ምይይጥ ሜድያዊኪ": {"canonical": "MediaWiki talk", "aliases": ["ሜዲያዊኪ ምይይጥ"]},
        "ሞደል": {"canonical": "Template"},
        "ምይይጥ ሞደል": {"canonical": "Template talk", "aliases": ["ሞደል ምይይጥ"]},
        "ሓገዝ": {"canonical": "Help"},
        "ምይይጥ ሓገዝ": {"canonical": "Help talk", "aliases": ["ሓገዝ ምይይጥ"]},
        "መደብ": {"canonical": "Category"},
        "ምይይጥ መደብ": {"canonical": "Category talk", "aliases": ["መደብ ምይይጥ"]},
        "ማዕጾ": {},
        "ምይይጥ ማዕጾ": {"aliases": ["ማዕጾ ምይይጥ"]},
        "ሞድዩል": {"canonical": "Module"},
        "ምይይጥ ሞድዩል": {"canonical": "Module talk"},
        "መሳርሒ": {"canonical": "Gadget"},
        "ምይይጥ መሳርሒ": {"canonical": "Gadget talk"},
        "መብርሂ መሳርሒ": {"canonical": "Gadget definition"},
        "ምይይጥ መብርሂ መሳርሒ": {"canonical": "Gadget definition talk"},
    },
    "tk": {
        "Ýörite": {"canonical": "Special"},
        "Çekişme": {"canonical": "Talk"},
        "Ulanyjy": {"canonical": "User"},
        "Ulanyjy çekişme": {"canonical": "User talk"},
        "Wikipediýa": {"canonical": "Project"},
        "Wikipediýa çekişme": {"canonical": "Project talk"},
        "Faýl": {"canonical": "File"},
        "Faýl çekişme": {"canonical": "File talk"},
        "MediaWiki çekişme": {"canonical": "MediaWiki talk"},
        "Şablon": {"canonical": "Template"},
        "Şablon çekişme": {"canonical": "Template talk"},
        "Ýardam": {"canonical": "Help"},
        "Ýardam çekişme": {"canonical": "Help talk"},
        "Kategoriýa": {"canonical": "Category"},
        "Kategoriýa çekişme": {"canonical": "Category talk"},
    },
    "tl": {
        "Midya": {"canonical": "Media"},
        "Natatangi": {"canonical": "Special"},
        "Usapan": {"canonical": "Talk"},
        "Tagagamit": {"canonical": "User"},
        "Usapang tagagamit": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Usapang Wikipedia": {"canonical": "Project talk"},
        "Talaksan": {"canonical": "File"},
        "Usapang talaksan": {"canonical": "File talk"},
        "Usapang MediaWiki": {"canonical": "MediaWiki talk"},
        "Padron": {"canonical": "Template", "aliases": ["Suleras"]},
        "Usapang padron": {
            "canonical": "Template talk",
            "aliases": ["Usapang suleras"],
        },
        "Tulong": {"canonical": "Help"},
        "Usapang tulong": {"canonical": "Help talk"},
        "Kategorya": {"canonical": "Category", "aliases": ["Kaurian"]},
        "Usapang kategorya": {
            "canonical": "Category talk",
            "aliases": ["Usapang kaurian"],
        },
        "Portada": {},
        "Usapang Portada": {},
    },
    "tn": {
        "Pego": {"canonical": "Media"},
        "Faphegileng": {"canonical": "Special"},
        "Puisano": {"canonical": "Talk"},
        "Modirisi": {"canonical": "User"},
        "Puisano ya modirisi": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Puisano ya Wikipedia": {"canonical": "Project talk"},
        "Setshwantsho": {"canonical": "File"},
        "Puisano ya setshwantsho": {"canonical": "File talk"},
        "Puisano ya MediaWiki": {"canonical": "MediaWiki talk"},
        "Tempolete": {"canonical": "Template"},
        "Puisano ya tempolete": {"canonical": "Template talk"},
        "Thuso": {"canonical": "Help"},
        "Puisano ya thuso": {"canonical": "Help talk"},
        "Karolo": {"canonical": "Category"},
        "Puisano ya karolo": {"canonical": "Category talk"},
    },
    "to": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "tpi": {
        "Sipesol": {"canonical": "Special"},
        "Toktok": {"canonical": "Talk"},
        "Yusa": {"canonical": "User"},
        "Toktok bilong yusa": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia toktok": {"canonical": "Project talk"},
        "Fail": {"canonical": "File"},
        "Toktok bilong fail": {"canonical": "File talk"},
        "Toktok bilong mediawiki": {"canonical": "MediaWiki talk"},
        "Templet": {"canonical": "Template"},
        "Toktok bilong templet": {"canonical": "Template talk"},
        "Halivim": {"canonical": "Help"},
        "Toktok bilong halivim": {"canonical": "Help talk"},
        "Grup": {"canonical": "Category"},
        "Toktok bilong grup": {"canonical": "Category talk"},
    },
    "tr": {
        "Ortam": {"canonical": "Media", "aliases": ["Medya"]},
        "Özel": {"canonical": "Special"},
        "Tartışma": {"canonical": "Talk", "aliases": ["T"]},
        "Kullanıcı": {"canonical": "User", "aliases": ["K"]},
        "Kullanıcı mesaj": {"canonical": "User talk"},
        "Vikipedi": {"canonical": "Project", "aliases": ["VP"]},
        "Vikipedi tartışma": {"canonical": "Project talk"},
        "Dosya": {"canonical": "File", "aliases": ["Resim"]},
        "Dosya tartışma": {"canonical": "File talk", "aliases": ["Resim tartışma"]},
        "MediaWiki": {"aliases": ["MedyaViki"]},
        "MediaWiki tartışma": {
            "canonical": "MediaWiki talk",
            "aliases": ["MedyaViki tartışma"],
        },
        "Şablon": {"canonical": "Template", "aliases": ["Ş"]},
        "Şablon tartışma": {"canonical": "Template talk"},
        "Yardım": {"canonical": "Help", "aliases": ["Y"]},
        "Yardım tartışma": {"canonical": "Help talk"},
        "Kategori": {"canonical": "Category", "aliases": ["KAT"]},
        "Kategori tartışma": {"canonical": "Category talk"},
        "Portal": {"aliases": ["P"]},
        "Portal tartışma": {},
        "Vikiproje": {"aliases": ["VPR"]},
        "Vikiproje tartışma": {},
        "Modül": {"canonical": "Module"},
        "Modül tartışma": {"canonical": "Module talk"},
    },
    "trv": {
        "Meyti": {"canonical": "Media", "aliases": ["媒体", "媒體"]},
        "Kingal nanaq": {"canonical": "Special", "aliases": ["特殊"]},
        "Mpprngaw": {"canonical": "Talk", "aliases": ["对话", "對話", "討論", "讨论"]},
        "Empduuy": {"canonical": "User", "aliases": ["用戶", "用户"]},
        "Pprngagun empduuy": {
            "canonical": "User talk",
            "aliases": ["用戶對話", "用戶討論", "用户对话", "用户讨论"],
        },
        "Wikipidiya": {"canonical": "Project"},
        "Pprngagun Wikipidiya": {"canonical": "Project talk"},
        "Patas bntasan": {
            "canonical": "File",
            "aliases": ["图像", "圖像", "圖片", "文件", "档案", "檔案"],
        },
        "Pprngagun patas bntasan": {
            "canonical": "File talk",
            "aliases": [
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "圖片討論",
                "文件对话",
                "文件對話",
                "文件討論",
                "文件讨论",
                "档案对话",
                "档案讨论",
                "檔案對話",
                "檔案討論",
            ],
        },
        "MeytiWiki": {"canonical": "MediaWiki"},
        "Pprngagun MeytiWiki": {"canonical": "MediaWiki talk"},
        "Snluan qcinuh": {"canonical": "Template", "aliases": ["样板", "模板", "樣板"]},
        "Pprngagun snluan qcinuh": {
            "canonical": "Template talk",
            "aliases": ["样板对话", "样板讨论", "模板对话", "模板對話", "模板討論", "模板讨论", "樣板對話", "樣板討論"],
        },
        "Dmayaw": {"canonical": "Help", "aliases": ["帮助", "幫助"]},
        "Pprngagun dmayaw": {
            "canonical": "Help talk",
            "aliases": ["帮助对话", "帮助讨论", "幫助對話", "幫助討論"],
        },
        "Snakun": {"canonical": "Category", "aliases": ["分类", "分類"]},
        "Snakun pprngagun": {
            "canonical": "Category talk",
            "aliases": ["分类对话", "分类讨论", "分類對話", "分類討論"],
        },
        "模組": {"canonical": "Module", "aliases": ["模块", "模塊", "模组"]},
        "模組討論": {
            "canonical": "Module talk",
            "aliases": ["模块对话", "模块讨论", "模塊對話", "模塊討論", "模組對話", "模组对话", "模组讨论"],
        },
    },
    "ts": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "tt": {
        "Медиа": {"canonical": "Media"},
        "Махсус": {"canonical": "Special", "aliases": ["Maxsus", "Служебная"]},
        "Бәхәс": {
            "canonical": "Talk",
            "aliases": ["Bäxäs", "Обсуждение", "Фикер алышу"],
        },
        "Кулланучы": {
            "canonical": "User",
            "aliases": ["Äğzä", "Участник", "Участница"],
        },
        "Кулланучы бәхәсе": {
            "canonical": "User talk",
            "aliases": ["Äğzä bäxäse", "Обсуждение участника", "Обсуждение участницы"],
        },
        "Википедия": {"canonical": "Project", "aliases": ["ВП"]},
        "Википедия бәхәсе": {
            "canonical": "Project talk",
            "aliases": ["Википедия bäxäse", "Обсуждение Википедия"],
        },
        "Файл": {"canonical": "File", "aliases": ["Räsem", "Изображение", "Рәсем"]},
        "Файл бәхәсе": {
            "canonical": "File talk",
            "aliases": [
                "Räsem bäxäse",
                "Обсуждение изображения",
                "Обсуждение файла",
                "Рәсем бәхәсе",
            ],
        },
        "МедиаВики": {"canonical": "MediaWiki", "aliases": ["Медиа Вики"]},
        "МедиаВики бәхәсе": {
            "canonical": "MediaWiki talk",
            "aliases": [
                "MediaWiki bäxäse",
                "Медиа Вики бәхәсе",
                "Обсуждение MediaWiki",
            ],
        },
        "Калып": {"canonical": "Template", "aliases": ["Ürnäk", "Шаблон", "Үрнәк"]},
        "Калып бәхәсе": {
            "canonical": "Template talk",
            "aliases": [
                "Ürnäk bäxäse",
                "Обсуждение шаблона",
                "Шаблон бәхәсе",
                "Үрнәк бәхәсе",
            ],
        },
        "Ярдәм": {"canonical": "Help", "aliases": ["Yärdäm", "Справка"]},
        "Ярдәм бәхәсе": {
            "canonical": "Help talk",
            "aliases": ["Yärdäm bäxäse", "Обсуждение справки"],
        },
        "Төркем": {"canonical": "Category", "aliases": ["Törkem", "Категория"]},
        "Төркем бәхәсе": {
            "canonical": "Category talk",
            "aliases": ["Törkem bäxäse", "Обсуждение категории"],
        },
        "Портал": {},
        "Портал бәхәсе": {},
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "tum": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "tw": {
        "Soronko": {"canonical": "Special"},
        "Nkitahode": {"canonical": "Talk"},
        "Dwumadini": {"canonical": "User"},
        "Dwumadini nkitahode": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia nkitahode": {"canonical": "Project talk"},
        "File nkitahode": {"canonical": "File talk"},
        "MediaWiki nkitahode": {"canonical": "MediaWiki talk"},
        "Nhwɛsoɔ": {"canonical": "Template"},
        "Nhwɛsoɔ nkitahode": {"canonical": "Template talk"},
        "Mmoa": {"canonical": "Help"},
        "Mmoa nkitahode": {"canonical": "Help talk"},
        "Nkyekyεmu": {"canonical": "Category"},
        "Nkyekyεmu nkitahode": {"canonical": "Category talk"},
    },
    "ty": {
        "Média": {"canonical": "Media"},
        "Spécial": {"canonical": "Special"},
        "Discussion": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Utilisateur": {"canonical": "User"},
        "Discussion utilisateur": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Discussion Wikipedia": {"canonical": "Project talk"},
        "Fichier": {"canonical": "File"},
        "Discussion fichier": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Discussion MediaWiki": {"canonical": "MediaWiki talk"},
        "Modèle": {"canonical": "Template"},
        "Discussion modèle": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Aide": {"canonical": "Help"},
        "Discussion aide": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Catégorie": {"canonical": "Category"},
        "Discussion catégorie": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "tyv": {
        "Медиа": {"canonical": "Media"},
        "Тускай": {"canonical": "Special"},
        "Чугаа": {"canonical": "Talk"},
        "Ажыглакчы": {"canonical": "User", "aliases": ["Aжыглакчы"]},
        "Ажыглакчы чугаа": {
            "canonical": "User talk",
            "aliases": ["Aжыглакчы чугаа", "Aжыглакчы чугаазы"],
        },
        "Википедия": {"canonical": "Project"},
        "Википедия дугайында сүмелел": {
            "canonical": "Project talk",
            "aliases": ["Википедия чугаазы"],
        },
        "Файл": {"canonical": "File", "aliases": ["Изображение"]},
        "Файл чугаа": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения", "Файл чугаазы"],
        },
        "МедиаВики": {"canonical": "MediaWiki"},
        "МедиаВики чугаа": {
            "canonical": "MediaWiki talk",
            "aliases": ["МедиаВики чугаазы"],
        },
        "Майык": {"canonical": "Template"},
        "Майык чугаа": {"canonical": "Template talk", "aliases": ["Майык чугаазы"]},
        "Дуза": {"canonical": "Help"},
        "Дуза чугаа": {"canonical": "Help talk", "aliases": ["Дуза чугаазы"]},
        "Аңгылал": {"canonical": "Category", "aliases": ["Категория"]},
        "Аңгылал чугаа": {
            "canonical": "Category talk",
            "aliases": ["Категория чугаазы"],
        },
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "udm": {
        "Медиа": {"canonical": "Media"},
        "Панель": {"canonical": "Special"},
        "Вераськон": {"canonical": "Talk"},
        "Викиавтор": {"canonical": "User"},
        "Викиавтор сярысь вераськон": {"canonical": "User talk"},
        "Википедия": {"canonical": "Project"},
        "Википедия сярысь вераськон": {"canonical": "Project talk"},
        "Файл": {"canonical": "File", "aliases": ["Изображение", "Суред"]},
        "Файл сярысь вераськон": {
            "canonical": "File talk",
            "aliases": ["Обсуждение изображения", "Суред сярысь вераськон"],
        },
        "MediaWiki сярысь вераськон": {"canonical": "MediaWiki talk"},
        "Шаблон": {"canonical": "Template"},
        "Шаблон сярысь вераськон": {"canonical": "Template talk"},
        "Валэктон": {"canonical": "Help"},
        "Валэктон сярысь вераськон": {"canonical": "Help talk"},
        "Категория": {"canonical": "Category"},
        "Категория сярысь вераськон": {"canonical": "Category talk"},
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "ug": {
        "ۋاسىتە": {"canonical": "Media"},
        "ئالاھىدە": {"canonical": "Special"},
        "مۇنازىرە": {"canonical": "Talk"},
        "ئىشلەتكۈچى": {"canonical": "User"},
        "ئىشلەتكۈچى مۇنازىرىسى": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Wikipediaمۇنازىرىسى": {
            "canonical": "Project talk",
            "aliases": ["مۇنازىرىسىWikipedia"],
        },
        "ھۆججەت": {"canonical": "File"},
        "ھۆججەت مۇنازىرىسى": {"canonical": "File talk"},
        "MediaWiki مۇنازىرىسى": {"canonical": "MediaWiki talk"},
        "قېلىپ": {"canonical": "Template"},
        "قېلىپ مۇنازىرىسى": {"canonical": "Template talk"},
        "ياردەم": {"canonical": "Help"},
        "ياردەم مۇنازىرىسى": {"canonical": "Help talk"},
        "تۈر": {"canonical": "Category"},
        "تۈر مۇنازىرىسى": {"canonical": "Category talk"},
    },
    "uk": {
        "Медіа": {"canonical": "Media", "aliases": ["Медиа"]},
        "Спеціальна": {"canonical": "Special", "aliases": ["Служебная", "Спеціальні"]},
        "Обговорення": {"canonical": "Talk", "aliases": ["Обсуждение"]},
        "Користувач": {"canonical": "User", "aliases": ["Користувачка", "Участник"]},
        "Обговорення користувача": {
            "canonical": "User talk",
            "aliases": ["Обговорення користувачки", "Обсуждение участника"],
        },
        "Вікіпедія": {"canonical": "Project", "aliases": ["ВП"]},
        "Обговорення Вікіпедії": {"canonical": "Project talk"},
        "Файл": {"canonical": "File", "aliases": ["Зображення", "Изображение"]},
        "Обговорення файлу": {
            "canonical": "File talk",
            "aliases": [
                "Обговорення зображення",
                "Обсуждение изображения",
                "Обсуждение файла",
            ],
        },
        "Обговорення MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Обсуждение MediaWiki"],
        },
        "Шаблон": {"canonical": "Template"},
        "Обговорення шаблону": {
            "canonical": "Template talk",
            "aliases": ["Обговорення шаблона", "Обсуждение шаблона"],
        },
        "Довідка": {"canonical": "Help", "aliases": ["Справка"]},
        "Обговорення довідки": {
            "canonical": "Help talk",
            "aliases": ["Обсуждение справки"],
        },
        "Категорія": {"canonical": "Category", "aliases": ["Категория"]},
        "Обговорення категорії": {
            "canonical": "Category talk",
            "aliases": ["Обсуждение категории"],
        },
        "Портал": {},
        "Обговорення порталу": {},
        "Education Program": {},
        "Education Program talk": {},
        "Модуль": {"canonical": "Module"},
        "Обговорення модуля": {"canonical": "Module talk"},
    },
    "ur": {
        "میڈیا": {"canonical": "Media", "aliases": ["زریعہ", "وسیط"]},
        "خاص": {"canonical": "Special"},
        "تبادلۂ خیال": {"canonical": "Talk"},
        "صارف": {"canonical": "User"},
        "تبادلۂ خیال صارف": {"canonical": "User talk"},
        "ویکیپیڈیا": {"canonical": "Project", "aliases": ["وپ"]},
        "تبادلۂ خیال ویکیپیڈیا": {
            "canonical": "Project talk",
            "aliases": ["ویکیپیڈیا تبادلۂ خیال"],
        },
        "فائل": {"canonical": "File", "aliases": ["تصویر", "ملف"]},
        "تبادلۂ خیال فائل": {
            "canonical": "File talk",
            "aliases": ["تبادلۂ خیال تصویر", "تبادلۂ خیال ملف"],
        },
        "میڈیاویکی": {"canonical": "MediaWiki", "aliases": ["میڈیاوکی"]},
        "تبادلۂ خیال میڈیاویکی": {
            "canonical": "MediaWiki talk",
            "aliases": ["تبادلۂ خیال میڈیاوکی"],
        },
        "سانچہ": {"canonical": "Template"},
        "تبادلۂ خیال سانچہ": {"canonical": "Template talk"},
        "معاونت": {"canonical": "Help"},
        "تبادلۂ خیال معاونت": {"canonical": "Help talk"},
        "زمرہ": {"canonical": "Category"},
        "تبادلۂ خیال زمرہ": {"canonical": "Category talk"},
        "باب": {"aliases": ["Portal"]},
        "تبادلۂ خیال باب": {"aliases": ["Portal talk"]},
        "کتاب": {},
        "تبادلۂ خیال کتاب": {},
        "مسودہ": {"aliases": ["Draft"]},
        "تبادلۂ خیال مسودہ": {"aliases": ["Draft talk"]},
        "ماڈیول": {"canonical": "Module"},
        "تبادلۂ خیال ماڈیول": {"canonical": "Module talk"},
        "آلہ": {"canonical": "Gadget"},
        "تبادلۂ خیال آلہ": {"canonical": "Gadget talk"},
        "تعریف آلہ": {"canonical": "Gadget definition"},
        "تبادلۂ خیال تعریف آلہ": {"canonical": "Gadget definition talk"},
        "موضوع": {"canonical": "Topic"},
    },
    "uz": {
        "Media": {"aliases": ["Mediya"]},
        "Maxsus": {"canonical": "Special"},
        "Munozara": {"canonical": "Talk"},
        "Foydalanuvchi": {"canonical": "User"},
        "Foydalanuvchi munozarasi": {"canonical": "User talk"},
        "Vikipediya": {"canonical": "Project", "aliases": ["VP"]},
        "Vikipediya munozarasi": {
            "canonical": "Project talk",
            "aliases": ["VM", "Vikipediya talk"],
        },
        "Fayl": {"canonical": "File", "aliases": ["Tasvir"]},
        "Fayl munozarasi": {"canonical": "File talk", "aliases": ["Tasvir munozarasi"]},
        "MediaWiki": {"aliases": ["MediyaViki"]},
        "MediaWiki munozarasi": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediyaViki munozarasi"],
        },
        "Andoza": {"canonical": "Template", "aliases": ["Shablon"]},
        "Andoza munozarasi": {
            "canonical": "Template talk",
            "aliases": ["Shablon munozarasi"],
        },
        "Yordam": {"canonical": "Help"},
        "Yordam munozarasi": {"canonical": "Help talk"},
        "Turkum": {"canonical": "Category", "aliases": ["Kategoriya"]},
        "Turkum munozarasi": {
            "canonical": "Category talk",
            "aliases": ["Kategoriya munozarasi"],
        },
        "Portal munozarasi": {"aliases": ["Portal munozarasi"]},
        "Loyiha": {},
        "Loyiha munozarasi": {"aliases": ["Loyiha munozarasi"]},
    },
    "ve": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "vec": {
        "Mèdia": {"canonical": "Media"},
        "Speçałe": {"canonical": "Special", "aliases": ["Speciale"]},
        "Discusion": {"canonical": "Talk", "aliases": ["Discussion"]},
        "Utensa": {"canonical": "User", "aliases": ["Utente"]},
        "Discusion Utensa": {
            "canonical": "User talk",
            "aliases": ["Discussion utente"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Discusion Wikipedia": {
            "canonical": "Project talk",
            "aliases": ["Discussion Wikipedia"],
        },
        "File": {"aliases": ["Immagine", "Imàjine"]},
        "Discusion File": {
            "canonical": "File talk",
            "aliases": [
                "Discusion Imàjine",
                "Discussion file",
                "Discussion imagine",
                "Discussioni immagine",
            ],
        },
        "Discusion MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Discussion MediaWiki"],
        },
        "Modeło": {"canonical": "Template", "aliases": ["Modèl"]},
        "Discusion Modeło": {
            "canonical": "Template talk",
            "aliases": ["Discussion modèl", "Discussion template"],
        },
        "Juto": {"canonical": "Help", "aliases": ["Aiuto", "Ajuto"]},
        "Discusion Juto": {
            "canonical": "Help talk",
            "aliases": ["Discussion aiuto", "Discussion ajuto"],
        },
        "Categoria": {"canonical": "Category"},
        "Discusion Categoria": {
            "canonical": "Category talk",
            "aliases": ["Discussion categoria"],
        },
        "Portałe": {},
        "Discussion portałe": {},
        "Projeto": {},
        "Discussion projeto": {},
        "Modulo": {"canonical": "Module"},
        "Discussioni modulo": {"canonical": "Module talk"},
        "Accessorio": {"canonical": "Gadget"},
        "Discussioni accessorio": {"canonical": "Gadget talk"},
        "Definizione accessorio": {"canonical": "Gadget definition"},
        "Discussioni definizione accessorio": {"canonical": "Gadget definition talk"},
    },
    "vep": {
        "Specialine": {"canonical": "Special"},
        "Lodu": {"canonical": "Talk"},
        "Kävutai": {"canonical": "User"},
        "Lodu kävutajas": {"canonical": "User talk"},
        "Vikipedii": {"canonical": "Project"},
        "Paginad Vikipedii": {
            "canonical": "Project talk",
            "aliases": ["Vikipedii arutelu"],
        },
        "Fail": {"canonical": "File", "aliases": ["Pilt"]},
        "Lodu failas": {"canonical": "File talk", "aliases": ["Pildi arutelu"]},
        "Lodu MediaWikiš": {"canonical": "MediaWiki talk"},
        "Šablon": {"canonical": "Template"},
        "Lodu šablonas": {"canonical": "Template talk"},
        "Abu": {"canonical": "Help"},
        "Lodu abus": {"canonical": "Help talk"},
        "Kategorii": {"canonical": "Category"},
        "Lodu kategorijas": {"canonical": "Category talk"},
        "Moodul": {"canonical": "Module"},
        "Mooduli arutelu": {"canonical": "Module talk"},
        "Tööriist": {"canonical": "Gadget"},
        "Tööriista arutelu": {"canonical": "Gadget talk"},
        "Tööriista määratlus": {"canonical": "Gadget definition"},
        "Tööriista määratluse arutelu": {"canonical": "Gadget definition talk"},
    },
    "vi": {
        "Phương tiện": {"canonical": "Media"},
        "Đặc biệt": {"canonical": "Special"},
        "Thảo luận": {"canonical": "Talk"},
        "Thành viên": {"canonical": "User"},
        "Thảo luận Thành viên": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Thảo luận Wikipedia": {"canonical": "Project talk"},
        "Tập tin": {"canonical": "File", "aliases": ["Hình"]},
        "Thảo luận Tập tin": {"canonical": "File talk", "aliases": ["Thảo luận Hình"]},
        "Thảo luận MediaWiki": {"canonical": "MediaWiki talk"},
        "Bản mẫu": {"canonical": "Template", "aliases": ["Tiêu bản"]},
        "Thảo luận Bản mẫu": {
            "canonical": "Template talk",
            "aliases": ["Thảo luận Tiêu bản"],
        },
        "Trợ giúp": {"canonical": "Help"},
        "Thảo luận Trợ giúp": {"canonical": "Help talk"},
        "Thể loại": {"canonical": "Category"},
        "Thảo luận Thể loại": {"canonical": "Category talk"},
        "Cổng thông tin": {"aliases": ["Chủ đề"]},
        "Thảo luận Cổng thông tin": {"aliases": ["Thảo luận Chủ đề"]},
        "Mô đun": {"canonical": "Module"},
        "Thảo luận Mô đun": {"canonical": "Module talk"},
        "Tiện ích": {"canonical": "Gadget"},
        "Thảo luận Tiện ích": {"canonical": "Gadget talk"},
        "Định nghĩa tiện ích": {"canonical": "Gadget definition"},
        "Thảo luận Định nghĩa tiện ích": {"canonical": "Gadget definition talk"},
    },
    "vls": {
        "Specioal": {"canonical": "Special"},
        "Discuusje": {"canonical": "Talk"},
        "Gebruker": {"canonical": "User"},
        "Discuusje gebruker": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Discuusje Wikipedia": {"canonical": "Project talk"},
        "Ofbeeldienge": {"canonical": "File", "aliases": ["Afbeelding"]},
        "Discuusje ofbeeldienge": {
            "canonical": "File talk",
            "aliases": ["Overleg afbeelding"],
        },
        "Discuusje MediaWiki": {"canonical": "MediaWiki talk"},
        "Patrôon": {"canonical": "Template"},
        "Discuusje patrôon": {"canonical": "Template talk"},
        "Ulpe": {"canonical": "Help"},
        "Discuusje ulpe": {"canonical": "Help talk"},
        "Categorie": {"canonical": "Category"},
        "Discuusje categorie": {"canonical": "Category talk"},
        "Overleg module": {"canonical": "Module talk"},
        "Uitbreiding": {"canonical": "Gadget"},
        "Overleg uitbreiding": {"canonical": "Gadget talk"},
        "Uitbreidingsdefinitie": {"canonical": "Gadget definition"},
        "Overleg uitbreidingsdefinitie": {"canonical": "Gadget definition talk"},
    },
    "vo": {
        "Nünamakanäd": {"canonical": "Media"},
        "Patikos": {"canonical": "Special"},
        "Bespik": {"canonical": "Talk"},
        "Geban": {"canonical": "User"},
        "Gebanibespik": {"canonical": "User talk"},
        "Vükiped": {"canonical": "Project"},
        "Bespik dö Vükiped": {"canonical": "Project talk"},
        "Ragiv": {"canonical": "File", "aliases": ["Magod"]},
        "Ragivibespik": {"canonical": "File talk", "aliases": ["Magodibespik"]},
        "Sitanuns": {"canonical": "MediaWiki"},
        "Bespik dö sitanuns": {"canonical": "MediaWiki talk"},
        "Samafomot": {"canonical": "Template"},
        "Samafomotibespik": {"canonical": "Template talk"},
        "Yuf": {"canonical": "Help"},
        "Yufibespik": {"canonical": "Help talk"},
        "Klad": {"canonical": "Category"},
        "Kladibespik": {"canonical": "Category talk"},
    },
    "wa": {
        "Sipeciås": {"canonical": "Special"},
        "Copene": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Uzeu": {"canonical": "User"},
        "Uzeu copene": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia copene": {"canonical": "Project talk"},
        "Imådje": {"canonical": "File"},
        "Imådje copene": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "MediaWiki copene": {"canonical": "MediaWiki talk"},
        "Modele": {"canonical": "Template"},
        "Modele copene": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Aidance": {"canonical": "Help"},
        "Aidance copene": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Categoreye": {"canonical": "Category"},
        "Categoreye copene": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
        "Sujet": {"canonical": "Topic"},
    },
    "war": {
        "Medya": {"canonical": "Media"},
        "Pinaurog": {"canonical": "Special"},
        "Hiruhimangraw": {"canonical": "Talk"},
        "Gumaramit": {"canonical": "User"},
        "Hiruhimangaw hiton gumaramit": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Hiruhimangraw hiton Wikipedia": {"canonical": "Project talk"},
        "Paypay": {"canonical": "File", "aliases": ["Fayl"]},
        "Hiruhimangraw hiton paypay": {
            "canonical": "File talk",
            "aliases": ["Hiruhimangraw hiton fayl"],
        },
        "MedyaWiki": {"canonical": "MediaWiki"},
        "Hiruhimangraw hiton MedyaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Hiruhimangraw hiton MediaWiki"],
        },
        "Batakan": {"canonical": "Template"},
        "Hiruhimangraw hiton batakan": {"canonical": "Template talk"},
        "Bulig": {"canonical": "Help"},
        "Hiruhimangaw hiton bulig": {"canonical": "Help talk"},
        "Kaarangay": {"canonical": "Category"},
        "Hiruhimangraw hiton kaarangay": {"canonical": "Category talk"},
    },
    "wo": {
        "Xibaarukaay": {"canonical": "Media"},
        "Jagleel": {"canonical": "Special"},
        "Waxtaan": {"canonical": "Talk", "aliases": ["Discuter"]},
        "Jëfandikukat": {"canonical": "User", "aliases": ["Utilisateur"]},
        "Waxtaani jëfandikukat": {
            "canonical": "User talk",
            "aliases": ["Discussion Utilisateur"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia waxtaan": {
            "canonical": "Project talk",
            "aliases": ["Discussion Wikipedia"],
        },
        "Dencukaay": {"canonical": "File"},
        "Waxtaani dencukaay": {
            "canonical": "File talk",
            "aliases": ["Discussion Fichier", "Discussion Image"],
        },
        "Waxtaani MediaWiki": {
            "canonical": "MediaWiki talk",
            "aliases": ["Discussion MediaWiki"],
        },
        "Royuwaay": {"canonical": "Template", "aliases": ["Modèle"]},
        "Waxtaani royuwaay": {
            "canonical": "Template talk",
            "aliases": ["Discussion Modèle"],
        },
        "Ndimbal": {"canonical": "Help", "aliases": ["Aide"]},
        "Waxtaani ndimbal": {"canonical": "Help talk", "aliases": ["Discussion Aide"]},
        "Wàll": {"canonical": "Category", "aliases": ["Catégorie"]},
        "Waxtaani wàll": {
            "canonical": "Category talk",
            "aliases": ["Discussion Catégorie"],
        },
        "Discussion module": {"canonical": "Module talk"},
        "Discussion gadget": {"canonical": "Gadget talk"},
        "Définition de gadget": {"canonical": "Gadget definition"},
        "Discussion définition de gadget": {"canonical": "Gadget definition talk"},
    },
    "wuu": {
        "Media": {"aliases": ["媒体", "媒體"]},
        "Special": {"aliases": ["特殊"]},
        "Talk": {"aliases": ["对话", "對話", "討論", "讨论"]},
        "User": {"aliases": ["用戶", "用户"]},
        "User talk": {"aliases": ["用戶對話", "用戶討論", "用户对话", "用户讨论"]},
        "Wikipedia": {"canonical": "Project", "aliases": ["维基百科"]},
        "Wikipedia talk": {"canonical": "Project talk"},
        "File": {"aliases": ["图像", "圖像", "文件", "档案", "檔案"]},
        "File talk": {
            "aliases": [
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "文件对话",
                "文件對話",
                "文件討論",
                "文件讨论",
                "档案对话",
                "档案讨论",
                "檔案對話",
                "檔案討論",
            ]
        },
        "Template": {"aliases": ["T", "样板", "模板", "樣板"]},
        "Template talk": {
            "aliases": ["样板对话", "样板讨论", "模板对话", "模板對話", "模板討論", "模板讨论", "樣板對話", "樣板討論"]
        },
        "Help": {"aliases": ["帮助", "幫助"]},
        "Help talk": {"aliases": ["帮助对话", "帮助讨论", "幫助對話", "幫助討論"]},
        "Category": {"aliases": ["分类", "分類"]},
        "Category talk": {"aliases": ["分类对话", "分类讨论", "分類對話", "分類討論"]},
        "模块": {"canonical": "Module", "aliases": ["模塊", "模組", "模组"]},
        "模块讨论": {
            "canonical": "Module talk",
            "aliases": ["模块对话", "模塊對話", "模塊討論", "模組對話", "模組討論", "模组对话", "模组讨论"],
        },
    },
    "xal": {
        "Аһар": {"canonical": "Media"},
        "Көдлхнә": {"canonical": "Special", "aliases": ["Көдлхнə"]},
        "Меткән": {"canonical": "Talk", "aliases": ["Ухалвр"]},
        "Демнч": {"canonical": "User", "aliases": ["Орлцач"]},
        "Демнчна туск меткән": {
            "canonical": "User talk",
            "aliases": ["Орлцачна тускар ухалвр"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia туск меткән": {
            "canonical": "Project talk",
            "aliases": ["Wikipedia тускар ухалвр"],
        },
        "Боомг": {"canonical": "File", "aliases": ["Зург", "Изображение"]},
        "Боомгин туск меткән": {
            "canonical": "File talk",
            "aliases": ["Зургин тускар ухалвр", "Обсуждение изображения"],
        },
        "MediaWiki туск меткән": {
            "canonical": "MediaWiki talk",
            "aliases": ["MediaWiki тускар ухалвр"],
        },
        "Кевләр": {"canonical": "Template", "aliases": ["Зура"]},
        "Зуран туск меткән": {
            "canonical": "Template talk",
            "aliases": ["Зуран тускар ухалвр"],
        },
        "Цәәлһлһн": {"canonical": "Help", "aliases": ["Цəəлһлһн"]},
        "Цәәлһлһин туск меткән": {
            "canonical": "Help talk",
            "aliases": ["Цəəлһлһин тускар ухалвр"],
        },
        "Әәшл": {"canonical": "Category", "aliases": ["Янз"]},
        "Әәшлин туск меткән": {
            "canonical": "Category talk",
            "aliases": ["Янзин тускар ухалвр"],
        },
        "Модуль": {"canonical": "Module"},
        "Обсуждение модуля": {"canonical": "Module talk"},
        "Гаджет": {"canonical": "Gadget"},
        "Обсуждение гаджета": {"canonical": "Gadget talk"},
        "Определение гаджета": {"canonical": "Gadget definition"},
        "Обсуждение определения гаджета": {"canonical": "Gadget definition talk"},
    },
    "xh": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
    "xmf": {
        "მედია": {"canonical": "Media"},
        "სპეციალური": {"canonical": "Special"},
        "განხილვა": {"canonical": "Talk"},
        "მომხმარებელი": {"canonical": "User", "aliases": ["მონაწილე"]},
        "მომხმარებლის განხილვა": {
            "canonical": "User talk",
            "aliases": ["მომხმარებელი განხილვა", "მონაწილის განხილვა"],
        },
        "ვიკიპედია": {"canonical": "Project"},
        "ვიკიპედია სხუნუა": {"canonical": "Project talk"},
        "ფაილი": {"canonical": "File", "aliases": ["სურათი"]},
        "ფაილის განხილვა": {"canonical": "File talk", "aliases": ["სურათი განხილვა"]},
        "მედიავიკი": {"canonical": "MediaWiki"},
        "მედიავიკის განხილვა": {
            "canonical": "MediaWiki talk",
            "aliases": ["მედიავიკი განხილვა"],
        },
        "თარგი": {"canonical": "Template"},
        "თარგის განხილვა": {
            "canonical": "Template talk",
            "aliases": ["თარგი განხილვა"],
        },
        "დახმარება": {"canonical": "Help"},
        "დახმარების განხილვა": {
            "canonical": "Help talk",
            "aliases": ["დახმარება განხილვა"],
        },
        "კატეგორია": {"canonical": "Category"},
        "კატეგორიის განხილვა": {
            "canonical": "Category talk",
            "aliases": ["კატეგორია განხილვა"],
        },
        "მოდული": {"canonical": "Module"},
        "მოდულის განხილვა": {"canonical": "Module talk"},
    },
    "yi": {
        "מעדיע": {"canonical": "Media"},
        "באַזונדער": {"canonical": "Special", "aliases": ["באזונדער"]},
        "רעדן": {"canonical": "Talk"},
        "באַניצער": {
            "canonical": "User",
            "aliases": ["באַניצערין", "באנוצער", "באניצער", "משתמש", "משתמשת"],
        },
        "באַניצער רעדן": {
            "canonical": "User talk",
            "aliases": [
                "באַניצערין רעדן",
                "באנוצער רעדן",
                "באניצער רעדן",
                "שיחת משתמש",
                "שיחת משתמשת",
            ],
        },
        "װיקיפּעדיע": {"canonical": "Project", "aliases": ["וויקיפעדיע"]},
        "װיקיפּעדיע רעדן": {
            "canonical": "Project talk",
            "aliases": ["וויקיפעדיע רעדן"],
        },
        "טעקע": {"canonical": "File", "aliases": ["בילד", "תמונה"]},
        "טעקע רעדן": {"canonical": "File talk", "aliases": ["בילד רעדן", "שיחת תמונה"]},
        "מעדיעװיקי": {"canonical": "MediaWiki", "aliases": ["מעדיעוויקי"]},
        "מעדיעװיקי רעדן": {
            "canonical": "MediaWiki talk",
            "aliases": ["מעדיעוויקי רעדן"],
        },
        "מוסטער": {"canonical": "Template"},
        "מוסטער רעדן": {"canonical": "Template talk"},
        "הילף": {"canonical": "Help"},
        "הילף רעדן": {"canonical": "Help talk"},
        "קאַטעגאָריע": {"canonical": "Category", "aliases": ["קאטעגאריע"]},
        "קאַטעגאָריע רעדן": {
            "canonical": "Category talk",
            "aliases": ["קאטעגאריע רעדן"],
        },
        "פארטאל": {},
        "פארטאל רעדן": {},
        "יחידה": {"canonical": "Module"},
        "שיחת יחידה": {"canonical": "Module talk"},
        "גאדג'ט": {"canonical": "Gadget"},
        "שיחת גאדג'ט": {"canonical": "Gadget talk"},
        "הגדרת גאדג'ט": {"canonical": "Gadget definition"},
        "שיחת הגדרת גאדג'ט": {"canonical": "Gadget definition talk"},
    },
    "yo": {
        "Amóhùnmáwòrán": {"canonical": "Media"},
        "Pàtàkì": {"canonical": "Special"},
        "Ọ̀rọ̀": {"canonical": "Talk"},
        "Oníṣe": {"canonical": "User"},
        "Ọ̀rọ̀ oníṣe": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Ọ̀rọ̀ Wikipedia": {"canonical": "Project talk"},
        "Fáìlì": {"canonical": "File", "aliases": ["Àwòrán"]},
        "Ọ̀rọ̀ fáìlì": {"canonical": "File talk", "aliases": ["Ọ̀rọ̀ àwòrán"]},
        "Ọ̀rọ̀ mediaWiki": {"canonical": "MediaWiki talk"},
        "Àdàkọ": {"canonical": "Template"},
        "Ọ̀rọ̀ àdàkọ": {"canonical": "Template talk"},
        "Ìrànlọ́wọ́": {"canonical": "Help"},
        "Ọ̀rọ̀ ìrànlọ́wọ́": {"canonical": "Help talk"},
        "Ẹ̀ka": {"canonical": "Category"},
        "Ọ̀rọ̀ ẹ̀ka": {"canonical": "Category talk"},
        "Èbúté": {"aliases": ["Portal"]},
        "Ọ̀rọ̀ èbúté": {"aliases": ["Portal talk"]},
        "Ìwé": {"aliases": ["Book"]},
        "Ọ̀rọ̀ ìwé": {"aliases": ["Book talk"]},
    },
    "za": {
        "媒体文件": {"canonical": "Media", "aliases": ["媒体", "媒體"]},
        "特殊": {"canonical": "Special"},
        "讨论": {"canonical": "Talk", "aliases": ["对话", "對話", "討論"]},
        "用户": {"canonical": "User", "aliases": ["用戶"]},
        "用户讨论": {"canonical": "User talk", "aliases": ["用戶對話", "用戶討論", "用户对话"]},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia讨论": {"canonical": "Project talk"},
        "文件": {"canonical": "File", "aliases": ["图像", "圖像", "档案", "檔案"]},
        "文件讨论": {
            "canonical": "File talk",
            "aliases": [
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "文件对话",
                "文件對話",
                "文件討論",
                "档案对话",
                "档案讨论",
                "檔案對話",
                "檔案討論",
            ],
        },
        "MediaWiki讨论": {"canonical": "MediaWiki talk"},
        "模板": {"canonical": "Template", "aliases": ["样板", "樣板"]},
        "模板讨论": {
            "canonical": "Template talk",
            "aliases": ["样板对话", "样板讨论", "模板对话", "模板對話", "模板討論", "樣板對話", "樣板討論"],
        },
        "帮助": {"canonical": "Help", "aliases": ["幫助"]},
        "帮助讨论": {"canonical": "Help talk", "aliases": ["帮助对话", "幫助對話", "幫助討論"]},
        "分类": {"canonical": "Category", "aliases": ["分類"]},
        "分类讨论": {"canonical": "Category talk", "aliases": ["分类对话", "分類對話", "分類討論"]},
        "模块": {"canonical": "Module", "aliases": ["模塊", "模組", "模组"]},
        "模块讨论": {
            "canonical": "Module talk",
            "aliases": ["模块对话", "模塊對話", "模塊討論", "模組對話", "模組討論", "模组对话", "模组讨论"],
        },
    },
    "zea": {
        "Speciaol": {"canonical": "Special"},
        "Overleg": {"canonical": "Talk"},
        "Gebruker": {"canonical": "User"},
        "Overleg gebruker": {"canonical": "User talk"},
        "Wikipedia": {"canonical": "Project"},
        "Overleg Wikipedia": {"canonical": "Project talk"},
        "Plaetje": {"canonical": "File", "aliases": ["Afbeelding"]},
        "Overleg plaetje": {
            "canonical": "File talk",
            "aliases": ["Overleg afbeelding"],
        },
        "Overleg MediaWiki": {"canonical": "MediaWiki talk"},
        "Sjabloon": {"canonical": "Template"},
        "Overleg sjabloon": {"canonical": "Template talk"},
        "Ulpe": {"canonical": "Help"},
        "Overleg ulpe": {"canonical": "Help talk"},
        "Categorie": {"canonical": "Category"},
        "Overleg categorie": {"canonical": "Category talk"},
        "Overleg module": {"canonical": "Module talk"},
        "Uitbreiding": {"canonical": "Gadget"},
        "Overleg uitbreiding": {"canonical": "Gadget talk"},
        "Uitbreidingsdefinitie": {"canonical": "Gadget definition"},
        "Overleg uitbreidingsdefinitie": {"canonical": "Gadget definition talk"},
    },
    "zh": {
        "Media": {"aliases": ["媒体", "媒体文件", "媒體"]},
        "Special": {"aliases": ["特殊"]},
        "Talk": {"aliases": ["对话", "對話", "討論", "讨论"]},
        "User": {"aliases": ["U", "使用者", "用戶", "用户"]},
        "User talk": {"aliases": ["UT", "使用者討論", "用戶對話", "用戶討論", "用户对话", "用户讨论"]},
        "Wikipedia": {"canonical": "Project", "aliases": ["維基百科", "维基百科"]},
        "Wikipedia talk": {
            "canonical": "Project talk",
            "aliases": ["維基百科對話", "維基百科討論", "维基百科对话", "维基百科讨论"],
        },
        "File": {"aliases": ["F", "图像", "圖像", "圖片", "文件", "档案", "檔案"]},
        "File talk": {
            "aliases": [
                "FT",
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "圖片討論",
                "文件对话",
                "文件對話",
                "文件討論",
                "文件讨论",
                "档案对话",
                "档案讨论",
                "檔案對話",
                "檔案討論",
            ]
        },
        "MediaWiki talk": {"aliases": ["MediaWiki討論", "MediaWiki讨论"]},
        "Template": {"aliases": ["T", "样板", "模板", "樣板"]},
        "Template talk": {
            "aliases": ["样板对话", "样板讨论", "模板对话", "模板對話", "模板討論", "模板讨论", "樣板對話", "樣板討論"]
        },
        "Help": {"aliases": ["H", "使用說明", "帮助", "幫助"]},
        "Help talk": {"aliases": ["使用說明討論", "帮助对话", "帮助讨论", "幫助對話", "幫助討論"]},
        "Category": {"aliases": ["CAT", "分类", "分類"]},
        "Category talk": {"aliases": ["分类对话", "分类讨论", "分類對話", "分類討論"]},
        "Portal": {"aliases": ["P", "主題", "主题"]},
        "Portal talk": {"aliases": ["主題對話", "主題討論", "主题对话", "主题讨论"]},
        "WikiProject": {"aliases": ["PJ", "WPJ", "专题", "專題", "維基專題", "维基专题"]},
        "WikiProject talk": {
            "aliases": [
                "PJT",
                "WPJT",
                "专题对话",
                "专题讨论",
                "專題對話",
                "專題討論",
                "維基專題對話",
                "維基專題討論",
                "维基专题对话",
                "维基专题讨论",
            ]
        },
        "Draft": {"aliases": ["草稿"]},
        "Draft talk": {"aliases": ["草稿討論", "草稿讨论"]},
        "Module": {"aliases": ["模块", "模塊", "模組", "模组"]},
        "Module talk": {
            "aliases": ["模块对话", "模块讨论", "模塊對話", "模塊討論", "模組對話", "模組討論", "模组对话", "模组讨论"]
        },
        "Topic": {"aliases": ["話題", "话题"]},
    },
    "zh-classical": {
        "媒體": {"canonical": "Media", "aliases": ["媒体"]},
        "特殊": {"canonical": "Special"},
        "討論": {"canonical": "Talk", "aliases": ["对话", "對話", "讨论"]},
        "用戶": {"canonical": "User", "aliases": ["用户"]},
        "用戶討論": {"canonical": "User talk", "aliases": ["用戶對話", "用户对话", "用户讨论"]},
        "維基大典": {"canonical": "Project"},
        "維基大典討論": {"canonical": "Project talk"},
        "檔案": {"canonical": "File", "aliases": ["图像", "圖像", "文件", "档案"]},
        "檔案討論": {
            "canonical": "File talk",
            "aliases": [
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "文件对话",
                "文件對話",
                "文件討論",
                "文件讨论",
                "档案对话",
                "档案讨论",
                "檔案對話",
            ],
        },
        "MediaWiki討論": {"canonical": "MediaWiki talk"},
        "模板": {"canonical": "Template", "aliases": ["T", "样板", "樣板"]},
        "模板討論": {
            "canonical": "Template talk",
            "aliases": ["样板对话", "样板讨论", "模板对话", "模板對話", "模板讨论", "樣板對話", "樣板討論"],
        },
        "幫助": {"canonical": "Help", "aliases": ["H", "帮助"]},
        "幫助討論": {"canonical": "Help talk", "aliases": ["帮助对话", "帮助讨论", "幫助對話"]},
        "分類": {"canonical": "Category", "aliases": ["CAT", "分类"]},
        "分類討論": {"canonical": "Category talk", "aliases": ["分类对话", "分类讨论", "分類對話"]},
        "門": {"aliases": ["P", "Portal"]},
        "議": {"aliases": ["Portal talk"]},
        "稿": {"aliases": ["Draft"]},
        "酌稿": {"aliases": ["Draft talk"]},
        "模組": {"canonical": "Module", "aliases": ["模块", "模塊", "模组"]},
        "模組討論": {
            "canonical": "Module talk",
            "aliases": ["模块对话", "模块讨论", "模塊對話", "模塊討論", "模組對話", "模组对话", "模组讨论"],
        },
    },
    "zh-min-nan": {
        "Mûi-thé": {"canonical": "Media", "aliases": ["媒体", "媒體"]},
        "Tek-pia̍t": {"canonical": "Special", "aliases": ["特殊"]},
        "Thó-lūn": {"canonical": "Talk", "aliases": ["对话", "對話", "討論", "讨论"]},
        "Iōng-chiá": {"canonical": "User", "aliases": ["用戶", "用户"]},
        "Iōng-chiá thó-lūn": {
            "canonical": "User talk",
            "aliases": ["用戶對話", "用戶討論", "用户对话", "用户讨论"],
        },
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia thó-lūn": {"canonical": "Project talk", "aliases": ["Wikipedia討論"]},
        "tóng-àn": {"canonical": "File", "aliases": ["图像", "圖像", "文件", "档案", "檔案"]},
        "tóng-àn thó-lūn": {
            "canonical": "File talk",
            "aliases": [
                "图像对话",
                "图像讨论",
                "圖像對話",
                "圖像討論",
                "文件对话",
                "文件對話",
                "文件討論",
                "文件讨论",
                "档案对话",
                "档案讨论",
                "檔案對話",
                "檔案討論",
            ],
        },
        "MediaWiki": {"aliases": ["媒體維基"]},
        "MediaWiki thó-lūn": {"canonical": "MediaWiki talk", "aliases": ["媒體維基討論"]},
        "Pang-bô͘": {"canonical": "Template", "aliases": ["样板", "模板", "樣板"]},
        "Pang-bô͘ thó-lūn": {
            "canonical": "Template talk",
            "aliases": ["样板对话", "样板讨论", "模板对话", "模板對話", "模板討論", "模板讨论", "樣板對話", "樣板討論"],
        },
        "Pang-chān": {"canonical": "Help", "aliases": ["帮助", "幫助"]},
        "Pang-chān thó-lūn": {
            "canonical": "Help talk",
            "aliases": ["帮助对话", "帮助讨论", "幫助對話", "幫助討論"],
        },
        "Lūi-pia̍t": {"canonical": "Category", "aliases": ["分类", "分類"]},
        "Lūi-pia̍t thó-lūn": {
            "canonical": "Category talk",
            "aliases": ["分类对话", "分类讨论", "分類對話", "分類討論"],
        },
        "模組": {"canonical": "Module", "aliases": ["模块", "模塊", "模组"]},
        "模組討論": {
            "canonical": "Module talk",
            "aliases": ["模块对话", "模块讨论", "模塊對話", "模塊討論", "模組對話", "模组对话", "模组讨论"],
        },
    },
    "zh-yue": {
        "Media": {"aliases": ["媒体", "媒體"]},
        "Special": {"aliases": ["特別", "特殊"]},
        "Talk": {"aliases": ["傾偈", "对话", "對話", "討論", "讨论"]},
        "User": {"aliases": ["用戶", "用户"]},
        "User talk": {"aliases": ["用戶 對話", "用戶 討論", "用戶傾偈", "用户 对话", "用户 讨论"]},
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {
            "canonical": "Project talk",
            "aliases": ["$1 傾偈", "Wikipedia 傾偈"],
        },
        "File": {"aliases": ["图", "图像", "圖", "圖像", "文件", "档", "档案", "檔", "檔案"]},
        "File talk": {
            "aliases": [
                "图 讨论",
                "图像 讨论",
                "圖 討論",
                "圖像 討論",
                "文件傾偈",
                "档 讨论",
                "档案 讨论",
                "檔 討論",
                "檔案 討論",
            ]
        },
        "MediaWiki talk": {"aliases": ["MediaWiki 傾偈"]},
        "Template": {"aliases": ["T", "模"]},
        "Template talk": {"aliases": ["模 討論", "模 讨论", "模傾偈"]},
        "Help": {"aliases": ["H", "帮助", "帮手", "幫助", "幫手", "說明", "说明"]},
        "Help talk": {
            "aliases": ["帮助 讨论", "帮手 讨论", "幫助 討論", "幫手 討論", "幫手傾偈", "說明 討論", "说明 讨论"]
        },
        "Category": {"aliases": ["分类", "分類", "类", "類"]},
        "Category talk": {"aliases": ["分类 讨论", "分類 討論", "分類傾偈", "类 讨论", "類 討論"]},
        "Portal": {"aliases": ["P"]},
        "模組": {"canonical": "Module"},
        "模組討論": {"canonical": "Module talk"},
    },
    "zu": {
        "Wikipedia": {"canonical": "Project"},
        "Wikipedia talk": {"canonical": "Project talk"},
    },
}
