---
id: configuration
title: 구성
sidebar_position: 8
---

# 구성

환경과 사용 사례에 맞게 Synapse SDK를 구성하세요.

## 구성 방법

Synapse SDK를 구성하는 세 가지 방법이 있습니다:

1. **Synapse CLI**
2. **환경 변수**
3. **구성 파일**

## CLI

대화형 구성 메뉴는 Synapse SDK를 구성하는 쉬운 방법을 제공합니다:

```bash
$ synapse config
```

다음을 수행할 수 있는 대화형 메뉴가 열립니다:
- 백엔드 호스트 및 API 토큰 구성
- 에이전트 선택 또는 수동 구성
- 현재 구성 보기

### 주요 기능:
- **일반 텍스트 토큰 표시**: 쉬운 검증을 위해 토큰이 일반 텍스트로 표시됩니다
- **연결 테스트**: 백엔드 또는 에이전트 구성 후 연결이 자동으로 테스트됩니다
- **시작 지연 없음**: 연결 확인은 설정 구성 시에만 발생하며, CLI 시작 시에는 발생하지 않습니다

## 구성 파일

`~/.synapse/config.json`에 구성 파일을 생성하세요:

```json
{
  "backend": {
    "host": "https://api.synapse.sh",
    "token": "your-api-token"
  },
  "agent": {
    "id": "agent-uuid-123",
    "name": "My Development Agent",
    "token": "your-agent-token"
  }
}
```

## 플러그인 관리

CLI는 대화형 플러그인 관리 인터페이스를 제공합니다:

```bash
$ synapse
# "플러그인 관리" 선택
```

### 사용 가능한 옵션:

1. **새 플러그인 생성**: cookiecutter를 사용하여 템플릿에서 새 플러그인을 생성합니다
2. **플러그인 로컬 실행**: 구성 가능한 매개변수로 플러그인을 실행하는 대화형 인터페이스
3. **플러그인 게시**: 디버그 모드 옵션과 함께 구성된 백엔드에 플러그인을 게시합니다

### 플러그인 게시

플러그인을 게시할 때:
- **디버그 모드**: 개발용으로 기본적으로 활성화됩니다
- **백엔드 통합**: 구성된 백엔드 설정을 사용합니다
- **연결 테스트**: 게시 전에 백엔드 연결을 확인합니다
- **오류 처리**: 오류 발생 시 중단하고 사용자 확인을 기다립니다

### 플러그인 개발 워크플로

1. **생성**: CLI를 사용하여 새 플러그인 템플릿 생성
2. **개발**: 생성된 구조를 따라 플러그인 코드 작성
3. **테스트**: 대화형 인터페이스를 통해 플러그인을 로컬에서 실행
4. **게시**: 디버그 옵션과 함께 구성된 백엔드에 배포