import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as constructs from 'constructs';
import * as network from './network';
/**
 * Construct properties for `HyperledgerFabricVpc`
 */
export interface HyperledgerFabricClientProps {
    /**
     * Client VPC to create the endpoints. If not provided,
     * VPC will be created with the default properties
     * (CIDR-`10.0.0.0/16` and subnets of type `PRIVATE_ISOLATED`)
     *
     */
    readonly vpc?: ec2.IVpc;
}
/**
 * Creates a VPC and endpoint that allows Hyperledger Fabric client to
 * interact with the Hyperledger Fabric endpoints that Amazon Managed Blockchain
 * exposes for the member and network resources.
 */
export declare class HyperledgerFabricClient extends constructs.Construct {
    /**
     * The client VPC that has endpoint to access the Amazon Managed Blockchain
     */
    readonly vpc: ec2.IVpc;
    /**
     * Managed Blockchain network VPC endpoint
     */
    readonly vpcEndpoint: ec2.InterfaceVpcEndpoint;
    constructor(scope: network.HyperledgerFabricNetwork, id: string, props?: HyperledgerFabricClientProps);
}
