#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['qpsolvers_benchmark']

package_data = \
{'': ['*'],
 'qpsolvers_benchmark': ['test_sets/*', 'test_sets/github_ffa_problems/*']}

install_requires = \
['clarabel >=0.4.1',
 'cvxopt >=1.2.6',
 'ecos >=2.0.8',
 'highspy >=1.1.2.dev3',
 'matplotlib >=3.6.2',
 'osqp >=0.6.2',
 'pandas >=1.4.3',
 'proxsuite >=0.3.0',
 'qpsolvers >=3.4.0',
 'quadprog >=0.1.11',
 'scs >=3.2.0',
 'tabulate >=0.9.0']

extras_require = \
{'open_source_solvers': ['cvxopt >= 1.3.0',
                         'ecos >= 2.0.10',
                         'highspy >= 1.1.2',
                         'osqp >= 0.6.2',
                         'proxsuite >= 0.3.0',
                         'quadprog >= 0.1.11',
                         'scs >= 3.2.2']}

entry_points = \
{'console_scripts': ['qpsolvers_benchmark = '
                     'qpsolvers_benchmark.benchmark:main']}

setup(name='qpsolvers_benchmark',
      version='1.0.0',
      description='Benchmark for quadratic programming solvers available in Python.',
      author=None,
      author_email='Stéphane Caron <stephane.caron@normalesup.org>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
