import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AlertConditionConfig extends cdktf.TerraformMetaArguments {
    /**
    * One of (application, instance). Choose application for most scenarios. If you are using the JVM plugin in New Relic, the instance setting allows your condition to trigger for specific app instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#condition_scope AlertCondition#condition_scope}
    */
    readonly conditionScope?: string;
    /**
    * Whether the condition is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#enabled AlertCondition#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The instance IDs associated with this condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#entities AlertCondition#entities}
    */
    readonly entities: number[];
    /**
    * A valid Garbage Collection metric e.g. GC/G1 Young Generation. This is required if you are using apm_jvm_metric with gc_cpu_time condition type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#gc_metric AlertCondition#gc_metric}
    */
    readonly gcMetric?: string;
    /**
    * The metric field accepts parameters based on the type set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#metric AlertCondition#metric}
    */
    readonly metric: string;
    /**
    * The title of the condition. Must be between 1 and 128 characters, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#name AlertCondition#name}
    */
    readonly name: string;
    /**
    * The ID of the policy where this condition should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#policy_id AlertCondition#policy_id}
    */
    readonly policyId: number;
    /**
    * Runbook URL to display in notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#runbook_url AlertCondition#runbook_url}
    */
    readonly runbookUrl?: string;
    /**
    * The type of condition. One of: (browser_metric, mobile_metric, servers_metric, apm_app_metric, apm_jvm_metric, apm_kt_metric).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#type AlertCondition#type}
    */
    readonly type: string;
    /**
    * A custom metric to be evaluated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#user_defined_metric AlertCondition#user_defined_metric}
    */
    readonly userDefinedMetric?: string;
    /**
    * One of: (average, min, max, total, sample_size).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#user_defined_value_function AlertCondition#user_defined_value_function}
    */
    readonly userDefinedValueFunction?: string;
    /**
    * Automatically close instance-based violations, including JVM health metric violations, after the number of hours specified. Must be: 1, 2, 4, 8, 12 or 24.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#violation_close_timer AlertCondition#violation_close_timer}
    */
    readonly violationCloseTimer?: number;
    /**
    * term block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#term AlertCondition#term}
    */
    readonly term: AlertConditionTerm[] | cdktf.IResolvable;
}
export interface AlertConditionTerm {
    /**
    * In minutes, must be in the range of 5 to 120, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#duration AlertCondition#duration}
    */
    readonly duration: number;
    /**
    * One of (above, below, equal). Defaults to equal.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#operator AlertCondition#operator}
    */
    readonly operator?: string;
    /**
    * One of (critical, warning). Defaults to critical.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#priority AlertCondition#priority}
    */
    readonly priority?: string;
    /**
    * Must be 0 or greater.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#threshold AlertCondition#threshold}
    */
    readonly threshold: number;
    /**
    * One of (all, any).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition#time_function AlertCondition#time_function}
    */
    readonly timeFunction: string;
}
export declare function alertConditionTermToTerraform(struct?: AlertConditionTerm | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition newrelic_alert_condition}
*/
export declare class AlertCondition extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition newrelic_alert_condition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AlertConditionConfig
    */
    constructor(scope: Construct, id: string, config: AlertConditionConfig);
    private _conditionScope?;
    get conditionScope(): string;
    set conditionScope(value: string);
    resetConditionScope(): void;
    get conditionScopeInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _entities?;
    get entities(): number[];
    set entities(value: number[]);
    get entitiesInput(): number[] | undefined;
    private _gcMetric?;
    get gcMetric(): string;
    set gcMetric(value: string);
    resetGcMetric(): void;
    get gcMetricInput(): string | undefined;
    get id(): string;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policyId?;
    get policyId(): number;
    set policyId(value: number);
    get policyIdInput(): number | undefined;
    private _runbookUrl?;
    get runbookUrl(): string;
    set runbookUrl(value: string);
    resetRunbookUrl(): void;
    get runbookUrlInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _userDefinedMetric?;
    get userDefinedMetric(): string;
    set userDefinedMetric(value: string);
    resetUserDefinedMetric(): void;
    get userDefinedMetricInput(): string | undefined;
    private _userDefinedValueFunction?;
    get userDefinedValueFunction(): string;
    set userDefinedValueFunction(value: string);
    resetUserDefinedValueFunction(): void;
    get userDefinedValueFunctionInput(): string | undefined;
    private _violationCloseTimer?;
    get violationCloseTimer(): number;
    set violationCloseTimer(value: number);
    resetViolationCloseTimer(): void;
    get violationCloseTimerInput(): number | undefined;
    private _term?;
    get term(): AlertConditionTerm[] | cdktf.IResolvable;
    set term(value: AlertConditionTerm[] | cdktf.IResolvable);
    get termInput(): cdktf.IResolvable | AlertConditionTerm[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
