import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicAlertChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the alert channel in New Relic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/alert_channel#name DataNewrelicAlertChannel#name}
    */
    readonly name: string;
}
export declare class DataNewrelicAlertChannelConfigA extends cdktf.ComplexComputedList {
    get apiKey(): string;
    get authPassword(): string;
    get authType(): string;
    get authUsername(): string;
    get baseUrl(): string;
    get channel(): string;
    get headers(): {
        [key: string]: string;
    };
    get includeJsonAttachment(): string;
    get key(): string;
    get payload(): {
        [key: string]: string;
    };
    get payloadType(): string;
    get recipients(): string;
    get region(): string;
    get routeKey(): string;
    get serviceKey(): string;
    get tags(): string;
    get teams(): string;
    get url(): string;
    get userId(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/alert_channel newrelic_alert_channel}
*/
export declare class DataNewrelicAlertChannel extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/alert_channel newrelic_alert_channel} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicAlertChannelConfig
    */
    constructor(scope: Construct, id: string, config: DataNewrelicAlertChannelConfig);
    config(index: string): DataNewrelicAlertChannelConfigA;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get policyIds(): number[];
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
