import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface InsightsEventConfig extends cdktf.TerraformMetaArguments {
    /**
    * event block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#event InsightsEvent#event}
    */
    readonly event: InsightsEventEvent[] | cdktf.IResolvable;
}
export interface InsightsEventEventAttribute {
    /**
    * The name of the attribute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#key InsightsEvent#key}
    */
    readonly key: string;
    /**
    * Specify the type for the attribute value. This is useful when passing integer or float values to Insights. Allowed values are string, int, or float. Defaults to string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#type InsightsEvent#type}
    */
    readonly type?: string;
    /**
    * The value of the attribute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#value InsightsEvent#value}
    */
    readonly value: string;
}
export declare function insightsEventEventAttributeToTerraform(struct?: InsightsEventEventAttribute | cdktf.IResolvable): any;
export interface InsightsEventEvent {
    /**
    * Must be a Unix epoch timestamp. You can define timestamps either in seconds or in milliseconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#timestamp InsightsEvent#timestamp}
    */
    readonly timestamp?: number;
    /**
    * The event's name. Can be a combination of alphanumeric characters, underscores, and colons.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#type InsightsEvent#type}
    */
    readonly type: string;
    /**
    * attribute block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event#attribute InsightsEvent#attribute}
    */
    readonly attribute: InsightsEventEventAttribute[] | cdktf.IResolvable;
}
export declare function insightsEventEventToTerraform(struct?: InsightsEventEvent | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event newrelic_insights_event}
*/
export declare class InsightsEvent extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/insights_event newrelic_insights_event} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options InsightsEventConfig
    */
    constructor(scope: Construct, id: string, config: InsightsEventConfig);
    get id(): string;
    private _event?;
    get event(): InsightsEventEvent[] | cdktf.IResolvable;
    set event(value: InsightsEventEvent[] | cdktf.IResolvable);
    get eventInput(): cdktf.IResolvable | InsightsEventEvent[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
