"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewrelicProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic newrelic}
*/
class NewrelicProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic newrelic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NewrelicProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'newrelic',
            terraformGeneratorMetadata: {
                providerName: 'newrelic',
                providerVersionConstraint: '~> 2.32'
            },
            terraformProviderSource: 'newrelic/newrelic'
        });
        this._accountId = config.accountId;
        this._adminApiKey = config.adminApiKey;
        this._apiKey = config.apiKey;
        this._apiUrl = config.apiUrl;
        this._cacertFile = config.cacertFile;
        this._infrastructureApiUrl = config.infrastructureApiUrl;
        this._insecureSkipVerify = config.insecureSkipVerify;
        this._insightsInsertKey = config.insightsInsertKey;
        this._insightsInsertUrl = config.insightsInsertUrl;
        this._insightsQueryUrl = config.insightsQueryUrl;
        this._nerdgraphApiUrl = config.nerdgraphApiUrl;
        this._region = config.region;
        this._syntheticsApiUrl = config.syntheticsApiUrl;
        this._alias = config.alias;
    }
    get accountId() {
        return this._accountId;
    }
    set accountId(value) {
        this._accountId = value;
    }
    // Temporarily expose input value. Use with caution.
    get accountIdInput() {
        return this._accountId;
    }
    get adminApiKey() {
        return this._adminApiKey;
    }
    set adminApiKey(value) {
        this._adminApiKey = value;
    }
    resetAdminApiKey() {
        this._adminApiKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get adminApiKeyInput() {
        return this._adminApiKey;
    }
    get apiKey() {
        return this._apiKey;
    }
    set apiKey(value) {
        this._apiKey = value;
    }
    resetApiKey() {
        this._apiKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apiKeyInput() {
        return this._apiKey;
    }
    get apiUrl() {
        return this._apiUrl;
    }
    set apiUrl(value) {
        this._apiUrl = value;
    }
    resetApiUrl() {
        this._apiUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apiUrlInput() {
        return this._apiUrl;
    }
    get cacertFile() {
        return this._cacertFile;
    }
    set cacertFile(value) {
        this._cacertFile = value;
    }
    resetCacertFile() {
        this._cacertFile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cacertFileInput() {
        return this._cacertFile;
    }
    get infrastructureApiUrl() {
        return this._infrastructureApiUrl;
    }
    set infrastructureApiUrl(value) {
        this._infrastructureApiUrl = value;
    }
    resetInfrastructureApiUrl() {
        this._infrastructureApiUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get infrastructureApiUrlInput() {
        return this._infrastructureApiUrl;
    }
    get insecureSkipVerify() {
        return this._insecureSkipVerify;
    }
    set insecureSkipVerify(value) {
        this._insecureSkipVerify = value;
    }
    resetInsecureSkipVerify() {
        this._insecureSkipVerify = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureSkipVerifyInput() {
        return this._insecureSkipVerify;
    }
    get insightsInsertKey() {
        return this._insightsInsertKey;
    }
    set insightsInsertKey(value) {
        this._insightsInsertKey = value;
    }
    resetInsightsInsertKey() {
        this._insightsInsertKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insightsInsertKeyInput() {
        return this._insightsInsertKey;
    }
    get insightsInsertUrl() {
        return this._insightsInsertUrl;
    }
    set insightsInsertUrl(value) {
        this._insightsInsertUrl = value;
    }
    resetInsightsInsertUrl() {
        this._insightsInsertUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insightsInsertUrlInput() {
        return this._insightsInsertUrl;
    }
    get insightsQueryUrl() {
        return this._insightsQueryUrl;
    }
    set insightsQueryUrl(value) {
        this._insightsQueryUrl = value;
    }
    resetInsightsQueryUrl() {
        this._insightsQueryUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insightsQueryUrlInput() {
        return this._insightsQueryUrl;
    }
    get nerdgraphApiUrl() {
        return this._nerdgraphApiUrl;
    }
    set nerdgraphApiUrl(value) {
        this._nerdgraphApiUrl = value;
    }
    resetNerdgraphApiUrl() {
        this._nerdgraphApiUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nerdgraphApiUrlInput() {
        return this._nerdgraphApiUrl;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get syntheticsApiUrl() {
        return this._syntheticsApiUrl;
    }
    set syntheticsApiUrl(value) {
        this._syntheticsApiUrl = value;
    }
    resetSyntheticsApiUrl() {
        this._syntheticsApiUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get syntheticsApiUrlInput() {
        return this._syntheticsApiUrl;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account_id: cdktf.numberToTerraform(this._accountId),
            admin_api_key: cdktf.stringToTerraform(this._adminApiKey),
            api_key: cdktf.stringToTerraform(this._apiKey),
            api_url: cdktf.stringToTerraform(this._apiUrl),
            cacert_file: cdktf.stringToTerraform(this._cacertFile),
            infrastructure_api_url: cdktf.stringToTerraform(this._infrastructureApiUrl),
            insecure_skip_verify: cdktf.booleanToTerraform(this._insecureSkipVerify),
            insights_insert_key: cdktf.stringToTerraform(this._insightsInsertKey),
            insights_insert_url: cdktf.stringToTerraform(this._insightsInsertUrl),
            insights_query_url: cdktf.stringToTerraform(this._insightsQueryUrl),
            nerdgraph_api_url: cdktf.stringToTerraform(this._nerdgraphApiUrl),
            region: cdktf.stringToTerraform(this._region),
            synthetics_api_url: cdktf.stringToTerraform(this._syntheticsApiUrl),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.NewrelicProvider = NewrelicProvider;
_a = JSII_RTTI_SYMBOL_1;
NewrelicProvider[_a] = { fqn: "@cdktf/provider-newrelic.NewrelicProvider", version: "0.3.298" };
// =================
// STATIC PROPERTIES
// =================
NewrelicProvider.tfResourceType = "newrelic";
//# sourceMappingURL=data:application/json;base64,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