import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NrqlAlertConditionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The New Relic account ID for managing your NRQL alert conditions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#account_id NrqlAlertCondition#account_id}
    */
    readonly accountId?: number;
    /**
    * How long we wait for data that belongs in each aggregation window. Depending on your data, a longer delay may increase accuracy but delay notifications. Use aggregationDelay with the EVENT_FLOW and CADENCE aggregation methods.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#aggregation_delay NrqlAlertCondition#aggregation_delay}
    */
    readonly aggregationDelay?: number;
    /**
    * The method that determines when we consider an aggregation window to be complete so that we can evaluate the signal for violations. Default is CADENCE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#aggregation_method NrqlAlertCondition#aggregation_method}
    */
    readonly aggregationMethod?: string;
    /**
    * How long we wait after each data point arrives to make sure we've processed the whole batch. Use aggregationTimer with the EVENT_TIMER aggregation method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#aggregation_timer NrqlAlertCondition#aggregation_timer}
    */
    readonly aggregationTimer?: number;
    /**
    * The duration of the time window used to evaluate the NRQL query, in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#aggregation_window NrqlAlertCondition#aggregation_window}
    */
    readonly aggregationWindow?: number;
    /**
    * The baseline direction of a baseline NRQL alert condition. Valid values are: 'LOWER_ONLY', 'UPPER_AND_LOWER', 'UPPER_ONLY' (case insensitive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#baseline_direction NrqlAlertCondition#baseline_direction}
    */
    readonly baselineDirection?: string;
    /**
    * Whether to close all open violations when the signal expires.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#close_violations_on_expiration NrqlAlertCondition#close_violations_on_expiration}
    */
    readonly closeViolationsOnExpiration?: boolean | cdktf.IResolvable;
    /**
    * The description of the NRQL alert condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#description NrqlAlertCondition#description}
    */
    readonly description?: string;
    /**
    * Whether or not to enable the alert condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#enabled NrqlAlertCondition#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Number of expected groups when using outlier detection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#expected_groups NrqlAlertCondition#expected_groups}
    */
    readonly expectedGroups?: number;
    /**
    * The amount of time (in seconds) to wait before considering the signal expired.  Must be in the range of 30 to 172800 (inclusive)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#expiration_duration NrqlAlertCondition#expiration_duration}
    */
    readonly expirationDuration?: number;
    /**
    * Which strategy to use when filling gaps in the signal. If static, the 'fill value' will be used for filling gaps in the signal. Valid values are: 'NONE', 'LAST_VALUE', or 'STATIC' (case insensitive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#fill_option NrqlAlertCondition#fill_option}
    */
    readonly fillOption?: string;
    /**
    * If using the 'static' fill option, this value will be used for filling gaps in the signal.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#fill_value NrqlAlertCondition#fill_value}
    */
    readonly fillValue?: number;
    /**
    * Whether to look for a convergence of groups when using outlier detection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#ignore_overlap NrqlAlertCondition#ignore_overlap}
    */
    readonly ignoreOverlap?: boolean | cdktf.IResolvable;
    /**
    * The title of the condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#name NrqlAlertCondition#name}
    */
    readonly name: string;
    /**
    * Whether to create a new violation to capture that the signal expired.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#open_violation_on_expiration NrqlAlertCondition#open_violation_on_expiration}
    */
    readonly openViolationOnExpiration?: boolean | cdktf.IResolvable;
    /**
    * Whether overlapping groups should produce a violation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#open_violation_on_group_overlap NrqlAlertCondition#open_violation_on_group_overlap}
    */
    readonly openViolationOnGroupOverlap?: boolean | cdktf.IResolvable;
    /**
    * The ID of the policy where this condition should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#policy_id NrqlAlertCondition#policy_id}
    */
    readonly policyId: number;
    /**
    * Runbook URL to display in notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#runbook_url NrqlAlertCondition#runbook_url}
    */
    readonly runbookUrl?: string;
    /**
    * The duration of overlapping timewindows used to smooth the chart line, in seconds. Must be a factor of `aggregation_window` and less than the aggregation window. It should be greater or equal to 30 seconds if `aggregation_window` is less than or equal to 3600 seconds, or greater or eqaul to `aggregation_window / 120` if `aggregation_window` is greater than 3600 seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#slide_by NrqlAlertCondition#slide_by}
    */
    readonly slideBy?: number;
    /**
    * The type of NRQL alert condition to create. Valid values are: 'static', 'baseline', 'outlier' (deprecated).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#type NrqlAlertCondition#type}
    */
    readonly type?: string;
    /**
    * Values are: 'single_value' (deprecated) or 'sum' (deprecated)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#value_function NrqlAlertCondition#value_function}
    */
    readonly valueFunction?: string;
    /**
    * Sets a time limit, in hours, that will automatically force-close a long-lasting violation after the time limit you select. Possible values are 'ONE_HOUR', 'TWO_HOURS', 'FOUR_HOURS', 'EIGHT_HOURS', 'TWELVE_HOURS', 'TWENTY_FOUR_HOURS', 'THIRTY_DAYS' (case insensitive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#violation_time_limit NrqlAlertCondition#violation_time_limit}
    */
    readonly violationTimeLimit?: string;
    /**
    * Sets a time limit, in seconds, that will automatically force-close a long-lasting violation after the time limit you select.  Must be in the range of 300 to 2592000 (inclusive)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#violation_time_limit_seconds NrqlAlertCondition#violation_time_limit_seconds}
    */
    readonly violationTimeLimitSeconds?: number;
    /**
    * critical block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#critical NrqlAlertCondition#critical}
    */
    readonly critical?: NrqlAlertConditionCritical;
    /**
    * nrql block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#nrql NrqlAlertCondition#nrql}
    */
    readonly nrql: NrqlAlertConditionNrql;
    /**
    * term block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#term NrqlAlertCondition#term}
    */
    readonly term?: NrqlAlertConditionTerm[] | cdktf.IResolvable;
    /**
    * warning block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#warning NrqlAlertCondition#warning}
    */
    readonly warning?: NrqlAlertConditionWarning;
}
export interface NrqlAlertConditionCritical {
    /**
    * In minutes, must be in the range of 1 to 120 (inclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#duration NrqlAlertCondition#duration}
    */
    readonly duration?: number;
    /**
    * One of (above, below, equals). Defaults to 'equals'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#operator NrqlAlertCondition#operator}
    */
    readonly operator?: string;
    /**
    * Must be 0 or greater. For baseline conditions must be in range [1, 1000].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#threshold NrqlAlertCondition#threshold}
    */
    readonly threshold: number;
    /**
    * The duration, in seconds, that the threshold must violate in order to create a violation. Value must be a multiple of the 'aggregation_window' (which has a default of 60 seconds). Value must be within 120-3600 seconds for baseline and outlier conditions, within 120-7200 seconds for static conditions with the sum value function, and within 60-7200 seconds for static conditions with the single_value value function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#threshold_duration NrqlAlertCondition#threshold_duration}
    */
    readonly thresholdDuration?: number;
    /**
    * The criteria for how many data points must be in violation for the specified threshold duration. Valid values are: 'ALL' or 'AT_LEAST_ONCE' (case insensitive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#threshold_occurrences NrqlAlertCondition#threshold_occurrences}
    */
    readonly thresholdOccurrences?: string;
    /**
    * Valid values are: 'all' or 'any'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#time_function NrqlAlertCondition#time_function}
    */
    readonly timeFunction?: string;
}
export declare function nrqlAlertConditionCriticalToTerraform(struct?: NrqlAlertConditionCriticalOutputReference | NrqlAlertConditionCritical): any;
export declare class NrqlAlertConditionCriticalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): NrqlAlertConditionCritical | undefined;
    set internalValue(value: NrqlAlertConditionCritical | undefined);
    private _duration?;
    get duration(): number;
    set duration(value: number);
    resetDuration(): void;
    get durationInput(): number | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _thresholdDuration?;
    get thresholdDuration(): number;
    set thresholdDuration(value: number);
    resetThresholdDuration(): void;
    get thresholdDurationInput(): number | undefined;
    private _thresholdOccurrences?;
    get thresholdOccurrences(): string;
    set thresholdOccurrences(value: string);
    resetThresholdOccurrences(): void;
    get thresholdOccurrencesInput(): string | undefined;
    private _timeFunction?;
    get timeFunction(): string;
    set timeFunction(value: string);
    resetTimeFunction(): void;
    get timeFunctionInput(): string | undefined;
}
export interface NrqlAlertConditionNrql {
    /**
    * NRQL queries are evaluated in one-minute time windows. The start time depends on the value you provide in the NRQL condition's `evaluation_offset`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#evaluation_offset NrqlAlertCondition#evaluation_offset}
    */
    readonly evaluationOffset?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#query NrqlAlertCondition#query}
    */
    readonly query: string;
    /**
    * NRQL queries are evaluated in one-minute time windows. The start time depends on the value you provide in the NRQL condition's `since_value`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#since_value NrqlAlertCondition#since_value}
    */
    readonly sinceValue?: string;
}
export declare function nrqlAlertConditionNrqlToTerraform(struct?: NrqlAlertConditionNrqlOutputReference | NrqlAlertConditionNrql): any;
export declare class NrqlAlertConditionNrqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): NrqlAlertConditionNrql | undefined;
    set internalValue(value: NrqlAlertConditionNrql | undefined);
    private _evaluationOffset?;
    get evaluationOffset(): number;
    set evaluationOffset(value: number);
    resetEvaluationOffset(): void;
    get evaluationOffsetInput(): number | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _sinceValue?;
    get sinceValue(): string;
    set sinceValue(value: string);
    resetSinceValue(): void;
    get sinceValueInput(): string | undefined;
}
export interface NrqlAlertConditionTerm {
    /**
    * In minutes, must be in the range of 1 to 120 (inclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#duration NrqlAlertCondition#duration}
    */
    readonly duration?: number;
    /**
    * One of (above, below, equals). Defaults to 'equals'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#operator NrqlAlertCondition#operator}
    */
    readonly operator?: string;
    /**
    * One of (critical, warning). Defaults to 'critical'. At least one condition term must have priority set to 'critical'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#priority NrqlAlertCondition#priority}
    */
    readonly priority?: string;
    /**
    * Must be 0 or greater. For baseline conditions must be in range [1, 1000].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#threshold NrqlAlertCondition#threshold}
    */
    readonly threshold: number;
    /**
    * The duration, in seconds, that the threshold must violate in order to create a violation. Value must be a multiple of the 'aggregation_window' (which has a default of 60 seconds). Value must be within 120-3600 seconds for baseline and outlier conditions, within 120-7200 seconds for static conditions with the sum value function, and within 60-7200 seconds for static conditions with the single_value value function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#threshold_duration NrqlAlertCondition#threshold_duration}
    */
    readonly thresholdDuration?: number;
    /**
    * The criteria for how many data points must be in violation for the specified threshold duration. Valid values are: 'ALL' or 'AT_LEAST_ONCE' (case insensitive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#threshold_occurrences NrqlAlertCondition#threshold_occurrences}
    */
    readonly thresholdOccurrences?: string;
    /**
    * Valid values are: 'all' or 'any'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#time_function NrqlAlertCondition#time_function}
    */
    readonly timeFunction?: string;
}
export declare function nrqlAlertConditionTermToTerraform(struct?: NrqlAlertConditionTerm | cdktf.IResolvable): any;
export interface NrqlAlertConditionWarning {
    /**
    * In minutes, must be in the range of 1 to 120 (inclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#duration NrqlAlertCondition#duration}
    */
    readonly duration?: number;
    /**
    * One of (above, below, equals). Defaults to 'equals'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#operator NrqlAlertCondition#operator}
    */
    readonly operator?: string;
    /**
    * Must be 0 or greater. For baseline conditions must be in range [1, 1000].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#threshold NrqlAlertCondition#threshold}
    */
    readonly threshold: number;
    /**
    * The duration, in seconds, that the threshold must violate in order to create a violation. Value must be a multiple of the 'aggregation_window' (which has a default of 60 seconds). Value must be within 120-3600 seconds for baseline and outlier conditions, within 120-7200 seconds for static conditions with the sum value function, and within 60-7200 seconds for static conditions with the single_value value function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#threshold_duration NrqlAlertCondition#threshold_duration}
    */
    readonly thresholdDuration?: number;
    /**
    * The criteria for how many data points must be in violation for the specified threshold duration. Valid values are: 'ALL' or 'AT_LEAST_ONCE' (case insensitive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#threshold_occurrences NrqlAlertCondition#threshold_occurrences}
    */
    readonly thresholdOccurrences?: string;
    /**
    * Valid values are: 'all' or 'any'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition#time_function NrqlAlertCondition#time_function}
    */
    readonly timeFunction?: string;
}
export declare function nrqlAlertConditionWarningToTerraform(struct?: NrqlAlertConditionWarningOutputReference | NrqlAlertConditionWarning): any;
export declare class NrqlAlertConditionWarningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): NrqlAlertConditionWarning | undefined;
    set internalValue(value: NrqlAlertConditionWarning | undefined);
    private _duration?;
    get duration(): number;
    set duration(value: number);
    resetDuration(): void;
    get durationInput(): number | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _thresholdDuration?;
    get thresholdDuration(): number;
    set thresholdDuration(value: number);
    resetThresholdDuration(): void;
    get thresholdDurationInput(): number | undefined;
    private _thresholdOccurrences?;
    get thresholdOccurrences(): string;
    set thresholdOccurrences(value: string);
    resetThresholdOccurrences(): void;
    get thresholdOccurrencesInput(): string | undefined;
    private _timeFunction?;
    get timeFunction(): string;
    set timeFunction(value: string);
    resetTimeFunction(): void;
    get timeFunctionInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition newrelic_nrql_alert_condition}
*/
export declare class NrqlAlertCondition extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition newrelic_nrql_alert_condition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NrqlAlertConditionConfig
    */
    constructor(scope: Construct, id: string, config: NrqlAlertConditionConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _aggregationDelay?;
    get aggregationDelay(): number;
    set aggregationDelay(value: number);
    resetAggregationDelay(): void;
    get aggregationDelayInput(): number | undefined;
    private _aggregationMethod?;
    get aggregationMethod(): string;
    set aggregationMethod(value: string);
    resetAggregationMethod(): void;
    get aggregationMethodInput(): string | undefined;
    private _aggregationTimer?;
    get aggregationTimer(): number;
    set aggregationTimer(value: number);
    resetAggregationTimer(): void;
    get aggregationTimerInput(): number | undefined;
    private _aggregationWindow?;
    get aggregationWindow(): number;
    set aggregationWindow(value: number);
    resetAggregationWindow(): void;
    get aggregationWindowInput(): number | undefined;
    private _baselineDirection?;
    get baselineDirection(): string;
    set baselineDirection(value: string);
    resetBaselineDirection(): void;
    get baselineDirectionInput(): string | undefined;
    private _closeViolationsOnExpiration?;
    get closeViolationsOnExpiration(): boolean | cdktf.IResolvable;
    set closeViolationsOnExpiration(value: boolean | cdktf.IResolvable);
    resetCloseViolationsOnExpiration(): void;
    get closeViolationsOnExpirationInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _expectedGroups?;
    get expectedGroups(): number;
    set expectedGroups(value: number);
    resetExpectedGroups(): void;
    get expectedGroupsInput(): number | undefined;
    private _expirationDuration?;
    get expirationDuration(): number;
    set expirationDuration(value: number);
    resetExpirationDuration(): void;
    get expirationDurationInput(): number | undefined;
    private _fillOption?;
    get fillOption(): string;
    set fillOption(value: string);
    resetFillOption(): void;
    get fillOptionInput(): string | undefined;
    private _fillValue?;
    get fillValue(): number;
    set fillValue(value: number);
    resetFillValue(): void;
    get fillValueInput(): number | undefined;
    get id(): string;
    private _ignoreOverlap?;
    get ignoreOverlap(): boolean | cdktf.IResolvable;
    set ignoreOverlap(value: boolean | cdktf.IResolvable);
    resetIgnoreOverlap(): void;
    get ignoreOverlapInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _openViolationOnExpiration?;
    get openViolationOnExpiration(): boolean | cdktf.IResolvable;
    set openViolationOnExpiration(value: boolean | cdktf.IResolvable);
    resetOpenViolationOnExpiration(): void;
    get openViolationOnExpirationInput(): boolean | cdktf.IResolvable | undefined;
    private _openViolationOnGroupOverlap?;
    get openViolationOnGroupOverlap(): boolean | cdktf.IResolvable;
    set openViolationOnGroupOverlap(value: boolean | cdktf.IResolvable);
    resetOpenViolationOnGroupOverlap(): void;
    get openViolationOnGroupOverlapInput(): boolean | cdktf.IResolvable | undefined;
    private _policyId?;
    get policyId(): number;
    set policyId(value: number);
    get policyIdInput(): number | undefined;
    private _runbookUrl?;
    get runbookUrl(): string;
    set runbookUrl(value: string);
    resetRunbookUrl(): void;
    get runbookUrlInput(): string | undefined;
    private _slideBy?;
    get slideBy(): number;
    set slideBy(value: number);
    resetSlideBy(): void;
    get slideByInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _valueFunction?;
    get valueFunction(): string;
    set valueFunction(value: string);
    resetValueFunction(): void;
    get valueFunctionInput(): string | undefined;
    private _violationTimeLimit?;
    get violationTimeLimit(): string;
    set violationTimeLimit(value: string);
    resetViolationTimeLimit(): void;
    get violationTimeLimitInput(): string | undefined;
    private _violationTimeLimitSeconds?;
    get violationTimeLimitSeconds(): number;
    set violationTimeLimitSeconds(value: number);
    resetViolationTimeLimitSeconds(): void;
    get violationTimeLimitSecondsInput(): number | undefined;
    private _critical;
    get critical(): NrqlAlertConditionCriticalOutputReference;
    putCritical(value: NrqlAlertConditionCritical): void;
    resetCritical(): void;
    get criticalInput(): NrqlAlertConditionCritical | undefined;
    private _nrql;
    get nrql(): NrqlAlertConditionNrqlOutputReference;
    putNrql(value: NrqlAlertConditionNrql): void;
    get nrqlInput(): NrqlAlertConditionNrql | undefined;
    private _term?;
    get term(): NrqlAlertConditionTerm[] | cdktf.IResolvable;
    set term(value: NrqlAlertConditionTerm[] | cdktf.IResolvable);
    resetTerm(): void;
    get termInput(): cdktf.IResolvable | NrqlAlertConditionTerm[] | undefined;
    private _warning;
    get warning(): NrqlAlertConditionWarningOutputReference;
    putWarning(value: NrqlAlertConditionWarning): void;
    resetWarning(): void;
    get warningInput(): NrqlAlertConditionWarning | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
