import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OneDashboardConfig extends cdktf.TerraformMetaArguments {
    /**
    * The New Relic account ID where you want to create the dashboard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The dashboard's description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#description OneDashboard#description}
    */
    readonly description?: string;
    /**
    * The dashboard's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#name OneDashboard#name}
    */
    readonly name: string;
    /**
    * Determines who can see or edit the dashboard. Valid values are private, public_read_only, public_read_write. Defaults to public_read_only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#permissions OneDashboard#permissions}
    */
    readonly permissions?: string;
    /**
    * page block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#page OneDashboard#page}
    */
    readonly page: OneDashboardPage[] | cdktf.IResolvable;
}
export interface OneDashboardPageWidgetAreaNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetAreaNrqlQueryToTerraform(struct?: OneDashboardPageWidgetAreaNrqlQuery | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetArea {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetAreaNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetAreaToTerraform(struct?: OneDashboardPageWidgetArea | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetBarNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetBarNrqlQueryToTerraform(struct?: OneDashboardPageWidgetBarNrqlQuery | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetBar {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Use this item to filter the current dashboard
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#filter_current_dashboard OneDashboard#filter_current_dashboard}
    */
    readonly filterCurrentDashboard?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Related entities. Currently only supports Dashboard entities, but may allow other cases in the future.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#linked_entity_guids OneDashboard#linked_entity_guids}
    */
    readonly linkedEntityGuids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetBarNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetBarToTerraform(struct?: OneDashboardPageWidgetBar | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetBillboardNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetBillboardNrqlQueryToTerraform(struct?: OneDashboardPageWidgetBillboardNrqlQuery | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetBillboard {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * The critical threshold value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#critical OneDashboard#critical}
    */
    readonly critical?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * The warning threshold value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#warning OneDashboard#warning}
    */
    readonly warning?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetBillboardNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetBillboardToTerraform(struct?: OneDashboardPageWidgetBillboard | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetBulletNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetBulletNrqlQueryToTerraform(struct?: OneDashboardPageWidgetBulletNrqlQuery | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetBullet {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * The maximum value for the visualization
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#limit OneDashboard#limit}
    */
    readonly limit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetBulletNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetBulletToTerraform(struct?: OneDashboardPageWidgetBullet | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetFunnelNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetFunnelNrqlQueryToTerraform(struct?: OneDashboardPageWidgetFunnelNrqlQuery | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetFunnel {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetFunnelNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetFunnelToTerraform(struct?: OneDashboardPageWidgetFunnel | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetHeatmapNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetHeatmapNrqlQueryToTerraform(struct?: OneDashboardPageWidgetHeatmapNrqlQuery | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetHeatmap {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetHeatmapNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetHeatmapToTerraform(struct?: OneDashboardPageWidgetHeatmap | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetHistogramNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetHistogramNrqlQueryToTerraform(struct?: OneDashboardPageWidgetHistogramNrqlQuery | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetHistogram {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetHistogramNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetHistogramToTerraform(struct?: OneDashboardPageWidgetHistogram | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetJsonNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetJsonNrqlQueryToTerraform(struct?: OneDashboardPageWidgetJsonNrqlQuery | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetJson {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetJsonNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetJsonToTerraform(struct?: OneDashboardPageWidgetJson | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetLineNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetLineNrqlQueryToTerraform(struct?: OneDashboardPageWidgetLineNrqlQuery | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetLine {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetLineNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetLineToTerraform(struct?: OneDashboardPageWidgetLine | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetMarkdown {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#text OneDashboard#text}
    */
    readonly text?: string;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
}
export declare function oneDashboardPageWidgetMarkdownToTerraform(struct?: OneDashboardPageWidgetMarkdown | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetPieNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetPieNrqlQueryToTerraform(struct?: OneDashboardPageWidgetPieNrqlQuery | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetPie {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Use this item to filter the current dashboard
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#filter_current_dashboard OneDashboard#filter_current_dashboard}
    */
    readonly filterCurrentDashboard?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Related entities. Currently only supports Dashboard entities, but may allow other cases in the future.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#linked_entity_guids OneDashboard#linked_entity_guids}
    */
    readonly linkedEntityGuids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetPieNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetPieToTerraform(struct?: OneDashboardPageWidgetPie | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetStackedBarNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetStackedBarNrqlQueryToTerraform(struct?: OneDashboardPageWidgetStackedBarNrqlQuery | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetStackedBar {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetStackedBarNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetStackedBarToTerraform(struct?: OneDashboardPageWidgetStackedBar | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetTableNrqlQuery {
    /**
    * The account id used for the NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#account_id OneDashboard#account_id}
    */
    readonly accountId?: number;
    /**
    * The NRQL query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#query OneDashboard#query}
    */
    readonly query: string;
}
export declare function oneDashboardPageWidgetTableNrqlQueryToTerraform(struct?: OneDashboardPageWidgetTableNrqlQuery | cdktf.IResolvable): any;
export interface OneDashboardPageWidgetTable {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#column OneDashboard#column}
    */
    readonly column: number;
    /**
    * Use this item to filter the current dashboard
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#filter_current_dashboard OneDashboard#filter_current_dashboard}
    */
    readonly filterCurrentDashboard?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#height OneDashboard#height}
    */
    readonly height?: number;
    /**
    * Related entities. Currently only supports Dashboard entities, but may allow other cases in the future.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#linked_entity_guids OneDashboard#linked_entity_guids}
    */
    readonly linkedEntityGuids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#row OneDashboard#row}
    */
    readonly row: number;
    /**
    * A title for the widget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#title OneDashboard#title}
    */
    readonly title: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#width OneDashboard#width}
    */
    readonly width?: number;
    /**
    * nrql_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#nrql_query OneDashboard#nrql_query}
    */
    readonly nrqlQuery: OneDashboardPageWidgetTableNrqlQuery[] | cdktf.IResolvable;
}
export declare function oneDashboardPageWidgetTableToTerraform(struct?: OneDashboardPageWidgetTable | cdktf.IResolvable): any;
export interface OneDashboardPage {
    /**
    * The dashboard page's description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#description OneDashboard#description}
    */
    readonly description?: string;
    /**
    * The dashboard page's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#name OneDashboard#name}
    */
    readonly name: string;
    /**
    * widget_area block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_area OneDashboard#widget_area}
    */
    readonly widgetArea?: OneDashboardPageWidgetArea[] | cdktf.IResolvable;
    /**
    * widget_bar block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_bar OneDashboard#widget_bar}
    */
    readonly widgetBar?: OneDashboardPageWidgetBar[] | cdktf.IResolvable;
    /**
    * widget_billboard block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_billboard OneDashboard#widget_billboard}
    */
    readonly widgetBillboard?: OneDashboardPageWidgetBillboard[] | cdktf.IResolvable;
    /**
    * widget_bullet block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_bullet OneDashboard#widget_bullet}
    */
    readonly widgetBullet?: OneDashboardPageWidgetBullet[] | cdktf.IResolvable;
    /**
    * widget_funnel block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_funnel OneDashboard#widget_funnel}
    */
    readonly widgetFunnel?: OneDashboardPageWidgetFunnel[] | cdktf.IResolvable;
    /**
    * widget_heatmap block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_heatmap OneDashboard#widget_heatmap}
    */
    readonly widgetHeatmap?: OneDashboardPageWidgetHeatmap[] | cdktf.IResolvable;
    /**
    * widget_histogram block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_histogram OneDashboard#widget_histogram}
    */
    readonly widgetHistogram?: OneDashboardPageWidgetHistogram[] | cdktf.IResolvable;
    /**
    * widget_json block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_json OneDashboard#widget_json}
    */
    readonly widgetJson?: OneDashboardPageWidgetJson[] | cdktf.IResolvable;
    /**
    * widget_line block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_line OneDashboard#widget_line}
    */
    readonly widgetLine?: OneDashboardPageWidgetLine[] | cdktf.IResolvable;
    /**
    * widget_markdown block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_markdown OneDashboard#widget_markdown}
    */
    readonly widgetMarkdown?: OneDashboardPageWidgetMarkdown[] | cdktf.IResolvable;
    /**
    * widget_pie block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_pie OneDashboard#widget_pie}
    */
    readonly widgetPie?: OneDashboardPageWidgetPie[] | cdktf.IResolvable;
    /**
    * widget_stacked_bar block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_stacked_bar OneDashboard#widget_stacked_bar}
    */
    readonly widgetStackedBar?: OneDashboardPageWidgetStackedBar[] | cdktf.IResolvable;
    /**
    * widget_table block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard#widget_table OneDashboard#widget_table}
    */
    readonly widgetTable?: OneDashboardPageWidgetTable[] | cdktf.IResolvable;
}
export declare function oneDashboardPageToTerraform(struct?: OneDashboardPage | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard newrelic_one_dashboard}
*/
export declare class OneDashboard extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/one_dashboard newrelic_one_dashboard} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OneDashboardConfig
    */
    constructor(scope: Construct, id: string, config: OneDashboardConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get guid(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get permalink(): string;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
    private _page?;
    get page(): OneDashboardPage[] | cdktf.IResolvable;
    set page(value: OneDashboardPage[] | cdktf.IResolvable);
    get pageInput(): cdktf.IResolvable | OneDashboardPage[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
