import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SyntheticsMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Bypass HEAD request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor#bypass_head_request SyntheticsMonitor#bypass_head_request}
    */
    readonly bypassHeadRequest?: boolean | cdktf.IResolvable;
    /**
    * The interval (in minutes) at which this monitor should run. Valid values are 1, 5, 10, 15, 30, 60, 360, 720, or 1440.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor#frequency SyntheticsMonitor#frequency}
    */
    readonly frequency: number;
    /**
    * The locations in which this monitor should be run.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor#locations SyntheticsMonitor#locations}
    */
    readonly locations: string[];
    /**
    * The title of this monitor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor#name SyntheticsMonitor#name}
    */
    readonly name: string;
    /**
    * The base threshold (in seconds) to calculate the apdex score for use in the SLA report. (Default 7 seconds)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor#sla_threshold SyntheticsMonitor#sla_threshold}
    */
    readonly slaThreshold?: number;
    /**
    * The monitor status (i.e. ENABLED, MUTED, DISABLED).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor#status SyntheticsMonitor#status}
    */
    readonly status: string;
    /**
    * Fail the monitor check if redirected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor#treat_redirect_as_failure SyntheticsMonitor#treat_redirect_as_failure}
    */
    readonly treatRedirectAsFailure?: boolean | cdktf.IResolvable;
    /**
    * The monitor type. Valid values are SIMPLE, BROWSER, SCRIPT_BROWSER, and SCRIPT_API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor#type SyntheticsMonitor#type}
    */
    readonly type: string;
    /**
    * The URI for the monitor to hit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor#uri SyntheticsMonitor#uri}
    */
    readonly uri?: string;
    /**
    * The string to validate against in the response.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor#validation_string SyntheticsMonitor#validation_string}
    */
    readonly validationString?: string;
    /**
    * Verify SSL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor#verify_ssl SyntheticsMonitor#verify_ssl}
    */
    readonly verifySsl?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor newrelic_synthetics_monitor}
*/
export declare class SyntheticsMonitor extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_monitor newrelic_synthetics_monitor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SyntheticsMonitorConfig
    */
    constructor(scope: Construct, id: string, config: SyntheticsMonitorConfig);
    private _bypassHeadRequest?;
    get bypassHeadRequest(): boolean | cdktf.IResolvable;
    set bypassHeadRequest(value: boolean | cdktf.IResolvable);
    resetBypassHeadRequest(): void;
    get bypassHeadRequestInput(): boolean | cdktf.IResolvable | undefined;
    private _frequency?;
    get frequency(): number;
    set frequency(value: number);
    get frequencyInput(): number | undefined;
    get id(): string;
    private _locations?;
    get locations(): string[];
    set locations(value: string[]);
    get locationsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _slaThreshold?;
    get slaThreshold(): number;
    set slaThreshold(value: number);
    resetSlaThreshold(): void;
    get slaThresholdInput(): number | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    get statusInput(): string | undefined;
    private _treatRedirectAsFailure?;
    get treatRedirectAsFailure(): boolean | cdktf.IResolvable;
    set treatRedirectAsFailure(value: boolean | cdktf.IResolvable);
    resetTreatRedirectAsFailure(): void;
    get treatRedirectAsFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    resetUri(): void;
    get uriInput(): string | undefined;
    private _validationString?;
    get validationString(): string;
    set validationString(value: string);
    resetValidationString(): void;
    get validationStringInput(): string | undefined;
    private _verifySsl?;
    get verifySsl(): boolean | cdktf.IResolvable;
    set verifySsl(value: boolean | cdktf.IResolvable);
    resetVerifySsl(): void;
    get verifySslInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
