import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WorkloadConfig extends cdktf.TerraformMetaArguments {
    /**
    * The New Relic account ID where you want to create the workload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#account_id Workload#account_id}
    */
    readonly accountId?: number;
    /**
    * A list of entity GUIDs manually assigned to this workload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#entity_guids Workload#entity_guids}
    */
    readonly entityGuids?: string[];
    /**
    * The workload's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#name Workload#name}
    */
    readonly name: string;
    /**
    * A list of account IDs that will be used to get entities from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#scope_account_ids Workload#scope_account_ids}
    */
    readonly scopeAccountIds?: number[];
    /**
    * entity_search_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#entity_search_query Workload#entity_search_query}
    */
    readonly entitySearchQuery?: WorkloadEntitySearchQuery[] | cdktf.IResolvable;
}
export interface WorkloadEntitySearchQuery {
    /**
    * The query.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/workload#query Workload#query}
    */
    readonly query: string;
}
export declare function workloadEntitySearchQueryToTerraform(struct?: WorkloadEntitySearchQuery | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/workload newrelic_workload}
*/
export declare class Workload extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/workload newrelic_workload} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WorkloadConfig
    */
    constructor(scope: Construct, id: string, config: WorkloadConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    get compositeEntitySearchQuery(): string;
    private _entityGuids?;
    get entityGuids(): string[];
    set entityGuids(value: string[]);
    resetEntityGuids(): void;
    get entityGuidsInput(): string[] | undefined;
    get guid(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get permalink(): string;
    private _scopeAccountIds?;
    get scopeAccountIds(): number[];
    set scopeAccountIds(value: number[]);
    resetScopeAccountIds(): void;
    get scopeAccountIdsInput(): number[] | undefined;
    get workloadId(): number;
    private _entitySearchQuery?;
    get entitySearchQuery(): WorkloadEntitySearchQuery[] | cdktf.IResolvable;
    set entitySearchQuery(value: WorkloadEntitySearchQuery[] | cdktf.IResolvable);
    resetEntitySearchQuery(): void;
    get entitySearchQueryInput(): cdktf.IResolvable | WorkloadEntitySearchQuery[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
