BEDROCK_MODELS = {
    #  ███████████               █████                             █████
    # ░░███░░░░░███             ░░███                             ░░███
    #  ░███    ░███  ██████   ███████  ████████   ██████   ██████  ░███ █████
    #  ░██████████  ███░░███ ███░░███ ░░███░░███ ███░░███ ███░░███ ░███░░███
    #  ░███░░░░░███░███████ ░███ ░███  ░███ ░░░ ░███ ░███░███ ░░░  ░██████░
    #  ░███    ░███░███░░░  ░███ ░███  ░███     ░███ ░███░███  ███ ░███░░███
    #  ███████████ ░░██████ ░░████████ █████    ░░██████ ░░██████  ████ █████
    # ░░░░░░░░░░░   ░░░░░░   ░░░░░░░░ ░░░░░      ░░░░░░   ░░░░░░  ░░░░ ░░░░░
    "claude-3-haiku-bedrock": {
        "id": "claude-3-haiku-bedrock",
        "name": "us.anthropic.claude-3-haiku-20240307-v1:0",
        "regions": ["us-east-1", "us-west-2", "ap-southeast-2", "eu-west-3"],
        "api_base": "",
        "api_key_env_var": "",
        "api_spec": "bedrock",
        "input_cost": 0.25,
        "output_cost": 1.25,
        "requests_per_minute": 4_000,
        "tokens_per_minute": 8_000_000,
    },
    "claude-3.5-haiku-bedrock": {
        "id": "claude-3.5-haiku-bedrock",
        "name": "us.anthropic.claude-3-5-haiku-20241022-v1:0",
        "regions": ["us-east-1", "us-west-2", "ap-southeast-2", "eu-west-3"],
        "api_base": "",
        "api_key_env_var": "",
        "api_spec": "bedrock",
        "input_cost": 0.25,
        "output_cost": 1.25,
        "requests_per_minute": 4_000,
        "tokens_per_minute": 8_000_000,
    },
    "claude-3.5-sonnet-bedrock": {
        "id": "claude-3.5-sonnet-bedrock",
        "name": "us.anthropic.claude-3-5-sonnet-20240620-v1:0",
        "regions": ["us-east-1", "us-west-2"],
        "api_base": "",
        "api_key_env_var": "",
        "api_spec": "bedrock",
        "input_cost": 3.0,
        "output_cost": 15.0,
        "requests_per_minute": 4_000,
        "tokens_per_minute": 400_000,
        "reasoning_model": False,
    },
    "claude-3.6-sonnet-bedrock": {
        "id": "claude-3.6-sonnet-bedrock",
        "name": "us.anthropic.claude-3-5-sonnet-20241022-v2:0",
        "regions": ["us-east-1", "us-west-2", "us-east-2"],
        "api_base": "",
        "api_key_env_var": "",
        "api_spec": "bedrock",
        "input_cost": 3.0,
        "output_cost": 15.0,
        "requests_per_minute": 4_000,
        "tokens_per_minute": 400_000,
        "reasoning_model": False,
    },
    "claude-3.7-sonnet-bedrock": {
        "id": "claude-3.7-sonnet-bedrock",
        "name": "us.anthropic.claude-3-7-sonnet-20250219-v1:0",
        "regions": ["us-east-1", "us-west-2", "eu-west-1"],
        "api_base": "",
        "api_key_env_var": "",
        "api_spec": "bedrock",
        "input_cost": 3.0,
        "output_cost": 15.0,
        "requests_per_minute": 4_000,
        "tokens_per_minute": 400_000,
        "reasoning_model": True,
    },
    "claude-4-sonnet-bedrock": {
        "id": "claude-4-sonnet-bedrock",
        "name": "us.anthropic.claude-sonnet-4-20250514-v1:0",
        "regions": ["us-east-1", "us-west-2", "us-east-2"],
        "api_base": "",
        "api_key_env_var": "",
        "api_spec": "bedrock",
        "input_cost": 3.0,
        "output_cost": 15.0,
        "requests_per_minute": 4_000,
        "tokens_per_minute": 400_000,
        "reasoning_model": True,
    },
    "claude-4-opus-bedrock": {
        "id": "claude-4-opus-bedrock",
        "name": "us.anthropic.claude-opus-4-20250514-v1:0",
        "regions": ["us-east-1", "us-west-2", "us-east-2"],
        "api_base": "",
        "api_key_env_var": "",
        "api_spec": "bedrock",
        "input_cost": 3.0,
        "output_cost": 15.0,
        "requests_per_minute": 4_000,
        "tokens_per_minute": 400_000,
        "reasoning_model": True,
    },
    # GPT-OSS on AWS Bedrock
    "gpt-oss-120b-bedrock": {
        "id": "gpt-oss-120b-bedrock",
        "name": "openai.gpt-oss-120b-1:0",
        "regions": ["us-west-2"],
        "api_base": "",
        "api_key_env_var": "",
        "api_spec": "bedrock",
        "input_cost": 0.0,
        "output_cost": 0.0,
        "supports_json": False,
        "supports_logprobs": False,
        "supports_responses": False,
        "reasoning_model": False,
    },
    "gpt-oss-20b-bedrock": {
        "id": "gpt-oss-20b-bedrock",
        "name": "openai.gpt-oss-20b-1:0",
        "regions": ["us-west-2"],
        "api_base": "",
        "api_key_env_var": "",
        "api_spec": "bedrock",
        "input_cost": 0.0,
        "output_cost": 0.0,
        "supports_json": False,
        "supports_logprobs": False,
        "supports_responses": False,
        "reasoning_model": False,
    },
}
