# coding: utf-8

"""
    Akeyless API

    The purpose of this application is to provide access to Akeyless API.  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: support@akeyless.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from akeyless.configuration import Configuration


class AuthMethodCreateOauth2(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'access_expires': 'int',
        'audience': 'str',
        'audit_logs_claims': 'list[str]',
        'bound_client_ids': 'list[str]',
        'bound_ips': 'list[str]',
        'cert': 'str',
        'cert_file_data': 'str',
        'delete_protection': 'str',
        'description': 'str',
        'expiration_event_in': 'list[str]',
        'force_sub_claims': 'bool',
        'gateway_url': 'str',
        'gw_bound_ips': 'list[str]',
        'issuer': 'str',
        'json': 'bool',
        'jwks_json_data': 'str',
        'jwks_uri': 'str',
        'jwt_ttl': 'int',
        'name': 'str',
        'product_type': 'list[str]',
        'subclaims_delimiters': 'list[str]',
        'token': 'str',
        'uid_token': 'str',
        'unique_identifier': 'str'
    }

    attribute_map = {
        'access_expires': 'access-expires',
        'audience': 'audience',
        'audit_logs_claims': 'audit-logs-claims',
        'bound_client_ids': 'bound-client-ids',
        'bound_ips': 'bound-ips',
        'cert': 'cert',
        'cert_file_data': 'cert-file-data',
        'delete_protection': 'delete_protection',
        'description': 'description',
        'expiration_event_in': 'expiration-event-in',
        'force_sub_claims': 'force-sub-claims',
        'gateway_url': 'gateway-url',
        'gw_bound_ips': 'gw-bound-ips',
        'issuer': 'issuer',
        'json': 'json',
        'jwks_json_data': 'jwks-json-data',
        'jwks_uri': 'jwks-uri',
        'jwt_ttl': 'jwt-ttl',
        'name': 'name',
        'product_type': 'product-type',
        'subclaims_delimiters': 'subclaims-delimiters',
        'token': 'token',
        'uid_token': 'uid-token',
        'unique_identifier': 'unique-identifier'
    }

    def __init__(self, access_expires=0, audience=None, audit_logs_claims=None, bound_client_ids=None, bound_ips=None, cert=None, cert_file_data=None, delete_protection=None, description=None, expiration_event_in=None, force_sub_claims=None, gateway_url=None, gw_bound_ips=None, issuer=None, json=False, jwks_json_data=None, jwks_uri=None, jwt_ttl=0, name=None, product_type=None, subclaims_delimiters=None, token=None, uid_token=None, unique_identifier=None, local_vars_configuration=None):  # noqa: E501
        """AuthMethodCreateOauth2 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._access_expires = None
        self._audience = None
        self._audit_logs_claims = None
        self._bound_client_ids = None
        self._bound_ips = None
        self._cert = None
        self._cert_file_data = None
        self._delete_protection = None
        self._description = None
        self._expiration_event_in = None
        self._force_sub_claims = None
        self._gateway_url = None
        self._gw_bound_ips = None
        self._issuer = None
        self._json = None
        self._jwks_json_data = None
        self._jwks_uri = None
        self._jwt_ttl = None
        self._name = None
        self._product_type = None
        self._subclaims_delimiters = None
        self._token = None
        self._uid_token = None
        self._unique_identifier = None
        self.discriminator = None

        if access_expires is not None:
            self.access_expires = access_expires
        if audience is not None:
            self.audience = audience
        if audit_logs_claims is not None:
            self.audit_logs_claims = audit_logs_claims
        if bound_client_ids is not None:
            self.bound_client_ids = bound_client_ids
        if bound_ips is not None:
            self.bound_ips = bound_ips
        if cert is not None:
            self.cert = cert
        if cert_file_data is not None:
            self.cert_file_data = cert_file_data
        if delete_protection is not None:
            self.delete_protection = delete_protection
        if description is not None:
            self.description = description
        if expiration_event_in is not None:
            self.expiration_event_in = expiration_event_in
        if force_sub_claims is not None:
            self.force_sub_claims = force_sub_claims
        if gateway_url is not None:
            self.gateway_url = gateway_url
        if gw_bound_ips is not None:
            self.gw_bound_ips = gw_bound_ips
        if issuer is not None:
            self.issuer = issuer
        if json is not None:
            self.json = json
        if jwks_json_data is not None:
            self.jwks_json_data = jwks_json_data
        if jwks_uri is not None:
            self.jwks_uri = jwks_uri
        if jwt_ttl is not None:
            self.jwt_ttl = jwt_ttl
        self.name = name
        if product_type is not None:
            self.product_type = product_type
        if subclaims_delimiters is not None:
            self.subclaims_delimiters = subclaims_delimiters
        if token is not None:
            self.token = token
        if uid_token is not None:
            self.uid_token = uid_token
        self.unique_identifier = unique_identifier

    @property
    def access_expires(self):
        """Gets the access_expires of this AuthMethodCreateOauth2.  # noqa: E501

        Access expiration date in Unix timestamp (select 0 for access without expiry date)  # noqa: E501

        :return: The access_expires of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: int
        """
        return self._access_expires

    @access_expires.setter
    def access_expires(self, access_expires):
        """Sets the access_expires of this AuthMethodCreateOauth2.

        Access expiration date in Unix timestamp (select 0 for access without expiry date)  # noqa: E501

        :param access_expires: The access_expires of this AuthMethodCreateOauth2.  # noqa: E501
        :type: int
        """

        self._access_expires = access_expires

    @property
    def audience(self):
        """Gets the audience of this AuthMethodCreateOauth2.  # noqa: E501

        The audience in the JWT  # noqa: E501

        :return: The audience of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._audience

    @audience.setter
    def audience(self, audience):
        """Sets the audience of this AuthMethodCreateOauth2.

        The audience in the JWT  # noqa: E501

        :param audience: The audience of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """

        self._audience = audience

    @property
    def audit_logs_claims(self):
        """Gets the audit_logs_claims of this AuthMethodCreateOauth2.  # noqa: E501

        Subclaims to include in audit logs, e.g \"--audit-logs-claims email --audit-logs-claims username\"  # noqa: E501

        :return: The audit_logs_claims of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: list[str]
        """
        return self._audit_logs_claims

    @audit_logs_claims.setter
    def audit_logs_claims(self, audit_logs_claims):
        """Sets the audit_logs_claims of this AuthMethodCreateOauth2.

        Subclaims to include in audit logs, e.g \"--audit-logs-claims email --audit-logs-claims username\"  # noqa: E501

        :param audit_logs_claims: The audit_logs_claims of this AuthMethodCreateOauth2.  # noqa: E501
        :type: list[str]
        """

        self._audit_logs_claims = audit_logs_claims

    @property
    def bound_client_ids(self):
        """Gets the bound_client_ids of this AuthMethodCreateOauth2.  # noqa: E501

        The clients ids that the access is restricted to  # noqa: E501

        :return: The bound_client_ids of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_client_ids

    @bound_client_ids.setter
    def bound_client_ids(self, bound_client_ids):
        """Sets the bound_client_ids of this AuthMethodCreateOauth2.

        The clients ids that the access is restricted to  # noqa: E501

        :param bound_client_ids: The bound_client_ids of this AuthMethodCreateOauth2.  # noqa: E501
        :type: list[str]
        """

        self._bound_client_ids = bound_client_ids

    @property
    def bound_ips(self):
        """Gets the bound_ips of this AuthMethodCreateOauth2.  # noqa: E501

        A CIDR whitelist with the IPs that the access is restricted to  # noqa: E501

        :return: The bound_ips of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_ips

    @bound_ips.setter
    def bound_ips(self, bound_ips):
        """Sets the bound_ips of this AuthMethodCreateOauth2.

        A CIDR whitelist with the IPs that the access is restricted to  # noqa: E501

        :param bound_ips: The bound_ips of this AuthMethodCreateOauth2.  # noqa: E501
        :type: list[str]
        """

        self._bound_ips = bound_ips

    @property
    def cert(self):
        """Gets the cert of this AuthMethodCreateOauth2.  # noqa: E501

        CertificateFile Path to a file that contain the certificate in a PEM format.  # noqa: E501

        :return: The cert of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._cert

    @cert.setter
    def cert(self, cert):
        """Sets the cert of this AuthMethodCreateOauth2.

        CertificateFile Path to a file that contain the certificate in a PEM format.  # noqa: E501

        :param cert: The cert of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """

        self._cert = cert

    @property
    def cert_file_data(self):
        """Gets the cert_file_data of this AuthMethodCreateOauth2.  # noqa: E501

        CertificateFileData PEM Certificate in a Base64 format.  # noqa: E501

        :return: The cert_file_data of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._cert_file_data

    @cert_file_data.setter
    def cert_file_data(self, cert_file_data):
        """Sets the cert_file_data of this AuthMethodCreateOauth2.

        CertificateFileData PEM Certificate in a Base64 format.  # noqa: E501

        :param cert_file_data: The cert_file_data of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """

        self._cert_file_data = cert_file_data

    @property
    def delete_protection(self):
        """Gets the delete_protection of this AuthMethodCreateOauth2.  # noqa: E501

        Protection from accidental deletion of this object [true/false]  # noqa: E501

        :return: The delete_protection of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._delete_protection

    @delete_protection.setter
    def delete_protection(self, delete_protection):
        """Sets the delete_protection of this AuthMethodCreateOauth2.

        Protection from accidental deletion of this object [true/false]  # noqa: E501

        :param delete_protection: The delete_protection of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """

        self._delete_protection = delete_protection

    @property
    def description(self):
        """Gets the description of this AuthMethodCreateOauth2.  # noqa: E501

        Auth Method description  # noqa: E501

        :return: The description of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AuthMethodCreateOauth2.

        Auth Method description  # noqa: E501

        :param description: The description of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def expiration_event_in(self):
        """Gets the expiration_event_in of this AuthMethodCreateOauth2.  # noqa: E501

        How many days before the expiration of the auth method would you like to be notified.  # noqa: E501

        :return: The expiration_event_in of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: list[str]
        """
        return self._expiration_event_in

    @expiration_event_in.setter
    def expiration_event_in(self, expiration_event_in):
        """Sets the expiration_event_in of this AuthMethodCreateOauth2.

        How many days before the expiration of the auth method would you like to be notified.  # noqa: E501

        :param expiration_event_in: The expiration_event_in of this AuthMethodCreateOauth2.  # noqa: E501
        :type: list[str]
        """

        self._expiration_event_in = expiration_event_in

    @property
    def force_sub_claims(self):
        """Gets the force_sub_claims of this AuthMethodCreateOauth2.  # noqa: E501

        if true: enforce role-association must include sub claims  # noqa: E501

        :return: The force_sub_claims of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: bool
        """
        return self._force_sub_claims

    @force_sub_claims.setter
    def force_sub_claims(self, force_sub_claims):
        """Sets the force_sub_claims of this AuthMethodCreateOauth2.

        if true: enforce role-association must include sub claims  # noqa: E501

        :param force_sub_claims: The force_sub_claims of this AuthMethodCreateOauth2.  # noqa: E501
        :type: bool
        """

        self._force_sub_claims = force_sub_claims

    @property
    def gateway_url(self):
        """Gets the gateway_url of this AuthMethodCreateOauth2.  # noqa: E501

        Akeyless Gateway URL (Configuration Management port). Relevant only when the jwks-uri is accessible only from the gateway.  # noqa: E501

        :return: The gateway_url of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._gateway_url

    @gateway_url.setter
    def gateway_url(self, gateway_url):
        """Sets the gateway_url of this AuthMethodCreateOauth2.

        Akeyless Gateway URL (Configuration Management port). Relevant only when the jwks-uri is accessible only from the gateway.  # noqa: E501

        :param gateway_url: The gateway_url of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """

        self._gateway_url = gateway_url

    @property
    def gw_bound_ips(self):
        """Gets the gw_bound_ips of this AuthMethodCreateOauth2.  # noqa: E501

        A CIDR whitelist with the GW IPs that the access is restricted to  # noqa: E501

        :return: The gw_bound_ips of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: list[str]
        """
        return self._gw_bound_ips

    @gw_bound_ips.setter
    def gw_bound_ips(self, gw_bound_ips):
        """Sets the gw_bound_ips of this AuthMethodCreateOauth2.

        A CIDR whitelist with the GW IPs that the access is restricted to  # noqa: E501

        :param gw_bound_ips: The gw_bound_ips of this AuthMethodCreateOauth2.  # noqa: E501
        :type: list[str]
        """

        self._gw_bound_ips = gw_bound_ips

    @property
    def issuer(self):
        """Gets the issuer of this AuthMethodCreateOauth2.  # noqa: E501

        Issuer URL  # noqa: E501

        :return: The issuer of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._issuer

    @issuer.setter
    def issuer(self, issuer):
        """Sets the issuer of this AuthMethodCreateOauth2.

        Issuer URL  # noqa: E501

        :param issuer: The issuer of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """

        self._issuer = issuer

    @property
    def json(self):
        """Gets the json of this AuthMethodCreateOauth2.  # noqa: E501

        Set output format to JSON  # noqa: E501

        :return: The json of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: bool
        """
        return self._json

    @json.setter
    def json(self, json):
        """Sets the json of this AuthMethodCreateOauth2.

        Set output format to JSON  # noqa: E501

        :param json: The json of this AuthMethodCreateOauth2.  # noqa: E501
        :type: bool
        """

        self._json = json

    @property
    def jwks_json_data(self):
        """Gets the jwks_json_data of this AuthMethodCreateOauth2.  # noqa: E501

        The JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server. base64 encoded string  # noqa: E501

        :return: The jwks_json_data of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._jwks_json_data

    @jwks_json_data.setter
    def jwks_json_data(self, jwks_json_data):
        """Sets the jwks_json_data of this AuthMethodCreateOauth2.

        The JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server. base64 encoded string  # noqa: E501

        :param jwks_json_data: The jwks_json_data of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """

        self._jwks_json_data = jwks_json_data

    @property
    def jwks_uri(self):
        """Gets the jwks_uri of this AuthMethodCreateOauth2.  # noqa: E501

        The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.  # noqa: E501

        :return: The jwks_uri of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._jwks_uri

    @jwks_uri.setter
    def jwks_uri(self, jwks_uri):
        """Sets the jwks_uri of this AuthMethodCreateOauth2.

        The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.  # noqa: E501

        :param jwks_uri: The jwks_uri of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """

        self._jwks_uri = jwks_uri

    @property
    def jwt_ttl(self):
        """Gets the jwt_ttl of this AuthMethodCreateOauth2.  # noqa: E501

        Jwt TTL  # noqa: E501

        :return: The jwt_ttl of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: int
        """
        return self._jwt_ttl

    @jwt_ttl.setter
    def jwt_ttl(self, jwt_ttl):
        """Sets the jwt_ttl of this AuthMethodCreateOauth2.

        Jwt TTL  # noqa: E501

        :param jwt_ttl: The jwt_ttl of this AuthMethodCreateOauth2.  # noqa: E501
        :type: int
        """

        self._jwt_ttl = jwt_ttl

    @property
    def name(self):
        """Gets the name of this AuthMethodCreateOauth2.  # noqa: E501

        Auth Method name  # noqa: E501

        :return: The name of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AuthMethodCreateOauth2.

        Auth Method name  # noqa: E501

        :param name: The name of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def product_type(self):
        """Gets the product_type of this AuthMethodCreateOauth2.  # noqa: E501

        Choose the relevant product type for the auth method [sm, sra, pm, dp, ca]  # noqa: E501

        :return: The product_type of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: list[str]
        """
        return self._product_type

    @product_type.setter
    def product_type(self, product_type):
        """Sets the product_type of this AuthMethodCreateOauth2.

        Choose the relevant product type for the auth method [sm, sra, pm, dp, ca]  # noqa: E501

        :param product_type: The product_type of this AuthMethodCreateOauth2.  # noqa: E501
        :type: list[str]
        """

        self._product_type = product_type

    @property
    def subclaims_delimiters(self):
        """Gets the subclaims_delimiters of this AuthMethodCreateOauth2.  # noqa: E501

        A list of additional sub claims delimiters (relevant only for SAML, OIDC, OAuth2/JWT)  # noqa: E501

        :return: The subclaims_delimiters of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: list[str]
        """
        return self._subclaims_delimiters

    @subclaims_delimiters.setter
    def subclaims_delimiters(self, subclaims_delimiters):
        """Sets the subclaims_delimiters of this AuthMethodCreateOauth2.

        A list of additional sub claims delimiters (relevant only for SAML, OIDC, OAuth2/JWT)  # noqa: E501

        :param subclaims_delimiters: The subclaims_delimiters of this AuthMethodCreateOauth2.  # noqa: E501
        :type: list[str]
        """

        self._subclaims_delimiters = subclaims_delimiters

    @property
    def token(self):
        """Gets the token of this AuthMethodCreateOauth2.  # noqa: E501

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :return: The token of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this AuthMethodCreateOauth2.

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :param token: The token of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """

        self._token = token

    @property
    def uid_token(self):
        """Gets the uid_token of this AuthMethodCreateOauth2.  # noqa: E501

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :return: The uid_token of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._uid_token

    @uid_token.setter
    def uid_token(self, uid_token):
        """Sets the uid_token of this AuthMethodCreateOauth2.

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :param uid_token: The uid_token of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """

        self._uid_token = uid_token

    @property
    def unique_identifier(self):
        """Gets the unique_identifier of this AuthMethodCreateOauth2.  # noqa: E501

        A unique identifier (ID) value should be configured for OAuth2, LDAP and SAML authentication method types and is usually a value such as the email, username, or upn for example. Whenever a user logs in with a token, these authentication types issue a \"sub claim\" that contains details uniquely identifying that user. This sub claim includes a key containing the ID value that you configured, and is used to distinguish between different users from within the same organization.  # noqa: E501

        :return: The unique_identifier of this AuthMethodCreateOauth2.  # noqa: E501
        :rtype: str
        """
        return self._unique_identifier

    @unique_identifier.setter
    def unique_identifier(self, unique_identifier):
        """Sets the unique_identifier of this AuthMethodCreateOauth2.

        A unique identifier (ID) value should be configured for OAuth2, LDAP and SAML authentication method types and is usually a value such as the email, username, or upn for example. Whenever a user logs in with a token, these authentication types issue a \"sub claim\" that contains details uniquely identifying that user. This sub claim includes a key containing the ID value that you configured, and is used to distinguish between different users from within the same organization.  # noqa: E501

        :param unique_identifier: The unique_identifier of this AuthMethodCreateOauth2.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and unique_identifier is None:  # noqa: E501
            raise ValueError("Invalid value for `unique_identifier`, must not be `None`")  # noqa: E501

        self._unique_identifier = unique_identifier

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuthMethodCreateOauth2):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AuthMethodCreateOauth2):
            return True

        return self.to_dict() != other.to_dict()
