# coding: utf-8

"""
    Akeyless API

    The purpose of this application is to provide access to Akeyless API.  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: support@akeyless.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from akeyless.configuration import Configuration


class EsmUpdate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'binary_value': 'bool',
        'description': 'str',
        'esm_name': 'str',
        'json': 'bool',
        'secret_id': 'str',
        'tags': 'dict(str, str)',
        'token': 'str',
        'uid_token': 'str',
        'value': 'str'
    }

    attribute_map = {
        'binary_value': 'binary-value',
        'description': 'description',
        'esm_name': 'esm-name',
        'json': 'json',
        'secret_id': 'secret-id',
        'tags': 'tags',
        'token': 'token',
        'uid_token': 'uid-token',
        'value': 'value'
    }

    def __init__(self, binary_value=None, description=None, esm_name=None, json=False, secret_id=None, tags=None, token=None, uid_token=None, value=None, local_vars_configuration=None):  # noqa: E501
        """EsmUpdate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._binary_value = None
        self._description = None
        self._esm_name = None
        self._json = None
        self._secret_id = None
        self._tags = None
        self._token = None
        self._uid_token = None
        self._value = None
        self.discriminator = None

        if binary_value is not None:
            self.binary_value = binary_value
        if description is not None:
            self.description = description
        self.esm_name = esm_name
        if json is not None:
            self.json = json
        self.secret_id = secret_id
        if tags is not None:
            self.tags = tags
        if token is not None:
            self.token = token
        if uid_token is not None:
            self.uid_token = uid_token
        self.value = value

    @property
    def binary_value(self):
        """Gets the binary_value of this EsmUpdate.  # noqa: E501

        Use this option if the external secret value is a base64 encoded binary  # noqa: E501

        :return: The binary_value of this EsmUpdate.  # noqa: E501
        :rtype: bool
        """
        return self._binary_value

    @binary_value.setter
    def binary_value(self, binary_value):
        """Sets the binary_value of this EsmUpdate.

        Use this option if the external secret value is a base64 encoded binary  # noqa: E501

        :param binary_value: The binary_value of this EsmUpdate.  # noqa: E501
        :type: bool
        """

        self._binary_value = binary_value

    @property
    def description(self):
        """Gets the description of this EsmUpdate.  # noqa: E501

        Description of the external secret  # noqa: E501

        :return: The description of this EsmUpdate.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this EsmUpdate.

        Description of the external secret  # noqa: E501

        :param description: The description of this EsmUpdate.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def esm_name(self):
        """Gets the esm_name of this EsmUpdate.  # noqa: E501

        Name of the External Secrets Manager item  # noqa: E501

        :return: The esm_name of this EsmUpdate.  # noqa: E501
        :rtype: str
        """
        return self._esm_name

    @esm_name.setter
    def esm_name(self, esm_name):
        """Sets the esm_name of this EsmUpdate.

        Name of the External Secrets Manager item  # noqa: E501

        :param esm_name: The esm_name of this EsmUpdate.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and esm_name is None:  # noqa: E501
            raise ValueError("Invalid value for `esm_name`, must not be `None`")  # noqa: E501

        self._esm_name = esm_name

    @property
    def json(self):
        """Gets the json of this EsmUpdate.  # noqa: E501

        Set output format to JSON  # noqa: E501

        :return: The json of this EsmUpdate.  # noqa: E501
        :rtype: bool
        """
        return self._json

    @json.setter
    def json(self, json):
        """Sets the json of this EsmUpdate.

        Set output format to JSON  # noqa: E501

        :param json: The json of this EsmUpdate.  # noqa: E501
        :type: bool
        """

        self._json = json

    @property
    def secret_id(self):
        """Gets the secret_id of this EsmUpdate.  # noqa: E501

        The external secret id (or name, for AWS, Azure or K8s targets) to update  # noqa: E501

        :return: The secret_id of this EsmUpdate.  # noqa: E501
        :rtype: str
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """Sets the secret_id of this EsmUpdate.

        The external secret id (or name, for AWS, Azure or K8s targets) to update  # noqa: E501

        :param secret_id: The secret_id of this EsmUpdate.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and secret_id is None:  # noqa: E501
            raise ValueError("Invalid value for `secret_id`, must not be `None`")  # noqa: E501

        self._secret_id = secret_id

    @property
    def tags(self):
        """Gets the tags of this EsmUpdate.  # noqa: E501

        Tags for the external secret  # noqa: E501

        :return: The tags of this EsmUpdate.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this EsmUpdate.

        Tags for the external secret  # noqa: E501

        :param tags: The tags of this EsmUpdate.  # noqa: E501
        :type: dict(str, str)
        """

        self._tags = tags

    @property
    def token(self):
        """Gets the token of this EsmUpdate.  # noqa: E501

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :return: The token of this EsmUpdate.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this EsmUpdate.

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :param token: The token of this EsmUpdate.  # noqa: E501
        :type: str
        """

        self._token = token

    @property
    def uid_token(self):
        """Gets the uid_token of this EsmUpdate.  # noqa: E501

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :return: The uid_token of this EsmUpdate.  # noqa: E501
        :rtype: str
        """
        return self._uid_token

    @uid_token.setter
    def uid_token(self, uid_token):
        """Sets the uid_token of this EsmUpdate.

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :param uid_token: The uid_token of this EsmUpdate.  # noqa: E501
        :type: str
        """

        self._uid_token = uid_token

    @property
    def value(self):
        """Gets the value of this EsmUpdate.  # noqa: E501

        Value of the external secret item, either text or base64 encoded binary  # noqa: E501

        :return: The value of this EsmUpdate.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this EsmUpdate.

        Value of the external secret item, either text or base64 encoded binary  # noqa: E501

        :param value: The value of this EsmUpdate.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and value is None:  # noqa: E501
            raise ValueError("Invalid value for `value`, must not be `None`")  # noqa: E501

        self._value = value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EsmUpdate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EsmUpdate):
            return True

        return self.to_dict() != other.to_dict()
