# coding: utf-8

"""
    Akeyless API

    The purpose of this application is to provide access to Akeyless API.  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: support@akeyless.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from akeyless.configuration import Configuration


class GatewayUpdateCache(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'backup_interval': 'str',
        'enable_cache': 'str',
        'enable_proactive': 'str',
        'json': 'bool',
        'minimum_fetch_interval': 'str',
        'stale_timeout': 'str',
        'token': 'str',
        'uid_token': 'str'
    }

    attribute_map = {
        'backup_interval': 'backup-interval',
        'enable_cache': 'enable-cache',
        'enable_proactive': 'enable-proactive',
        'json': 'json',
        'minimum_fetch_interval': 'minimum-fetch-interval',
        'stale_timeout': 'stale-timeout',
        'token': 'token',
        'uid_token': 'uid-token'
    }

    def __init__(self, backup_interval='1', enable_cache=None, enable_proactive=None, json=False, minimum_fetch_interval='5', stale_timeout='60', token=None, uid_token=None, local_vars_configuration=None):  # noqa: E501
        """GatewayUpdateCache - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._backup_interval = None
        self._enable_cache = None
        self._enable_proactive = None
        self._json = None
        self._minimum_fetch_interval = None
        self._stale_timeout = None
        self._token = None
        self._uid_token = None
        self.discriminator = None

        if backup_interval is not None:
            self.backup_interval = backup_interval
        if enable_cache is not None:
            self.enable_cache = enable_cache
        if enable_proactive is not None:
            self.enable_proactive = enable_proactive
        if json is not None:
            self.json = json
        if minimum_fetch_interval is not None:
            self.minimum_fetch_interval = minimum_fetch_interval
        if stale_timeout is not None:
            self.stale_timeout = stale_timeout
        if token is not None:
            self.token = token
        if uid_token is not None:
            self.uid_token = uid_token

    @property
    def backup_interval(self):
        """Gets the backup_interval of this GatewayUpdateCache.  # noqa: E501

        Secure backup interval in minutes. To ensure service continuity in case of power cycle and network outage secrets will be backed up periodically per backup interval  # noqa: E501

        :return: The backup_interval of this GatewayUpdateCache.  # noqa: E501
        :rtype: str
        """
        return self._backup_interval

    @backup_interval.setter
    def backup_interval(self, backup_interval):
        """Sets the backup_interval of this GatewayUpdateCache.

        Secure backup interval in minutes. To ensure service continuity in case of power cycle and network outage secrets will be backed up periodically per backup interval  # noqa: E501

        :param backup_interval: The backup_interval of this GatewayUpdateCache.  # noqa: E501
        :type: str
        """

        self._backup_interval = backup_interval

    @property
    def enable_cache(self):
        """Gets the enable_cache of this GatewayUpdateCache.  # noqa: E501

        Enable cache [true/false]  # noqa: E501

        :return: The enable_cache of this GatewayUpdateCache.  # noqa: E501
        :rtype: str
        """
        return self._enable_cache

    @enable_cache.setter
    def enable_cache(self, enable_cache):
        """Sets the enable_cache of this GatewayUpdateCache.

        Enable cache [true/false]  # noqa: E501

        :param enable_cache: The enable_cache of this GatewayUpdateCache.  # noqa: E501
        :type: str
        """

        self._enable_cache = enable_cache

    @property
    def enable_proactive(self):
        """Gets the enable_proactive of this GatewayUpdateCache.  # noqa: E501

        Enable proactive caching [true/false]  # noqa: E501

        :return: The enable_proactive of this GatewayUpdateCache.  # noqa: E501
        :rtype: str
        """
        return self._enable_proactive

    @enable_proactive.setter
    def enable_proactive(self, enable_proactive):
        """Sets the enable_proactive of this GatewayUpdateCache.

        Enable proactive caching [true/false]  # noqa: E501

        :param enable_proactive: The enable_proactive of this GatewayUpdateCache.  # noqa: E501
        :type: str
        """

        self._enable_proactive = enable_proactive

    @property
    def json(self):
        """Gets the json of this GatewayUpdateCache.  # noqa: E501

        Set output format to JSON  # noqa: E501

        :return: The json of this GatewayUpdateCache.  # noqa: E501
        :rtype: bool
        """
        return self._json

    @json.setter
    def json(self, json):
        """Sets the json of this GatewayUpdateCache.

        Set output format to JSON  # noqa: E501

        :param json: The json of this GatewayUpdateCache.  # noqa: E501
        :type: bool
        """

        self._json = json

    @property
    def minimum_fetch_interval(self):
        """Gets the minimum_fetch_interval of this GatewayUpdateCache.  # noqa: E501

        When using Cache or/and Proactive Cache, additional secrets will be fetched upon requesting a secret, based on the requestor's access policy. Define minimum fetching interval to avoid over fetching in a given time frame  # noqa: E501

        :return: The minimum_fetch_interval of this GatewayUpdateCache.  # noqa: E501
        :rtype: str
        """
        return self._minimum_fetch_interval

    @minimum_fetch_interval.setter
    def minimum_fetch_interval(self, minimum_fetch_interval):
        """Sets the minimum_fetch_interval of this GatewayUpdateCache.

        When using Cache or/and Proactive Cache, additional secrets will be fetched upon requesting a secret, based on the requestor's access policy. Define minimum fetching interval to avoid over fetching in a given time frame  # noqa: E501

        :param minimum_fetch_interval: The minimum_fetch_interval of this GatewayUpdateCache.  # noqa: E501
        :type: str
        """

        self._minimum_fetch_interval = minimum_fetch_interval

    @property
    def stale_timeout(self):
        """Gets the stale_timeout of this GatewayUpdateCache.  # noqa: E501

        Stale timeout in minutes, cache entries which are not accessed within timeout will be removed from cache  # noqa: E501

        :return: The stale_timeout of this GatewayUpdateCache.  # noqa: E501
        :rtype: str
        """
        return self._stale_timeout

    @stale_timeout.setter
    def stale_timeout(self, stale_timeout):
        """Sets the stale_timeout of this GatewayUpdateCache.

        Stale timeout in minutes, cache entries which are not accessed within timeout will be removed from cache  # noqa: E501

        :param stale_timeout: The stale_timeout of this GatewayUpdateCache.  # noqa: E501
        :type: str
        """

        self._stale_timeout = stale_timeout

    @property
    def token(self):
        """Gets the token of this GatewayUpdateCache.  # noqa: E501

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :return: The token of this GatewayUpdateCache.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this GatewayUpdateCache.

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :param token: The token of this GatewayUpdateCache.  # noqa: E501
        :type: str
        """

        self._token = token

    @property
    def uid_token(self):
        """Gets the uid_token of this GatewayUpdateCache.  # noqa: E501

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :return: The uid_token of this GatewayUpdateCache.  # noqa: E501
        :rtype: str
        """
        return self._uid_token

    @uid_token.setter
    def uid_token(self, uid_token):
        """Sets the uid_token of this GatewayUpdateCache.

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :param uid_token: The uid_token of this GatewayUpdateCache.  # noqa: E501
        :type: str
        """

        self._uid_token = uid_token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GatewayUpdateCache):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GatewayUpdateCache):
            return True

        return self.to_dict() != other.to_dict()
