# coding: utf-8

"""
    Akeyless API

    The purpose of this application is to provide access to Akeyless API.  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: support@akeyless.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from akeyless.configuration import Configuration


class GatewayUpdateDefaults(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cert_access_id': 'str',
        'event_on_status_change': 'str',
        'hvp_route_version': 'int',
        'json': 'bool',
        'key': 'str',
        'oidc_access_id': 'str',
        'saml_access_id': 'str',
        'token': 'str',
        'uid_token': 'str'
    }

    attribute_map = {
        'cert_access_id': 'cert-access-id',
        'event_on_status_change': 'event-on-status-change',
        'hvp_route_version': 'hvp-route-version',
        'json': 'json',
        'key': 'key',
        'oidc_access_id': 'oidc-access-id',
        'saml_access_id': 'saml-access-id',
        'token': 'token',
        'uid_token': 'uid-token'
    }

    def __init__(self, cert_access_id='use-existing', event_on_status_change=None, hvp_route_version=None, json=False, key='Default', oidc_access_id='use-existing', saml_access_id='use-existing', token=None, uid_token=None, local_vars_configuration=None):  # noqa: E501
        """GatewayUpdateDefaults - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._cert_access_id = None
        self._event_on_status_change = None
        self._hvp_route_version = None
        self._json = None
        self._key = None
        self._oidc_access_id = None
        self._saml_access_id = None
        self._token = None
        self._uid_token = None
        self.discriminator = None

        if cert_access_id is not None:
            self.cert_access_id = cert_access_id
        if event_on_status_change is not None:
            self.event_on_status_change = event_on_status_change
        if hvp_route_version is not None:
            self.hvp_route_version = hvp_route_version
        if json is not None:
            self.json = json
        if key is not None:
            self.key = key
        if oidc_access_id is not None:
            self.oidc_access_id = oidc_access_id
        if saml_access_id is not None:
            self.saml_access_id = saml_access_id
        if token is not None:
            self.token = token
        if uid_token is not None:
            self.uid_token = uid_token

    @property
    def cert_access_id(self):
        """Gets the cert_access_id of this GatewayUpdateDefaults.  # noqa: E501

        Default Certificate access id for UI login  # noqa: E501

        :return: The cert_access_id of this GatewayUpdateDefaults.  # noqa: E501
        :rtype: str
        """
        return self._cert_access_id

    @cert_access_id.setter
    def cert_access_id(self, cert_access_id):
        """Sets the cert_access_id of this GatewayUpdateDefaults.

        Default Certificate access id for UI login  # noqa: E501

        :param cert_access_id: The cert_access_id of this GatewayUpdateDefaults.  # noqa: E501
        :type: str
        """

        self._cert_access_id = cert_access_id

    @property
    def event_on_status_change(self):
        """Gets the event_on_status_change of this GatewayUpdateDefaults.  # noqa: E501

        Trigger an event when Gateway status is changed [true/false]  # noqa: E501

        :return: The event_on_status_change of this GatewayUpdateDefaults.  # noqa: E501
        :rtype: str
        """
        return self._event_on_status_change

    @event_on_status_change.setter
    def event_on_status_change(self, event_on_status_change):
        """Sets the event_on_status_change of this GatewayUpdateDefaults.

        Trigger an event when Gateway status is changed [true/false]  # noqa: E501

        :param event_on_status_change: The event_on_status_change of this GatewayUpdateDefaults.  # noqa: E501
        :type: str
        """

        self._event_on_status_change = event_on_status_change

    @property
    def hvp_route_version(self):
        """Gets the hvp_route_version of this GatewayUpdateDefaults.  # noqa: E501

        Hvp route version to use [1/2]  # noqa: E501

        :return: The hvp_route_version of this GatewayUpdateDefaults.  # noqa: E501
        :rtype: int
        """
        return self._hvp_route_version

    @hvp_route_version.setter
    def hvp_route_version(self, hvp_route_version):
        """Sets the hvp_route_version of this GatewayUpdateDefaults.

        Hvp route version to use [1/2]  # noqa: E501

        :param hvp_route_version: The hvp_route_version of this GatewayUpdateDefaults.  # noqa: E501
        :type: int
        """

        self._hvp_route_version = hvp_route_version

    @property
    def json(self):
        """Gets the json of this GatewayUpdateDefaults.  # noqa: E501

        Set output format to JSON  # noqa: E501

        :return: The json of this GatewayUpdateDefaults.  # noqa: E501
        :rtype: bool
        """
        return self._json

    @json.setter
    def json(self, json):
        """Sets the json of this GatewayUpdateDefaults.

        Set output format to JSON  # noqa: E501

        :param json: The json of this GatewayUpdateDefaults.  # noqa: E501
        :type: bool
        """

        self._json = json

    @property
    def key(self):
        """Gets the key of this GatewayUpdateDefaults.  # noqa: E501

        The name of the gateway default encryption key  # noqa: E501

        :return: The key of this GatewayUpdateDefaults.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this GatewayUpdateDefaults.

        The name of the gateway default encryption key  # noqa: E501

        :param key: The key of this GatewayUpdateDefaults.  # noqa: E501
        :type: str
        """

        self._key = key

    @property
    def oidc_access_id(self):
        """Gets the oidc_access_id of this GatewayUpdateDefaults.  # noqa: E501

        Default OIDC access id for UI login  # noqa: E501

        :return: The oidc_access_id of this GatewayUpdateDefaults.  # noqa: E501
        :rtype: str
        """
        return self._oidc_access_id

    @oidc_access_id.setter
    def oidc_access_id(self, oidc_access_id):
        """Sets the oidc_access_id of this GatewayUpdateDefaults.

        Default OIDC access id for UI login  # noqa: E501

        :param oidc_access_id: The oidc_access_id of this GatewayUpdateDefaults.  # noqa: E501
        :type: str
        """

        self._oidc_access_id = oidc_access_id

    @property
    def saml_access_id(self):
        """Gets the saml_access_id of this GatewayUpdateDefaults.  # noqa: E501

        Default SAML access id for UI login  # noqa: E501

        :return: The saml_access_id of this GatewayUpdateDefaults.  # noqa: E501
        :rtype: str
        """
        return self._saml_access_id

    @saml_access_id.setter
    def saml_access_id(self, saml_access_id):
        """Sets the saml_access_id of this GatewayUpdateDefaults.

        Default SAML access id for UI login  # noqa: E501

        :param saml_access_id: The saml_access_id of this GatewayUpdateDefaults.  # noqa: E501
        :type: str
        """

        self._saml_access_id = saml_access_id

    @property
    def token(self):
        """Gets the token of this GatewayUpdateDefaults.  # noqa: E501

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :return: The token of this GatewayUpdateDefaults.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this GatewayUpdateDefaults.

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :param token: The token of this GatewayUpdateDefaults.  # noqa: E501
        :type: str
        """

        self._token = token

    @property
    def uid_token(self):
        """Gets the uid_token of this GatewayUpdateDefaults.  # noqa: E501

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :return: The uid_token of this GatewayUpdateDefaults.  # noqa: E501
        :rtype: str
        """
        return self._uid_token

    @uid_token.setter
    def uid_token(self, uid_token):
        """Sets the uid_token of this GatewayUpdateDefaults.

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :param uid_token: The uid_token of this GatewayUpdateDefaults.  # noqa: E501
        :type: str
        """

        self._uid_token = uid_token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GatewayUpdateDefaults):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GatewayUpdateDefaults):
            return True

        return self.to_dict() != other.to_dict()
