# coding: utf-8

"""
    Akeyless API

    The purpose of this application is to provide access to Akeyless API.  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: support@akeyless.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from akeyless.configuration import Configuration


class GetPKICertificate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'alt_names': 'str',
        'cert_issuer_name': 'str',
        'common_name': 'str',
        'csr_data_base64': 'str',
        'extended_key_usage': 'str',
        'extra_extensions': 'str',
        'json': 'bool',
        'key_data_base64': 'str',
        'max_path_len': 'int',
        'token': 'str',
        'ttl': 'str',
        'uid_token': 'str',
        'uri_sans': 'str'
    }

    attribute_map = {
        'alt_names': 'alt-names',
        'cert_issuer_name': 'cert-issuer-name',
        'common_name': 'common-name',
        'csr_data_base64': 'csr-data-base64',
        'extended_key_usage': 'extended-key-usage',
        'extra_extensions': 'extra-extensions',
        'json': 'json',
        'key_data_base64': 'key-data-base64',
        'max_path_len': 'max-path-len',
        'token': 'token',
        'ttl': 'ttl',
        'uid_token': 'uid-token',
        'uri_sans': 'uri-sans'
    }

    def __init__(self, alt_names=None, cert_issuer_name=None, common_name=None, csr_data_base64=None, extended_key_usage=None, extra_extensions=None, json=False, key_data_base64=None, max_path_len=-1, token=None, ttl=None, uid_token=None, uri_sans=None, local_vars_configuration=None):  # noqa: E501
        """GetPKICertificate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._alt_names = None
        self._cert_issuer_name = None
        self._common_name = None
        self._csr_data_base64 = None
        self._extended_key_usage = None
        self._extra_extensions = None
        self._json = None
        self._key_data_base64 = None
        self._max_path_len = None
        self._token = None
        self._ttl = None
        self._uid_token = None
        self._uri_sans = None
        self.discriminator = None

        if alt_names is not None:
            self.alt_names = alt_names
        self.cert_issuer_name = cert_issuer_name
        if common_name is not None:
            self.common_name = common_name
        if csr_data_base64 is not None:
            self.csr_data_base64 = csr_data_base64
        if extended_key_usage is not None:
            self.extended_key_usage = extended_key_usage
        if extra_extensions is not None:
            self.extra_extensions = extra_extensions
        if json is not None:
            self.json = json
        if key_data_base64 is not None:
            self.key_data_base64 = key_data_base64
        if max_path_len is not None:
            self.max_path_len = max_path_len
        if token is not None:
            self.token = token
        if ttl is not None:
            self.ttl = ttl
        if uid_token is not None:
            self.uid_token = uid_token
        if uri_sans is not None:
            self.uri_sans = uri_sans

    @property
    def alt_names(self):
        """Gets the alt_names of this GetPKICertificate.  # noqa: E501

        The Subject Alternative Names to be included in the PKI certificate (in a comma-separated list) (if CSR is supplied this flag is ignored and any DNS.* names are taken from it)  # noqa: E501

        :return: The alt_names of this GetPKICertificate.  # noqa: E501
        :rtype: str
        """
        return self._alt_names

    @alt_names.setter
    def alt_names(self, alt_names):
        """Sets the alt_names of this GetPKICertificate.

        The Subject Alternative Names to be included in the PKI certificate (in a comma-separated list) (if CSR is supplied this flag is ignored and any DNS.* names are taken from it)  # noqa: E501

        :param alt_names: The alt_names of this GetPKICertificate.  # noqa: E501
        :type: str
        """

        self._alt_names = alt_names

    @property
    def cert_issuer_name(self):
        """Gets the cert_issuer_name of this GetPKICertificate.  # noqa: E501

        The name of the PKI certificate issuer  # noqa: E501

        :return: The cert_issuer_name of this GetPKICertificate.  # noqa: E501
        :rtype: str
        """
        return self._cert_issuer_name

    @cert_issuer_name.setter
    def cert_issuer_name(self, cert_issuer_name):
        """Sets the cert_issuer_name of this GetPKICertificate.

        The name of the PKI certificate issuer  # noqa: E501

        :param cert_issuer_name: The cert_issuer_name of this GetPKICertificate.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and cert_issuer_name is None:  # noqa: E501
            raise ValueError("Invalid value for `cert_issuer_name`, must not be `None`")  # noqa: E501

        self._cert_issuer_name = cert_issuer_name

    @property
    def common_name(self):
        """Gets the common_name of this GetPKICertificate.  # noqa: E501

        The common name to be included in the PKI certificate (if CSR is supplied this flag is ignored and the CSR subject CN is taken)  # noqa: E501

        :return: The common_name of this GetPKICertificate.  # noqa: E501
        :rtype: str
        """
        return self._common_name

    @common_name.setter
    def common_name(self, common_name):
        """Sets the common_name of this GetPKICertificate.

        The common name to be included in the PKI certificate (if CSR is supplied this flag is ignored and the CSR subject CN is taken)  # noqa: E501

        :param common_name: The common_name of this GetPKICertificate.  # noqa: E501
        :type: str
        """

        self._common_name = common_name

    @property
    def csr_data_base64(self):
        """Gets the csr_data_base64 of this GetPKICertificate.  # noqa: E501

        Certificate Signing Request contents encoded in base64 to generate the certificate with  # noqa: E501

        :return: The csr_data_base64 of this GetPKICertificate.  # noqa: E501
        :rtype: str
        """
        return self._csr_data_base64

    @csr_data_base64.setter
    def csr_data_base64(self, csr_data_base64):
        """Sets the csr_data_base64 of this GetPKICertificate.

        Certificate Signing Request contents encoded in base64 to generate the certificate with  # noqa: E501

        :param csr_data_base64: The csr_data_base64 of this GetPKICertificate.  # noqa: E501
        :type: str
        """

        self._csr_data_base64 = csr_data_base64

    @property
    def extended_key_usage(self):
        """Gets the extended_key_usage of this GetPKICertificate.  # noqa: E501

        A comma-separated list of extended key usage requests which will be used for certificate issuance. Supported values: 'clientauth', 'serverauth'. If critical is present the extension will be marked as critical  # noqa: E501

        :return: The extended_key_usage of this GetPKICertificate.  # noqa: E501
        :rtype: str
        """
        return self._extended_key_usage

    @extended_key_usage.setter
    def extended_key_usage(self, extended_key_usage):
        """Sets the extended_key_usage of this GetPKICertificate.

        A comma-separated list of extended key usage requests which will be used for certificate issuance. Supported values: 'clientauth', 'serverauth'. If critical is present the extension will be marked as critical  # noqa: E501

        :param extended_key_usage: The extended_key_usage of this GetPKICertificate.  # noqa: E501
        :type: str
        """

        self._extended_key_usage = extended_key_usage

    @property
    def extra_extensions(self):
        """Gets the extra_extensions of this GetPKICertificate.  # noqa: E501

        A json string that defines the requested extra extensions for the certificate  # noqa: E501

        :return: The extra_extensions of this GetPKICertificate.  # noqa: E501
        :rtype: str
        """
        return self._extra_extensions

    @extra_extensions.setter
    def extra_extensions(self, extra_extensions):
        """Sets the extra_extensions of this GetPKICertificate.

        A json string that defines the requested extra extensions for the certificate  # noqa: E501

        :param extra_extensions: The extra_extensions of this GetPKICertificate.  # noqa: E501
        :type: str
        """

        self._extra_extensions = extra_extensions

    @property
    def json(self):
        """Gets the json of this GetPKICertificate.  # noqa: E501

        Set output format to JSON  # noqa: E501

        :return: The json of this GetPKICertificate.  # noqa: E501
        :rtype: bool
        """
        return self._json

    @json.setter
    def json(self, json):
        """Sets the json of this GetPKICertificate.

        Set output format to JSON  # noqa: E501

        :param json: The json of this GetPKICertificate.  # noqa: E501
        :type: bool
        """

        self._json = json

    @property
    def key_data_base64(self):
        """Gets the key_data_base64 of this GetPKICertificate.  # noqa: E501

        PKI key file contents. If this option is used, the certificate will be printed to stdout  # noqa: E501

        :return: The key_data_base64 of this GetPKICertificate.  # noqa: E501
        :rtype: str
        """
        return self._key_data_base64

    @key_data_base64.setter
    def key_data_base64(self, key_data_base64):
        """Sets the key_data_base64 of this GetPKICertificate.

        PKI key file contents. If this option is used, the certificate will be printed to stdout  # noqa: E501

        :param key_data_base64: The key_data_base64 of this GetPKICertificate.  # noqa: E501
        :type: str
        """

        self._key_data_base64 = key_data_base64

    @property
    def max_path_len(self):
        """Gets the max_path_len of this GetPKICertificate.  # noqa: E501

        The maximum path length for the generated certificate. -1, means unlimited unless the signing certificate has a maximum path length set  # noqa: E501

        :return: The max_path_len of this GetPKICertificate.  # noqa: E501
        :rtype: int
        """
        return self._max_path_len

    @max_path_len.setter
    def max_path_len(self, max_path_len):
        """Sets the max_path_len of this GetPKICertificate.

        The maximum path length for the generated certificate. -1, means unlimited unless the signing certificate has a maximum path length set  # noqa: E501

        :param max_path_len: The max_path_len of this GetPKICertificate.  # noqa: E501
        :type: int
        """

        self._max_path_len = max_path_len

    @property
    def token(self):
        """Gets the token of this GetPKICertificate.  # noqa: E501

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :return: The token of this GetPKICertificate.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this GetPKICertificate.

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :param token: The token of this GetPKICertificate.  # noqa: E501
        :type: str
        """

        self._token = token

    @property
    def ttl(self):
        """Gets the ttl of this GetPKICertificate.  # noqa: E501

        Updated certificate lifetime in seconds (must be less than the Certificate Issuer default TTL)  # noqa: E501

        :return: The ttl of this GetPKICertificate.  # noqa: E501
        :rtype: str
        """
        return self._ttl

    @ttl.setter
    def ttl(self, ttl):
        """Sets the ttl of this GetPKICertificate.

        Updated certificate lifetime in seconds (must be less than the Certificate Issuer default TTL)  # noqa: E501

        :param ttl: The ttl of this GetPKICertificate.  # noqa: E501
        :type: str
        """

        self._ttl = ttl

    @property
    def uid_token(self):
        """Gets the uid_token of this GetPKICertificate.  # noqa: E501

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :return: The uid_token of this GetPKICertificate.  # noqa: E501
        :rtype: str
        """
        return self._uid_token

    @uid_token.setter
    def uid_token(self, uid_token):
        """Sets the uid_token of this GetPKICertificate.

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :param uid_token: The uid_token of this GetPKICertificate.  # noqa: E501
        :type: str
        """

        self._uid_token = uid_token

    @property
    def uri_sans(self):
        """Gets the uri_sans of this GetPKICertificate.  # noqa: E501

        The URI Subject Alternative Names to be included in the PKI certificate (in a comma-separated list) (if CSR is supplied this flag is ignored and any URI.* names are taken from it)  # noqa: E501

        :return: The uri_sans of this GetPKICertificate.  # noqa: E501
        :rtype: str
        """
        return self._uri_sans

    @uri_sans.setter
    def uri_sans(self, uri_sans):
        """Sets the uri_sans of this GetPKICertificate.

        The URI Subject Alternative Names to be included in the PKI certificate (in a comma-separated list) (if CSR is supplied this flag is ignored and any URI.* names are taken from it)  # noqa: E501

        :param uri_sans: The uri_sans of this GetPKICertificate.  # noqa: E501
        :type: str
        """

        self._uri_sans = uri_sans

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetPKICertificate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GetPKICertificate):
            return True

        return self.to_dict() != other.to_dict()
