# coding: utf-8

"""
    Akeyless API

    The purpose of this application is to provide access to Akeyless API.  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: support@akeyless.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from akeyless.configuration import Configuration


class KubernetesAccessRules(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'alg': 'str',
        'audience': 'str',
        'bound_namespaces': 'list[str]',
        'bound_pod_names': 'list[str]',
        'bound_service_account_names': 'list[str]',
        'gen_key_pair': 'str',
        'pub_key': 'str'
    }

    attribute_map = {
        'alg': 'alg',
        'audience': 'audience',
        'bound_namespaces': 'bound_namespaces',
        'bound_pod_names': 'bound_pod_names',
        'bound_service_account_names': 'bound_service_account_names',
        'gen_key_pair': 'gen_key_pair',
        'pub_key': 'pub_key'
    }

    def __init__(self, alg=None, audience=None, bound_namespaces=None, bound_pod_names=None, bound_service_account_names=None, gen_key_pair=None, pub_key=None, local_vars_configuration=None):  # noqa: E501
        """KubernetesAccessRules - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._alg = None
        self._audience = None
        self._bound_namespaces = None
        self._bound_pod_names = None
        self._bound_service_account_names = None
        self._gen_key_pair = None
        self._pub_key = None
        self.discriminator = None

        if alg is not None:
            self.alg = alg
        if audience is not None:
            self.audience = audience
        if bound_namespaces is not None:
            self.bound_namespaces = bound_namespaces
        if bound_pod_names is not None:
            self.bound_pod_names = bound_pod_names
        if bound_service_account_names is not None:
            self.bound_service_account_names = bound_service_account_names
        if gen_key_pair is not None:
            self.gen_key_pair = gen_key_pair
        if pub_key is not None:
            self.pub_key = pub_key

    @property
    def alg(self):
        """Gets the alg of this KubernetesAccessRules.  # noqa: E501


        :return: The alg of this KubernetesAccessRules.  # noqa: E501
        :rtype: str
        """
        return self._alg

    @alg.setter
    def alg(self, alg):
        """Sets the alg of this KubernetesAccessRules.


        :param alg: The alg of this KubernetesAccessRules.  # noqa: E501
        :type: str
        """

        self._alg = alg

    @property
    def audience(self):
        """Gets the audience of this KubernetesAccessRules.  # noqa: E501

        Audience is an optional Kubernetes jwt claim to verify  # noqa: E501

        :return: The audience of this KubernetesAccessRules.  # noqa: E501
        :rtype: str
        """
        return self._audience

    @audience.setter
    def audience(self, audience):
        """Sets the audience of this KubernetesAccessRules.

        Audience is an optional Kubernetes jwt claim to verify  # noqa: E501

        :param audience: The audience of this KubernetesAccessRules.  # noqa: E501
        :type: str
        """

        self._audience = audience

    @property
    def bound_namespaces(self):
        """Gets the bound_namespaces of this KubernetesAccessRules.  # noqa: E501

        A list of namespaces that the authentication is restricted to.  # noqa: E501

        :return: The bound_namespaces of this KubernetesAccessRules.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_namespaces

    @bound_namespaces.setter
    def bound_namespaces(self, bound_namespaces):
        """Sets the bound_namespaces of this KubernetesAccessRules.

        A list of namespaces that the authentication is restricted to.  # noqa: E501

        :param bound_namespaces: The bound_namespaces of this KubernetesAccessRules.  # noqa: E501
        :type: list[str]
        """

        self._bound_namespaces = bound_namespaces

    @property
    def bound_pod_names(self):
        """Gets the bound_pod_names of this KubernetesAccessRules.  # noqa: E501

        A list of pods names that the authentication is restricted to.  # noqa: E501

        :return: The bound_pod_names of this KubernetesAccessRules.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_pod_names

    @bound_pod_names.setter
    def bound_pod_names(self, bound_pod_names):
        """Sets the bound_pod_names of this KubernetesAccessRules.

        A list of pods names that the authentication is restricted to.  # noqa: E501

        :param bound_pod_names: The bound_pod_names of this KubernetesAccessRules.  # noqa: E501
        :type: list[str]
        """

        self._bound_pod_names = bound_pod_names

    @property
    def bound_service_account_names(self):
        """Gets the bound_service_account_names of this KubernetesAccessRules.  # noqa: E501

        A list of service account names that the authentication is restricted to.  # noqa: E501

        :return: The bound_service_account_names of this KubernetesAccessRules.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_service_account_names

    @bound_service_account_names.setter
    def bound_service_account_names(self, bound_service_account_names):
        """Sets the bound_service_account_names of this KubernetesAccessRules.

        A list of service account names that the authentication is restricted to.  # noqa: E501

        :param bound_service_account_names: The bound_service_account_names of this KubernetesAccessRules.  # noqa: E501
        :type: list[str]
        """

        self._bound_service_account_names = bound_service_account_names

    @property
    def gen_key_pair(self):
        """Gets the gen_key_pair of this KubernetesAccessRules.  # noqa: E501

        Generate public/private key (the private key is required for the K8S Auth Config in the Akeyless Gateway)  # noqa: E501

        :return: The gen_key_pair of this KubernetesAccessRules.  # noqa: E501
        :rtype: str
        """
        return self._gen_key_pair

    @gen_key_pair.setter
    def gen_key_pair(self, gen_key_pair):
        """Sets the gen_key_pair of this KubernetesAccessRules.

        Generate public/private key (the private key is required for the K8S Auth Config in the Akeyless Gateway)  # noqa: E501

        :param gen_key_pair: The gen_key_pair of this KubernetesAccessRules.  # noqa: E501
        :type: str
        """

        self._gen_key_pair = gen_key_pair

    @property
    def pub_key(self):
        """Gets the pub_key of this KubernetesAccessRules.  # noqa: E501

        The public key value of the Kubernetes auth method configuration in the Akeyless Gateway.  # noqa: E501

        :return: The pub_key of this KubernetesAccessRules.  # noqa: E501
        :rtype: str
        """
        return self._pub_key

    @pub_key.setter
    def pub_key(self, pub_key):
        """Sets the pub_key of this KubernetesAccessRules.

        The public key value of the Kubernetes auth method configuration in the Akeyless Gateway.  # noqa: E501

        :param pub_key: The pub_key of this KubernetesAccessRules.  # noqa: E501
        :type: str
        """

        self._pub_key = pub_key

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KubernetesAccessRules):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, KubernetesAccessRules):
            return True

        return self.to_dict() != other.to_dict()
