# coding: utf-8

"""
    Akeyless API

    The purpose of this application is to provide access to Akeyless API.  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: support@akeyless.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from akeyless.configuration import Configuration


class ShareItem(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'accessibility': 'str',
        'action': 'str',
        'emails': 'list[str]',
        'item_name': 'str',
        'json': 'bool',
        'share_type': 'str',
        'shared_token_id': 'list[str]',
        'token': 'str',
        'ttl': 'int',
        'uid_token': 'str',
        'view_once': 'bool'
    }

    attribute_map = {
        'accessibility': 'accessibility',
        'action': 'action',
        'emails': 'emails',
        'item_name': 'item-name',
        'json': 'json',
        'share_type': 'share-type',
        'shared_token_id': 'shared-token-id',
        'token': 'token',
        'ttl': 'ttl',
        'uid_token': 'uid-token',
        'view_once': 'view-once'
    }

    def __init__(self, accessibility='regular', action=None, emails=None, item_name=None, json=False, share_type='email', shared_token_id=None, token=None, ttl=None, uid_token=None, view_once=False, local_vars_configuration=None):  # noqa: E501
        """ShareItem - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._accessibility = None
        self._action = None
        self._emails = None
        self._item_name = None
        self._json = None
        self._share_type = None
        self._shared_token_id = None
        self._token = None
        self._ttl = None
        self._uid_token = None
        self._view_once = None
        self.discriminator = None

        if accessibility is not None:
            self.accessibility = accessibility
        self.action = action
        if emails is not None:
            self.emails = emails
        self.item_name = item_name
        if json is not None:
            self.json = json
        if share_type is not None:
            self.share_type = share_type
        if shared_token_id is not None:
            self.shared_token_id = shared_token_id
        if token is not None:
            self.token = token
        if ttl is not None:
            self.ttl = ttl
        if uid_token is not None:
            self.uid_token = uid_token
        if view_once is not None:
            self.view_once = view_once

    @property
    def accessibility(self):
        """Gets the accessibility of this ShareItem.  # noqa: E501

        for personal password manager  # noqa: E501

        :return: The accessibility of this ShareItem.  # noqa: E501
        :rtype: str
        """
        return self._accessibility

    @accessibility.setter
    def accessibility(self, accessibility):
        """Sets the accessibility of this ShareItem.

        for personal password manager  # noqa: E501

        :param accessibility: The accessibility of this ShareItem.  # noqa: E501
        :type: str
        """

        self._accessibility = accessibility

    @property
    def action(self):
        """Gets the action of this ShareItem.  # noqa: E501

        Action to be performed on the item [start/stop/describe]  # noqa: E501

        :return: The action of this ShareItem.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this ShareItem.

        Action to be performed on the item [start/stop/describe]  # noqa: E501

        :param action: The action of this ShareItem.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and action is None:  # noqa: E501
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501

        self._action = action

    @property
    def emails(self):
        """Gets the emails of this ShareItem.  # noqa: E501

        List of emails to start/stop sharing the secret with  # noqa: E501

        :return: The emails of this ShareItem.  # noqa: E501
        :rtype: list[str]
        """
        return self._emails

    @emails.setter
    def emails(self, emails):
        """Sets the emails of this ShareItem.

        List of emails to start/stop sharing the secret with  # noqa: E501

        :param emails: The emails of this ShareItem.  # noqa: E501
        :type: list[str]
        """

        self._emails = emails

    @property
    def item_name(self):
        """Gets the item_name of this ShareItem.  # noqa: E501

        Item name  # noqa: E501

        :return: The item_name of this ShareItem.  # noqa: E501
        :rtype: str
        """
        return self._item_name

    @item_name.setter
    def item_name(self, item_name):
        """Sets the item_name of this ShareItem.

        Item name  # noqa: E501

        :param item_name: The item_name of this ShareItem.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and item_name is None:  # noqa: E501
            raise ValueError("Invalid value for `item_name`, must not be `None`")  # noqa: E501

        self._item_name = item_name

    @property
    def json(self):
        """Gets the json of this ShareItem.  # noqa: E501

        Set output format to JSON  # noqa: E501

        :return: The json of this ShareItem.  # noqa: E501
        :rtype: bool
        """
        return self._json

    @json.setter
    def json(self, json):
        """Sets the json of this ShareItem.

        Set output format to JSON  # noqa: E501

        :param json: The json of this ShareItem.  # noqa: E501
        :type: bool
        """

        self._json = json

    @property
    def share_type(self):
        """Gets the share_type of this ShareItem.  # noqa: E501

        Share type [email/token]  # noqa: E501

        :return: The share_type of this ShareItem.  # noqa: E501
        :rtype: str
        """
        return self._share_type

    @share_type.setter
    def share_type(self, share_type):
        """Sets the share_type of this ShareItem.

        Share type [email/token]  # noqa: E501

        :param share_type: The share_type of this ShareItem.  # noqa: E501
        :type: str
        """

        self._share_type = share_type

    @property
    def shared_token_id(self):
        """Gets the shared_token_id of this ShareItem.  # noqa: E501

        Shared token ids in order to stop sharing a secret  # noqa: E501

        :return: The shared_token_id of this ShareItem.  # noqa: E501
        :rtype: list[str]
        """
        return self._shared_token_id

    @shared_token_id.setter
    def shared_token_id(self, shared_token_id):
        """Sets the shared_token_id of this ShareItem.

        Shared token ids in order to stop sharing a secret  # noqa: E501

        :param shared_token_id: The shared_token_id of this ShareItem.  # noqa: E501
        :type: list[str]
        """

        self._shared_token_id = shared_token_id

    @property
    def token(self):
        """Gets the token of this ShareItem.  # noqa: E501

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :return: The token of this ShareItem.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this ShareItem.

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :param token: The token of this ShareItem.  # noqa: E501
        :type: str
        """

        self._token = token

    @property
    def ttl(self):
        """Gets the ttl of this ShareItem.  # noqa: E501

        TTL of the Availability of the shared secret in seconds  # noqa: E501

        :return: The ttl of this ShareItem.  # noqa: E501
        :rtype: int
        """
        return self._ttl

    @ttl.setter
    def ttl(self, ttl):
        """Sets the ttl of this ShareItem.

        TTL of the Availability of the shared secret in seconds  # noqa: E501

        :param ttl: The ttl of this ShareItem.  # noqa: E501
        :type: int
        """

        self._ttl = ttl

    @property
    def uid_token(self):
        """Gets the uid_token of this ShareItem.  # noqa: E501

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :return: The uid_token of this ShareItem.  # noqa: E501
        :rtype: str
        """
        return self._uid_token

    @uid_token.setter
    def uid_token(self, uid_token):
        """Sets the uid_token of this ShareItem.

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :param uid_token: The uid_token of this ShareItem.  # noqa: E501
        :type: str
        """

        self._uid_token = uid_token

    @property
    def view_once(self):
        """Gets the view_once of this ShareItem.  # noqa: E501

        ViewOnlyOnce Shared secrets can only be viewed once [true/false]  # noqa: E501

        :return: The view_once of this ShareItem.  # noqa: E501
        :rtype: bool
        """
        return self._view_once

    @view_once.setter
    def view_once(self, view_once):
        """Sets the view_once of this ShareItem.

        ViewOnlyOnce Shared secrets can only be viewed once [true/false]  # noqa: E501

        :param view_once: The view_once of this ShareItem.  # noqa: E501
        :type: bool
        """

        self._view_once = view_once

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ShareItem):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ShareItem):
            return True

        return self.to_dict() != other.to_dict()
