# coding: utf-8

"""
    Akeyless API

    The purpose of this application is to provide access to Akeyless API.  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: support@akeyless.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from akeyless.configuration import Configuration


class UpdateAccountSettings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'address': 'str',
        'allowed_email_domains': 'list[str]',
        'bound_ips': 'list[str]',
        'city': 'str',
        'company_name': 'str',
        'country': 'str',
        'default_certificate_expiration_notification_days': 'list[str]',
        'default_key_name': 'str',
        'default_share_link_ttl_minutes': 'str',
        'default_versioning': 'str',
        'dp_enable_classic_key_protection': 'str',
        'dynamic_secret_max_ttl': 'int',
        'dynamic_secret_max_ttl_enable': 'str',
        'enable_ai_insights': 'str',
        'enable_default_certificate_expiration_event': 'str',
        'enable_item_sharing': 'str',
        'enable_password_expiration': 'str',
        'force_new_versions': 'str',
        'gw_bound_ips': 'list[str]',
        'hide_personal_folder': 'str',
        'hide_static_password': 'str',
        'invalid_characters': 'str',
        'item_type': 'str',
        'items_deletion_protection': 'str',
        'json': 'bool',
        'jwt_ttl_default': 'int',
        'jwt_ttl_max': 'int',
        'jwt_ttl_min': 'int',
        'lock_bound_ips': 'str',
        'lock_default_key': 'str',
        'lock_gw_bound_ips': 'str',
        'max_rotation_interval': 'int',
        'max_rotation_interval_enable': 'str',
        'max_versions': 'str',
        'password_expiration_days': 'str',
        'password_expiration_notification_days': 'str',
        'password_length': 'int',
        'phone': 'str',
        'postal_code': 'str',
        'token': 'str',
        'uid_token': 'str',
        'usage_event_enable': 'str',
        'usage_event_interval': 'int',
        'usage_event_object_type': 'str',
        'use_capital_letters': 'str',
        'use_lower_letters': 'str',
        'use_numbers': 'str',
        'use_special_characters': 'str'
    }

    attribute_map = {
        'address': 'address',
        'allowed_email_domains': 'allowed-email-domains',
        'bound_ips': 'bound-ips',
        'city': 'city',
        'company_name': 'company-name',
        'country': 'country',
        'default_certificate_expiration_notification_days': 'default-certificate-expiration-notification-days',
        'default_key_name': 'default-key-name',
        'default_share_link_ttl_minutes': 'default-share-link-ttl-minutes',
        'default_versioning': 'default-versioning',
        'dp_enable_classic_key_protection': 'dp-enable-classic-key-protection',
        'dynamic_secret_max_ttl': 'dynamic-secret-max-ttl',
        'dynamic_secret_max_ttl_enable': 'dynamic-secret-max-ttl-enable',
        'enable_ai_insights': 'enable-ai-insights',
        'enable_default_certificate_expiration_event': 'enable-default-certificate-expiration-event',
        'enable_item_sharing': 'enable-item-sharing',
        'enable_password_expiration': 'enable-password-expiration',
        'force_new_versions': 'force-new-versions',
        'gw_bound_ips': 'gw-bound-ips',
        'hide_personal_folder': 'hide-personal-folder',
        'hide_static_password': 'hide-static-password',
        'invalid_characters': 'invalid-characters',
        'item_type': 'item-type',
        'items_deletion_protection': 'items-deletion-protection',
        'json': 'json',
        'jwt_ttl_default': 'jwt-ttl-default',
        'jwt_ttl_max': 'jwt-ttl-max',
        'jwt_ttl_min': 'jwt-ttl-min',
        'lock_bound_ips': 'lock-bound-ips',
        'lock_default_key': 'lock-default-key',
        'lock_gw_bound_ips': 'lock-gw-bound-ips',
        'max_rotation_interval': 'max-rotation-interval',
        'max_rotation_interval_enable': 'max-rotation-interval-enable',
        'max_versions': 'max-versions',
        'password_expiration_days': 'password-expiration-days',
        'password_expiration_notification_days': 'password-expiration-notification-days',
        'password_length': 'password-length',
        'phone': 'phone',
        'postal_code': 'postal-code',
        'token': 'token',
        'uid_token': 'uid-token',
        'usage_event_enable': 'usage-event-enable',
        'usage_event_interval': 'usage-event-interval',
        'usage_event_object_type': 'usage-event-object-type',
        'use_capital_letters': 'use-capital-letters',
        'use_lower_letters': 'use-lower-letters',
        'use_numbers': 'use-numbers',
        'use_special_characters': 'use-special-characters'
    }

    def __init__(self, address=None, allowed_email_domains=None, bound_ips=None, city=None, company_name=None, country=None, default_certificate_expiration_notification_days=None, default_key_name=None, default_share_link_ttl_minutes=None, default_versioning=None, dp_enable_classic_key_protection=None, dynamic_secret_max_ttl=None, dynamic_secret_max_ttl_enable=None, enable_ai_insights=None, enable_default_certificate_expiration_event=None, enable_item_sharing=None, enable_password_expiration=None, force_new_versions=None, gw_bound_ips=None, hide_personal_folder=None, hide_static_password=None, invalid_characters='notReceivedInvalidCharacter', item_type=None, items_deletion_protection=None, json=False, jwt_ttl_default=None, jwt_ttl_max=None, jwt_ttl_min=None, lock_bound_ips=None, lock_default_key=None, lock_gw_bound_ips=None, max_rotation_interval=None, max_rotation_interval_enable=None, max_versions=None, password_expiration_days=None, password_expiration_notification_days=None, password_length=None, phone=None, postal_code=None, token=None, uid_token=None, usage_event_enable=None, usage_event_interval=None, usage_event_object_type=None, use_capital_letters=None, use_lower_letters=None, use_numbers=None, use_special_characters=None, local_vars_configuration=None):  # noqa: E501
        """UpdateAccountSettings - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._address = None
        self._allowed_email_domains = None
        self._bound_ips = None
        self._city = None
        self._company_name = None
        self._country = None
        self._default_certificate_expiration_notification_days = None
        self._default_key_name = None
        self._default_share_link_ttl_minutes = None
        self._default_versioning = None
        self._dp_enable_classic_key_protection = None
        self._dynamic_secret_max_ttl = None
        self._dynamic_secret_max_ttl_enable = None
        self._enable_ai_insights = None
        self._enable_default_certificate_expiration_event = None
        self._enable_item_sharing = None
        self._enable_password_expiration = None
        self._force_new_versions = None
        self._gw_bound_ips = None
        self._hide_personal_folder = None
        self._hide_static_password = None
        self._invalid_characters = None
        self._item_type = None
        self._items_deletion_protection = None
        self._json = None
        self._jwt_ttl_default = None
        self._jwt_ttl_max = None
        self._jwt_ttl_min = None
        self._lock_bound_ips = None
        self._lock_default_key = None
        self._lock_gw_bound_ips = None
        self._max_rotation_interval = None
        self._max_rotation_interval_enable = None
        self._max_versions = None
        self._password_expiration_days = None
        self._password_expiration_notification_days = None
        self._password_length = None
        self._phone = None
        self._postal_code = None
        self._token = None
        self._uid_token = None
        self._usage_event_enable = None
        self._usage_event_interval = None
        self._usage_event_object_type = None
        self._use_capital_letters = None
        self._use_lower_letters = None
        self._use_numbers = None
        self._use_special_characters = None
        self.discriminator = None

        if address is not None:
            self.address = address
        if allowed_email_domains is not None:
            self.allowed_email_domains = allowed_email_domains
        if bound_ips is not None:
            self.bound_ips = bound_ips
        if city is not None:
            self.city = city
        if company_name is not None:
            self.company_name = company_name
        if country is not None:
            self.country = country
        if default_certificate_expiration_notification_days is not None:
            self.default_certificate_expiration_notification_days = default_certificate_expiration_notification_days
        if default_key_name is not None:
            self.default_key_name = default_key_name
        if default_share_link_ttl_minutes is not None:
            self.default_share_link_ttl_minutes = default_share_link_ttl_minutes
        if default_versioning is not None:
            self.default_versioning = default_versioning
        if dp_enable_classic_key_protection is not None:
            self.dp_enable_classic_key_protection = dp_enable_classic_key_protection
        if dynamic_secret_max_ttl is not None:
            self.dynamic_secret_max_ttl = dynamic_secret_max_ttl
        if dynamic_secret_max_ttl_enable is not None:
            self.dynamic_secret_max_ttl_enable = dynamic_secret_max_ttl_enable
        if enable_ai_insights is not None:
            self.enable_ai_insights = enable_ai_insights
        if enable_default_certificate_expiration_event is not None:
            self.enable_default_certificate_expiration_event = enable_default_certificate_expiration_event
        if enable_item_sharing is not None:
            self.enable_item_sharing = enable_item_sharing
        if enable_password_expiration is not None:
            self.enable_password_expiration = enable_password_expiration
        if force_new_versions is not None:
            self.force_new_versions = force_new_versions
        if gw_bound_ips is not None:
            self.gw_bound_ips = gw_bound_ips
        if hide_personal_folder is not None:
            self.hide_personal_folder = hide_personal_folder
        if hide_static_password is not None:
            self.hide_static_password = hide_static_password
        if invalid_characters is not None:
            self.invalid_characters = invalid_characters
        if item_type is not None:
            self.item_type = item_type
        if items_deletion_protection is not None:
            self.items_deletion_protection = items_deletion_protection
        if json is not None:
            self.json = json
        if jwt_ttl_default is not None:
            self.jwt_ttl_default = jwt_ttl_default
        if jwt_ttl_max is not None:
            self.jwt_ttl_max = jwt_ttl_max
        if jwt_ttl_min is not None:
            self.jwt_ttl_min = jwt_ttl_min
        if lock_bound_ips is not None:
            self.lock_bound_ips = lock_bound_ips
        if lock_default_key is not None:
            self.lock_default_key = lock_default_key
        if lock_gw_bound_ips is not None:
            self.lock_gw_bound_ips = lock_gw_bound_ips
        if max_rotation_interval is not None:
            self.max_rotation_interval = max_rotation_interval
        if max_rotation_interval_enable is not None:
            self.max_rotation_interval_enable = max_rotation_interval_enable
        if max_versions is not None:
            self.max_versions = max_versions
        if password_expiration_days is not None:
            self.password_expiration_days = password_expiration_days
        if password_expiration_notification_days is not None:
            self.password_expiration_notification_days = password_expiration_notification_days
        if password_length is not None:
            self.password_length = password_length
        if phone is not None:
            self.phone = phone
        if postal_code is not None:
            self.postal_code = postal_code
        if token is not None:
            self.token = token
        if uid_token is not None:
            self.uid_token = uid_token
        if usage_event_enable is not None:
            self.usage_event_enable = usage_event_enable
        if usage_event_interval is not None:
            self.usage_event_interval = usage_event_interval
        if usage_event_object_type is not None:
            self.usage_event_object_type = usage_event_object_type
        if use_capital_letters is not None:
            self.use_capital_letters = use_capital_letters
        if use_lower_letters is not None:
            self.use_lower_letters = use_lower_letters
        if use_numbers is not None:
            self.use_numbers = use_numbers
        if use_special_characters is not None:
            self.use_special_characters = use_special_characters

    @property
    def address(self):
        """Gets the address of this UpdateAccountSettings.  # noqa: E501

        Address  # noqa: E501

        :return: The address of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this UpdateAccountSettings.

        Address  # noqa: E501

        :param address: The address of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._address = address

    @property
    def allowed_email_domains(self):
        """Gets the allowed_email_domains of this UpdateAccountSettings.  # noqa: E501

        Limits email sharing to the specified domains. Relevant only when item sharing is enabled. By default, all domains are allowed.  # noqa: E501

        :return: The allowed_email_domains of this UpdateAccountSettings.  # noqa: E501
        :rtype: list[str]
        """
        return self._allowed_email_domains

    @allowed_email_domains.setter
    def allowed_email_domains(self, allowed_email_domains):
        """Sets the allowed_email_domains of this UpdateAccountSettings.

        Limits email sharing to the specified domains. Relevant only when item sharing is enabled. By default, all domains are allowed.  # noqa: E501

        :param allowed_email_domains: The allowed_email_domains of this UpdateAccountSettings.  # noqa: E501
        :type: list[str]
        """

        self._allowed_email_domains = allowed_email_domains

    @property
    def bound_ips(self):
        """Gets the bound_ips of this UpdateAccountSettings.  # noqa: E501

        A default list of comma-separated CIDR block that are allowed to authenticate.  # noqa: E501

        :return: The bound_ips of this UpdateAccountSettings.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_ips

    @bound_ips.setter
    def bound_ips(self, bound_ips):
        """Sets the bound_ips of this UpdateAccountSettings.

        A default list of comma-separated CIDR block that are allowed to authenticate.  # noqa: E501

        :param bound_ips: The bound_ips of this UpdateAccountSettings.  # noqa: E501
        :type: list[str]
        """

        self._bound_ips = bound_ips

    @property
    def city(self):
        """Gets the city of this UpdateAccountSettings.  # noqa: E501

        City  # noqa: E501

        :return: The city of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """Sets the city of this UpdateAccountSettings.

        City  # noqa: E501

        :param city: The city of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._city = city

    @property
    def company_name(self):
        """Gets the company_name of this UpdateAccountSettings.  # noqa: E501

        Company name  # noqa: E501

        :return: The company_name of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._company_name

    @company_name.setter
    def company_name(self, company_name):
        """Sets the company_name of this UpdateAccountSettings.

        Company name  # noqa: E501

        :param company_name: The company_name of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._company_name = company_name

    @property
    def country(self):
        """Gets the country of this UpdateAccountSettings.  # noqa: E501

        Country  # noqa: E501

        :return: The country of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """Sets the country of this UpdateAccountSettings.

        Country  # noqa: E501

        :param country: The country of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._country = country

    @property
    def default_certificate_expiration_notification_days(self):
        """Gets the default_certificate_expiration_notification_days of this UpdateAccountSettings.  # noqa: E501

        How many days before the expiration of the certificate would you like to be notified. To specify multiple events, use argument multiple times: --default-certificate-expiration-notification-days 1 --default-certificate-expiration-notification-days 5  # noqa: E501

        :return: The default_certificate_expiration_notification_days of this UpdateAccountSettings.  # noqa: E501
        :rtype: list[str]
        """
        return self._default_certificate_expiration_notification_days

    @default_certificate_expiration_notification_days.setter
    def default_certificate_expiration_notification_days(self, default_certificate_expiration_notification_days):
        """Sets the default_certificate_expiration_notification_days of this UpdateAccountSettings.

        How many days before the expiration of the certificate would you like to be notified. To specify multiple events, use argument multiple times: --default-certificate-expiration-notification-days 1 --default-certificate-expiration-notification-days 5  # noqa: E501

        :param default_certificate_expiration_notification_days: The default_certificate_expiration_notification_days of this UpdateAccountSettings.  # noqa: E501
        :type: list[str]
        """

        self._default_certificate_expiration_notification_days = default_certificate_expiration_notification_days

    @property
    def default_key_name(self):
        """Gets the default_key_name of this UpdateAccountSettings.  # noqa: E501

        Set the account default key based on the DFC key name. Use \"set-original-akeyless-default-key\" to revert to using the original default key of the account.  # noqa: E501

        :return: The default_key_name of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._default_key_name

    @default_key_name.setter
    def default_key_name(self, default_key_name):
        """Sets the default_key_name of this UpdateAccountSettings.

        Set the account default key based on the DFC key name. Use \"set-original-akeyless-default-key\" to revert to using the original default key of the account.  # noqa: E501

        :param default_key_name: The default_key_name of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._default_key_name = default_key_name

    @property
    def default_share_link_ttl_minutes(self):
        """Gets the default_share_link_ttl_minutes of this UpdateAccountSettings.  # noqa: E501

        Set the default ttl in minutes for sharing item number between 60 and 43200  # noqa: E501

        :return: The default_share_link_ttl_minutes of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._default_share_link_ttl_minutes

    @default_share_link_ttl_minutes.setter
    def default_share_link_ttl_minutes(self, default_share_link_ttl_minutes):
        """Sets the default_share_link_ttl_minutes of this UpdateAccountSettings.

        Set the default ttl in minutes for sharing item number between 60 and 43200  # noqa: E501

        :param default_share_link_ttl_minutes: The default_share_link_ttl_minutes of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._default_share_link_ttl_minutes = default_share_link_ttl_minutes

    @property
    def default_versioning(self):
        """Gets the default_versioning of this UpdateAccountSettings.  # noqa: E501

        If set to true, new versions is enabled by default  # noqa: E501

        :return: The default_versioning of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._default_versioning

    @default_versioning.setter
    def default_versioning(self, default_versioning):
        """Sets the default_versioning of this UpdateAccountSettings.

        If set to true, new versions is enabled by default  # noqa: E501

        :param default_versioning: The default_versioning of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._default_versioning = default_versioning

    @property
    def dp_enable_classic_key_protection(self):
        """Gets the dp_enable_classic_key_protection of this UpdateAccountSettings.  # noqa: E501

        Set to update protection with classic keys state [true/false]  # noqa: E501

        :return: The dp_enable_classic_key_protection of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._dp_enable_classic_key_protection

    @dp_enable_classic_key_protection.setter
    def dp_enable_classic_key_protection(self, dp_enable_classic_key_protection):
        """Sets the dp_enable_classic_key_protection of this UpdateAccountSettings.

        Set to update protection with classic keys state [true/false]  # noqa: E501

        :param dp_enable_classic_key_protection: The dp_enable_classic_key_protection of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._dp_enable_classic_key_protection = dp_enable_classic_key_protection

    @property
    def dynamic_secret_max_ttl(self):
        """Gets the dynamic_secret_max_ttl of this UpdateAccountSettings.  # noqa: E501

        Set the maximum ttl for dynamic secrets  # noqa: E501

        :return: The dynamic_secret_max_ttl of this UpdateAccountSettings.  # noqa: E501
        :rtype: int
        """
        return self._dynamic_secret_max_ttl

    @dynamic_secret_max_ttl.setter
    def dynamic_secret_max_ttl(self, dynamic_secret_max_ttl):
        """Sets the dynamic_secret_max_ttl of this UpdateAccountSettings.

        Set the maximum ttl for dynamic secrets  # noqa: E501

        :param dynamic_secret_max_ttl: The dynamic_secret_max_ttl of this UpdateAccountSettings.  # noqa: E501
        :type: int
        """

        self._dynamic_secret_max_ttl = dynamic_secret_max_ttl

    @property
    def dynamic_secret_max_ttl_enable(self):
        """Gets the dynamic_secret_max_ttl_enable of this UpdateAccountSettings.  # noqa: E501

        Set a maximum ttl for dynamic secrets [true/false]  # noqa: E501

        :return: The dynamic_secret_max_ttl_enable of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._dynamic_secret_max_ttl_enable

    @dynamic_secret_max_ttl_enable.setter
    def dynamic_secret_max_ttl_enable(self, dynamic_secret_max_ttl_enable):
        """Sets the dynamic_secret_max_ttl_enable of this UpdateAccountSettings.

        Set a maximum ttl for dynamic secrets [true/false]  # noqa: E501

        :param dynamic_secret_max_ttl_enable: The dynamic_secret_max_ttl_enable of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._dynamic_secret_max_ttl_enable = dynamic_secret_max_ttl_enable

    @property
    def enable_ai_insights(self):
        """Gets the enable_ai_insights of this UpdateAccountSettings.  # noqa: E501

        Enable AI insights [true/false]  # noqa: E501

        :return: The enable_ai_insights of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._enable_ai_insights

    @enable_ai_insights.setter
    def enable_ai_insights(self, enable_ai_insights):
        """Sets the enable_ai_insights of this UpdateAccountSettings.

        Enable AI insights [true/false]  # noqa: E501

        :param enable_ai_insights: The enable_ai_insights of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._enable_ai_insights = enable_ai_insights

    @property
    def enable_default_certificate_expiration_event(self):
        """Gets the enable_default_certificate_expiration_event of this UpdateAccountSettings.  # noqa: E501

        How many days before the expiration of the certificate would you like to be notified. [true/false]  # noqa: E501

        :return: The enable_default_certificate_expiration_event of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._enable_default_certificate_expiration_event

    @enable_default_certificate_expiration_event.setter
    def enable_default_certificate_expiration_event(self, enable_default_certificate_expiration_event):
        """Sets the enable_default_certificate_expiration_event of this UpdateAccountSettings.

        How many days before the expiration of the certificate would you like to be notified. [true/false]  # noqa: E501

        :param enable_default_certificate_expiration_event: The enable_default_certificate_expiration_event of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._enable_default_certificate_expiration_event = enable_default_certificate_expiration_event

    @property
    def enable_item_sharing(self):
        """Gets the enable_item_sharing of this UpdateAccountSettings.  # noqa: E501

        Enable sharing items [true/false]  # noqa: E501

        :return: The enable_item_sharing of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._enable_item_sharing

    @enable_item_sharing.setter
    def enable_item_sharing(self, enable_item_sharing):
        """Sets the enable_item_sharing of this UpdateAccountSettings.

        Enable sharing items [true/false]  # noqa: E501

        :param enable_item_sharing: The enable_item_sharing of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._enable_item_sharing = enable_item_sharing

    @property
    def enable_password_expiration(self):
        """Gets the enable_password_expiration of this UpdateAccountSettings.  # noqa: E501

        Enable password expiration policy [true/false]  # noqa: E501

        :return: The enable_password_expiration of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._enable_password_expiration

    @enable_password_expiration.setter
    def enable_password_expiration(self, enable_password_expiration):
        """Sets the enable_password_expiration of this UpdateAccountSettings.

        Enable password expiration policy [true/false]  # noqa: E501

        :param enable_password_expiration: The enable_password_expiration of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._enable_password_expiration = enable_password_expiration

    @property
    def force_new_versions(self):
        """Gets the force_new_versions of this UpdateAccountSettings.  # noqa: E501

        If set to true, new version will be created on update  # noqa: E501

        :return: The force_new_versions of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._force_new_versions

    @force_new_versions.setter
    def force_new_versions(self, force_new_versions):
        """Sets the force_new_versions of this UpdateAccountSettings.

        If set to true, new version will be created on update  # noqa: E501

        :param force_new_versions: The force_new_versions of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._force_new_versions = force_new_versions

    @property
    def gw_bound_ips(self):
        """Gets the gw_bound_ips of this UpdateAccountSettings.  # noqa: E501

        A default list of comma-separated CIDR block that acts as a trusted Gateway entity.  # noqa: E501

        :return: The gw_bound_ips of this UpdateAccountSettings.  # noqa: E501
        :rtype: list[str]
        """
        return self._gw_bound_ips

    @gw_bound_ips.setter
    def gw_bound_ips(self, gw_bound_ips):
        """Sets the gw_bound_ips of this UpdateAccountSettings.

        A default list of comma-separated CIDR block that acts as a trusted Gateway entity.  # noqa: E501

        :param gw_bound_ips: The gw_bound_ips of this UpdateAccountSettings.  # noqa: E501
        :type: list[str]
        """

        self._gw_bound_ips = gw_bound_ips

    @property
    def hide_personal_folder(self):
        """Gets the hide_personal_folder of this UpdateAccountSettings.  # noqa: E501

        Hide personal folder, if set - users will not be able to use personal folder [true/false]  # noqa: E501

        :return: The hide_personal_folder of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._hide_personal_folder

    @hide_personal_folder.setter
    def hide_personal_folder(self, hide_personal_folder):
        """Sets the hide_personal_folder of this UpdateAccountSettings.

        Hide personal folder, if set - users will not be able to use personal folder [true/false]  # noqa: E501

        :param hide_personal_folder: The hide_personal_folder of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._hide_personal_folder = hide_personal_folder

    @property
    def hide_static_password(self):
        """Gets the hide_static_password of this UpdateAccountSettings.  # noqa: E501

        Hide static secret's password type [true/false]  # noqa: E501

        :return: The hide_static_password of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._hide_static_password

    @hide_static_password.setter
    def hide_static_password(self, hide_static_password):
        """Sets the hide_static_password of this UpdateAccountSettings.

        Hide static secret's password type [true/false]  # noqa: E501

        :param hide_static_password: The hide_static_password of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._hide_static_password = hide_static_password

    @property
    def invalid_characters(self):
        """Gets the invalid_characters of this UpdateAccountSettings.  # noqa: E501

        Characters that cannot be used for items/targets/roles/auths/event_forwarder names. Empty string will enforce nothing.  # noqa: E501

        :return: The invalid_characters of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._invalid_characters

    @invalid_characters.setter
    def invalid_characters(self, invalid_characters):
        """Sets the invalid_characters of this UpdateAccountSettings.

        Characters that cannot be used for items/targets/roles/auths/event_forwarder names. Empty string will enforce nothing.  # noqa: E501

        :param invalid_characters: The invalid_characters of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._invalid_characters = invalid_characters

    @property
    def item_type(self):
        """Gets the item_type of this UpdateAccountSettings.  # noqa: E501

        VersionSettingsObjectType defines object types for account version settings  # noqa: E501

        :return: The item_type of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._item_type

    @item_type.setter
    def item_type(self, item_type):
        """Sets the item_type of this UpdateAccountSettings.

        VersionSettingsObjectType defines object types for account version settings  # noqa: E501

        :param item_type: The item_type of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._item_type = item_type

    @property
    def items_deletion_protection(self):
        """Gets the items_deletion_protection of this UpdateAccountSettings.  # noqa: E501

        Set or unset the default behaviour of items deletion protection [true/false]  # noqa: E501

        :return: The items_deletion_protection of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._items_deletion_protection

    @items_deletion_protection.setter
    def items_deletion_protection(self, items_deletion_protection):
        """Sets the items_deletion_protection of this UpdateAccountSettings.

        Set or unset the default behaviour of items deletion protection [true/false]  # noqa: E501

        :param items_deletion_protection: The items_deletion_protection of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._items_deletion_protection = items_deletion_protection

    @property
    def json(self):
        """Gets the json of this UpdateAccountSettings.  # noqa: E501

        Set output format to JSON  # noqa: E501

        :return: The json of this UpdateAccountSettings.  # noqa: E501
        :rtype: bool
        """
        return self._json

    @json.setter
    def json(self, json):
        """Sets the json of this UpdateAccountSettings.

        Set output format to JSON  # noqa: E501

        :param json: The json of this UpdateAccountSettings.  # noqa: E501
        :type: bool
        """

        self._json = json

    @property
    def jwt_ttl_default(self):
        """Gets the jwt_ttl_default of this UpdateAccountSettings.  # noqa: E501

        Default ttl  # noqa: E501

        :return: The jwt_ttl_default of this UpdateAccountSettings.  # noqa: E501
        :rtype: int
        """
        return self._jwt_ttl_default

    @jwt_ttl_default.setter
    def jwt_ttl_default(self, jwt_ttl_default):
        """Sets the jwt_ttl_default of this UpdateAccountSettings.

        Default ttl  # noqa: E501

        :param jwt_ttl_default: The jwt_ttl_default of this UpdateAccountSettings.  # noqa: E501
        :type: int
        """

        self._jwt_ttl_default = jwt_ttl_default

    @property
    def jwt_ttl_max(self):
        """Gets the jwt_ttl_max of this UpdateAccountSettings.  # noqa: E501

        Maximum ttl  # noqa: E501

        :return: The jwt_ttl_max of this UpdateAccountSettings.  # noqa: E501
        :rtype: int
        """
        return self._jwt_ttl_max

    @jwt_ttl_max.setter
    def jwt_ttl_max(self, jwt_ttl_max):
        """Sets the jwt_ttl_max of this UpdateAccountSettings.

        Maximum ttl  # noqa: E501

        :param jwt_ttl_max: The jwt_ttl_max of this UpdateAccountSettings.  # noqa: E501
        :type: int
        """

        self._jwt_ttl_max = jwt_ttl_max

    @property
    def jwt_ttl_min(self):
        """Gets the jwt_ttl_min of this UpdateAccountSettings.  # noqa: E501

        Minimum ttl  # noqa: E501

        :return: The jwt_ttl_min of this UpdateAccountSettings.  # noqa: E501
        :rtype: int
        """
        return self._jwt_ttl_min

    @jwt_ttl_min.setter
    def jwt_ttl_min(self, jwt_ttl_min):
        """Sets the jwt_ttl_min of this UpdateAccountSettings.

        Minimum ttl  # noqa: E501

        :param jwt_ttl_min: The jwt_ttl_min of this UpdateAccountSettings.  # noqa: E501
        :type: int
        """

        self._jwt_ttl_min = jwt_ttl_min

    @property
    def lock_bound_ips(self):
        """Gets the lock_bound_ips of this UpdateAccountSettings.  # noqa: E501

        Lock bound-ips setting globally in the account.  # noqa: E501

        :return: The lock_bound_ips of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._lock_bound_ips

    @lock_bound_ips.setter
    def lock_bound_ips(self, lock_bound_ips):
        """Sets the lock_bound_ips of this UpdateAccountSettings.

        Lock bound-ips setting globally in the account.  # noqa: E501

        :param lock_bound_ips: The lock_bound_ips of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._lock_bound_ips = lock_bound_ips

    @property
    def lock_default_key(self):
        """Gets the lock_default_key of this UpdateAccountSettings.  # noqa: E501

        Lock the account's default protection key, if set - users will not be able to use a different protection key, relevant only if default-key-name is configured [true/false]  # noqa: E501

        :return: The lock_default_key of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._lock_default_key

    @lock_default_key.setter
    def lock_default_key(self, lock_default_key):
        """Sets the lock_default_key of this UpdateAccountSettings.

        Lock the account's default protection key, if set - users will not be able to use a different protection key, relevant only if default-key-name is configured [true/false]  # noqa: E501

        :param lock_default_key: The lock_default_key of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._lock_default_key = lock_default_key

    @property
    def lock_gw_bound_ips(self):
        """Gets the lock_gw_bound_ips of this UpdateAccountSettings.  # noqa: E501

        Lock gw-bound-ips setting in the account.  # noqa: E501

        :return: The lock_gw_bound_ips of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._lock_gw_bound_ips

    @lock_gw_bound_ips.setter
    def lock_gw_bound_ips(self, lock_gw_bound_ips):
        """Sets the lock_gw_bound_ips of this UpdateAccountSettings.

        Lock gw-bound-ips setting in the account.  # noqa: E501

        :param lock_gw_bound_ips: The lock_gw_bound_ips of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._lock_gw_bound_ips = lock_gw_bound_ips

    @property
    def max_rotation_interval(self):
        """Gets the max_rotation_interval of this UpdateAccountSettings.  # noqa: E501

        Set the maximum rotation interval for rotated secrets auto rotation settings  # noqa: E501

        :return: The max_rotation_interval of this UpdateAccountSettings.  # noqa: E501
        :rtype: int
        """
        return self._max_rotation_interval

    @max_rotation_interval.setter
    def max_rotation_interval(self, max_rotation_interval):
        """Sets the max_rotation_interval of this UpdateAccountSettings.

        Set the maximum rotation interval for rotated secrets auto rotation settings  # noqa: E501

        :param max_rotation_interval: The max_rotation_interval of this UpdateAccountSettings.  # noqa: E501
        :type: int
        """

        self._max_rotation_interval = max_rotation_interval

    @property
    def max_rotation_interval_enable(self):
        """Gets the max_rotation_interval_enable of this UpdateAccountSettings.  # noqa: E501

        Set a maximum rotation interval for rotated secrets auto rotation settings [true/false]  # noqa: E501

        :return: The max_rotation_interval_enable of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._max_rotation_interval_enable

    @max_rotation_interval_enable.setter
    def max_rotation_interval_enable(self, max_rotation_interval_enable):
        """Sets the max_rotation_interval_enable of this UpdateAccountSettings.

        Set a maximum rotation interval for rotated secrets auto rotation settings [true/false]  # noqa: E501

        :param max_rotation_interval_enable: The max_rotation_interval_enable of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._max_rotation_interval_enable = max_rotation_interval_enable

    @property
    def max_versions(self):
        """Gets the max_versions of this UpdateAccountSettings.  # noqa: E501

        Max versions  # noqa: E501

        :return: The max_versions of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._max_versions

    @max_versions.setter
    def max_versions(self, max_versions):
        """Sets the max_versions of this UpdateAccountSettings.

        Max versions  # noqa: E501

        :param max_versions: The max_versions of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._max_versions = max_versions

    @property
    def password_expiration_days(self):
        """Gets the password_expiration_days of this UpdateAccountSettings.  # noqa: E501

        Specifies the number of days that a password is valid before it must be changed. A default value of 90 days is used.  # noqa: E501

        :return: The password_expiration_days of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._password_expiration_days

    @password_expiration_days.setter
    def password_expiration_days(self, password_expiration_days):
        """Sets the password_expiration_days of this UpdateAccountSettings.

        Specifies the number of days that a password is valid before it must be changed. A default value of 90 days is used.  # noqa: E501

        :param password_expiration_days: The password_expiration_days of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._password_expiration_days = password_expiration_days

    @property
    def password_expiration_notification_days(self):
        """Gets the password_expiration_notification_days of this UpdateAccountSettings.  # noqa: E501

        Specifies the number of days before a user receives notification that their password will expire. A default value of 14 days is used.  # noqa: E501

        :return: The password_expiration_notification_days of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._password_expiration_notification_days

    @password_expiration_notification_days.setter
    def password_expiration_notification_days(self, password_expiration_notification_days):
        """Sets the password_expiration_notification_days of this UpdateAccountSettings.

        Specifies the number of days before a user receives notification that their password will expire. A default value of 14 days is used.  # noqa: E501

        :param password_expiration_notification_days: The password_expiration_notification_days of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._password_expiration_notification_days = password_expiration_notification_days

    @property
    def password_length(self):
        """Gets the password_length of this UpdateAccountSettings.  # noqa: E501

        Password length between 5 - to 50 characters  # noqa: E501

        :return: The password_length of this UpdateAccountSettings.  # noqa: E501
        :rtype: int
        """
        return self._password_length

    @password_length.setter
    def password_length(self, password_length):
        """Sets the password_length of this UpdateAccountSettings.

        Password length between 5 - to 50 characters  # noqa: E501

        :param password_length: The password_length of this UpdateAccountSettings.  # noqa: E501
        :type: int
        """

        self._password_length = password_length

    @property
    def phone(self):
        """Gets the phone of this UpdateAccountSettings.  # noqa: E501

        Phone number  # noqa: E501

        :return: The phone of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._phone

    @phone.setter
    def phone(self, phone):
        """Sets the phone of this UpdateAccountSettings.

        Phone number  # noqa: E501

        :param phone: The phone of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._phone = phone

    @property
    def postal_code(self):
        """Gets the postal_code of this UpdateAccountSettings.  # noqa: E501

        Postal code  # noqa: E501

        :return: The postal_code of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._postal_code

    @postal_code.setter
    def postal_code(self, postal_code):
        """Sets the postal_code of this UpdateAccountSettings.

        Postal code  # noqa: E501

        :param postal_code: The postal_code of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._postal_code = postal_code

    @property
    def token(self):
        """Gets the token of this UpdateAccountSettings.  # noqa: E501

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :return: The token of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this UpdateAccountSettings.

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :param token: The token of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._token = token

    @property
    def uid_token(self):
        """Gets the uid_token of this UpdateAccountSettings.  # noqa: E501

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :return: The uid_token of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._uid_token

    @uid_token.setter
    def uid_token(self, uid_token):
        """Sets the uid_token of this UpdateAccountSettings.

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :param uid_token: The uid_token of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._uid_token = uid_token

    @property
    def usage_event_enable(self):
        """Gets the usage_event_enable of this UpdateAccountSettings.  # noqa: E501

        Enable event for objects that have not been used or changed [true/false]  # noqa: E501

        :return: The usage_event_enable of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._usage_event_enable

    @usage_event_enable.setter
    def usage_event_enable(self, usage_event_enable):
        """Sets the usage_event_enable of this UpdateAccountSettings.

        Enable event for objects that have not been used or changed [true/false]  # noqa: E501

        :param usage_event_enable: The usage_event_enable of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._usage_event_enable = usage_event_enable

    @property
    def usage_event_interval(self):
        """Gets the usage_event_interval of this UpdateAccountSettings.  # noqa: E501

        Interval by days for unused objects. Default and minimum interval is 90 days  # noqa: E501

        :return: The usage_event_interval of this UpdateAccountSettings.  # noqa: E501
        :rtype: int
        """
        return self._usage_event_interval

    @usage_event_interval.setter
    def usage_event_interval(self, usage_event_interval):
        """Sets the usage_event_interval of this UpdateAccountSettings.

        Interval by days for unused objects. Default and minimum interval is 90 days  # noqa: E501

        :param usage_event_interval: The usage_event_interval of this UpdateAccountSettings.  # noqa: E501
        :type: int
        """

        self._usage_event_interval = usage_event_interval

    @property
    def usage_event_object_type(self):
        """Gets the usage_event_object_type of this UpdateAccountSettings.  # noqa: E501

        Usage event is supported for auth method or secrets-and-keys [auth/item]  # noqa: E501

        :return: The usage_event_object_type of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._usage_event_object_type

    @usage_event_object_type.setter
    def usage_event_object_type(self, usage_event_object_type):
        """Sets the usage_event_object_type of this UpdateAccountSettings.

        Usage event is supported for auth method or secrets-and-keys [auth/item]  # noqa: E501

        :param usage_event_object_type: The usage_event_object_type of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._usage_event_object_type = usage_event_object_type

    @property
    def use_capital_letters(self):
        """Gets the use_capital_letters of this UpdateAccountSettings.  # noqa: E501

        Password must contain capital letters [true/false]  # noqa: E501

        :return: The use_capital_letters of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._use_capital_letters

    @use_capital_letters.setter
    def use_capital_letters(self, use_capital_letters):
        """Sets the use_capital_letters of this UpdateAccountSettings.

        Password must contain capital letters [true/false]  # noqa: E501

        :param use_capital_letters: The use_capital_letters of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._use_capital_letters = use_capital_letters

    @property
    def use_lower_letters(self):
        """Gets the use_lower_letters of this UpdateAccountSettings.  # noqa: E501

        Password must contain lower case letters [true/false]  # noqa: E501

        :return: The use_lower_letters of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._use_lower_letters

    @use_lower_letters.setter
    def use_lower_letters(self, use_lower_letters):
        """Sets the use_lower_letters of this UpdateAccountSettings.

        Password must contain lower case letters [true/false]  # noqa: E501

        :param use_lower_letters: The use_lower_letters of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._use_lower_letters = use_lower_letters

    @property
    def use_numbers(self):
        """Gets the use_numbers of this UpdateAccountSettings.  # noqa: E501

        Password must contain numbers [true/false]  # noqa: E501

        :return: The use_numbers of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._use_numbers

    @use_numbers.setter
    def use_numbers(self, use_numbers):
        """Sets the use_numbers of this UpdateAccountSettings.

        Password must contain numbers [true/false]  # noqa: E501

        :param use_numbers: The use_numbers of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._use_numbers = use_numbers

    @property
    def use_special_characters(self):
        """Gets the use_special_characters of this UpdateAccountSettings.  # noqa: E501

        Password must contain special characters [true/false]  # noqa: E501

        :return: The use_special_characters of this UpdateAccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._use_special_characters

    @use_special_characters.setter
    def use_special_characters(self, use_special_characters):
        """Sets the use_special_characters of this UpdateAccountSettings.

        Password must contain special characters [true/false]  # noqa: E501

        :param use_special_characters: The use_special_characters of this UpdateAccountSettings.  # noqa: E501
        :type: str
        """

        self._use_special_characters = use_special_characters

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdateAccountSettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UpdateAccountSettings):
            return True

        return self.to_dict() != other.to_dict()
