"""Stub file for reflex/components/recharts/charts.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import Any, Literal

from reflex.components.core.breakpoints import Breakpoints
from reflex.constants.colors import Color
from reflex.event import EventType, PointerEventInfo
from reflex.vars.base import Var

from .recharts import RechartsCharts

class ChartBase(RechartsCharts):
    @classmethod
    def create(
        cls,
        *children,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ChartBase:
        """Create a chart component.

        Args:
            *children: The children of the chart component.
            width: The width of chart container. String or Integer
            height: The height of chart container.
            on_click: The customized event handler of click on the component in this chart
            on_mouse_enter: The customized event handler of mouseenter on the component in this chart
            on_mouse_move: The customized event handler of mousemove on the component in this chart
            on_mouse_leave: The customized event handler of mouseleave on the component in this chart
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the chart component.

        Returns:
            The chart component wrapped in a responsive container.
        """

class CategoricalChartBase(ChartBase):
    @classmethod
    def create(
        cls,
        *children,
        data: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        margin: Var[dict[str, Any]] | dict[str, Any] | None = None,
        sync_id: Var[str] | str | None = None,
        sync_method: Literal["index", "value"]
        | Var[Literal["index", "value"]]
        | None = None,
        layout: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        stack_offset: Literal["expand", "none", "silhouette", "wiggle"]
        | Var[Literal["expand", "none", "silhouette", "wiggle"]]
        | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> CategoricalChartBase:
        """Create a chart component.

        Args:
            *children: The children of the chart component.
            data: The source data, in which each element is an object.
            margin: The sizes of whitespace around the chart, i.e. {"top": 50, "right": 30, "left": 20, "bottom": 5}.
            sync_id: If any two categorical charts(rx.line_chart, rx.area_chart, rx.bar_chart, rx.composed_chart) have the same sync_id, these two charts can sync the position GraphingTooltip, and the start_index, end_index of Brush.
            sync_method: When sync_id is provided, allows customisation of how the charts will synchronize GraphingTooltips and brushes. Using 'index' (default setting), other charts will reuse current datum's index within the data array. In cases where data does not have the same length, this might yield unexpected results. In that case use 'value' which will try to match other charts values, or a fully custom function which will receive tick, data as argument and should return an index. 'index' | 'value' | function. Default: "index"
            layout: The layout of area in the chart. 'horizontal' | 'vertical'. Default: "horizontal"
            stack_offset: The type of offset function used to generate the lower and upper values in the series array. The four types are built-in offsets in d3-shape. 'expand' | 'none' | 'wiggle' | 'silhouette'
            width: The width of chart container. String or Integer
            height: The height of chart container.
            on_click: The customized event handler of click on the component in this chart
            on_mouse_enter: The customized event handler of mouseenter on the component in this chart
            on_mouse_move: The customized event handler of mousemove on the component in this chart
            on_mouse_leave: The customized event handler of mouseleave on the component in this chart
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the chart component.

        Returns:
            The chart component wrapped in a responsive container.
        """

class AreaChart(CategoricalChartBase):
    @classmethod
    def create(
        cls,
        *children,
        base_value: Literal["auto", "dataMax", "dataMin"]
        | Var[Literal["auto", "dataMax", "dataMin"] | int]
        | int
        | None = None,
        data: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        margin: Var[dict[str, Any]] | dict[str, Any] | None = None,
        sync_id: Var[str] | str | None = None,
        sync_method: Literal["index", "value"]
        | Var[Literal["index", "value"]]
        | None = None,
        layout: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        stack_offset: Literal["expand", "none", "silhouette", "wiggle"]
        | Var[Literal["expand", "none", "silhouette", "wiggle"]]
        | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> AreaChart:
        """Create a chart component.

        Args:
            *children: The children of the chart component.
            base_value: The base value of area. Number | 'dataMin' | 'dataMax' | 'auto'. Default: "auto"
            data: The source data, in which each element is an object.
            margin: The sizes of whitespace around the chart, i.e. {"top": 50, "right": 30, "left": 20, "bottom": 5}.
            sync_id: If any two categorical charts(rx.line_chart, rx.area_chart, rx.bar_chart, rx.composed_chart) have the same sync_id, these two charts can sync the position GraphingTooltip, and the start_index, end_index of Brush.
            sync_method: When sync_id is provided, allows customisation of how the charts will synchronize GraphingTooltips and brushes. Using 'index' (default setting), other charts will reuse current datum's index within the data array. In cases where data does not have the same length, this might yield unexpected results. In that case use 'value' which will try to match other charts values, or a fully custom function which will receive tick, data as argument and should return an index. 'index' | 'value' | function. Default: "index"
            layout: The layout of area in the chart. 'horizontal' | 'vertical'. Default: "horizontal"
            stack_offset: The type of offset function used to generate the lower and upper values in the series array. The four types are built-in offsets in d3-shape. 'expand' | 'none' | 'wiggle' | 'silhouette'
            width: The width of chart container. String or Integer
            height: The height of chart container.
            on_click: The customized event handler of click on the component in this chart
            on_mouse_enter: The customized event handler of mouseenter on the component in this chart
            on_mouse_move: The customized event handler of mousemove on the component in this chart
            on_mouse_leave: The customized event handler of mouseleave on the component in this chart
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the chart component.

        Returns:
            The chart component wrapped in a responsive container.
        """

class BarChart(CategoricalChartBase):
    @classmethod
    def create(
        cls,
        *children,
        bar_category_gap: Var[int | str] | int | str | None = None,
        bar_gap: Var[int | str] | int | str | None = None,
        bar_size: Var[int] | int | None = None,
        max_bar_size: Var[int] | int | None = None,
        stack_offset: Literal["expand", "none", "silhouette", "wiggle"]
        | Var[Literal["expand", "none", "silhouette", "wiggle"]]
        | None = None,
        reverse_stack_order: Var[bool] | bool | None = None,
        data: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        margin: Var[dict[str, Any]] | dict[str, Any] | None = None,
        sync_id: Var[str] | str | None = None,
        sync_method: Literal["index", "value"]
        | Var[Literal["index", "value"]]
        | None = None,
        layout: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> BarChart:
        """Create a chart component.

        Args:
            *children: The children of the chart component.
            bar_category_gap: The gap between two bar categories, which can be a percent value or a fixed value. Percentage | Number. Default: "10%"
            bar_gap: The gap between two bars in the same category, which can be a percent value or a fixed value. Percentage | Number. Default: 4
            bar_size: The width of all the bars in the chart. Number
            max_bar_size: The maximum width of all the bars in a horizontal BarChart, or maximum height in a vertical BarChart.
            stack_offset: The type of offset function used to generate the lower and upper values in the series array. The four types are built-in offsets in d3-shape. 'expand' | 'none' | 'wiggle' | 'silhouette'
            reverse_stack_order: If false set, stacked items will be rendered left to right. If true set, stacked items will be rendered right to left. (Render direction affects SVG layering, not x position.) Default: False
            data: The source data, in which each element is an object.
            margin: The sizes of whitespace around the chart, i.e. {"top": 50, "right": 30, "left": 20, "bottom": 5}.
            sync_id: If any two categorical charts(rx.line_chart, rx.area_chart, rx.bar_chart, rx.composed_chart) have the same sync_id, these two charts can sync the position GraphingTooltip, and the start_index, end_index of Brush.
            sync_method: When sync_id is provided, allows customisation of how the charts will synchronize GraphingTooltips and brushes. Using 'index' (default setting), other charts will reuse current datum's index within the data array. In cases where data does not have the same length, this might yield unexpected results. In that case use 'value' which will try to match other charts values, or a fully custom function which will receive tick, data as argument and should return an index. 'index' | 'value' | function. Default: "index"
            layout: The layout of area in the chart. 'horizontal' | 'vertical'. Default: "horizontal"
            width: The width of chart container. String or Integer
            height: The height of chart container.
            on_click: The customized event handler of click on the component in this chart
            on_mouse_enter: The customized event handler of mouseenter on the component in this chart
            on_mouse_move: The customized event handler of mousemove on the component in this chart
            on_mouse_leave: The customized event handler of mouseleave on the component in this chart
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the chart component.

        Returns:
            The chart component wrapped in a responsive container.
        """

class LineChart(CategoricalChartBase):
    @classmethod
    def create(
        cls,
        *children,
        data: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        margin: Var[dict[str, Any]] | dict[str, Any] | None = None,
        sync_id: Var[str] | str | None = None,
        sync_method: Literal["index", "value"]
        | Var[Literal["index", "value"]]
        | None = None,
        layout: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        stack_offset: Literal["expand", "none", "silhouette", "wiggle"]
        | Var[Literal["expand", "none", "silhouette", "wiggle"]]
        | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> LineChart:
        """Create a chart component.

        Args:
            *children: The children of the chart component.
            data: The source data, in which each element is an object.
            margin: The sizes of whitespace around the chart, i.e. {"top": 50, "right": 30, "left": 20, "bottom": 5}.
            sync_id: If any two categorical charts(rx.line_chart, rx.area_chart, rx.bar_chart, rx.composed_chart) have the same sync_id, these two charts can sync the position GraphingTooltip, and the start_index, end_index of Brush.
            sync_method: When sync_id is provided, allows customisation of how the charts will synchronize GraphingTooltips and brushes. Using 'index' (default setting), other charts will reuse current datum's index within the data array. In cases where data does not have the same length, this might yield unexpected results. In that case use 'value' which will try to match other charts values, or a fully custom function which will receive tick, data as argument and should return an index. 'index' | 'value' | function. Default: "index"
            layout: The layout of area in the chart. 'horizontal' | 'vertical'. Default: "horizontal"
            stack_offset: The type of offset function used to generate the lower and upper values in the series array. The four types are built-in offsets in d3-shape. 'expand' | 'none' | 'wiggle' | 'silhouette'
            width: The width of chart container. String or Integer
            height: The height of chart container.
            on_click: The customized event handler of click on the component in this chart
            on_mouse_enter: The customized event handler of mouseenter on the component in this chart
            on_mouse_move: The customized event handler of mousemove on the component in this chart
            on_mouse_leave: The customized event handler of mouseleave on the component in this chart
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the chart component.

        Returns:
            The chart component wrapped in a responsive container.
        """

class ComposedChart(CategoricalChartBase):
    @classmethod
    def create(
        cls,
        *children,
        base_value: Literal["auto", "dataMax", "dataMin"]
        | Var[Literal["auto", "dataMax", "dataMin"] | int]
        | int
        | None = None,
        bar_category_gap: Var[int | str] | int | str | None = None,
        bar_gap: Var[int] | int | None = None,
        bar_size: Var[int] | int | None = None,
        reverse_stack_order: Var[bool] | bool | None = None,
        data: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        margin: Var[dict[str, Any]] | dict[str, Any] | None = None,
        sync_id: Var[str] | str | None = None,
        sync_method: Literal["index", "value"]
        | Var[Literal["index", "value"]]
        | None = None,
        layout: Literal["horizontal", "vertical"]
        | Var[Literal["horizontal", "vertical"]]
        | None = None,
        stack_offset: Literal["expand", "none", "silhouette", "wiggle"]
        | Var[Literal["expand", "none", "silhouette", "wiggle"]]
        | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ComposedChart:
        """Create a chart component.

        Args:
            *children: The children of the chart component.
            base_value: The base value of area. Number | 'dataMin' | 'dataMax' | 'auto'. Default: "auto"
            bar_category_gap: The gap between two bar categories, which can be a percent value or a fixed value. Percentage | Number. Default: "10%"
            bar_gap: The gap between two bars in the same category. Default: 4
            bar_size: The width or height of each bar. If the barSize is not specified, the size of the bar will be calculated by the barCategoryGap, barGap and the quantity of bar groups.
            reverse_stack_order: If false set, stacked items will be rendered left to right. If true set, stacked items will be rendered right to left. (Render direction affects SVG layering, not x position). Default: False
            data: The source data, in which each element is an object.
            margin: The sizes of whitespace around the chart, i.e. {"top": 50, "right": 30, "left": 20, "bottom": 5}.
            sync_id: If any two categorical charts(rx.line_chart, rx.area_chart, rx.bar_chart, rx.composed_chart) have the same sync_id, these two charts can sync the position GraphingTooltip, and the start_index, end_index of Brush.
            sync_method: When sync_id is provided, allows customisation of how the charts will synchronize GraphingTooltips and brushes. Using 'index' (default setting), other charts will reuse current datum's index within the data array. In cases where data does not have the same length, this might yield unexpected results. In that case use 'value' which will try to match other charts values, or a fully custom function which will receive tick, data as argument and should return an index. 'index' | 'value' | function. Default: "index"
            layout: The layout of area in the chart. 'horizontal' | 'vertical'. Default: "horizontal"
            stack_offset: The type of offset function used to generate the lower and upper values in the series array. The four types are built-in offsets in d3-shape. 'expand' | 'none' | 'wiggle' | 'silhouette'
            width: The width of chart container. String or Integer
            height: The height of chart container.
            on_click: The customized event handler of click on the component in this chart
            on_mouse_enter: The customized event handler of mouseenter on the component in this chart
            on_mouse_move: The customized event handler of mousemove on the component in this chart
            on_mouse_leave: The customized event handler of mouseleave on the component in this chart
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the chart component.

        Returns:
            The chart component wrapped in a responsive container.
        """

class PieChart(ChartBase):
    @classmethod
    def create(
        cls,
        *children,
        margin: Var[dict[str, Any]] | dict[str, Any] | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> PieChart:
        """Create a chart component.

        Args:
            *children: The children of the chart component.
            margin: The sizes of whitespace around the chart, i.e. {"top": 50, "right": 30, "left": 20, "bottom": 5}.
            on_mouse_down: The customized event handler of mousedown on the sectors in this group
            on_mouse_up: The customized event handler of mouseup on the sectors in this group
            on_mouse_over: The customized event handler of mouseover on the sectors in this group
            on_mouse_out: The customized event handler of mouseout on the sectors in this group
            width: The width of chart container. String or Integer
            height: The height of chart container.
            on_click: The customized event handler of click on the component in this chart
            on_mouse_enter: The customized event handler of mouseenter on the component in this chart
            on_mouse_move: The customized event handler of mousemove on the component in this chart
            on_mouse_leave: The customized event handler of mouseleave on the component in this chart
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the chart component.

        Returns:
            The chart component wrapped in a responsive container.
        """

class RadarChart(ChartBase):
    @classmethod
    def get_event_triggers(cls) -> dict[str, Var | Any]: ...
    @classmethod
    def create(
        cls,
        *children,
        data: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        margin: Var[dict[str, Any]] | dict[str, Any] | None = None,
        cx: Var[int | str] | int | str | None = None,
        cy: Var[int | str] | int | str | None = None,
        start_angle: Var[int] | int | None = None,
        end_angle: Var[int] | int | None = None,
        inner_radius: Var[int | str] | int | str | None = None,
        outer_radius: Var[int | str] | int | str | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_click: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        **props,
    ) -> RadarChart:
        """Create a chart component.

        Args:
            *children: The children of the chart component.
            data: The source data, in which each element is an object.
            margin: The sizes of whitespace around the chart, i.e. {"top": 50, "right": 30, "left": 20, "bottom": 5}. Default: {"top": 0, "right": 0, "left": 0, "bottom": 0}
            cx: The The x-coordinate of center. If set a percentage, the final value is obtained by multiplying the percentage of width. Number | Percentage. Default: "50%"
            cy: The The y-coordinate of center. If set a percentage, the final value is obtained by multiplying the percentage of height. Number | Percentage. Default: "50%"
            start_angle: The angle of first radial direction line. Default: 90
            end_angle: The angle of last point in the circle which should be startAngle - 360 or startAngle + 360. We'll calculate the direction of chart by 'startAngle' and 'endAngle'. Default: -270
            inner_radius: The inner radius of first circle grid. If set a percentage, the final value is obtained by multiplying the percentage of maxRadius which is calculated by the width, height, cx, cy. Number | Percentage. Default: 0
            outer_radius: The outer radius of last circle grid. If set a percentage, the final value is obtained by multiplying the percentage of maxRadius which is calculated by the width, height, cx, cy. Number | Percentage. Default: "80%"
            width: The width of chart container. String or Integer
            height: The height of chart container.
            on_click: The customized event handler of click on the component in this chart
            on_mouse_enter: The customized event handler of mouseenter on the component in this chart
            on_mouse_leave: The customized event handler of mouseleave on the component in this chart
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the chart component.

        Returns:
            The chart component wrapped in a responsive container.
        """

class RadialBarChart(ChartBase):
    @classmethod
    def create(
        cls,
        *children,
        data: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        margin: Var[dict[str, Any]] | dict[str, Any] | None = None,
        cx: Var[int | str] | int | str | None = None,
        cy: Var[int | str] | int | str | None = None,
        start_angle: Var[int] | int | None = None,
        end_angle: Var[int] | int | None = None,
        inner_radius: Var[int | str] | int | str | None = None,
        outer_radius: Var[int | str] | int | str | None = None,
        bar_category_gap: Var[int | str] | int | str | None = None,
        bar_gap: Var[str] | str | None = None,
        bar_size: Var[int] | int | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> RadialBarChart:
        """Create a chart component.

        Args:
            *children: The children of the chart component.
            data: The source data which each element is an object.
            margin: The sizes of whitespace around the chart. Default: {"top": 5, "right": 5, "left": 5 "bottom": 5}
            cx: The The x-coordinate of center. If set a percentage, the final value is obtained by multiplying the percentage of width. Number | Percentage. Default: "50%"
            cy: The The y-coordinate of center. If set a percentage, the final value is obtained by multiplying the percentage of height. Number | Percentage. Default: "50%"
            start_angle: The angle of first radial direction line. Default: 0
            end_angle: The angle of last point in the circle which should be startAngle - 360 or startAngle + 360. We'll calculate the direction of chart by 'startAngle' and 'endAngle'. Default: 360
            inner_radius: The inner radius of first circle grid. If set a percentage, the final value is obtained by multiplying the percentage of maxRadius which is calculated by the width, height, cx, cy. Number | Percentage. Default: "30%"
            outer_radius: The outer radius of last circle grid. If set a percentage, the final value is obtained by multiplying the percentage of maxRadius which is calculated by the width, height, cx, cy. Number | Percentage. Default: "100%"
            bar_category_gap: The gap between two bar categories, which can be a percent value or a fixed value. Percentage | Number. Default: "10%"
            bar_gap: The gap between two bars in the same category, which can be a percent value or a fixed value. Percentage | Number. Default: 4
            bar_size: The size of each bar. If the barSize is not specified, the size of bar will be calculated by the barCategoryGap, barGap and the quantity of bar groups.
            width: The width of chart container. String or Integer
            height: The height of chart container.
            on_click: The customized event handler of click on the component in this chart
            on_mouse_enter: The customized event handler of mouseenter on the component in this chart
            on_mouse_move: The customized event handler of mousemove on the component in this chart
            on_mouse_leave: The customized event handler of mouseleave on the component in this chart
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the chart component.

        Returns:
            The chart component wrapped in a responsive container.
        """

class ScatterChart(ChartBase):
    @classmethod
    def get_event_triggers(cls) -> dict[str, Var | Any]: ...
    @classmethod
    def create(
        cls,
        *children,
        margin: Var[dict[str, Any]] | dict[str, Any] | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_click: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        **props,
    ) -> ScatterChart:
        """Create a chart component.

        Args:
            *children: The children of the chart component.
            margin: The sizes of whitespace around the chart. Default: {"top": 5, "right": 5, "bottom": 5, "left": 5}
            width: The width of chart container. String or Integer
            height: The height of chart container.
            on_click: The customized event handler of click on the component in this chart
            on_mouse_enter: The customized event handler of mouseenter on the component in this chart
            on_mouse_move: The customized event handler of mousemove on the component in this chart
            on_mouse_leave: The customized event handler of mouseleave on the component in this chart
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the chart component.

        Returns:
            The chart component wrapped in a responsive container.
        """

class FunnelChart(ChartBase):
    @classmethod
    def create(
        cls,
        *children,
        layout: Var[str] | str | None = None,
        margin: Var[dict[str, Any]] | dict[str, Any] | None = None,
        stroke: Color | Var[Color | str] | str | None = None,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> FunnelChart:
        """Create a chart component.

        Args:
            *children: The children of the chart component.
            layout: The layout of bars in the chart. Default: "centric"
            margin: The sizes of whitespace around the chart. Default: {"top": 5, "right": 5, "bottom": 5, "left": 5}
            stroke: The stroke color of each bar. String | Object
            width: The width of chart container. String or Integer
            height: The height of chart container.
            on_click: The customized event handler of click on the component in this chart
            on_mouse_enter: The customized event handler of mouseenter on the component in this chart
            on_mouse_move: The customized event handler of mousemove on the component in this chart
            on_mouse_leave: The customized event handler of mouseleave on the component in this chart
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the chart component.

        Returns:
            The chart component wrapped in a responsive container.
        """

class Treemap(RechartsCharts):
    @classmethod
    def create(
        cls,
        *children,
        width: Var[int | str] | int | str | None = None,
        height: Var[int | str] | int | str | None = None,
        data: Sequence[dict[str, Any]] | Var[Sequence[dict[str, Any]]] | None = None,
        data_key: Var[int | str] | int | str | None = None,
        name_key: Var[str] | str | None = None,
        aspect_ratio: Var[int] | int | None = None,
        is_animation_active: Var[bool] | bool | None = None,
        animation_begin: Var[int] | int | None = None,
        animation_duration: Var[int] | int | None = None,
        animation_easing: Literal[
            "ease", "ease-in", "ease-in-out", "ease-out", "linear"
        ]
        | Var[Literal["ease", "ease-in", "ease-in-out", "ease-out", "linear"]]
        | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_animation_end: EventType[()] | None = None,
        on_animation_start: EventType[()] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> Treemap:
        """Create a chart component.

        Args:
            *children: The children of the chart component.
            width: The width of chart container. String or Integer. Default: "100%"
            height: The height of chart container. String or Integer. Default: "100%"
            data: data of treemap. Array
            data_key: The key of a group of data which should be unique in a treemap. String | Number. Default: "value"
            name_key: The key of each sector's name. String. Default: "name"
            aspect_ratio: The treemap will try to keep every single rectangle's aspect ratio near the aspectRatio given. Number
            is_animation_active: If set false, animation of area will be disabled. Default: True
            animation_begin: Specifies when the animation should begin, the unit of this option is ms. Default: 0
            animation_duration: Specifies the duration of animation, the unit of this option is ms. Default: 1500
            animation_easing: The type of easing function. 'ease' | 'ease-in' | 'ease-out' | 'ease-in-out' | 'linear'. Default: "ease"
            on_animation_start: The customized event handler of animation start
            on_animation_end: The customized event handler of animation end
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the chart component.

        Returns:
            The Treemap component wrapped in a responsive container.
        """

area_chart = AreaChart.create
bar_chart = BarChart.create
line_chart = LineChart.create
composed_chart = ComposedChart.create
pie_chart = PieChart.create
radar_chart = RadarChart.create
radial_bar_chart = RadialBarChart.create
scatter_chart = ScatterChart.create
funnel_chart = FunnelChart.create
treemap = Treemap.create
