# AKGPT - Python клиент для Pollinations.ai Text-to-Text API

AKGPT - это простая в использовании Python библиотека для взаимодействия с Text-to-Text API от Pollinations.ai. Она позволяет генерировать текст на основе заданных промптов с различными параметрами.

## Установка

```bash
pip install akgpt
```

## Использование

Инициализируйте клиент `AKGPT` и используйте метод `query` для генерации текста.

### Основной запрос

```python
from akgpt.main import AKGPT

client = AKGPT()

prompt = "Что такое искусственный интеллект?"
result = client.query(prompt)

if result:
    print("Ответ API:", result)
```

### Запрос с дополнительными параметрами

Вы можете передавать различные параметры для управления генерацией текста, такие как `model`, `seed`, `temperature`, `system` и другие.

```python
from akgpt.main import AKGPT

client = AKGPT()

prompt = "Напиши короткое стихотворение о роботах"
model = "mistral"
seed = 123
system_prompt = "Ты поэт"

result_poem = client.query(
    prompt,
    model=model,
    seed=seed,
    system=system_prompt
)

if result_poem:
    print("Ответ API:", result_poem)
```

### Получение JSON ответа

Если вам нужен ответ в формате JSON, установите параметр `json_response=True`.

```python
import json
from akgpt.main import AKGPT

client = AKGPT()

prompt = "Что такое AI?"
result_json = client.query(prompt, json_response=True)

if result_json:
    print("Ответ API (JSON):")
    print(json.dumps(result_json, indent=2, ensure_ascii=False))
```

### Доступные параметры метода `query`:

- `prompt` (обязательный): Текстовый промпт для AI.
- `model` (необязательный): Модель для генерации (например, "openai", "mistral").
- `seed` (необязательный): Сид для воспроизводимых результатов.
- `temperature` (необязательный): Контролирует случайность в выводе (от 0.0 до 3.0).
- `top_p` (необязательный): Параметр ядерной выборки (от 0.0 до 1.0).
- `presence_penalty` (необязательный): Штрафует токены на основе их присутствия в тексте (-2.0 до 2.0).
- `frequency_penalty` (необязательный): Штрафует токены на основе их частоты в тексте (-2.0 до 2.0).
- `json_response` (необязательный): Установите `True` для получения ответа в формате JSON.
- `system` (необязательный): Системный промпт для управления поведением AI.
- `stream` (необязательный): Установите `True` для потоковой передачи ответов (Server-Sent Events).
- `private` (необязательный): Установите `True` чтобы предотвратить появление ответа в публичной ленте.
- `referrer` (необязательный): URL/идентификатор реферера.

## Лицензия

Эта библиотека распространяется под лицензией MIT. Подробности см. в файле `LICENSE`.