import * as iotevents from '@aws-cdk/aws-iotevents-alpha';
import { Construct } from 'constructs';
import { TimerDuration } from './timer-duration';
/**
 * The action to create a timer with duration in seconds.
 */
export declare class SetTimerAction implements iotevents.IAction {
    private readonly timerName;
    private readonly timerDuration;
    /**
     * @param timerName the name of the timer
     * @param timerDuration the duration of the timer
     */
    constructor(timerName: string, timerDuration: TimerDuration);
    /**
     * @internal
     */
    _bind(_scope: Construct, _options: iotevents.ActionBindOptions): iotevents.ActionConfig;
}
