"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetTimerAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The action to create a timer with duration in seconds.
 */
class SetTimerAction {
    /**
     * @param timerName the name of the timer
     * @param timerDuration the duration of the timer
     */
    constructor(timerName, timerDuration) {
        this.timerName = timerName;
        this.timerDuration = timerDuration;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_actions_alpha_TimerDuration(timerDuration);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SetTimerAction);
            }
            throw error;
        }
    }
    /**
     * @internal
     */
    _bind(_scope, _options) {
        return {
            configuration: {
                setTimer: {
                    timerName: this.timerName,
                    durationExpression: this.timerDuration._bind(),
                },
            },
        };
    }
}
exports.SetTimerAction = SetTimerAction;
_a = JSII_RTTI_SYMBOL_1;
SetTimerAction[_a] = { fqn: "@aws-cdk/aws-iotevents-actions-alpha.SetTimerAction", version: "2.142.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2V0LXRpbWVyLWFjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNldC10aW1lci1hY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBSUE7O0dBRUc7QUFDSCxNQUFhLGNBQWM7SUFDekI7OztPQUdHO0lBQ0gsWUFDbUIsU0FBaUIsRUFDakIsYUFBNEI7UUFENUIsY0FBUyxHQUFULFNBQVMsQ0FBUTtRQUNqQixrQkFBYSxHQUFiLGFBQWEsQ0FBZTs7Ozs7OytDQVBwQyxjQUFjOzs7O0tBU3hCO0lBRUQ7O09BRUc7SUFDSSxLQUFLLENBQUMsTUFBaUIsRUFBRSxRQUFxQztRQUNuRSxPQUFPO1lBQ0wsYUFBYSxFQUFFO2dCQUNiLFFBQVEsRUFBRTtvQkFDUixTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7b0JBQ3pCLGtCQUFrQixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxFQUFFO2lCQUMvQzthQUNGO1NBQ0YsQ0FBQztLQUNIOztBQXZCSCx3Q0F3QkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpb3RldmVudHMgZnJvbSAnQGF3cy1jZGsvYXdzLWlvdGV2ZW50cy1hbHBoYSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFRpbWVyRHVyYXRpb24gfSBmcm9tICcuL3RpbWVyLWR1cmF0aW9uJztcblxuLyoqXG4gKiBUaGUgYWN0aW9uIHRvIGNyZWF0ZSBhIHRpbWVyIHdpdGggZHVyYXRpb24gaW4gc2Vjb25kcy5cbiAqL1xuZXhwb3J0IGNsYXNzIFNldFRpbWVyQWN0aW9uIGltcGxlbWVudHMgaW90ZXZlbnRzLklBY3Rpb24ge1xuICAvKipcbiAgICogQHBhcmFtIHRpbWVyTmFtZSB0aGUgbmFtZSBvZiB0aGUgdGltZXJcbiAgICogQHBhcmFtIHRpbWVyRHVyYXRpb24gdGhlIGR1cmF0aW9uIG9mIHRoZSB0aW1lclxuICAgKi9cbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSByZWFkb25seSB0aW1lck5hbWU6IHN0cmluZyxcbiAgICBwcml2YXRlIHJlYWRvbmx5IHRpbWVyRHVyYXRpb246IFRpbWVyRHVyYXRpb24sXG4gICkge1xuICB9XG5cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIF9iaW5kKF9zY29wZTogQ29uc3RydWN0LCBfb3B0aW9uczogaW90ZXZlbnRzLkFjdGlvbkJpbmRPcHRpb25zKTogaW90ZXZlbnRzLkFjdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgc2V0VGltZXI6IHtcbiAgICAgICAgICB0aW1lck5hbWU6IHRoaXMudGltZXJOYW1lLFxuICAgICAgICAgIGR1cmF0aW9uRXhwcmVzc2lvbjogdGhpcy50aW1lckR1cmF0aW9uLl9iaW5kKCksXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cbiJdfQ==