"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetVariableAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The action to create a variable with a specified value.
 */
class SetVariableAction {
    /**
     * @param variableName the name of the variable
     * @param value the new value of the variable
     */
    constructor(variableName, value) {
        this.variableName = variableName;
        this.value = value;
    }
    /**
     * @internal
     */
    _bind(_scope, _options) {
        return {
            configuration: {
                setVariable: {
                    variableName: this.variableName,
                    value: this.value.evaluate(),
                },
            },
        };
    }
}
exports.SetVariableAction = SetVariableAction;
_a = JSII_RTTI_SYMBOL_1;
SetVariableAction[_a] = { fqn: "@aws-cdk/aws-iotevents-actions-alpha.SetVariableAction", version: "2.142.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2V0LXZhcmlhYmxlLWFjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNldC12YXJpYWJsZS1hY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFHQTs7R0FFRztBQUNILE1BQWEsaUJBQWlCO0lBQzVCOzs7T0FHRztJQUNILFlBQTZCLFlBQW9CLEVBQW1CLEtBQTJCO1FBQWxFLGlCQUFZLEdBQVosWUFBWSxDQUFRO1FBQW1CLFVBQUssR0FBTCxLQUFLLENBQXNCO0tBQzlGO0lBRUQ7O09BRUc7SUFDSSxLQUFLLENBQUMsTUFBaUIsRUFBRSxRQUFxQztRQUNuRSxPQUFPO1lBQ0wsYUFBYSxFQUFFO2dCQUNiLFdBQVcsRUFBRTtvQkFDWCxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7b0JBQy9CLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsRUFBRTtpQkFDN0I7YUFDRjtTQUNGLENBQUM7S0FDSDs7QUFwQkgsOENBcUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgaW90ZXZlbnRzIGZyb20gJ0Bhd3MtY2RrL2F3cy1pb3RldmVudHMtYWxwaGEnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogVGhlIGFjdGlvbiB0byBjcmVhdGUgYSB2YXJpYWJsZSB3aXRoIGEgc3BlY2lmaWVkIHZhbHVlLlxuICovXG5leHBvcnQgY2xhc3MgU2V0VmFyaWFibGVBY3Rpb24gaW1wbGVtZW50cyBpb3RldmVudHMuSUFjdGlvbiB7XG4gIC8qKlxuICAgKiBAcGFyYW0gdmFyaWFibGVOYW1lIHRoZSBuYW1lIG9mIHRoZSB2YXJpYWJsZVxuICAgKiBAcGFyYW0gdmFsdWUgdGhlIG5ldyB2YWx1ZSBvZiB0aGUgdmFyaWFibGVcbiAgICovXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgdmFyaWFibGVOYW1lOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgdmFsdWU6IGlvdGV2ZW50cy5FeHByZXNzaW9uKSB7XG4gIH1cblxuICAvKipcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgX2JpbmQoX3Njb3BlOiBDb25zdHJ1Y3QsIF9vcHRpb25zOiBpb3RldmVudHMuQWN0aW9uQmluZE9wdGlvbnMpOiBpb3RldmVudHMuQWN0aW9uQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgY29uZmlndXJhdGlvbjoge1xuICAgICAgICBzZXRWYXJpYWJsZToge1xuICAgICAgICAgIHZhcmlhYmxlTmFtZTogdGhpcy52YXJpYWJsZU5hbWUsXG4gICAgICAgICAgdmFsdWU6IHRoaXMudmFsdWUuZXZhbHVhdGUoKSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuIl19