import * as iotevents from '@aws-cdk/aws-iotevents-alpha';
import { Duration } from 'aws-cdk-lib/core';
/**
 * The duration of the timer.
 */
export declare abstract class TimerDuration {
    /**
     * Create a timer-duration from Duration.
     *
     * The range of the duration is 60-31622400 seconds.
     * The evaluated result of the duration expression is rounded down to the nearest whole number.
     * For example, if you set the timer to 60.99 seconds, the evaluated result of the duration expression is 60 seconds.
     */
    static fromDuration(duration: Duration): TimerDuration;
    /**
     * Create a timer-duration from Expression.
     *
     * You can use a string expression that includes numbers, variables ($variable.<variable-name>),
     * and input values ($input.<input-name>.<path-to-datum>) as the duration.
     *
     * The range of the duration is 60-31622400 seconds.
     * The evaluated result of the duration expression is rounded down to the nearest whole number.
     * For example, if you set the timer to 60.99 seconds, the evaluated result of the duration expression is 60 seconds.
     */
    static fromExpression(expression: iotevents.Expression): TimerDuration;
    /**
     * @internal
     */
    abstract _bind(): string;
}
