"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimerDuration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The duration of the timer.
 */
class TimerDuration {
    /**
     * Create a timer-duration from Duration.
     *
     * The range of the duration is 60-31622400 seconds.
     * The evaluated result of the duration expression is rounded down to the nearest whole number.
     * For example, if you set the timer to 60.99 seconds, the evaluated result of the duration expression is 60 seconds.
     */
    static fromDuration(duration) {
        const seconds = duration.toSeconds();
        if (seconds < 60) {
            throw new Error(`duration cannot be less than 60 seconds, got: ${duration.toString()}`);
        }
        if (seconds > 31622400) {
            throw new Error(`duration cannot be greater than 31622400 seconds, got: ${duration.toString()}`);
        }
        return new TimerDurationImpl(seconds.toString());
    }
    /**
     * Create a timer-duration from Expression.
     *
     * You can use a string expression that includes numbers, variables ($variable.<variable-name>),
     * and input values ($input.<input-name>.<path-to-datum>) as the duration.
     *
     * The range of the duration is 60-31622400 seconds.
     * The evaluated result of the duration expression is rounded down to the nearest whole number.
     * For example, if you set the timer to 60.99 seconds, the evaluated result of the duration expression is 60 seconds.
     */
    static fromExpression(expression) {
        return new TimerDurationImpl(expression.evaluate());
    }
}
exports.TimerDuration = TimerDuration;
_a = JSII_RTTI_SYMBOL_1;
TimerDuration[_a] = { fqn: "@aws-cdk/aws-iotevents-actions-alpha.TimerDuration", version: "2.142.1-alpha.0" };
class TimerDurationImpl extends TimerDuration {
    constructor(durationExpression) {
        super();
        this.durationExpression = durationExpression;
    }
    _bind() {
        return this.durationExpression;
    }
}
//# sourceMappingURL=data:application/json;base64,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