# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Accessibility Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import GetAXNodeAndAncestorsParameters
    from .commands import GetAXNodeAndAncestorsReturns
    from .commands import GetChildAXNodesParameters
    from .commands import GetChildAXNodesReturns
    from .commands import GetFullAXTreeParameters
    from .commands import GetFullAXTreeReturns
    from .commands import GetPartialAXTreeParameters
    from .commands import GetPartialAXTreeReturns
    from .commands import GetRootAXNodeParameters
    from .commands import GetRootAXNodeReturns
    from .commands import QueryAXTreeParameters
    from .commands import QueryAXTreeReturns

class AccessibilityClient:
    """Client for Accessibility domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables the accessibility domain."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Accessibility.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables the accessibility domain which causes `AXNodeId`s to remain consistent between method calls.
This turns on accessibility for the page, which can impact performance until accessibility is disabled."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Accessibility.enable",
            params=params,
            session_id=session_id,
        ))

    async def getPartialAXTree(
        self,
        params: Optional["GetPartialAXTreeParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetPartialAXTreeReturns":
        """Fetches the accessibility node and partial accessibility tree for this DOM node, if it exists."""
        return cast("GetPartialAXTreeReturns", await self._client.send_raw(
            method="Accessibility.getPartialAXTree",
            params=params,
            session_id=session_id,
        ))

    async def getFullAXTree(
        self,
        params: Optional["GetFullAXTreeParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetFullAXTreeReturns":
        """Fetches the entire accessibility tree for the root Document"""
        return cast("GetFullAXTreeReturns", await self._client.send_raw(
            method="Accessibility.getFullAXTree",
            params=params,
            session_id=session_id,
        ))

    async def getRootAXNode(
        self,
        params: Optional["GetRootAXNodeParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetRootAXNodeReturns":
        """Fetches the root node.
Requires `enable()` to have been called previously."""
        return cast("GetRootAXNodeReturns", await self._client.send_raw(
            method="Accessibility.getRootAXNode",
            params=params,
            session_id=session_id,
        ))

    async def getAXNodeAndAncestors(
        self,
        params: Optional["GetAXNodeAndAncestorsParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetAXNodeAndAncestorsReturns":
        """Fetches a node and all ancestors up to and including the root.
Requires `enable()` to have been called previously."""
        return cast("GetAXNodeAndAncestorsReturns", await self._client.send_raw(
            method="Accessibility.getAXNodeAndAncestors",
            params=params,
            session_id=session_id,
        ))

    async def getChildAXNodes(
        self,
        params: "GetChildAXNodesParameters",
        session_id: Optional[str] = None,
    ) -> "GetChildAXNodesReturns":
        """Fetches a particular accessibility node by AXNodeId.
Requires `enable()` to have been called previously."""
        return cast("GetChildAXNodesReturns", await self._client.send_raw(
            method="Accessibility.getChildAXNodes",
            params=params,
            session_id=session_id,
        ))

    async def queryAXTree(
        self,
        params: Optional["QueryAXTreeParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "QueryAXTreeReturns":
        """Query a DOM node's accessibility subtree for accessible name and role.
This command computes the name and role for all nodes in the subtree, including those that are
ignored for accessibility, and returns those that match the specified name and role. If no DOM
node is specified, or the DOM node does not exist, the command returns an error. If neither
`accessibleName` or `role` is specified, it returns all the accessibility nodes in the subtree."""
        return cast("QueryAXTreeReturns", await self._client.send_raw(
            method="Accessibility.queryAXTree",
            params=params,
            session_id=session_id,
        ))


