# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Animation Domain Event Registration"""

from typing import Callable, Optional

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..registry import EventRegistry
    from .events import AnimationCanceledEvent, AnimationCreatedEvent, AnimationStartedEvent, AnimationUpdatedEvent

class AnimationRegistration:
    """Event registration interface for Animation domain."""

    def __init__(self, registry: 'EventRegistry'):
        self._registry = registry
        self._domain = "Animation"

    def animationCanceled(
        self,
        callback: Callable[['AnimationCanceledEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for animationCanceled events.
        
        Event for when an animation has been cancelled.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Animation.animationCanceled", callback)

    def animationCreated(
        self,
        callback: Callable[['AnimationCreatedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for animationCreated events.
        
        Event for each animation that has been created.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Animation.animationCreated", callback)

    def animationStarted(
        self,
        callback: Callable[['AnimationStartedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for animationStarted events.
        
        Event for animation that has been started.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Animation.animationStarted", callback)

    def animationUpdated(
        self,
        callback: Callable[['AnimationUpdatedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for animationUpdated events.
        
        Event for animation that has been updated.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("Animation.animationUpdated", callback)

