# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Animation Domain Types"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..dom.types import BackendNodeId
    from ..dom.types import ScrollOrientation

class Animation(TypedDict):
    """Animation instance."""

    id: "str"
    """`Animation`'s id."""
    name: "str"
    """`Animation`'s name."""
    pausedState: "bool"
    """`Animation`'s internal paused state."""
    playState: "str"
    """`Animation`'s play state."""
    playbackRate: "float"
    """`Animation`'s playback rate."""
    startTime: "float"
    """`Animation`'s start time.
Milliseconds for time based animations and
percentage [0 - 100] for scroll driven animations
(i.e. when viewOrScrollTimeline exists)."""
    currentTime: "float"
    """`Animation`'s current time."""
    type: "str"
    """Animation type of `Animation`."""
    source: "NotRequired[AnimationEffect]"
    """`Animation`'s source animation node."""
    cssId: "NotRequired[str]"
    """A unique ID for `Animation` representing the sources that triggered this CSS
animation/transition."""
    viewOrScrollTimeline: "NotRequired[ViewOrScrollTimeline]"
    """View or scroll timeline"""



class ViewOrScrollTimeline(TypedDict):
    """Timeline instance"""

    sourceNodeId: "NotRequired[BackendNodeId]"
    """Scroll container node"""
    startOffset: "NotRequired[float]"
    """Represents the starting scroll position of the timeline
as a length offset in pixels from scroll origin."""
    endOffset: "NotRequired[float]"
    """Represents the ending scroll position of the timeline
as a length offset in pixels from scroll origin."""
    subjectNodeId: "NotRequired[BackendNodeId]"
    """The element whose principal box's visibility in the
scrollport defined the progress of the timeline.
Does not exist for animations with ScrollTimeline"""
    axis: "ScrollOrientation"
    """Orientation of the scroll"""



class AnimationEffect(TypedDict):
    """AnimationEffect instance"""

    delay: "float"
    """`AnimationEffect`'s delay."""
    endDelay: "float"
    """`AnimationEffect`'s end delay."""
    iterationStart: "float"
    """`AnimationEffect`'s iteration start."""
    iterations: "float"
    """`AnimationEffect`'s iterations."""
    duration: "float"
    """`AnimationEffect`'s iteration duration.
Milliseconds for time based animations and
percentage [0 - 100] for scroll driven animations
(i.e. when viewOrScrollTimeline exists)."""
    direction: "str"
    """`AnimationEffect`'s playback direction."""
    fill: "str"
    """`AnimationEffect`'s fill mode."""
    backendNodeId: "NotRequired[BackendNodeId]"
    """`AnimationEffect`'s target node."""
    keyframesRule: "NotRequired[KeyframesRule]"
    """`AnimationEffect`'s keyframes."""
    easing: "str"
    """`AnimationEffect`'s timing function."""



class KeyframesRule(TypedDict):
    """Keyframes Rule"""

    name: "NotRequired[str]"
    """CSS keyframed animation's name."""
    keyframes: "List[KeyframeStyle]"
    """List of animation keyframes."""



class KeyframeStyle(TypedDict):
    """Keyframe Style"""

    offset: "str"
    """Keyframe's time offset."""
    easing: "str"
    """`AnimationEffect`'s timing function."""
