# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Audits Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import CheckContrastParameters
    from .commands import CheckFormsIssuesReturns
    from .commands import GetEncodedResponseParameters
    from .commands import GetEncodedResponseReturns

class AuditsClient:
    """Client for Audits domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def getEncodedResponse(
        self,
        params: "GetEncodedResponseParameters",
        session_id: Optional[str] = None,
    ) -> "GetEncodedResponseReturns":
        """Returns the response body and size if it were re-encoded with the specified settings. Only
applies to images."""
        return cast("GetEncodedResponseReturns", await self._client.send_raw(
            method="Audits.getEncodedResponse",
            params=params,
            session_id=session_id,
        ))

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables issues domain, prevents further issues from being reported to the client."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Audits.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables issues domain, sends the issues collected so far to the client by means of the
`issueAdded` event."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Audits.enable",
            params=params,
            session_id=session_id,
        ))

    async def checkContrast(
        self,
        params: Optional["CheckContrastParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Runs the contrast check for the target page. Found issues are reported
using Audits.issueAdded event."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Audits.checkContrast",
            params=params,
            session_id=session_id,
        ))

    async def checkFormsIssues(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "CheckFormsIssuesReturns":
        """Runs the form issues check for the target page. Found issues are reported
using Audits.issueAdded event."""
        return cast("CheckFormsIssuesReturns", await self._client.send_raw(
            method="Audits.checkFormsIssues",
            params=params,
            session_id=session_id,
        ))


