# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Autofill Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import SetAddressesParameters
    from .commands import TriggerParameters

class AutofillClient:
    """Client for Autofill domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def trigger(
        self,
        params: "TriggerParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Trigger autofill on a form identified by the fieldId.
If the field and related form cannot be autofilled, returns an error."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Autofill.trigger",
            params=params,
            session_id=session_id,
        ))

    async def setAddresses(
        self,
        params: "SetAddressesParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Set addresses so that developers can verify their forms implementation."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Autofill.setAddresses",
            params=params,
            session_id=session_id,
        ))

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables autofill domain notifications."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Autofill.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables autofill domain notifications."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Autofill.enable",
            params=params,
            session_id=session_id,
        ))


