# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP BluetoothEmulation Domain Event Registration"""

from typing import Callable, Optional

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..registry import EventRegistry
    from .events import CharacteristicOperationReceivedEvent, DescriptorOperationReceivedEvent, GattOperationReceivedEvent

class BluetoothEmulationRegistration:
    """Event registration interface for BluetoothEmulation domain."""

    def __init__(self, registry: 'EventRegistry'):
        self._registry = registry
        self._domain = "BluetoothEmulation"

    def gattOperationReceived(
        self,
        callback: Callable[['GattOperationReceivedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for gattOperationReceived events.
        
        Event for when a GATT operation of |type| to the peripheral with |address|
happened.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("BluetoothEmulation.gattOperationReceived", callback)

    def characteristicOperationReceived(
        self,
        callback: Callable[['CharacteristicOperationReceivedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for characteristicOperationReceived events.
        
        Event for when a characteristic operation of |type| to the characteristic
respresented by |characteristicId| happened. |data| and |writeType| is
expected to exist when |type| is write.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("BluetoothEmulation.characteristicOperationReceived", callback)

    def descriptorOperationReceived(
        self,
        callback: Callable[['DescriptorOperationReceivedEvent', Optional[str]], None],
    ) -> None:
        """
        Register a callback for descriptorOperationReceived events.
        
        Event for when a descriptor operation of |type| to the descriptor
respresented by |descriptorId| happened. |data| is expected to exist when
|type| is write.
        
        Args:
            callback: Function to call when event occurs.
                     Receives (event_data, session_id) as parameters.
        """
        self._registry.register("BluetoothEmulation.descriptorOperationReceived", callback)

