# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP CSS Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import AddRuleParameters
    from .commands import AddRuleReturns
    from .commands import CollectClassNamesParameters
    from .commands import CollectClassNamesReturns
    from .commands import CreateStyleSheetParameters
    from .commands import CreateStyleSheetReturns
    from .commands import ForcePseudoStateParameters
    from .commands import ForceStartingStyleParameters
    from .commands import GetAnimatedStylesForNodeParameters
    from .commands import GetAnimatedStylesForNodeReturns
    from .commands import GetBackgroundColorsParameters
    from .commands import GetBackgroundColorsReturns
    from .commands import GetComputedStyleForNodeParameters
    from .commands import GetComputedStyleForNodeReturns
    from .commands import GetInlineStylesForNodeParameters
    from .commands import GetInlineStylesForNodeReturns
    from .commands import GetLayersForNodeParameters
    from .commands import GetLayersForNodeReturns
    from .commands import GetLocationForSelectorParameters
    from .commands import GetLocationForSelectorReturns
    from .commands import GetLonghandPropertiesParameters
    from .commands import GetLonghandPropertiesReturns
    from .commands import GetMatchedStylesForNodeParameters
    from .commands import GetMatchedStylesForNodeReturns
    from .commands import GetMediaQueriesReturns
    from .commands import GetPlatformFontsForNodeParameters
    from .commands import GetPlatformFontsForNodeReturns
    from .commands import GetStyleSheetTextParameters
    from .commands import GetStyleSheetTextReturns
    from .commands import ResolveValuesParameters
    from .commands import ResolveValuesReturns
    from .commands import SetContainerQueryTextParameters
    from .commands import SetContainerQueryTextReturns
    from .commands import SetEffectivePropertyValueForNodeParameters
    from .commands import SetKeyframeKeyParameters
    from .commands import SetKeyframeKeyReturns
    from .commands import SetLocalFontsEnabledParameters
    from .commands import SetMediaTextParameters
    from .commands import SetMediaTextReturns
    from .commands import SetPropertyRulePropertyNameParameters
    from .commands import SetPropertyRulePropertyNameReturns
    from .commands import SetRuleSelectorParameters
    from .commands import SetRuleSelectorReturns
    from .commands import SetScopeTextParameters
    from .commands import SetScopeTextReturns
    from .commands import SetStyleSheetTextParameters
    from .commands import SetStyleSheetTextReturns
    from .commands import SetStyleTextsParameters
    from .commands import SetStyleTextsReturns
    from .commands import SetSupportsTextParameters
    from .commands import SetSupportsTextReturns
    from .commands import StopRuleUsageTrackingReturns
    from .commands import TakeComputedStyleUpdatesReturns
    from .commands import TakeCoverageDeltaReturns
    from .commands import TrackComputedStyleUpdatesForNodeParameters
    from .commands import TrackComputedStyleUpdatesParameters

class CSSClient:
    """Client for CSS domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def addRule(
        self,
        params: "AddRuleParameters",
        session_id: Optional[str] = None,
    ) -> "AddRuleReturns":
        """Inserts a new rule with the given `ruleText` in a stylesheet with given `styleSheetId`, at the
position specified by `location`."""
        return cast("AddRuleReturns", await self._client.send_raw(
            method="CSS.addRule",
            params=params,
            session_id=session_id,
        ))

    async def collectClassNames(
        self,
        params: "CollectClassNamesParameters",
        session_id: Optional[str] = None,
    ) -> "CollectClassNamesReturns":
        """Returns all class names from specified stylesheet."""
        return cast("CollectClassNamesReturns", await self._client.send_raw(
            method="CSS.collectClassNames",
            params=params,
            session_id=session_id,
        ))

    async def createStyleSheet(
        self,
        params: "CreateStyleSheetParameters",
        session_id: Optional[str] = None,
    ) -> "CreateStyleSheetReturns":
        """Creates a new special \"via-inspector\" stylesheet in the frame with given `frameId`."""
        return cast("CreateStyleSheetReturns", await self._client.send_raw(
            method="CSS.createStyleSheet",
            params=params,
            session_id=session_id,
        ))

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables the CSS agent for the given page."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="CSS.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables the CSS agent for the given page. Clients should not assume that the CSS agent has been
enabled until the result of this command is received."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="CSS.enable",
            params=params,
            session_id=session_id,
        ))

    async def forcePseudoState(
        self,
        params: "ForcePseudoStateParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Ensures that the given node will have specified pseudo-classes whenever its style is computed by
the browser."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="CSS.forcePseudoState",
            params=params,
            session_id=session_id,
        ))

    async def forceStartingStyle(
        self,
        params: "ForceStartingStyleParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Ensures that the given node is in its starting-style state."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="CSS.forceStartingStyle",
            params=params,
            session_id=session_id,
        ))

    async def getBackgroundColors(
        self,
        params: "GetBackgroundColorsParameters",
        session_id: Optional[str] = None,
    ) -> "GetBackgroundColorsReturns":
        return cast("GetBackgroundColorsReturns", await self._client.send_raw(
            method="CSS.getBackgroundColors",
            params=params,
            session_id=session_id,
        ))

    async def getComputedStyleForNode(
        self,
        params: "GetComputedStyleForNodeParameters",
        session_id: Optional[str] = None,
    ) -> "GetComputedStyleForNodeReturns":
        """Returns the computed style for a DOM node identified by `nodeId`."""
        return cast("GetComputedStyleForNodeReturns", await self._client.send_raw(
            method="CSS.getComputedStyleForNode",
            params=params,
            session_id=session_id,
        ))

    async def resolveValues(
        self,
        params: "ResolveValuesParameters",
        session_id: Optional[str] = None,
    ) -> "ResolveValuesReturns":
        """Resolve the specified values in the context of the provided element.
For example, a value of '1em' is evaluated according to the computed
'font-size' of the element and a value 'calc(1px + 2px)' will be
resolved to '3px'.
If the `propertyName` was specified the `values` are resolved as if
they were property's declaration. If a value cannot be parsed according
to the provided property syntax, the value is parsed using combined
syntax as if null `propertyName` was provided. If the value cannot be
resolved even then, return the provided value without any changes."""
        return cast("ResolveValuesReturns", await self._client.send_raw(
            method="CSS.resolveValues",
            params=params,
            session_id=session_id,
        ))

    async def getLonghandProperties(
        self,
        params: "GetLonghandPropertiesParameters",
        session_id: Optional[str] = None,
    ) -> "GetLonghandPropertiesReturns":
        return cast("GetLonghandPropertiesReturns", await self._client.send_raw(
            method="CSS.getLonghandProperties",
            params=params,
            session_id=session_id,
        ))

    async def getInlineStylesForNode(
        self,
        params: "GetInlineStylesForNodeParameters",
        session_id: Optional[str] = None,
    ) -> "GetInlineStylesForNodeReturns":
        """Returns the styles defined inline (explicitly in the \"style\" attribute and implicitly, using DOM
attributes) for a DOM node identified by `nodeId`."""
        return cast("GetInlineStylesForNodeReturns", await self._client.send_raw(
            method="CSS.getInlineStylesForNode",
            params=params,
            session_id=session_id,
        ))

    async def getAnimatedStylesForNode(
        self,
        params: "GetAnimatedStylesForNodeParameters",
        session_id: Optional[str] = None,
    ) -> "GetAnimatedStylesForNodeReturns":
        """Returns the styles coming from animations & transitions
including the animation & transition styles coming from inheritance chain."""
        return cast("GetAnimatedStylesForNodeReturns", await self._client.send_raw(
            method="CSS.getAnimatedStylesForNode",
            params=params,
            session_id=session_id,
        ))

    async def getMatchedStylesForNode(
        self,
        params: "GetMatchedStylesForNodeParameters",
        session_id: Optional[str] = None,
    ) -> "GetMatchedStylesForNodeReturns":
        """Returns requested styles for a DOM node identified by `nodeId`."""
        return cast("GetMatchedStylesForNodeReturns", await self._client.send_raw(
            method="CSS.getMatchedStylesForNode",
            params=params,
            session_id=session_id,
        ))

    async def getMediaQueries(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetMediaQueriesReturns":
        """Returns all media queries parsed by the rendering engine."""
        return cast("GetMediaQueriesReturns", await self._client.send_raw(
            method="CSS.getMediaQueries",
            params=params,
            session_id=session_id,
        ))

    async def getPlatformFontsForNode(
        self,
        params: "GetPlatformFontsForNodeParameters",
        session_id: Optional[str] = None,
    ) -> "GetPlatformFontsForNodeReturns":
        """Requests information about platform fonts which we used to render child TextNodes in the given
node."""
        return cast("GetPlatformFontsForNodeReturns", await self._client.send_raw(
            method="CSS.getPlatformFontsForNode",
            params=params,
            session_id=session_id,
        ))

    async def getStyleSheetText(
        self,
        params: "GetStyleSheetTextParameters",
        session_id: Optional[str] = None,
    ) -> "GetStyleSheetTextReturns":
        """Returns the current textual content for a stylesheet."""
        return cast("GetStyleSheetTextReturns", await self._client.send_raw(
            method="CSS.getStyleSheetText",
            params=params,
            session_id=session_id,
        ))

    async def getLayersForNode(
        self,
        params: "GetLayersForNodeParameters",
        session_id: Optional[str] = None,
    ) -> "GetLayersForNodeReturns":
        """Returns all layers parsed by the rendering engine for the tree scope of a node.
Given a DOM element identified by nodeId, getLayersForNode returns the root
layer for the nearest ancestor document or shadow root. The layer root contains
the full layer tree for the tree scope and their ordering."""
        return cast("GetLayersForNodeReturns", await self._client.send_raw(
            method="CSS.getLayersForNode",
            params=params,
            session_id=session_id,
        ))

    async def getLocationForSelector(
        self,
        params: "GetLocationForSelectorParameters",
        session_id: Optional[str] = None,
    ) -> "GetLocationForSelectorReturns":
        """Given a CSS selector text and a style sheet ID, getLocationForSelector
returns an array of locations of the CSS selector in the style sheet."""
        return cast("GetLocationForSelectorReturns", await self._client.send_raw(
            method="CSS.getLocationForSelector",
            params=params,
            session_id=session_id,
        ))

    async def trackComputedStyleUpdatesForNode(
        self,
        params: Optional["TrackComputedStyleUpdatesForNodeParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Starts tracking the given node for the computed style updates
and whenever the computed style is updated for node, it queues
a `computedStyleUpdated` event with throttling.
There can only be 1 node tracked for computed style updates
so passing a new node id removes tracking from the previous node.
Pass `undefined` to disable tracking."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="CSS.trackComputedStyleUpdatesForNode",
            params=params,
            session_id=session_id,
        ))

    async def trackComputedStyleUpdates(
        self,
        params: "TrackComputedStyleUpdatesParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Starts tracking the given computed styles for updates. The specified array of properties
replaces the one previously specified. Pass empty array to disable tracking.
Use takeComputedStyleUpdates to retrieve the list of nodes that had properties modified.
The changes to computed style properties are only tracked for nodes pushed to the front-end
by the DOM agent. If no changes to the tracked properties occur after the node has been pushed
to the front-end, no updates will be issued for the node."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="CSS.trackComputedStyleUpdates",
            params=params,
            session_id=session_id,
        ))

    async def takeComputedStyleUpdates(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "TakeComputedStyleUpdatesReturns":
        """Polls the next batch of computed style updates."""
        return cast("TakeComputedStyleUpdatesReturns", await self._client.send_raw(
            method="CSS.takeComputedStyleUpdates",
            params=params,
            session_id=session_id,
        ))

    async def setEffectivePropertyValueForNode(
        self,
        params: "SetEffectivePropertyValueForNodeParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Find a rule with the given active property for the given node and set the new value for this
property"""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="CSS.setEffectivePropertyValueForNode",
            params=params,
            session_id=session_id,
        ))

    async def setPropertyRulePropertyName(
        self,
        params: "SetPropertyRulePropertyNameParameters",
        session_id: Optional[str] = None,
    ) -> "SetPropertyRulePropertyNameReturns":
        """Modifies the property rule property name."""
        return cast("SetPropertyRulePropertyNameReturns", await self._client.send_raw(
            method="CSS.setPropertyRulePropertyName",
            params=params,
            session_id=session_id,
        ))

    async def setKeyframeKey(
        self,
        params: "SetKeyframeKeyParameters",
        session_id: Optional[str] = None,
    ) -> "SetKeyframeKeyReturns":
        """Modifies the keyframe rule key text."""
        return cast("SetKeyframeKeyReturns", await self._client.send_raw(
            method="CSS.setKeyframeKey",
            params=params,
            session_id=session_id,
        ))

    async def setMediaText(
        self,
        params: "SetMediaTextParameters",
        session_id: Optional[str] = None,
    ) -> "SetMediaTextReturns":
        """Modifies the rule selector."""
        return cast("SetMediaTextReturns", await self._client.send_raw(
            method="CSS.setMediaText",
            params=params,
            session_id=session_id,
        ))

    async def setContainerQueryText(
        self,
        params: "SetContainerQueryTextParameters",
        session_id: Optional[str] = None,
    ) -> "SetContainerQueryTextReturns":
        """Modifies the expression of a container query."""
        return cast("SetContainerQueryTextReturns", await self._client.send_raw(
            method="CSS.setContainerQueryText",
            params=params,
            session_id=session_id,
        ))

    async def setSupportsText(
        self,
        params: "SetSupportsTextParameters",
        session_id: Optional[str] = None,
    ) -> "SetSupportsTextReturns":
        """Modifies the expression of a supports at-rule."""
        return cast("SetSupportsTextReturns", await self._client.send_raw(
            method="CSS.setSupportsText",
            params=params,
            session_id=session_id,
        ))

    async def setScopeText(
        self,
        params: "SetScopeTextParameters",
        session_id: Optional[str] = None,
    ) -> "SetScopeTextReturns":
        """Modifies the expression of a scope at-rule."""
        return cast("SetScopeTextReturns", await self._client.send_raw(
            method="CSS.setScopeText",
            params=params,
            session_id=session_id,
        ))

    async def setRuleSelector(
        self,
        params: "SetRuleSelectorParameters",
        session_id: Optional[str] = None,
    ) -> "SetRuleSelectorReturns":
        """Modifies the rule selector."""
        return cast("SetRuleSelectorReturns", await self._client.send_raw(
            method="CSS.setRuleSelector",
            params=params,
            session_id=session_id,
        ))

    async def setStyleSheetText(
        self,
        params: "SetStyleSheetTextParameters",
        session_id: Optional[str] = None,
    ) -> "SetStyleSheetTextReturns":
        """Sets the new stylesheet text."""
        return cast("SetStyleSheetTextReturns", await self._client.send_raw(
            method="CSS.setStyleSheetText",
            params=params,
            session_id=session_id,
        ))

    async def setStyleTexts(
        self,
        params: "SetStyleTextsParameters",
        session_id: Optional[str] = None,
    ) -> "SetStyleTextsReturns":
        """Applies specified style edits one after another in the given order."""
        return cast("SetStyleTextsReturns", await self._client.send_raw(
            method="CSS.setStyleTexts",
            params=params,
            session_id=session_id,
        ))

    async def startRuleUsageTracking(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables the selector recording."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="CSS.startRuleUsageTracking",
            params=params,
            session_id=session_id,
        ))

    async def stopRuleUsageTracking(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "StopRuleUsageTrackingReturns":
        """Stop tracking rule usage and return the list of rules that were used since last call to
`takeCoverageDelta` (or since start of coverage instrumentation)."""
        return cast("StopRuleUsageTrackingReturns", await self._client.send_raw(
            method="CSS.stopRuleUsageTracking",
            params=params,
            session_id=session_id,
        ))

    async def takeCoverageDelta(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "TakeCoverageDeltaReturns":
        """Obtain list of rules that became used since last call to this method (or since start of coverage
instrumentation)."""
        return cast("TakeCoverageDeltaReturns", await self._client.send_raw(
            method="CSS.takeCoverageDelta",
            params=params,
            session_id=session_id,
        ))

    async def setLocalFontsEnabled(
        self,
        params: "SetLocalFontsEnabledParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables/disables rendering of local CSS fonts (enabled by default)."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="CSS.setLocalFontsEnabled",
            params=params,
            session_id=session_id,
        ))


