# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Debugger Domain Types"""

from typing import List
from typing_extensions import Literal
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..runtime.types import RemoteObject
    from ..runtime.types import ScriptId

BreakpointId = str
"""Breakpoint identifier."""



CallFrameId = str
"""Call frame identifier."""



class Location(TypedDict):
    """Location in the source code."""

    scriptId: "ScriptId"
    """Script identifier as reported in the `Debugger.scriptParsed`."""
    lineNumber: "int"
    """Line number in the script (0-based)."""
    columnNumber: "NotRequired[int]"
    """Column number in the script (0-based)."""



class ScriptPosition(TypedDict):
    """Location in the source code."""

    lineNumber: "int"
    columnNumber: "int"



class LocationRange(TypedDict):
    """Location range within one script."""

    scriptId: "ScriptId"
    start: "ScriptPosition"
    end: "ScriptPosition"



class CallFrame(TypedDict):
    """JavaScript call frame. Array of call frames form the call stack."""

    callFrameId: "CallFrameId"
    """Call frame identifier. This identifier is only valid while the virtual machine is paused."""
    functionName: "str"
    """Name of the JavaScript function called on this call frame."""
    functionLocation: "NotRequired[Location]"
    """Location in the source code."""
    location: "Location"
    """Location in the source code."""
    url: "str"
    """JavaScript script name or url.
Deprecated in favor of using the `location.scriptId` to resolve the URL via a previously
sent `Debugger.scriptParsed` event."""
    scopeChain: "List[Scope]"
    """Scope chain for this call frame."""
    this: "RemoteObject"
    """`this` object for this call frame."""
    returnValue: "NotRequired[RemoteObject]"
    """The value being returned, if the function is at return point."""
    canBeRestarted: "NotRequired[bool]"
    """Valid only while the VM is paused and indicates whether this frame
can be restarted or not. Note that a `true` value here does not
guarantee that Debugger#restartFrame with this CallFrameId will be
successful, but it is very likely."""



class Scope(TypedDict):
    """Scope description."""

    type: "str"
    """Scope type."""
    object: "RemoteObject"
    """Object representing the scope. For `global` and `with` scopes it represents the actual
object; for the rest of the scopes, it is artificial transient object enumerating scope
variables as its properties."""
    name: "NotRequired[str]"
    startLocation: "NotRequired[Location]"
    """Location in the source code where scope starts"""
    endLocation: "NotRequired[Location]"
    """Location in the source code where scope ends"""



class SearchMatch(TypedDict):
    """Search match for resource."""

    lineNumber: "float"
    """Line number in resource content."""
    lineContent: "str"
    """Line with match content."""



class BreakLocation(TypedDict):
    scriptId: "ScriptId"
    """Script identifier as reported in the `Debugger.scriptParsed`."""
    lineNumber: "int"
    """Line number in the script (0-based)."""
    columnNumber: "NotRequired[int]"
    """Column number in the script (0-based)."""
    type: "NotRequired[str]"



class WasmDisassemblyChunk(TypedDict):
    lines: "List[str]"
    """The next chunk of disassembled lines."""
    bytecodeOffsets: "List[int]"
    """The bytecode offsets describing the start of each line."""



ScriptLanguage = Literal["JavaScript", "WebAssembly"]
"""Enum of possible script languages."""



class DebugSymbols(TypedDict):
    """Debug symbols available for a wasm script."""

    type: "str"
    """Type of the debug symbols."""
    externalURL: "NotRequired[str]"
    """URL of the external symbol source."""



class ResolvedBreakpoint(TypedDict):
    breakpointId: "BreakpointId"
    """Breakpoint unique identifier."""
    location: "Location"
    """Actual breakpoint location."""
